﻿module("VOICE")

----------------------------------------------------------------------------------------------------
---------------------------|  V O I C E   T R A N S F O R M   U T I L S  |--------------------------
----------------------------------------------------------------------------------------------------

-----------------------------------------------
-- ASSERT a konyvtari transform fuggvenyekre --
-----------------------------------------------
fill_functions.fill_waypointname = function (idx) return format_waypointname(info, idx) end
wprevroadtable = {L"-1", L"-1", L"-1"}
wsameroadname = false
wprevpointtable = {L"-1", L"-1"}
waypointname = L""
local use_dativ_for_sameroad = SysConfig:get("tts", "dativ_for_sameroad", 1)
local function get_full_roadname(road)
	local roadname = road.name
	local roadnumber = road.number
	local roadtext = L""
	if roadname and roadnumber then roadtext = roadname.text .. L"|" .. roadnumber.text
	elseif roadnumber then roadtext = roadnumber.text
	elseif roadname then roadtext = roadname.text end
	return roadtext
end
local function check_same_maneuvers_done(data, idx, prevroadtable)
	local same = true
	local t = {L"-1", L"-1", L"-1"}
	local roadtext = get_full_roadname(data[idx].road)
	local t_unused_manouvers = {L"^roundabout", L"^goal", L"^uturn", L"^via"}
	if transform_pattern_match(towstring(data[idx].manouver),t_unused_manouvers) then same = false
	elseif prevroadtable[1] ~= roadtext then same = false
	elseif prevroadtable[2] ~= data[idx].manouver then same = false
	elseif prevroadtable[3] ~= roadtext then same = false end
	t[1] = roadtext == L"" and L"-1" or roadtext
	if #data > idx then
		t[2] = data[idx+1].manouver
		if data[idx+1].road then
			roadtext = get_full_roadname(data[idx+1].road)
			t[3] = roadtext == L"" and L"-1" or roadtext
		end
	end
	return same, t
end
local function check_same_maneuvers(mapinfo, events)
	if events.new_manouver then
		if mapinfo[1].road then wsameroadname, wprevroadtable = check_same_maneuvers_done(mapinfo, 1, wprevroadtable)
		else wsameroadname = false wprevroadtable = {L"-1", L"-1", L"-1"} end
		local match = wsameroadname and L"same" or L"other"
		local str = table_concat(wprevroadtable, L"|")
		voice_debug_log(L"TTS: sameroadname: " .. match .. L" road'"..str..L"'", 3)
	end
end
local function check_waypoint_maneuvers(mapinfo, events)
	local t_used_manouvers = {L"^goal", L"^via"}
	if transform_pattern_match(towstring(mapinfo[1].manouver),t_used_manouvers) then
		local via_type = wstring.find(towstring(mapinfo[1].manouver), L"^via")
		if events.new_manouver or via_type and waypointname == L"" then
			local str, str_index = L"", L""
			if via_type then
				local way_points = MODEL[SysConfig:get("tts", "waypoints_list", "route.list.navigated.waypoints.list")]
				for i = 0, #way_points - 1 do
					if MODEL.navigation.distance_to_destination() > (way_points[#way_points - 1].total_length() - way_points[i].total_length()) then str = way_points[i].name() str_index = towstring(#way_points - i) break end
				end
				if wprevpointtable[1] == str or wprevpointtable[2] == str_index then str = L"" end
			else
				str, str_index = MODEL.navigation.destination_name_short(), L"0"
			end
			wprevpointtable[1] = str == L"" and L"-1" or str
			wprevpointtable[2] = str_index == L"" and L"-1" or str_index
			waypointname = str
			str = (events.new_manouver and L"new" or L"old")..L" maneuver"..L"|"..str_index..L"|"..waypointname
			voice_debug_log(L"TTS: waypointname check: '"..str..L"'", 3)
		end
	else
		wprevpointtable = {L"-1", L"-1"}
		waypointname = L""
	end
end
local guidance_orig = guidance
guidance = function(mapinfo, events)
	if use_dativ_for_sameroad then check_same_maneuvers(mapinfo, events) end
	if announce_waypointname then check_waypoint_maneuvers(mapinfo, events) end
	return guidance_orig(mapinfo, events)
end
function set_announce_waypoint()
	if MODEL.EXISTS.lua.tts.announce_waypointname() then announce_waypointname = MODEL.lua["tts.announce_waypointname"]()
	else announce_waypointname = SysConfig:get("tts", "announce_waypointname", 0) end
end
function set_tts_settings()
	if MODEL.EXISTS.lua.tts.numbers_mode() then numbers_mode = MODEL.lua["tts.numbers_mode"]()
	else numbers_mode = SysConfig:get("tts", "numbers_mode", 1) end
	set_distances_meters()
	set_distances_ttspro_meters()
	local unit_names = {"yards","meters","feet"}
	dist_table = distances[unit_names[MODEL.regional.units() + 1]]
	if MODEL.EXISTS.lua.tts.sentence_variations() then sentence_variations = MODEL.lua["tts.sentence_variations"]()
	else sentence_variations = SysConfig:get("tts", "sentence_variations", 1) end
	set_pattern_variations()
	if MODEL.EXISTS.lua.tts.roadnumber_mode() then roadnumber_mode = MODEL.lua["tts.roadnumber_mode"]()
	else roadnumber_mode = SysConfig:get("tts", "roadnumber_mode", 1) end
	if MODEL.EXISTS.lua.tts.traffic_events_description() then traffic_events_description = MODEL.lua["tts.traffic_events_description"]()
	else traffic_events_description = SysConfig:get("tts", "traffic_events_description", 1) end
	if MODEL.EXISTS.lua.tts.traffic_events_distance() then traffic_events_distance = MODEL.lua["tts.traffic_events_distance"]()
	else traffic_events_distance = SysConfig:get("tts", "traffic_events_distance", 0) end
	set_announce_waypoint()
end
set_tts_settings()

assert(type(transform_and_format) == "function")
assert(type(transform_pattern_match) == "function")
assert(type(transform_chain) == "function")
assert(type(transform_format_roadnumber_eu) == "function")

local preposition_tbl = {L"Через",L"в Направлении На"}

local preposition_insert_tbl = {
	{L"в ",{L"Переулок",L"Проезд",L"Тупик"}},
	{L"на ",{L""}},
}
local preposition_insert_tbl_direction = {
	{L"по ",{L""}},
}

local main_streetnames = {L"Бульвар",L"Линия",L"Переулок",L"Площадь",L"Проспект",L"Улица"}
local mother_country = "_rus"
local settlement_preposition = L"в направлении на"
local exit_preposition = L"на съезд"
local replace_roadnumber_prepare = {
	{L"^ ",L""},
	{wstring.char(160),L""},
	{L"[еЕ]",L"E"},
	{L"[мМ]",L"M"},
	{L"[nHН]",L"N"},
	{L"[рPР]",L"R"},
	{L"[tтТ]",L"T"},
	{L"[аА]",L"A"},
}
VOICE["replace_roadnumber" .. mother_country] = {
	{L"(.*)",L"%1/"},
	{L"^A +100([^0-9])",L"Дорога Москва Бородино%1"},
	{L"^A +101([^0-9])",L"Дорога Москва Рославль%1"},
	{L"^A +102([^0-9])",L"Рязанское Шоссе%1"},
	{L"^A +103([^0-9])",L"Щелковское Шоссе%1"},
	{L"^A +104([^0-9])",L"Дмитровское Шоссе%1"},
	{L"^A +105([^0-9])",L"Успенское Шоссе%1"},
	{L"^A +106([^0-9])",L"Ильинское Шоссе%1"},
	{L"^A +107([^0-9])",L"Московское Малое Кольцо%1"},
	{L"^A +108([^0-9])",L"Московское Большое Кольцо%1"},
	{L"^A +111([^0-9])",L"Дорога Торжок Осташков%1"},
	{L"^A +112([^0-9])",L"Дорога Тверь Ржев%1"},
	{L"^A +113([^0-9])",L"Дорога Кострома Иваново%1"},
	{L"^A +114([^0-9])",L"Дорога Вологда Новая Ладога%1"},
	{L"^A +116([^0-9])",L"Дорога Порхов Остров%1"},
	{L"^A +117([^0-9])",L"Дорога Опочка граница с Белоруссией%1"},
	{L"^A +121([^0-9])",L"Дорога Санкт-Петербург Ропша%1"},
	{L"^A +122([^0-9])",L"Дорога Санкт-Петербург Огоньки%1"},
	{L"^A +123([^0-9])",L"Дорога Зеленогорск Выборг%1"},
	{L"^A +124([^0-9])",L"Дорога Выборг Приозерск%1"},
	{L"^A +125([^0-9])",L"Дорога Молодежное Черкасово%1"},
	{L"^A +126([^0-9])",L"Дорога Дубки граница с Финляндией%1"},
	{L"^A +127([^0-9])",L"Дорога Зверево граница с Финляндией%1"},
	{L"^A +128([^0-9])",L"Дорога Санкт-Петербург Морье%1"},
	{L"^A +129([^0-9])",L"Дорога Зеленогорск Выборг%1"},
	{L"^A +130([^0-9])",L"Дорога Олонец Сортавала%1"},
	{L"^A +131([^0-9])",L"Дорога Суоярви Койриноя%1"},
	{L"^A +132([^0-9])",L"Дорога Суоярви Юстозеро%1"},
	{L"^A +133([^0-9])",L"Дорога Петрозаводск Суоярви%1"},
	{L"^A +134([^0-9])",L"Дорога Кочкома Реболы%1"},
	{L"^A +135([^0-9])",L"Дорога Кемь Лонка%1"},
	{L"^A +136([^0-9])",L"Дорога Лоухи Суоперя%1"},
	{L"^A +137([^0-9])",L"Дорога Тунгозеро Калевала%1"},
	{L"^A +138([^0-9])",L"Дорога Кола Печенга%1"},
	{L"^A +141([^0-9])",L"Дорога Орел Смоленск%1"},
	{L"^A +142([^0-9])",L"Дорога Тросна Калиновка%1"},
	{L"^A +144([^0-9])",L"Дорога Курск Борисоглебск%1"},
	{L"^A +146([^0-9])",L"Дорога Краснодар Новоросийск%1"},
	{L"^A +147([^0-9])",L"Дорога Краснодар Джубга%1"},
	{L"^A +148([^0-9])",L"Дорога Адлер Красная Поляна%1"},
	{L"^A +151([^0-9])",L"Дорога Цивильск Ульяновск%1"},
	{L"^A +153([^0-9])",L"Дорога Волгоград Мариновка%1"},
	{L"^A +154([^0-9])",L"Дорога Астрахань Ставрополь%1"},
	{L"^A +155([^0-9])",L"Дорога Черкесск Домбай%1"},
	{L"^A +156([^0-9])",L"Дорога Лермонтов Черкесск%1"},
	{L"^A +157([^0-9])",L"Дорога Минеральные Воды Кисловодск%1"},
	{L"^A +158([^0-9])",L"Дорога Прохладный Баксан Эльбрус%1"},
	{L"^A +166([^0-9])",L"Дорога Чита Забайкальск%1"},
	{L"^A +190([^0-9])",L"Дорога Калининград Полесск%1"},
	{L"^A +191([^0-9])",L"Дорога Калининград Зеленоградск%1"},
	{L"^A +192([^0-9])",L"Дорога Зеленоградск Приморск%1"},
	{L"^A +193([^0-9])",L"Дорога Калининград Балтийск%1"},
	{L"^A +194([^0-9])",L"Дорога Калининград Мамоново%1"},
	{L"^A +195([^0-9])",L"Дорога Калининград Долгоруково%1"},
	{L"^A +196([^0-9])",L"Дорога Калининград Крылово%1"},
	{L"^A +197([^0-9])",L"Дорога Черняховск Крылово%1"},
	{L"^A +198([^0-9])",L"Дорога Советск Гусев%1"},
	{L"^A +212([^0-9])",L"Дорога Псков Изборск%1"},
	{L"^A +216([^0-9])",L"Дорога Гвардейск Неман%1"},
	{L"^A +229([^0-9])",L"Дорога Калининград Нестеров%1"},
	{L"^A +340([^0-9])",L"Дорога Астрахань Красный Яр%1"},
	{L"^A +349([^0-9])",L"Дорога Барнаул Рубцовск%1"},
	{L"^E +18([^0-9])",L"Трасса Выборг Санкт-Петербург%1"},
	{L"^E +20([^0-9])",L"Трасса Таллин Санкт-Петербург%1"},
	{L"^E +22([^0-9])",L"Трасса Рига Москва Тюмень%1"},
	{L"^E +28([^0-9])",L"Трасса Калининград Нестеров%1"},
	{L"^E +30([^0-9])",L"Трасса Минск Москва Омск%1"},
	{L"^E +38([^0-9])",L"Трасса Глухов Воронеж Уральск%1"},
	{L"^E +40([^0-9])",L"Трасса Харьков Волгоград Астрахань%1"},
	{L"^E +50([^0-9])",L"Трасса Донецк Ростов-на-Дону Махачкала%1"},
	{L"^E +58([^0-9])",L"Трасса Мариуполь Ростов-на-Дону%1"},
	{L"^E +77([^0-9])",L"Трасса Псков Рига Калининград%1"},
	{L"^E +95([^0-9])",L"Трасса Санкт-Петербург Витебск%1"},
	{L"^E +97([^0-9])",L"Трасса Новороссийск Сочи%1"},
	{L"^E +101([^0-9])",L"Трасса Москва Брянск Киев%1"},
	{L"^E +105([^0-9])",L"Трасса Мурманск Белгород%1"},
	{L"^E +115([^0-9])",L"Трасса Ярославль Москва Новороссийск%1"},
	{L"^E +117([^0-9])",L"Трасса Минеральные Воды Нальчик Владикавказ%1"},
	{L"^E +119([^0-9])",L"Трасса Махачкала Баку%1"},
	{L"^M +0?1([^0-9])",L"Трасса Москва Минск%1"},
	{L"^M +0?2([^0-9])",L"Трасса Москва Симферополь%1"},
	{L"^M +0?3([^0-9])",L"Трасса Москва Киев%1"},
	{L"^M +0?4([^0-9])",L"Трасса Москва Новороссийск%1"},
	{L"^M +0?5([^0-9])",L"Трасса Москва Екатеринбург%1"},
	{L"^M +0?6([^0-9])",L"Трасса Москва Астрахань%1"},
	{L"^M +0?7([^0-9])",L"Трасса Москва Уфа%1"},
	{L"^M +0?8([^0-9])",L"Трасса Москва Архангельск%1"},
	{L"^M +0?9([^0-9])",L"Трасса Москва Рига%1"},
	{L"^M +10([^0-9])",L"Трасса Москва Санкт-Петербург%1"},
	{L"^M +11([^0-9])",L"Трасса Санкт-Петербург Таллин%1"},
	{L"^M +12([^0-9])",L"Трасса Минск Вильнюс Рига Таллин%1"},
	{L"^M +13([^0-9])",L"Трасса Брянск Новозыбков%1"},
	{L"^M +14([^0-9])",L"Трасса Брест Кишинев Одесса%1"},
	{L"^M +17([^0-9])",L"Трасса Киев Чоп Будапешт%1"},
	{L"^M +18([^0-9])",L"Трасса Санкт-Петербург Мурманск%1"},
	{L"^M +19([^0-9])",L"Трасса Новошахтинск Майский%1"},
	{L"^M +20([^0-9])",L"Трасса Санкт-Петербург Минск%1"},
	{L"^M +21([^0-9])",L"Трасса Волгоград Каменск Шахтинский%1"},
	{L"^M +23([^0-9])",L"Трасса Ростов-на-Дону Таганрог%1"},
	{L"^M +25([^0-9])",L"Трасса Новороссийск Керченский пролив%1"},
	{L"^M +27([^0-9])",L"Трасса Джубга Новороссийск%1"},
	{L"^M +29([^0-9])",L"Трасса Краснодар Баку%1"},
	{L"^M +32([^0-9])",L"Трасса Самара Большая Черниговка%1"},
	{L"^M +36([^0-9])",L"Трасса Челябинск Троицк%1"},
	{L"^M +38([^0-9])",L"Трасса Омск Черлак%1"},
	{L"^M +51([^0-9])",L"Трасса Челябинск Чита%1"},
	{L"^M +52([^0-9])",L"Трасса Новосибирск Бийск%1"},
	{L"^M +53([^0-9])",L"Трасса Челябинск Чита%1"},
	{L"^M +54([^0-9])",L"Трасса Красноярск Кызыл%1"},
	{L"^M +55([^0-9])",L"Трасса Челябинск Чита%1"},
	{L"^M +56([^0-9])",L"Трасса Невр Якутск%1"},
	{L"^M +60([^0-9])",L"Трасса Хабаровск Владивосток%1"},
	{L"^R +0?1([^0-9])",L"Дорога Архангельск Прокшино%1"},
	{L"^R +0?2([^0-9])",L"Дорога М8 Няндома Пудож%1"},
	{L"^R +0?5([^0-9])",L"Дорога Вологда Медвежьегорск%1"},
	{L"^R +0?6([^0-9])",L"Дорога Череповец Липин Бор%1"},
	{L"^R +0?7([^0-9])",L"Дорога Чекшино Никольск%1"},
	{L"^R +0?8([^0-9])",L"Дорога Устюжна Валдай%1"},
	{L"^R +10([^0-9])",L"Дорога Лиинахамари граница Финляндии Виртаниеми%1"},
	{L"^R +12([^0-9])",L"Дорога Мурманск КПП Лотта%1"},
	{L"^R +15([^0-9])",L"Дорога Петрозаводск Гирвас%1"},
	{L"^R +16([^0-9])",L"Дорога Пудож Семеново%1"},
	{L"^R +17([^0-9])",L"Дорога Медвежьегорск Великая Губа%1"},
	{L"^R +18([^0-9])",L"Дорога Пушной Беломорск%1"},
	{L"^R +19([^0-9])",L"Дорога Петрозаводск Оштинский Погост%1"},
	{L"^R +20([^0-9])",L"Дорога Спасская Губа Корписелькя%1"},
	{L"^R +21([^0-9])",L"Дорога Пряжа Колатсельга Леметти%1"},
	{L"^R +25([^0-9])",L"Дорога Сыктывкар Вогваздино Ухта%1"},
	{L"^R +26([^0-9])",L"Дорога Сыктывкар Троицко-Печорск%1"},
	{L"^R +27([^0-9])",L"Дорога Вогваздино Яренск%1"},
	{L"^R +28([^0-9])",L"Дорога Айкино Кослан%1"},
	{L"^R +33([^0-9])",L"Дорога Санкт-Петербург Запорожское%1"},
	{L"^R +34([^0-9])",L"Дорога Ушково Гравийное%1"},
	{L"^R +35([^0-9])",L"Дорога Петродворец Кейкино%1"},
	{L"^R +36([^0-9])",L"Дорога Ладейное Поле Чудово%1"},
	{L"^R +37([^0-9])",L"Дорога Лодейное Поле Вытегра%1"},
	{L"^R +38([^0-9])",L"Дорога Гатчина Ополье%1"},
	{L"^R +39([^0-9])",L"Дорога Пружицы Толмачево%1"},
	{L"^R +40([^0-9])",L"Дорога Кемполово Тосно Шапки%1"},
	{L"^R +41([^0-9])",L"Дорога Павлово Любань Луга%1"},
	{L"^R +42([^0-9])",L"Дорога Гостицы Косколково%1"},
	{L"^R +47([^0-9])",L"Дорога Новгород Луга%1"},
	{L"^R +48([^0-9])",L"Дорога Яжелбицы Старая Русса Сольцы%1"},
	{L"^R +49([^0-9])",L"Дорога Красея Лычково%1"},
	{L"^R +50([^0-9])",L"Дорога Демянск Марево%1"},
	{L"^R +51([^0-9])",L"Дорога Шимск Великие Луки Невель%1"},
	{L"^R +52([^0-9])",L"Дорога Шимск Николаево%1"},
	{L"^R +53([^0-9])",L"Дорога Спасская Полисть Боровичи%1"},
	{L"^R +56([^0-9])",L"Дорога Новгород Порхов Псков%1"},
	{L"^R +57([^0-9])",L"Дорога Порхов Успенское%1"},
	{L"^R +58([^0-9])",L"Дорога Локня Пушкинские Горы%1"},
	{L"^R +59([^0-9])",L"Дорога Быстроникольское Черская%1"},
	{L"^R +60([^0-9])",L"Дорога Псков Кингисепп Краколье%1"},
	{L"^R +61([^0-9])",L"Дорога Заполье Гдов%1"},
	{L"^R +62([^0-9])",L"Дорога Себеж граница с Белоруссией на Верхнедвинск%1"},
	{L"^R +63([^0-9])",L"Дорога Новоселье Боровичи Псковской области%1"},
	{L"^R +68([^0-9])",L"Дорога Брянск Киров Куземки%1"},
	{L"^R +71([^0-9])",L"Дорога Сенинские Дворики Кинешма%1"},
	{L"^R +72([^0-9])",L"Дорога Владимир Муром Арзамас%1"},
	{L"^R +73([^0-9])",L"Дорога Владимир Тума%1"},
	{L"^R +74([^0-9])",L"Дорога Владимир Переславль-Залесский%1"},
	{L"^R +75([^0-9])",L"Дорога Дворики Хрястово%1"},
	{L"^R +76([^0-9])",L"Дорога Гаврильцево Муром%1"},
	{L"^R +79([^0-9])",L"Дорога Иваново Гаврилов-Ям Ярославль%1"},
	{L"^R +80([^0-9])",L"Дорога Иваново Родники%1"},
	{L"^R +81([^0-9])",L"Дорога Кинешма Пурех%1"},
	{L"^R +84([^0-9])",L"Дорога Тверь Бежецк Устюжна%1"},
	{L"^R +85([^0-9])",L"Дорога Вышний Волочек Бежецк Углич%1"},
	{L"^R +86([^0-9])",L"Дорога Калязин Боровичи%1"},
	{L"^R +87([^0-9])",L"Дорога Осташков Ржев%1"},
	{L"^R +88([^0-9])",L"Дорога Торжок Старица%1"},
	{L"^R +89([^0-9])",L"Дорога Осташков Волговерховье%1"},
	{L"^R +90([^0-9])",L"Дорога Тверь Шаховская Уваровка%1"},
	{L"^R +91([^0-9])",L"Дорога Барановичи Осиповичи%1"},
	{L"^R +92([^0-9])",L"Дорога Калуга Орел%1"},
	{L"^R +93([^0-9])",L"Дорога Калуга Медынь%1"},
	{L"^R +94([^0-9])",L"Дорога Перемышль Козельск%1"},
	{L"^R +95([^0-9])",L"Дорога Голодское Одоев%1"},
	{L"^R +96([^0-9])",L"Дорога Новоалександровский Починок%1"},
	{L"^R +98([^0-9])",L"Дорога Кострома Верхнеспасское%1"},
	{L"^R +99([^0-9])",L"Дорога Кострома Буй%1"},
	{L"^R +100([^0-9])",L"Дорога Судиславль Чухлома%1"},
	{L"^R +101([^0-9])",L"Дорога Островское Заволжск%1"},
	{L"^R +104([^0-9])",L"Дорога Череповец Рыбинск Сергиев Посад до М8%1"},
	{L"^R +105([^0-9])",L"Егорьевское Шоссе%1"},
	{L"^R +106([^0-9])",L"Дорога Куровское Шатура Самойлиха%1"},
	{L"^R +107([^0-9])",L"Дорога Лотошино Клин%1"},
	{L"^R +108([^0-9])",L"Дорога Суворово Волоколамск Руза%1"},
	{L"^R +109([^0-9])",L"Дорога Анискино Монино Электроугли%1"},
	{L"^R +110([^0-9])",L"Дорога Щелково Фряново%1"},
	{L"^R +111([^0-9])",L"Волоколамское Шоссе%1"},
	{L"^R +112([^0-9])",L"Дорога Дмитров Талдом Темпы%1"},
	{L"^R +113([^0-9])",L"Рогачевское Шоссе%1"},
	{L"^R +114([^0-9])",L"Дорога Кашира Кимовск Узловая%1"},
	{L"^R +115([^0-9])",L"Дорога Егорьевск Коломна Ненашево%1"},
	{L"^R +116([^0-9])",L"Дорога Дубна Кимры Горицы%1"},
	{L"^R +119([^0-9])",L"Дорога Орел Липецк Тамбов%1"},
	{L"^R +120([^0-9])",L"Дорога Орел Ефремов%1"},
	{L"^R +123([^0-9])",L"Дорога Спас-Клепики Рязань%1"},
	{L"^R +124([^0-9])",L"Дорога Шацк Касимов%1"},
	{L"^R +125([^0-9])",L"Дорога Касимов Муром Нижний Новгород%1"},
	{L"^R +126([^0-9])",L"Дорога Рязань Ряжск Ефремов%1"},
	{L"^R +127([^0-9])",L"Дорога Пехлец Кораблино Скопин%1"},
	{L"^R +130([^0-9])",L"Дорога Демидов Рудня%1"},
	{L"^R +131([^0-9])",L"Дорога Велиж граница с Белоруссией на Витебск%1"},
	{L"^R +132([^0-9])",L"Дорога Вязьма Калуга Рязань%1"},
	{L"^R +133([^0-9])",L"Дорога Ольша Невель граница с Белоруссией на Клястицы%1"},
	{L"^R +134([^0-9])",L"Дорога Смоленск Вязьма Зубцов%1"},
	{L"^R +135([^0-9])",L"Дорога Смоленск Красный Гусево%1"},
	{L"^R +136([^0-9])",L"Дорога Витязи М1 Лисичино Нелидово%1"},
	{L"^R +137([^0-9])",L"Дорога Рославль Ельня Сафоново%1"},
	{L"^R +139([^0-9])",L"Дорога Тула Белев%1"},
	{L"^R +140([^0-9])",L"Дорога Тула Новомосковск%1"},
	{L"^R +141([^0-9])",L"Дорога Ефремов Лопотково%1"},
	{L"^R +142([^0-9])",L"Дорога Богородицк Товарковский Куркино%1"},
	{L"^R +143([^0-9])",L"Дорога Железня Алексин%1"},
	{L"^R +144([^0-9])",L"Дорога Малахово Заокский музей-заповедник Поленова%1"},
	{L"^R +145([^0-9])",L"Дорога Кимовск Куликово Поле Кресты%1"},
	{L"^R +146([^0-9])",L"Дорога Чекалин Суворов станция Ханино%1"},
	{L"^R +147([^0-9])",L"Дорога Чернь Медведки%1"},
	{L"^R +148([^0-9])",L"Дорога Щекино Одоев Арсеньево%1"},
	{L"^R +151([^0-9])",L"Дорога Ярославль Рыбинск%1"},
	{L"^R +152([^0-9])",L"Дорога Ростов Иваново Нижний Новгород%1"},
	{L"^R +153([^0-9])",L"Дорога Углич Ростов%1"},
	{L"^R +157([^0-9])",L"Дорога Урень Шарья Котлас%1"},
	{L"^R +158([^0-9])",L"Дорога Нижний Новгород Саранск Саратов%1"},
	{L"^R +159([^0-9])",L"Дорога Нижний Новгород Шахунья Яранск%1"},
	{L"^R +160([^0-9])",L"Дорога Линда Заволжье%1"},
	{L"^R +161([^0-9])",L"Дорога Навашино Линда%1"},
	{L"^R +162([^0-9])",L"Дорога Работки Сергач Порецкое%1"},
	{L"^R +166([^0-9])",L"Дорога Киров Белая Холуница%1"},
	{L"^R +167([^0-9])",L"Дорога Киров Цепели Стрижи%1"},
	{L"^R +168([^0-9])",L"Дорога Киров Адышево Нижнеивкино%1"},
	{L"^R +169([^0-9])",L"Дорога Киров Малмыж Вятские Поляны%1"},
	{L"^R +172([^0-9])",L"Дорога Йошкар-Ола Уржум%1"},
	{L"^R +173([^0-9])",L"Дорога Йошкар-Ола Чебоксары М7%1"},
	{L"^R +174([^0-9])",L"Дорога Йошкар-Ола Мариинский Посад Цивильск%1"},
	{L"^R +175([^0-9])",L"Дорога Казань Йошкар-Ола%1"},
	{L"^R +178([^0-9])",L"Дорога Ульяновск Саранск Торбеево до М5%1"},
	{L"^R +179([^0-9])",L"Дорога Саранск Рузаевка%1"},
	{L"^R +180([^0-9])",L"Дорога Саранск Новые Выселки%1"},
	{L"^R +185([^0-9])",L"Дорога Белгород Россошь%1"},
	{L"^R +186([^0-9])",L"Дорога Белгород граница с Украиной на Великую Писаревку%1"},
	{L"^R +187([^0-9])",L"Дорога Новый Оскол Валуйки Ровеньки%1"},
	{L"^R +188([^0-9])",L"Дорога Старый Оскол Новый Оскол%1"},
	{L"^R +189([^0-9])",L"Дорога Короча Горшечное Старый Оскол%1"},
	{L"^R +190([^0-9])",L"Дорога Лукьяновка Тим%1"},
	{L"^R +193([^0-9])",L"Дорога Воронеж Тамбов%1"},
	{L"^R +194([^0-9])",L"Дорога Воронеж Россошь Мимерово%1"},
	{L"^R +195([^0-9])",L"Дорога Россошь граница с Украиной на Старобельск%1"},
	{L"^R +196([^0-9])",L"Дорога Р194 Подгорное Павловск%1"},
	{L"^R +199([^0-9])",L"Дорога Курск граница с Украиной на Глухов%1"},
	{L"^R +200([^0-9])",L"Дорога Дьяконово граница с Украиной на Сумы%1"},
	{L"^R +203([^0-9])",L"Дорога Липецк Грязи Песковатка%1"},
	{L"^R +204([^0-9])",L"Дорога Липецк Мичуринск%1"},
	{L"^R +205([^0-9])",L"Дорога Липецк Данков%1"},
	{L"^R +208([^0-9])",L"Дорога Тамбов Рассказово Пенза%1"},
	{L"^R +209([^0-9])",L"Дорога Тамбов Пенза%1"},
	{L"^R +214([^0-9])",L"Дорога Астрахань Камызяк%1"},
	{L"^R +215([^0-9])",L"Дорога Астрахань Махачкала%1"},
	{L"^R +216([^0-9])",L"Дорога Астрахань Лиман%1"},
	{L"^R +217([^0-9])",L"Дорога Зензели Лиман Оля%1"},
	{L"^R +220([^0-9])",L"Дорога Волгоград аэропорт Гумрак%1"},
	{L"^R +224([^0-9])",L"Дорога Самара Пугачев Энгельс Волгоград%1"},
	{L"^R +225([^0-9])",L"Дорога Самара Бугуруслан%1"},
	{L"^R +227([^0-9])",L"Дорога Сызрань Шигоны Усолье%1"},
	{L"^R +228([^0-9])",L"Дорога Сызрань Саратов Волгоград%1"},
	{L"^R +231([^0-9])",L"Дорога Сурское Шумерля М7%1"},
	{L"^R +234([^0-9])",L"Дорога Ельшанка Песчаный Умет%1"},
	{L"^R +235([^0-9])",L"Дорога Балашов Ртищево%1"},
	{L"^R +236([^0-9])",L"Дорога Энгельс граница с Казахстаном на Уральск%1"},
	{L"^R +239([^0-9])",L"Дорога Казань Бугульма Р314%1"},
	{L"^R +240([^0-9])",L"Дорога Алексеевское Высокий Колок%1"},
	{L"^R +241([^0-9])",L"Дорога Казань Буинск Ульяновск%1"},
	{L"^R +242([^0-9])",L"Дорога Пермь Екатеринбург%1"},
	{L"^R +244([^0-9])",L"Дорога Казань туристический комплекс Волга%1"},
	{L"^R +245([^0-9])",L"Дорога Казань аэропорт Казань 2%1"},
	{L"^R +246([^0-9])",L"Дорога Бугульма граница с Казахстаном на Уральск%1"},
	{L"^R +250([^0-9])",L"Дорога Старощербиновская Ейск%1"},
	{L"^R +251([^0-9])",L"Дорога Темрюк Краснодар Кропоткин%1"},
	{L"^R +252([^0-9])",L"Дорога Андреева Гора Анапа%1"},
	{L"^R +253([^0-9])",L"Дорога Кореновск Белореченск Армавир%1"},
	{L"^R +254([^0-9])",L"Дорога Туапсе Майкоп Кавказский заповедник%1"},
	{L"^R +255([^0-9])",L"Дорога Армавир Отрадное%1"},
	{L"^R +256([^0-9])",L"Дорога Майкоп Гиагинская Псебай Карачаевск%1"},
	{L"^R +262([^0-9])",L"Дорога Ставрополь Моздок Крайновка%1"},
	{L"^R +263([^0-9])",L"Дорога Кочубей Нефтекумск Зеленокумск%1"},
	{L"^R +264([^0-9])",L"Дорога Пятигорск Георгиевск%1"},
	{L"^R +265([^0-9])",L"Дорога Черкесск Зеленчукская Архыз%1"},
	{L"^R +266([^0-9])",L"Дорога Светлоград Благодарный Буденновск%1"},
	{L"^R +267([^0-9])",L"Дорога Ставрополь аэропорт Шпаковское%1"},
	{L"^R +268([^0-9])",L"Дорога Батайск Краснодар%1"},
	{L"^R +269([^0-9])",L"Дорога Батайск Ставрополь%1"},
	{L"^R +270([^0-9])",L"Дорога Егорлыкская Сальск%1"},
	{L"^R +271([^0-9])",L"Дорога Миллерово Вешенская%1"},
	{L"^R +272([^0-9])",L"Дорога Мимерово граница с Украиной на Луганск%1"},
	{L"^R +275([^0-9])",L"Дорога Махачкала Буйнакск Гуниб%1"},
	{L"^R +276([^0-9])",L"Дорога Леваши Сергокала%1"},
	{L"^R +277([^0-9])",L"Дорога Гунибское шоссе Вантляшевский перевал%1"},
	{L"^R +278([^0-9])",L"Дорога Хасавюрт Тлох%1"},
	{L"^R +279([^0-9])",L"Дорога Хасавюрт Бабаюрт%1"},
	{L"^R +280([^0-9])",L"Дорога Манаскент Сергокала Первомайское%1"},
	{L"^R +281([^0-9])",L"Дорога Мамраш Ташкапур Араканский мост%1"},
	{L"^R +282([^0-9])",L"Дорога Буйнакск Кизилюрт%1"},
	{L"^R +283([^0-9])",L"Дорога Буйнакск Терменлик%1"},
	{L"^R +284([^0-9])",L"Дорога Каспийск махачкалинский аэропорт Уиташ%1"},
	{L"^R +285([^0-9])",L"Дорога Кочубей Нефтекумск Урожайное%1"},
	{L"^R +288([^0-9])",L"Дорога Нальчик Майский%1"},
	{L"^R +289([^0-9])",L"Дорога Прохладный Баксан%1"},
	{L"^R +290([^0-9])",L"Дорога Прохладный Эльхотов%1"},
	{L"^R +291([^0-9])",L"Дорога Махачкала Кизляр Уштулу%1"},
	{L"^R +292([^0-9])",L"Дорога Аргудан Александровская%1"},
	{L"^R +295([^0-9])",L"Дорога Владикавказ Ардон Старый Лескен%1"},
	{L"^R +296([^0-9])",L"Дорога Моздок Чермен Владикавказ%1"},
	{L"^R +297([^0-9])",L"Дорога Владикавказ Алагир аэропорт Беслан%1"},
	{L"^R +298([^0-9])",L"Дорога Алагир Карджин%1"},
	{L"^R +299([^0-9])",L"Дорога Гизель Кармадон Дзуарикау%1"},
	{L"^R +300([^0-9])",L"Дорога Дигора Минеральные источники%1"},
	{L"^R +301([^0-9])",L"Дорога Беслан Владикавказский аэропорт Беслан%1"},
	{L"^R +302([^0-9])",L"Дорога Чиколо Мацута Дзинага%1"},
	{L"^R +305([^0-9])",L"Дорога Грозный Шатой Итум-Кале%1"},
	{L"^R +306([^0-9])",L"Дорога Грозный Ботлих Араканы-Буйнакск%1"},
	{L"^R +307([^0-9])",L"Дорога Ищерская Грозный%1"},
	{L"^R +308([^0-9])",L"Дорога Червленная Грозный%1"},
	{L"^R +309([^0-9])",L"Дорога Гребенская Хасавюрт%1"},
	{L"^R +314([^0-9])",L"Дорога Уфа Оренбург подъезд к Мелеузу%1"},
	{L"^R +315([^0-9])",L"Дорога Уфа Бирск Янаул%1"},
	{L"^R +316([^0-9])",L"Дорога Стерлитамак Белорецк Магнитогорск%1"},
	{L"^R +317([^0-9])",L"Дорога Бирск Тастуба Сатка%1"},
	{L"^R +321([^0-9])",L"Дорога Игра Глазов%1"},
	{L"^R +322([^0-9])",L"Дорога Ижевск Сарапул%1"},
	{L"^R +327([^0-9])",L"Дорога Курган граница с Казахстаном на Кустанай%1"},
	{L"^R +328([^0-9])",L"Дорога Шумиха граница с Казахстаном на Кустанай%1"},
	{L"^R +329([^0-9])",L"Дорога Шадринск Ялуторовск%1"},
	{L"^R +330([^0-9])",L"Дорога Шадринск Миасское%1"},
	{L"^R +335([^0-9])",L"Дорога Оренбург граница с Казахстаном на Уральск%1"},
	{L"^R +336([^0-9])",L"Дорога Оренбург Орск%1"},
	{L"^R +337([^0-9])",L"Дорога Сара Самарское%1"},
	{L"^R +338([^0-9])",L"Дорога Адамовка Шильда Кваркено%1"},
	{L"^R +343([^0-9])",L"Дорога Кунгур Соликамск%1"},
	{L"^R +344([^0-9])",L"Дорога Кудымкар Краснокамск%1"},
	{L"^R +345([^0-9])",L"Дорога Пермь Усть-Качка%1"},
	{L"^R +351([^0-9])",L"Дорога Екатеринбург Тюмень%1"},
	{L"^R +352([^0-9])",L"Серовский Тракт%1"},
	{L"^R +353([^0-9])",L"Дорога Нижний Тагил Нижняя Салда%1"},
	{L"^R +354([^0-9])",L"Дорога Екатеринбург Шадринск Курган%1"},
	{L"^R +355([^0-9])",L"Дорога Екатеринбург Полевской%1"},
	{L"^R +360([^0-9])",L"Дорога Южноуральск Магнитогорск%1"},
	{L"^R +361([^0-9])",L"Дорога Магнитогорск Сибай Зилаир Ира%1"},
	{L"^R +366([^0-9])",L"Дорога Бийск Мартыново Новокузнецк%1"},
	{L"^R +367([^0-9])",L"Дорога Мартыново Тогул Залесово%1"},
	{L"^R +368([^0-9])",L"Дорога Бийск Белокуриха%1"},
	{L"^R +369([^0-9])",L"Дорога Катунское Красный Яр Черга%1"},
	{L"^R +370([^0-9])",L"Дорога Поспелиха Курья Третьякова%1"},
	{L"^R +371([^0-9])",L"Дорога Алейск граница с Казахстаном на Павлодар%1"},
	{L"^R +372([^0-9])",L"Дорога Родино Благовещенка%1"},
	{L"^R +373([^0-9])",L"Дорога Иня Усть-Кокса Туэкта%1"},
	{L"^R +374([^0-9])",L"Дорога Белоярск Заринск%1"},
	{L"^R +375([^0-9])",L"Дорога Бийск Турочак Артыбаш%1"},
	{L"^R +380([^0-9])",L"Дорога Новосибирск Камень-на-Оби Барнаул%1"},
	{L"^R +381([^0-9])",L"Дорога Здвинск Барабинск Куйбышев%1"},
	{L"^R +382([^0-9])",L"Дорога Ордынское граница с Казахстаном на Павлодар%1"},
	{L"^R +383([^0-9])",L"Дорога Кочки Каргат%1"},
	{L"^R +384([^0-9])",L"Дорога Новосибирск Кемерово Юрга%1"},
	{L"^R +390([^0-9])",L"Дорога Омск Русская Поляна%1"},
	{L"^R +391([^0-9])",L"Дорога Горьковское Калачинск Оконешниково%1"},
	{L"^R +392([^0-9])",L"Дорога Омск Р402 Тара%1"},
	{L"^R +393([^0-9])",L"Дорога Омск Кокчетов%1"},
	{L"^R +398([^0-9])",L"Дорога Томск Каргала Колпашево%1"},
	{L"^R +399([^0-9])",L"Дорога Каргала Бакчар%1"},
	{L"^R +400([^0-9])",L"Дорога Томск Мариинск%1"},
	{L"^R +401([^0-9])",L"Дорога Тюмень аэропорт Рощино%1"},
	{L"^R +402([^0-9])",L"Дорога Тюмень Ишим Омск%1"},
	{L"^R +402([^0-9])",L"Дорога Тюмень Ишим Омск%1"},
	{L"^R +403([^0-9])",L"Дорога Ишим граница с Казахстаном на Петропавловск%1"},
	{L"^R +404([^0-9])",L"Дорога Тюмень Тобольск Ханты-Мансийск%1"},
	{L"^R +409([^0-9])",L"Дорога Красноярск Енисейск%1"},
	{L"^R +410([^0-9])",L"Дорога Канск Троицк%1"},
	{L"^R +411([^0-9])",L"Дорога Абакан Саяногорск%1"},
	{L"^R +412([^0-9])",L"Дорога Шарыпово Ужур Балахта%1"},
	{L"^R +413([^0-9])",L"Дорога Заозерный Агинское%1"},
	{L"^R +418([^0-9])",L"Дорога Иркутск Усть-Ордынский%1"},
	{L"^R +419([^0-9])",L"Дорога Тулун Братск Осетрово%1"},
	{L"^R +420([^0-9])",L"Дорога Залари Жигалово%1"},
	{L"^R +425([^0-9])",L"Дорога Петровск-Забайкальский Чикой Ярмаровка%1"},
	{L"^R +426([^0-9])",L"Дорога Могойтуй Нерчинск Сретенск%1"},
	{L"^R +427([^0-9])",L"Дорога Нерчинск Чернышевск%1"},
	{L"^R +428([^0-9])",L"Дорога Нерчинск Шоноктуй%1"},
	{L"^R +429([^0-9])",L"Дорога Сретенск Нерчинский завод Олочи%1"},
	{L"^R +430([^0-9])",L"Дорога Нерчинский Соловьевск%1"},
	{L"^R +431([^0-9])",L"Дорога Онон Цаган-Олуй%1"},
	{L"^R +436([^0-9])",L"Дорога Улан-Удэ Чита%1"},
	{L"^R +437([^0-9])",L"Дорога Романовка Багдарин%1"},
	{L"^R +438([^0-9])",L"Дорога Улан-Удэ Курумкан%1"},
	{L"^R +439([^0-9])",L"Дорога Турунтаево Татаурово%1"},
	{L"^R +440([^0-9])",L"Дорога Гусиноозерск Закаменск%1"},
	{L"^R +441([^0-9])",L"Дорога Мухоршибир Бичура Кяхта%1"},
	{L"^R +442([^0-9])",L"Дорога Кяхта Наушки граница с Монголией%1"},
	{L"^R +447([^0-9])",L"Дорога Находка Кавалерово%1"},
	{L"^R +448([^0-9])",L"Дорога Лазо Заповедный%1"},
	{L"^R +449([^0-9])",L"Дорога Лесное Тихменево%1"},
	{L"^R +454([^0-9])",L"Дорога Биробиджан Новое%1"},
	{L"^R +456([^0-9])",L"Дорога Бирофельд Биджан%1"},
	{L"^R +461([^0-9])",L"Дорога Благовещенск Облучье%1"},
	{L"^R +463([^0-9])",L"Дорога Толстовка Березовка%1"},
	{L"^R +464([^0-9])",L"Дорога Завитинск Поярково%1"},
	{L"^R +465([^0-9])",L"Дорога Екатеринославка Константиновка%1"},
	{L"^R +466([^0-9])",L"Дорога Райчихинск Бурея Новобурейский%1"},
	{L"^R +467([^0-9])",L"Дорога Архара Иннокентьевка%1"},
	{L"^R +468([^0-9])",L"Дорога Благовещенск Свободный%1"},
	{L"^R +469([^0-9])",L"Дорога Белогорск Новотроицкое%1"},
	{L"^R +474([^0-9])",L"Дорога Петропавловск-Камчатский Мильково%1"},
	{L"^R +475([^0-9])",L"Дорога Елизово Паратунка%1"},
	{L"^R +481([^0-9])",L"Дорога Магадан Балаганное Талон%1"},
	{L"^R +482([^0-9])",L"Дорога Магадан Солнечный Ола%1"},
	{L"^R +487([^0-9])",L"Дорога Южно-Сахалинск Александров-Сахалинский%1"},
	{L"^R +488([^0-9])",L"Дорога Корсаков Южно-Сахалинск Холмск%1"},
	{L"^R +489([^0-9])",L"Дорога Арсентьевка Ильинский%1"},
	{L"^R +490([^0-9])",L"Дорога Гастелло Углегорск%1"},
	{L"^R +491([^0-9])",L"Дорога Смирных Бошняково%1"},
	{L"^R +492([^0-9])",L"Дорога Южно-Сахалинск Анива Атласово%1"},
	{L"^R +493([^0-9])",L"Дорога Анива Ловецкое%1"},
	{L"^R +495([^0-9])",L"Дорога Южно-Сахалинск Холмск%1"},
	{L"^R +501([^0-9])",L"Дорога Якутск Вестях%1"},
	{L"^R +502([^0-9])",L"Дорога Якутск Амга%1"},
	{L"^R +503([^0-9])",L"Дорога Якутск Намцы%1"},
	{L"^R +508([^0-9])",L"Дорога Калининград Гусев Неман%1"},
	{L"^R +509([^0-9])",L"Дорога Добровольск Кутузово%1"},
	{L"^R +510([^0-9])",L"Дорога Добровольск граница с Польшей%1"},
	{L"^R +511([^0-9])",L"Дорога Краснознаменск Победино Р510%1"},
	{L"^R +512([^0-9])",L"Дорога Полесск Гвардейск Правдинск%1"},
	{L"^R +513([^0-9])",L"Дорога Советск Славск Мысовка%1"},
	{L"^R +514([^0-9])",L"Дорога Зорино Красное%1"},
	{L"^R +515([^0-9])",L"Дорога Зеленоградск Морское%1"},
	{L"^R +516([^0-9])",L"Дорога Калининград граница с Польшей%1"},
	{L"^R +517([^0-9])",L"Дорога Черняховск Озерск%1"},
	{L"/",L""},
}
VOICE["replace_mapinfo_roadnumber_name" .. mother_country] = {
	{L"^ +(%S+) +$", function (s)
		local strroad
		local t_roads = {
			{L"Беларусь",L"М 1"},
			{L"Крым",L"М 2"},
			{L"Украина",L"М 3"},
			{L"Дон",L"М 4"},
			{L"Урал",L"М 5"},
			{L"Волга",L"М 7"},
			{L"Холмогоры",L"М 8"},
			{L"Балтия",L"М 9"},
			{L"Россия",L"М 10"},
			{L"Кола",L"Р 21"},
			{L"Каспий",L"Р 22"},
			{L"Псков",L"Р 23"},
			{L"Вятка",L"Р 176"},
			{L"Кавказ",L"Р 217"},
			{L"Иртыш",L"Р 254"},
			{L"Сибирь",L"Р 255"},
			{L"Енисей",L"Р 257"},
			{L"Байкал",L"Р 258"},
			{L"Амур",L"Р 297"},
			{L"Колыма",L"Р 504"},
			{L"Сортавала",L"А 121"},
			{L"Транскам",L"А 164"},
			{L"Нарва",L"А 180"},
			{L"Скандинавия",L"А 181"},
			{L"Вилюй",L"А 331"},
			{L"Лена",L"А 360"},
			{L"Уссури",L"А 370"},
			{L"Восток",L"А 375"},
		}
		for _,roads in ipairs(t_roads) do if roads[1] == s then strroad = roads[2] break end end
		if strroad == nil then return L" "..s..L" " end
		local strroadtype = wstring.find(strroad, L"^М") and L" Трасса " or L" Дорога "
		return strroadtype..strroad..L" "..s..L" " end},
}
VOICE["replace_mapinfo" .. mother_country] = {
	{L"(.*)",L" %1 "},
	{L",",L" , "},
	{L"%([%S ]+%)",L" "},
	{L" [0-9]+%.[0-9]+ ",L" "},
	{L" ([0-9]+)",L"  %1"},
	{L" (%S)%.( ?)(%S)%. ", function (s1, s2, s3)
		if smart_lower_case_get_codegroup(wstring.byte(s1,1)) and smart_lower_case_get_codegroup(wstring.byte(s3,1)) then return L" " end
		return L" "..s1..L"."..s2..s3..L". " end},
	{L"Ак%.",L"Академика "},
	{L"Ал%.",L"Аллея "},
	{L"Бол%.",L"Большая "},
	{L"Буль?в?%.",L"Бульвар "},
	{L"Дор%. Без Имени",L" "},
	{L"Дорога Без Имени",L" "},
	{L"Екад ",L"Кольцевая Автодорога "},
	{L"Им[%. ]",L" Имени "},
	{L"Кад ",L"Кольцевая Автодорога "},
	{L"Км%.",L"Километр "},
	{L"Наб[%. ]",L"Набережная "},
	{L"Пер%.",L"Переулок "},
	{L"Пл%.",L"Площадь "},
	{L"Пр%-д ",L"Проезд "},
	{L"Пр ?%- ?т ",L"Проспект "},
	{L"(.*)Пр[%. ](.*)", function (s1, s3)
		local s2 = L" Проспект "
		local t = {L"Шмитовский", L"Серебрякова", L"Петровско%-Разумовский"}
		for _,v in ipairs(t) do
			if wstring.find(s1..s3,v) then s2 = L" Проезд " break end
		end
		return s1..s2..s3 end},
	{L"Просп%.",L"Проспект "},
	{L"Ст%.",L"Станция "},
	{L"Туп%.",L"Тупик "},
	{L"У[дл][%. ]",L"Улица "},
	{L" ш[%. ]",L" Шоссе "},
	{L"В Михайловский",L"Верхний Михайловский"},
	{L"Верх%. ?Сыромятническая",L"Верхняя Сыромятническая"},
	{L"Влксм",L"Комсомола"},
	{L"ние +Поля",L"ние Поля_"},
	{L"н%. ?Новгород[, ]",L"Нижний Новгород"},
	{L"Поля Фильтрации",L"Поля_ Фильтрации"},
	{L"Хх%-",L"20-"},
	{L"Brateyevo",L"Братеево"},
	{L"Domodedowo",L"Домодедово"},
	{L"Dzhubga",L"Джубга"},
	{L"Khimki",L"Химки"},
	{L"N%. ?Novgorod",L"Нижний Новгород"},
	{L"Podolьsk",L"Подольск"},
	{L"Sheremetyevo",L"Шереметьево"},
	{L"Sheremetъevo",L"Шереметьево"},
	{L"Shcherbinka",L"Щербинка"},
	{L"St%.",L"Sankt "},
	{L"Volokolamsk",L"Волоколамск"},
	{L"|",L""},
}
local mapinfo_numbers = {
	{L"", L"двух", L"трёх", L"четырёх", L"пяти", L"шести", L"семи", L"восьми", L"девяти"},
	{L"один", L"две", L"три", L"четыр", L"пят", L"шест", L"сем", L"восем", L"девят"},
	{L"", L"двадцать", L"тридцать", L"сорок", L"пятьдесят", L"шестьдесят", L"семьдесят", L"восемьдесят", L"девяносто"},
	{L"сто", L"двести", L"триста", L"четыреста", L"пятьсот", L"шестьсот", L"семьсот", L"восемьсот", L"девятьсот"},
	{L"тысяча", L"две тысячи", L"три тысячи", L"четыре тысячи", L"пять тысяч", L"шесть тысяч", L"семь тысяч", L"восемь тысяч", L"девять тысяч"},
}
VOICE["replace_mapinfo_numbers" .. mother_country] = {
	{L" 26[%- ]?Т?и? Бакинских ",L" двадцати шести Бакинских "},
	{L" ([0-9]+)%-Т?и Летия ",L" %1 Летия "},
	{L"%-й Конной Лахты",L"-Ой Конной Лахты"},
	{L"(.*)", function (s)
		local matched = 0
		wstring.gsub(s, L"([0-9]+)", function() matched = matched + 1 end)
		return (matched >= 2 and L"||" or L"")..wstring.gsub(s, L"Имени ", L"|Имени ") end},
	{L"([0-9]+) +(%S+)", function (s1,s2)
		local t = {L"Года", L"Партсъезда", L"Января", L"Февраля", L"Марта", L"Апреля", L"Мая", L"Июня", L"Июля", L"Августа", L"Сентября", L"Октября", L"Ноября", L"Декабря"}
		local suffix = L""
		for _,v in ipairs(t) do
			if s2==v then suffix = L"-о" break end
		end
		if s2==L"Километр" then suffix = L"-й" end
		if s2==L"Линия" then suffix = L"-я" end
		if s2==L"Пятилетки" then suffix = L"-Ой" end
		return s1..suffix..L" "..s2 end},
	{L"([^0-9]+) ([0-9]+) ([^0-9]+)", function (s1,s2,s3)
		local suffix = L""
		if wstring.find(s1..s3,L"Проезд") then suffix = L"-й" end
		if wstring.find(s3,L"Дивизии") then suffix = L"-Ой" end
		return s1..L" "..s2..suffix..L" "..s3 end},
	{L"([0-9]+)-й ([^0-9]+)", function (s1,s2)
		local t = {L"Дивизии", L"Армии", L"Батареи", L"Линии"}
		local suffix = L"-й"
		for _,v in ipairs(t) do
			if wstring.find(s2,v) then suffix = L"-Ой" break end
		end
		return s1..suffix..L" "..s2 end},

	{L" ([0-9])000[%- ]?А?я ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"тысячная| " end},
	{L" ([0-9])000[%- ]?Ой ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"тысячной " end},
	{L" ([0-9])000[%- ]?Ы?й ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"тысячный| " end},
	{L" ([0-9])000[%- ]?О?е ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"тысячное| " end},
	{L" ([0-9])000[%- ]?Г?о ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"тысячного " end},
	{L" ([0-9])000[%- ]?Летия ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"тысячелетия " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[АЬ]?я ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-я " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[ОЕ]й ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-Ой " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[ЫИ]?й ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-й " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[ОЬ]?е ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-е " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?Г?о ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" "..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-о " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?Летия ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" "..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-Летия " end},
	{L" ([0-9])00[%- ]?А?я ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"сотая| " end},
	{L" ([0-9])00[%- ]?Ой ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"сотой| " end},
	{L" ([0-9])00[%- ]?Ы?й ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"сотый| " end},
	{L" ([0-9])00[%- ]?О?е ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"сотое| " end},
	{L" ([0-9])00[%- ]?Г?о ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"сотого " end},
	{L" ([0-9])00[%- ]?Летия ", function (s)
		local t = {L"сто", L"двухсот", L"трёхсот", L"четырёхсот", L"пятьсот", L"шестьсот", L"семьсот", L"восемьсот", L"девятьсот"}
		return L" "..t[tonumber(s)]..L"летия " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[АЬ]?я ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-я " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[ОЕ]й ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-Ой " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[ЫИ]?й ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-й " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[ОЬ]?е ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-е " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?Г?о ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" "..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-о " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?Летия ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" "..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-Летия " end},
	{L" ([0-9])0[%- ]?А?я ", function (s)
		local t = {L"десятая", L"двадцатая", L"тридцатая", L"сороковая", L"пятидесятая", L"шестидесятая", L"семидесятая", L"восьмидесятая", L"девяностая"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?Ой ", function (s)
		local t = {L"десятой", L"двадцатой", L"тридцатой", L"сороковой", L"пятидесятой", L"шестидесятой", L"семидесятой", L"восьмидесятой", L"девяностой"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?Ы?й ", function (s)
		local t = {L"десятый", L"двадцатый", L"тридцатый", L"сороковой", L"пятидесятый", L"шестидесятый", L"семидесятый", L"восьмидесятый", L"девяностый"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?О?е ", function (s)
		local t = {L"десятое", L"двадцатое", L"тридцатое", L"сороковое", L"пятидесятое", L"шестидесятое", L"семидесятое", L"восьмидесятое", L"девяностое"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?Г?о ", function (s)
		local t = {L"десятого", L"двадцатого", L"тридцатого", L"сорокового", L"пятидесятого", L"шестидесятого", L"семидесятого", L"восьмидесятого", L"девяностого"}
		return L" "..t[tonumber(s)]..L" " end},
	{L" ([0-9])0[%- ]?Летия ", function (s)
		local t = {L"десяти", L"двадцати", L"тридцати", L"сорока", L"пятидесяти", L"шестидесяти", L"семидесяти", L"восьмидесяти", L"девяносто"}
		return L" "..t[tonumber(s)]..L"летия " end},
	{L" 1([0-9])[%- ]?А?я ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцатая| " end},
	{L" 1([0-9])[%- ]?Ой ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцатой| " end},
	{L" 1([0-9])[%- ]?Ы?й ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцатый| " end},
	{L" 1([0-9])[%- ]?О?е ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцатое| " end},
	{L" 1([0-9])[%- ]?Г?о ", function (s) return L" "..mapinfo_numbers[2][tonumber(s)]..L"надцатого " end},
	{L" 1([0-9])[%- ]?Летия ", function (s)
		local t = {L"одиннадцати", L"двенадцати", L"тринадцати", L"четырнадцати", L"пятнадцати", L"шестнадцати", L"семнадцати", L"восемнадцати", L"девятнадцати"}
		return L" "..t[tonumber(s)]..L"летия " end},
	{L" ([0-9])([0-9])[%- ]?[АЬ]?я ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-я " end},
	{L" ([0-9])([0-9])[%- ]?[ОЕ]й ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-Ой " end},
	{L" ([0-9])([0-9])[%- ]?[ЫИ]?й ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-й " end},
	{L" ([0-9])([0-9])[%- ]?[ОЬ]?е ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-е " end},
	{L" ([0-9])([0-9])[%- ]?Г?о ", function (s1,s2) return L" "..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-о " end},
	{L" ([0-9])([0-9])[%- ]?Летия ", function (s1,s2)
		local t = {L"", L"двадцати", L"тридцати", L"сорока", L"пятидесяти", L"шестидесяти", L"семидесяти", L"восьмидесяти", L"девяносто"}
		return L" "..t[tonumber(s1)]..L" "..s2..L"-Летия " end},
	{L" ([0-9])[%- ]?[АЬ]?я ", function (s)
		local t = {L"первая", L"вторая", L"третья", L"четвёртая", L"пятая", L"шестая", L"седьмая", L"восьмая", L"девятая"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?[ОЕ]й ", function (s)
		local t = {L"первой", L"второй", L"третьей", L"четвёртой", L"пятой", L"шестой", L"седьмой", L"восьмой", L"девятой"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?[ЫИ]?й ", function (s)
		local t = {L"первый", L"второй", L"третий", L"четвёртый", L"пятый", L"шестой", L"седьмой", L"восьмой", L"девятый"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?[ОЬ]?е ", function (s)
		local t = {L"первое", L"второе", L"третье", L"четвёртое", L"пятое", L"шестое", L"седьмое", L"восьмое", L"девятое"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?Г?о ", function (s)
		local t = {L"первого", L"второго", L"третьего", L"четвёртого", L"пятого", L"шестого", L"седьмого", L"восьмого", L"девятого"}
		return L" "..t[tonumber(s)]..L" " end},
	{L" ([0-9])[%- ]?Летия ", function (s)
		local t = {L"одно", L"двух", L"трёх", L"четырёх", L"пяти", L"шести", L"семи", L"восьми", L"девяти"}
		return L" "..t[tonumber(s)]..L"летия " end},

	{L"^||(.*)",function (s) return wstring.gsub(s, L"|", L"") end},
	{L"|(.*)|", function (s) return L"|"..wstring.gsub(s, L"|",L"")..L"|" end},
}
VOICE["replace_mapinfo_end" .. mother_country] = {
	{L" +м[%. ]+(.* +Улица) +",L" Малая %1 "},
	{L" +б[%. ]+(.* +Улица) +",L" Большая %1 "},
	{L" +м[%. ]+(.* +Переулок) +",L" Малый %1 "},
	{L" +б[%. ]+(.* +Переулок) +",L" Большой %1 "},
	{L" +м[%. ]+(.* +Тупик) +",L" Малый %1 "},
	{L" +б[%. ]+(.* +Тупик) +",L" Большой %1 "},
	{L" +м[%. ]+(.* +Проезд) +",L" Малый %1 "},
	{L" +б[%. ]+(.* +Проезд) +",L" Большой %1 "},
	{L" +в[%. ]+(.* +Улица) +",L" Верхняя %1 "},
	{L" +н[%. ]+(.* +Улица) +",L" Нижняя %1 "},
	{L" +в[%. ]+(.* +Переулок) +",L" Верхний %1 "},
	{L" +н[%. ]+(.* +Переулок) +",L" Нижний %1 "},
	{L" +в[%. ]+(.* +Проезд) +",L" Верхний %1 "},
	{L" +н[%. ]+(.* +Проезд) +",L" Нижний %1 "},
-- Слова "большой", "малый" и т.д. переносятся в начало строки: "1-ая большая улица" -> "большая первая улица"
	{L"(.*) +(Большой) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Большая) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Большое) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Большые) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Малый) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Малая) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Малое) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Малые) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Верхний) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Верхняя) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Верхнее) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Верхние) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Нижний) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Нижняя) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Нижнее) +(.*)",L" %2 %1 %3 "},
	{L"(.*) +(Нижние) +(.*)",L" %2 %1 %3 "},
-- Слова "первый", "второй" и т.д. переносятся в начало строки: "советская 1-я улица" -> "первая советская улица", "улица советская 1-ая" -> "первая улица советская"
	{L"(.*)|(.*)|(.*)",L" %2 %1 %3 "},
	{L" (%S)%.", function (s) if smart_lower_case_get_codegroup(wstring.byte(s,1)) then return L" " end return L" "..s..L". " end},
	{L"^([A-Z])([A-Z])[ ?]*([0-9]+)",L"%1.%2. %3"},
	{L"%-([0-9]+)",L" %1"},
	{L"([0-9])([a-zA-Z])",L"%1 %2"},
	{L"([a-zA-Z])([0-9])",L"%1 %2"},
	{L"//",L", "},
	{L" +",L" "},
	{L"^ ",L""},
	{L" $",L""},
}
VOICE["replace_mapinfo_inner" .. mother_country] = {}
VOICE["replace_mapinfo_inner2" .. mother_country] = {}
VOICE["match_inner" .. mother_country] = {}
VOICE["replace_tmc_description" .. mother_country] = {}
local replace_for_turns = {
	{L"(.*)",L" %1 "},
}
local replace_for_turns_end = {
	{L" +",L" "},
	{L"^ ",L""},
	{L" $",L""},
}
local replace_for_turns_inner = {
	{L"^ +Грунтовая Дорога +$",L" Грунтовую Дорогу "},
	{L"(.*) Дорога ",L" Дорогу %1 "},
	{L"(.*) Мост ",L" Мост %1 "},
	{L"(.*) Набережная ",L" Набережную %1 "},
	{L"(.*) Проезд ",L" Проезд %1 "},
	{L"(.*) Станция ",L" Станцию %1 "},
}
local replace_for_turns_inner2 = {
	{L"(.*) Аллея ",L" Аллею %1 "},
	{L"(.*) Бульвар ",L" Бульвар %1 "},
	{L"(.*) Выезд ",L" Выезд %1 "},
	{L"(.*) Въезд ",L" Въезд %1 "},
	{L"(.*) Микрорайон ",L" Микрорайон %1 "},
	{L"(.*) Переезд ",L" Переезд %1 "},
	{L"(.*) Переулок ",L" Переулок %1 "},
	{L"(.*) Площадь ",L" Площадь %1 "},
	{L"(.*) Проспект ",L" Проспект %1 "},
	{L"(.*) Спуск ",L" Спуск %1 "},
	{L"(.*) Трасса ",L" Трассу %1 "},
	{L"(.*) Тупик ",L" Тупик %1 "},
	{L"(.*) Улица ",L" Улицу %1 "},
	{L"^ +Кольцевая Автодорога +$",L" Кольцевую Автодорогу "},
}
VOICE["replace_cities_for_turns" .. mother_country] = {
	{L"^(%S+)ая$", L"%1ую"},
	{L"^(%S+)яя$", L"%1юю"},
	{L"^(%S+)а$", L"%1у"},
	{L"^(%S+)я$", L"%1ю"},
	{L"^Белая Калитва$", L"Белую Калитву"},
	{L"^Белая Холуница$", L"Белую Холуницу"},
	{L"^Верхняя Пышма$", L"Верхнюю Пышму"},
	{L"^Верхняя Салда$", L"Верхнюю Салду"},
	{L"^Верхняя Тура$", L"Верхнюю Туру"},
	{L"^Белая Калитва$", L"Белую Калитву"},
	{L"^Западная Двина$", L"Западную Двину"},
	{L"^Малая Вишера$", L"Малую Вишеру"},
	{L"^Нижняя Салда$", L"Нижнюю Салду"},
	{L"^Нижняя Тура$", L"Нижнюю Туру"},
	{L"^Новая Ладога$", L"Новую Ладогу"},
	{L"^Новая Ляля$", L"Новую Лялю"},
	{L"^Советская Гавань$", L"Советскую Гавань"},
	{L"^Старая Русса$", L"Старую Руссу"},
}
local replace_for_directions_inner = {
	{L"^ +Грунтовая Дорога +$",L" Грунтовой Дороге "},
	{L"(.*) Дорога ",L" Дороге %1 "},
	{L"(.*) Мост ",L" Мосту %1 "},
	{L"(.*) Набережная ",L" Набережной %1 "},
	{L"(.*) Проезд ",L" Проезду %1 "},
	{L"(.*) Станция ",L" Станции %1 "},
	{L"(.*) Шоссе ",L" Шоссе %1 "},
}
local replace_for_directions_inner2 = {
	{L"(.*) Аллея ",L" Аллее %1 "},
	{L"(.*) Бульвар ",L" Бульвару %1 "},
	{L"(.*) Выезд ",L" Выезду %1 "},
	{L"(.*) Въезд ",L" Въезду %1 "},
	{L"(.*) Микрорайон ",L" Микрорайону %1 "},
	{L"(.*) Переезд ",L" Переезду %1 "},
	{L"(.*) Переулок ",L" Переулку %1 "},
	{L"(.*) Площадь ",L" Площади %1 "},
	{L"(.*) Проспект ",L" Проспекту %1 "},
	{L"(.*) Спуск ",L" Спуску %1 "},
	{L"(.*) Трасса ",L" Трассе %1 "},
	{L"(.*) Тупик ",L" Тупику %1 "},
	{L"(.*) Улица ",L" Улице %1 "},
	{L"^ +(%S+)е +Кольцо +$", L" %1му Кольцу "},
	{L"^ +(%S+)е +(%S+)е +Кольцо +$", L" %1му %2му Кольцу "},
	{L"^ +Кольцевая Автодорога +$",L" Кольцевой Автодороге "},
	{L"^ +[Тт]ретьму (.*)",L" Третьему %1 "},
}
local replace_for_traffic_fromto_inner = {
	{L"^ +Грунтовая Дорога +$",L" Грунтовой Дороги "},
	{L"(.*) Дорога ",L" Дороги %1 "},
	{L"(.*) Мост ",L" Моста %1 "},
	{L"(.*) Набережная ",L" Набережной %1 "},
	{L"(.*) Проезд ",L" Проезда %1 "},
	{L"(.*) Станция ",L" Станции %1 "},
	{L"(.*) Шоссе ",L" Шоссе %1 "},
}
local replace_for_traffic_fromto_inner2 = {
	{L"(.*) Аллея ",L" Аллеи %1 "},
	{L"(.*) Бульвар ",L" Бульвара %1 "},
	{L"(.*) Выезд ",L" Выезда %1 "},
	{L"(.*) Въезд ",L" Въезда %1 "},
	{L"(.*) Микрорайон ",L" Микрорайона %1 "},
	{L"(.*) Переезд ",L" Переезда %1 "},
	{L"(.*) Переулок ",L" Переулка %1 "},
	{L"(.*) Площадь ",L" Площади %1 "},
	{L"(.*) Проспект ",L" Проспекта %1 "},
	{L"(.*) Спуск ",L" Спуска %1 "},
	{L"(.*) Трасса ",L" Трассы %1 "},
	{L"(.*) Тупик ",L" Тупика %1 "},
	{L"(.*) Улица ",L" Улицы %1 "},
	{L"^ +(%S+)е +Кольцо +$", L" %1го Кольца "},
	{L"^ +(%S+)е +(%S+)е +Кольцо +$", L" %1го %2го Кольца "},
	{L"^ +Кольцевая Автодорога +$",L" Кольцевой Автодороги "},
	{L"^ +[Тт]ретьго (.*)",L" Третьего %1 "},
}
local replace_for_traffic_on_inner = {
	{L"^ +Грунтовая Дорога +$",L" Грунтовой Дороге "},
	{L"(.*) Дорога ",L" Дороге %1 "},
	{L"(.*) Мост ",L" Мосту %1 "},
	{L"(.*) Набережная ",L" Набережной %1 "},
	{L"(.*) Проезд ",L" Проезде %1 "},
	{L"(.*) Станция ",L" Станции %1 "},
	{L"(.*) Шоссе ",L" Шоссе %1 "},
}
local replace_for_traffic_on_inner2 = {
	{L"(.*) Аллея ",L" Аллее %1 "},
	{L"(.*) Бульвар ",L" Бульваре %1 "},
	{L"(.*) Выезд ",L" Выезде %1 "},
	{L"(.*) Въезд ",L" Въезде %1 "},
	{L"(.*) Микрорайон ",L" Микрорайоне %1 "},
	{L"(.*) Переезд ",L" Переезде %1 "},
	{L"(.*) Переулок ",L" Переулке %1 "},
	{L"(.*) Площадь ",L" Площади %1 "},
	{L"(.*) Проспект ",L" Проспекте %1 "},
	{L"(.*) Спуск ",L" Спуске %1 "},
	{L"(.*) Трасса ",L" Трассе %1 "},
	{L"(.*) Тупик ",L" Тупике %1 "},
	{L"(.*) Улица ",L" Улице %1 "},
	{L"^ +(%S+)е +Кольцо +$", L" %1м Кольце "},
	{L"^ +(%S+)е +(%S+)е +Кольцо +$", L" %1м %2м Кольце "},
	{L"^ +Кольцевая Автодорога +$",L" Кольцевой Автодороге "},
	{L"^ +[Тт]ретьм (.*)",L" Третьем %1 "},
}
local replace_for_summary_inner = {
	{L"(.*) Дорога ",L" Дорога %1 "},
	{L"(.*) Мост ",L" Мост %1 "},
	{L"(.*) Набережная ",L" Набережная %1 "},
	{L"(.*) Проезд ",L" Проезд %1 "},
	{L"(.*) Станция ",L" Станция %1 "},
}
local replace_for_summary_inner2 = {
	{L"(.*) Аллея ",L" Аллея %1 "},
	{L"(.*) Бульвар ",L" Бульвар %1 "},
	{L"(.*) Выезд ",L" Выезд %1 "},
	{L"(.*) Въезд ",L" Въезд %1 "},
	{L"(.*) Микрорайон ",L" Микрорайон %1 "},
	{L"(.*) Переезд ",L" Переезд %1 "},
	{L"(.*) Переулок ",L" Переулок %1 "},
	{L"(.*) Площадь ",L" Площадь %1 "},
	{L"(.*) Проспект ",L" Проспект %1 "},
	{L"(.*) Спуск ",L" Спуск %1 "},
	{L"(.*) Трасса ",L" Трасса %1 "},
	{L"(.*) Тупик ",L" Тупик %1 "},
	{L"(.*) Улица ",L" Улица %1 "},
}
local replace_sentence={
	{L"/",L" , "},
	{L" +",L" "},
	{L" затем ",L" , затем "},
	{L" там ",L" , там "},
}
local function get_preposition(str, tbl)
	for k,value in ipairs(tbl) do
		for _,pattern in ipairs(tbl[k][2]) do
			if wstring.find(str,pattern) then
				return tbl[k][1]
			end
		end
	end
end

----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------

local function not_settlement(str, direction)
	if transform_pattern_match(str,preposition_tbl) then return L"" end
        return get_preposition(str, direction and preposition_insert_tbl_direction or preposition_insert_tbl)
end
local function wlocalize_table(tname,tcountry)
	if tcountry == mother_country then return VOICE[tname .. mother_country] end
	local localized = ""
	for _,v in pairs(wlocalized.countries) do
		if v == tcountry then localized = v break end
	end
	local need_load = localized ~= ""
	if need_load then need_load = not wlocalized["loaded"..localized] end
	if need_load then pcall(dofile, L"%app%/config/config_transforms"..towstring(localized)..L".lua") end
	if type(VOICE[tname .. localized]) ~= "table" then localized = mother_country end
	return VOICE[tname .. localized]
end
local function check_unknown_country(country)
	if country == nil then
		MODEL.other.country_info.select_country_by_pos(MODEL.navigation.car.position())
		local countryindex = MODEL.other.country_info.list.index()
		if countryindex ~= nil then
			country = MODEL.other.country_info.list[countryindex].name()
		end
	end
	return string.lower(country)
end

local function format_mapinfo(str, country, roadnumber_name)
	country = check_unknown_country(country)
	str = smart_lower_case(str)
	if roadnumber_name then str = transform_and_format(str, wlocalize_table("replace_mapinfo_roadnumber_name",country)) end
	local replace_mapinfo_inner_need = transform_pattern_match(str..L" ",wlocalize_table("match_inner",country))
	str = transform_and_format(transform_and_format(transform_and_format(str, wlocalize_table("replace_mapinfo",country)), replace_mapinfo_inner_need and wlocalize_table("replace_mapinfo_inner",country)), wlocalize_table("replace_mapinfo_inner2",country))
	local replace_mapinfo_numbers_need = wstring.find(str,L"[0-9]")
	return transform_and_format(transform_and_format(str, replace_mapinfo_numbers_need and wlocalize_table("replace_mapinfo_numbers",country)), wlocalize_table("replace_mapinfo_end",country))
end

local function format_roadnumber(number, country)
	country = check_unknown_country(country)
	local str = transform_format_roadnumber_eu(transform_and_format(number, replace_roadnumber_prepare))
	local need2text = roadnumber_mode
	if VOICE["replace_roadnumber" .. mother_country] == wlocalize_table("replace_roadnumber",country) and need2text then need2text = country == mother_country end
	local str1 = transform_and_format(str, need2text and wlocalize_table("replace_roadnumber",country))
	if str1 == str then
		str1 = wstring.gsub(str1,L"E +",L"Е ")
		str1 = wstring.gsub(str1,L",",L" , ")
	elseif wstring.find(number,L"/") then
		str1 = wstring.gsub(str1,L"(.*),(.*)",L"%1")
	end
	return format_all_numbers2text(str1)
end

local function format_cases(str, case, mapinfo)
	local str_input = str
	str=transform_and_format(str, replace_for_turns)
	local t_inner = replace_for_turns_inner
	local t_inner2 = replace_for_turns_inner2
	if case == "for_directions" then
		t_inner = replace_for_directions_inner
		t_inner2 = replace_for_directions_inner2
	elseif case == "for_summary" then
		t_inner = replace_for_summary_inner
		t_inner2 = replace_for_summary_inner2
	elseif case == "for_traffic_on" then
		t_inner = replace_for_traffic_on_inner
		t_inner2 = replace_for_traffic_on_inner2
	elseif case == "for_traffic_fromto" then
		t_inner = replace_for_traffic_fromto_inner
		t_inner2 = replace_for_traffic_fromto_inner2
	end
	if not transform_pattern_match(str, main_streetnames) then str = transform_and_format(str, t_inner) end
	local matched = 0
	for _,v in ipairs(main_streetnames) do
		if wstring.find(str,v) then wstring.gsub(str, v, function() matched = matched + 1 end) end
	end
	if matched < 2 then str = transform_and_format(str, t_inner2) end
	str = transform_and_format(str, replace_for_turns_end)
	if wstring.find(str,L"[0-9]$") then str = format_all_numbers2text(str) end
	if mapinfo == nil or str == L"" or case == "for_summary" or case == "for_traffic_fromto" then
		return str
	else
		return not_settlement(str_input, case == "for_directions") .. str
	end
end

function format_tmc_description(str, country)
	country = check_unknown_country(country)
	local announce = SysConfig:get("tts", "announce_speed_unit", true)
	local wtmc_units = {"km/h", "mph"}
	str = transform_and_format(str, wlocalize_table("replace_tmc_description",country))
	for _,v in pairs(wtmc_units) do
		local value = announce and (MODEL.regional.is_it_voice_localizable(m_i18n_voice(v)) and translate_voice(v) or translate(v)) or L""
		str = wstring.gsub(str, L"([0-9]+) -"..translate(v),L"%1 "..value)
	end
	return str
end

local function signpost_exit(data, idx)
	local exitnumber = data[idx].signpost.exitnumber
	local exitname = data[idx].signpost.exitname
	local strnumber, strname = L"", L""
	local preposition_name = true
	if exitnumber then
		strnumber = wstring.gsub(exitnumber.text,L"([0-9]+)",L"%1 ")
		strnumber = format_all_numbers2text(strnumber)
		preposition_name = nil
	end
	if exitname then
		strname=exitname.text
		voice_debug_log(L"TTS: signpost_exitname in: '"..strname..L"'", 3)
		strname = format_cases(format_mapinfo(strname, data[idx].signpost.country), "for_turns", preposition_name)
		voice_debug_log(L"TTS: signpost_exitname out: '"..strname..L"'", 3)
	end
	if exitnumber or exitname then
		return exit_preposition .. L" " .. strnumber .. (exitnumber and exitname and L"/" or L"") .. strname
	end
end

local function signpost_destination(data, idx)
	local dest
	if not ( data[idx].signpost and data[idx].road ) then return end
	if data[idx].signpost.destination and wstring.find( data[idx].signpost.destination.text, L"[A-z]" ) and data[idx].road then
	dest = data[idx].road.name --amk data[idx].signpost.destination
	else
	  dest = data[idx].signpost.destination
	end
	if dest then
		local str=dest.text
		voice_debug_log(L"TTS: signpost_destination in: '"..str..L"'", 3)
		str = format_cases(transform_and_format(format_mapinfo(str, data[idx].signpost.country), wlocalize_table("replace_cities_for_turns",check_unknown_country(data[idx].signpost.country))), "for_turns", true)
		voice_debug_log(L"TTS: signpost_destination out: '"..str..L"'", 3)
		return str
	end
end

local function signpost_settlement(data, idx) 			--  в "напрвлении" где символы  '>>'
	local settlement = data[idx].signpost.settlement
	if not ( settlement and data[idx].road ) then return end
	if settlement and wstring.find( settlement.text, L"[A-z]" ) and data[idx].road then
		settlement = data[idx].road.name --amk
	end

	if settlement then
		local str=settlement.text
		voice_debug_log(L"TTS: signpost_settlement in: '"..str..L"'", 3)
		str = format_cases(transform_and_format(format_mapinfo(str, data[idx].signpost.country),wlocalize_table("replace_cities_for_turns",check_unknown_country(data[idx].signpost.country))), "for_turns")
		if not wstring.find(settlement.text,settlement_preposition) then
			str=settlement_preposition .. L" " .. str
		end
		voice_debug_log(L"TTS: signpost_settlement out: '"..str..L"'", 3)
		return str
	end
end

local function signpost_roadnumber(data, idx)    		--  название трассы M1 ... Mx
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then
		local str=roadnumber.text
		voice_debug_log(L"TTS: signpost_roadnumber in: '"..str..L"'", 3)
		str = format_cases(format_roadnumber(str, data[idx].signpost.country), "for_turns", true)
		voice_debug_log(L"TTS: signpost_roadnumber out: '"..str..L"'", 3)
		return str
	end
end

local function road_number_name(data, idx)
	local number = data[idx].road.number
	local name = data[idx].road.name
	local country = data[idx].road.country
	local road_changed, strnumber, strname
	local t_for_turns = "for_turns"
	if number then road_changed = number.change
	elseif name then road_changed = name.change end
	if not use_dativ_for_sameroad then
	elseif road_changed ~= nil then t_for_turns = not road_changed and "for_directions" or "for_turns"
	elseif idx == 1 then t_for_turns = wsameroadname and "for_directions" or "for_turns"
	elseif idx == 2 then
		t_for_turns = check_same_maneuvers_done(data, idx, wprevroadtable) and "for_directions" or "for_turns"
		local match = t_for_turns == "for_directions" and L"same" or L"other"
		local str = get_full_roadname(data[idx].road)
		voice_debug_log(L"TTS: sameroadname then: " .. match .. L" road'"..str..L"'", 3)
	end
	if number and name then
		strnumber=number.text
		strname=name.text
		voice_debug_log(L"TTS: road_number in: '"..strnumber..L"'", 3)
		voice_debug_log(L"TTS: road_name in: '"..strname..L"'", 3)
		strnumber = format_cases(format_roadnumber(strnumber, country), t_for_turns, true)
		strname = format_cases(format_mapinfo(strname, country, true), t_for_turns)
		voice_debug_log(L"TTS: road_number out: '"..strnumber..L"'", 3)
		voice_debug_log(L"TTS: road_name out: '"..strname..L"'", 3)
		return strnumber .. L"/" .. strname
	elseif number then
		strnumber=number.text
		voice_debug_log(L"TTS: road_number in: '"..strnumber..L"'", 3)
		strnumber = format_cases(format_roadnumber(strnumber, country), t_for_turns, true)
		voice_debug_log(L"TTS: road_number out: '"..strnumber..L"'", 3)
		return strnumber
	elseif name then
		strname=name.text
		voice_debug_log(L"TTS: road_name in: '"..strname..L"'", 3)
		strname = format_cases(format_mapinfo(strname, country, true), t_for_turns, true)
		voice_debug_log(L"TTS: road_name out: '"..strname..L"'", 3)
		return strname
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exit, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber,data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number_name, 	data, idx)
	end
	return table_concat(t, L"/")
end

function format_streetname(data, idx)
	local t = {}
	if data[idx].road then t = transform_chain({}, road_number_name, data, idx) end
	return table_concat(t, L"/")
end

function format_sentence(str)
	for key, value in ipairs(replace_sentence) do
		str = wstring.gsub(str,value[1],value[2])
	end
	return str
end

local function format_replace_shield(str)
	for i=4190, 4200 do
		str = wstring.gsub(str, wstring.char(i),L"|")
	end
	str = wstring.gsub(str, wstring.char(4244),L"|")
	str = wstring.gsub(str, wstring.char(4255),L"|")
	str = wstring.gsub(str, L"|(.*)|",L"")
	return wstring.gsub(str, L"|",L"")
end

function format_street_name(streetname)
	voice_debug_log(L"TTS: streetname from skin in: '"..streetname..L"'", 3)
	streetname = format_replace_shield(streetname)
	if wstring.sub(streetname, 1, 9) == L"for_turns" then
		local no_settlement = true
		local sett_preposition = L""
		streetname = wstring.sub(streetname, 10)
		if wstring.find(streetname, wstring.char(187)) then
			no_settlement = nil
			sett_preposition = settlement_preposition .. L" "
			streetname = wstring.gsub(streetname, wstring.char(187),L"")
		end
		streetname = wstring.gsub(streetname, L",", L"/")
		local t = {}
		if wstring.find(streetname, L"/") then
			wstring.gsub(streetname, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, s) end end)
			if #t then streetname = t[1] end
		end
		streetname = format_mapinfo(streetname)
		local matched = 0
		for _,v in ipairs(main_streetnames) do
			streetname = wstring.gsub(streetname, v,  function()
				matched = matched + 1
				if matched > 1 then return L"/"..v
				else return v end
			end)
		end
		t = {}
		if wstring.find(streetname, L"/") then
			wstring.gsub(streetname, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, s) end end)
			if #t then streetname = t[1] end
		end
		streetname = sett_preposition .. format_cases(streetname, "for_turns", no_settlement)
	else
		streetname = format_cases(format_mapinfo(streetname), "for_summary")
	end
	voice_debug_log(L"TTS: streetname from skin out: '"..streetname..L"'", 3)
	return streetname
end

function format_waypointname(data, idx)
        local str = L""
	if announce_waypointname and waypointname ~= L"" and idx == 1 then
		str = format_replace_shield(waypointname)
		voice_debug_log(L"TTS: waypointname in: '"..str..L"'", 3)
		str = wstring.gsub(str, L"([0-9]+)(%S)[ +]?$", function (s1,s2)
			if smart_lower_case_get_codegroup(wstring.byte(s2,1)) > 2 then return s1..wstring.char(2200)..s2 end
			return s1..s2 end)
	        local m_sign = wstring.char(215)
		local t = {}
		if wstring.find(str, m_sign) then
			wstring.gsub(str, L"([^"..m_sign..L"]+)"..m_sign..L"?", function(s) if wstring.gsub(s,L" ",L"")~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
			for k,v in ipairs(t) do t[k] = format_cases(format_mapinfo(v), "for_traffic_fromto") end
		end
		if #t > 1 then str = L" перекресток " .. table_concat(t, L" и ")
		else str = format_cases(format_mapinfo(str), "for_summary") end
		str = wstring.gsub(str, wstring.char(2200), L" ")
		voice_debug_log(L"TTS: waypointname out: '"..str..L"'", 3)
	end
	return str
end

local transform_roadnumber_explode_eu_origvoice = transform_roadnumber_explode_eu
transform_roadnumber_explode_eu = function(str)
	local t = transform_roadnumber_explode_eu_origvoice(str)
	for k in ipairs(t) do
		if t[k+1] and wstring.gsub(t[k], L" ", L"") == wstring.gsub(t[k+1], L" ", L"") then
			table.remove(t, k+1)
		end
	end
	return t
end

----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------

function route_summary_format_road_name(data)
        local str = data.text
	voice_debug_log(L"TTS: summary roadnumber in: '"..str..L"'", 3)
	str = format_roadnumber(str,"")
	voice_debug_log(L"TTS: summary roadnumber out: '"..str..L"'", 3)
	return str
end

function route_summary_format_street_name(data)
        local str = data.text
	voice_debug_log(L"TTS: summary streetname in: '"..str..L"'", 3)
	str = format_cases(format_mapinfo(str), "for_summary")
	voice_debug_log(L"TTS: summary streetname out: '"..str..L"'", 3)
	return str
end

function route_summary_format_bridge_tunnel(data)
        local str = data.text
	voice_debug_log(L"TTS: summary bridge_tunnel in: '"..str..L"'", 3)
	str = format_cases(format_mapinfo(str), "for_summary")
	voice_debug_log(L"TTS: summary bridge_tunnel out: '"..str..L"'", 3)
	return str
end

function route_summary_format_order(data)
        local str = data.text
	voice_debug_log(L"TTS: summary order in: '"..str..L"'", 3)
	str = format_cases(format_mapinfo(str), "for_summary")
	voice_debug_log(L"TTS: summary order out: '"..str..L"'", 3)
	return str
end

----------------------------------------------------------------------------------------------------
local function format_string2unicode(str)
	if not SysConfig:get("tts", "voice_log_to_unicode_chars", 0) then return str end
	local out, uni_code, repl_str
	out = L""
	for i = 1, #str do
		uni_code = wstring.byte(str, i)
		if uni_code >= 1025 and uni_code <= 1111 then repl_str = L"|"..wstring.sub(towstring(uni_code),2,4)
		else repl_str = wstring.sub(str,i,i) end
		out = out .. repl_str
	end
	return out
end
local voice_debug_log_origvoice = voice_debug_log
voice_debug_log = function(message, level)
	message = format_string2unicode(towstring(message))
	voice_debug_log_origvoice(message, level)
end
function smart_lower_case_get_codegroup(s)
	return s>=65 and s<=90 and 1 or (s>=97 and s<=122 and 2 or (s>=1040 and s<=1071 and 3 or (s>=1072 and s<=1103 and 4 or (s>=1025 and s<=1031 and 5 or (s>=1105 and s<=1111 and 6 or 0)))))
end
function smart_lower_case_inner1(s1, s3)
	local s2 = smart_lower_case_get_codegroup(wstring.byte(s1,1)) and (smart_lower_case_get_codegroup(wstring.byte(s3,1)) or wstring.byte(s3,1) == 32) and L"ь" or L"`"
	return s1..s2..s3
end
function smart_lower_case_inner2(s1, s3)
	local s2 = smart_lower_case_get_codegroup(wstring.byte(s1,1)) and (smart_lower_case_get_codegroup(wstring.byte(s3,1)) or wstring.byte(s3,1) == 32) and L"ъ" or L"'"
	return s1..s2..s3
end
function smart_lower_case_inner3(s1,s2,s3)
	local upper_shift = {0,-32,0,-32,0,-80}
	local lower_shift = {32,0,32,0,80,0}
	local shift, group1, group2, group3 = 0, smart_lower_case_get_codegroup(s1), smart_lower_case_get_codegroup(s2), smart_lower_case_get_codegroup(s3)
	if group2 then
		if not group1 and not group3 or group1 then shift = lower_shift[group2] end
		if not group1 and group3 then shift = upper_shift[group2] end
	end
	return wstring.char(s2+shift)
end
function smart_lower_case(str)
	str = wstring.gsub(str, wstring.char(4244),L" ")
	str = wstring.gsub(str, wstring.char(4255),L" ")
	str = L" " .. format_sentence(str) .. L" "
	str = wstring.gsub(str, L" [`'](%S+)[`'] ", L" %1 ")
	str = wstring.gsub(str, L"(%S)`(.*)", smart_lower_case_inner1)
	str = wstring.gsub(str, L"(%S)'(.*)",  smart_lower_case_inner2)
	local out = L" "
	for i = 2, #str-1 do
		out = out .. smart_lower_case_inner3(wstring.byte(str,i-1),wstring.byte(str,i),wstring.byte(str,i+1))
	end
	return out .. L" "
end
----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

-- 1. Zar az M0 uton, Martonvasar kozeleben. = in die Strasse Numer A1, in der Nahe von Martonvasar./ in der Nahe von der HaupStrasse Numer 33.
-- 2. Zar az M0 uton, Martonvasar es Velence kozt. = in die Strasse Numer A1, zwischen Martonvasar und Velence.
-- 3. Zar a Budai uton, a Budai ut Fiskalis ut keresztezodesben = in der/dem (lsd tabla) Budai ut, in der Kreuzung Budai ut und Fiskalis ut.
-- 4. Zar a Budai uton, Fiskalis ut es 8. ut kozott. = in der/dem Budai ut, zwischen Fiskalis ut und 8. ut.

function traffic_event_supported()
	return true
end
local function traffic_fromto_format_func(str)
	return wstring.gsub(str,L"^ ?(%S) ?[0-9]+$",
		function (s)
			if smart_lower_case_get_codegroup(wstring.byte(s,1)) then return L"" else return s end
		end) == L"" and format_roadnumber or format_mapinfo
end
local function transform_traffic_fromto(fromto, str, roadname)
	local t = {}
	wstring.gsub(str, L"([^,]+),?", function(s) if s~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
	for k in ipairs(t) do
		if roadname~=L"" and t[k+1] and (wstring.find(roadname, t[k+1]) or roadname==t[k+1]) then table.remove(t, k+1) end
	end
	if roadname~=L"" and (wstring.find(roadname, t[1]) or roadname==t[1]) then table.remove(t, 1) end
	if #t then
		str = t[1]
		if wstring.find(str, L"/") then
			t = {}
			wstring.gsub(str, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
			local str_format_function, str_is_number = nil, false
			for k,v in ipairs(t) do
				str_format_function = traffic_fromto_format_func(v)
				if str_format_function == format_roadnumber then str_is_number = true end
				t[k] = format_cases(str_format_function(v), "for_traffic_fromto")
			end
			if str_is_number then
				for k in ipairs(t) do
					if t[k+1] and wstring.gsub(t[k], L" ", L"") == wstring.gsub(t[k+1], L" ", L"") then table.remove(t, k+1) end
				end
			end
			return fromto .. (#t > 1 and L" перекрестка " or L" ") .. table_concat(t, L" и ")
		else
			return fromto .. L" " .. format_cases(traffic_fromto_format_func(str)(str), "for_traffic_fromto")
		end
	end
	return L""
end
local function traffic_event_distance_get(dist)
	local unit_names = {"yards","meters","feet"}
	dist_table = distances[unit_names[MODEL.regional.units() + 1]]
	local _, _, f_dist = distance_formatter(dist)
	local dist_idx = search_distance_index(f_dist)
	local code_string
	if f_dist == dist_table[dist_idx] then code_string = dist_table[dist_idx + 1]
	else code_string = dist_table[search_distance_index(dist) + 1] end
	return decode_string(code_string, 1)
end
function traffic_event(DescKey, data)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	local traffic_on, traffic_roadnumber, traffic_roadname, traffic_from, traffic_to, voice_from, voice_to = L"", L"", L"", L"", L"", L"", L""
	if data.roadnumber then
		traffic_roadnumber = data.roadnumber.text
		voice_debug_log(L"TTS: traffic on roadnumber in: '"..traffic_roadnumber..L"'", 3)
		traffic_on = format_cases(format_roadnumber(traffic_roadnumber), "for_traffic_on",true)
		voice_debug_log(L"TTS: traffic on roadnumber out: '"..traffic_on..L"'", 3)
	end
	if data.roadname then
		local roadnumber_nonexist = true
		if traffic_on ~= L"" then traffic_on = traffic_on .. L"/" roadnumber_nonexist = nil end
		traffic_roadname = data.roadname.text
		voice_debug_log(L"TTS: traffic on roadname in: '"..traffic_roadname..L"'", 3)
		if wstring.find(traffic_roadname, L"/") then
			local t = {}
			wstring.gsub(traffic_roadname, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
			if #t then traffic_on = traffic_on .. format_cases(format_mapinfo(t[1]), "for_traffic_on", roadnumber_nonexist) end
			if #t>1 then traffic_on =  traffic_on .. L" в районе " .. format_cases(format_mapinfo(t[2]), "for_traffic_fromto") end
		else
			traffic_on = traffic_on .. format_cases(format_mapinfo(traffic_roadname), "for_traffic_on", roadnumber_nonexist)
		end
		voice_debug_log(L"TTS: traffic on roadname out: '"..traffic_on..L"'", 3)
	end
	if data.roadname then traffic_roadname = data.roadname.text end
	if traffic_on ~= L"" then traffic_on = L" " .. traffic_on end
	if data.from then
		voice_from = data.from.text
		voice_debug_log(L"TTS: traffic from in: '"..voice_from..L"'", 3)
		traffic_from = transform_traffic_fromto((data.to and L" , от" or L" , около"), voice_from, traffic_roadname)
		voice_debug_log(L"TTS: traffic from out: '"..traffic_from..L"'", 3)
	end
	if data.to then
		voice_to = data.to.text
		voice_debug_log(L"TTS: traffic to in: '"..voice_to..L"'", 3)
		traffic_to = transform_traffic_fromto(L" , до", voice_to, traffic_roadname)
		voice_debug_log(L"TTS: traffic to out: '"..traffic_to..L"'", 3)
	end
	local traffic_description, traffic_distance = translate_voice(DescKey), L""
	local traffic_description_on = traffic_events_description and MODEL.regional.current_language.lcid() == MODEL.regional.current_voice.lcid()
	if traffic_description_on then traffic_description_on = transform_pattern_match(towstring(DescKey), {L"ahead", L"blocked"}) end
	if (traffic_description_on or traffic_events_distance) and (data.roadnumber or data.roadname or data.from or data.to) then
		local current
		for i = 0, #MODEL.traffic.events.significant_events - 1 do
			current = MODEL.traffic.events.significant_events[i]
			local roadnumber_str = current.roadnumber_enc()
			if roadnumber_str ~= L"" and roadnumber_str ~= nil then roadnumber_str = wstring.gsub(L" "..roadnumber_str..L" ", L"(.*)([a-zA-Z]+)[%- ]?([0-9]+)(.*)",L"%2%3")
			else roadnumber_str = L"" end
			if traffic_roadnumber == roadnumber_str and traffic_roadname == current.road_name() and voice_to == current.location_to() and voice_from == current.location_from() then
				if current.description() ~= L"" and traffic_description_on then traffic_description = format_tmc_description(current.description()) voice_debug_log(L"TTS: traffic description out: '"..traffic_description..L"'", 3) end
				if current.distance() and traffic_events_distance then traffic_distance = translated_voice_format(m_i18n_voice("After %s"), traffic_event_distance_get(current.distance())) ..  L" " end
				break
			end
			if i>30 then break end
		end
	end
	return format_sentence(traffic_distance .. traffic_description .. traffic_on .. traffic_from .. traffic_to)
end

----------------------------------------------------------------------------------------------------
---------------------------------------------|  E T A  |--------------------------------------------
----------------------------------------------------------------------------------------------------
function format_all_numbers2text(str,spell)
	return wstring.gsub(str, L"([0-9]+)", function(s)
		local inner = L""
		if #s > 3 or wstring.find(s, L"^0") or spell then
			for i = 1, #s do inner = inner .. format_numbers2text(tonumber(wstring.sub(s, i, i))) end
		else inner = format_numbers2text(tonumber(s)) end
		return inner .. L" "
	end)
end
function format_numbers2text(number)
	local index = {{39,9,43,49,33,53,37,4,13},
		{14,8,42,38,32,52,36,3,12},
		{25,5,40,47,30,50,34,1,10,14,26,7,41,48,31,51,35,2,11}}
	local str = towstring(number)
	if #str > 3 then return L" " .. str end
	if str == L"0" then return L" ноль" end
	local t = {}
	local out = L""
	for i = 1, #str do
		table.insert(t, tonumber(wstring.sub(str, i, i)))
	end
	for i = 1, (3 - #str)  do
		table.insert(t, 1, 0)
	end
	if (10 * t[2] + t[3]) < 20 then
		t[3] = 10 * t[2] + t[3]
		t[2] = 0
	end
	for i = 1, #t do
		if t[i] then
			out = out .. L" " .. distances.patterns[index[i][t[i]]]
		end
	end
	return out
end
--WANDEL™
local time_patternts = {L" одна", L" две"}
function format_timeto(timeto)
	local hour, min
	if type(timeto) == "wstring" then
		local hour_ = wstring.sub(timeto,1,-4)
		local min_  = wstring.sub(timeto,-2,-1)
		hour = tonumber(hour_)
		min = tonumber(min_)
	else
		local _, _, hour_, min_ = wstring.find(Format_Timespan(timeto, ETimespanFormat.HrMinRounded), L"(%d+):(%d+)")
		hour, min = tonumber(hour_), tonumber(min_)
	end

	local function time_to_phrase(number, hm)
		local sentence = L""
		if number ~= 0 then
			local number_10 = number % 10
			if number_10 == 1 and number ~= 11 then
				sentence = hm == "h" and L" час " or L" минута "
			elseif number_10 > 4 or number_10 == 0 or (number > 10 and number < 20) then
				sentence = hm == "h" and L" часов " or L" минут "
			else
				sentence = hm == "h" and L" часа " or L" минуты "
			end

			sentence = (((hm=="m")
						and(number_10 == 1 or number_10 == 2)
						and number ~= 11 and number ~= 12)
						and((number - number_10)
						and format_numbers2text(number - number_10) or L"") .. time_patternts[number_10]
						or format_numbers2text(number)) .. sentence
		end
		return sentence
	end

	local time_text = time_to_phrase(hour, "h") .. time_to_phrase(min, "m")
	if time_text == L"" then
		time_text = L"меньше одной минуты"
	end
	return time_text
end

function eta(time,waypoint)
	local head = waypoint and L"Прибытие в промежуточный пункт" or L"Прибытие в конечный пункт"
	--local head = waypoint and L" Надеюсь, будем в промежуточном пункте " or L"Надеюсь, будем на месте "
	local hours, mins, tod = L"", L"", L""
	local hour = time.hour
	local min = time.min
	if hour == 0 then hour = 12 tod = L" - ночи" end
	if hour == 1 then hours = L" в час"
	else hours = L" в" .. format_numbers2text(hour) end
	if min == 0 then mins = L""
	elseif min < 10 then mins = L" ноль" .. format_numbers2text(min)
	else mins = format_numbers2text(min) end
	if min == 0 and tod == L"" then mins = L" ноль ноль" end
	return head..hours..mins..tod
end
wlocalized = {}
wlocalized.countries = {"_ukr"}
for _,v in pairs(wlocalized.countries) do
	wlocalized["loaded"..v] = false
end
if type(complete_POI_CAT_PRIO) == "function" then
	VOICE["complete_POI_CAT_PRIO"]()
	if not (fill_functions._PROC and condfun._PROC) then
		init_functions()
	end
end
