﻿module("VOICE")

ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(transform_chain) == "function", "Missing transform_chain function.")
ASSERT(type(table_concat) == "function", "Missing table_concat function.")
ASSERT(type(transform_pattern_match) == "function", "Missing transform_pattern_match function.")
ASSERT(type(transform_format_roadnumber_eu) == "function", "Missing transform_format_roadnumber_eu function.")

local function find_preposition(data, tbl)
	str = wstring.lower(data)
	for k, value in ipairs(tbl) do
		for _, pattern in ipairs(tbl[k][2]) do
			if wstring.find(str, pattern) then
				return tbl[k][1] 
			end
		end
	end
	return transform.transform_destname.simple
end

local function get_prepositionFormatSTRs(data)
	local str = wstring.lower(data)
	local _, found_preposition = transform_pattern_match(str, transform.prepositionFormatSTRs)
	if found_preposition then
		return transform.transform_destname.simple
	else
		return find_preposition(str, transform.preposition_accusatives)
	end
end

local function signpost_exitnumber(data, idx)
	return transform_and_format(data[idx].signpost.exitnumber, transform.replace_exitnumber, transform.transform_destname.exitnumber)
end

local function signpost_exitname(data, idx)
	if data[idx].signpost.exitname then 
		return transform_and_format(data[idx].signpost.exitname, transform.replace_mapinfo, get_prepositionFormatSTRs(data[idx].signpost.exitname.text))
	end
end

local function signpost_destination(data, idx)
	if data[idx].signpost.destination then
		return transform_and_format(data[idx].signpost.destination, transform.replace_mapinfo, get_prepositionFormatSTRs(data[idx].signpost.destination.text))
	end
end

local function signpost_settlement(data, idx)
	if data[idx].signpost.settlement then
		local format_str
		if wstring.find(data[idx].signpost.settlement.text, transform.transform_destname.settlement_pattern) then
			format_str = transform.transform_destname.simple
		else
			format_str = transform.transform_destname.settlement
		end
		return transform_and_format(data[idx].signpost.settlement, transform.replace_mapinfo, format_str)
	end
end

local function signpost_roadnumber(data, idx)
	if data[idx].signpost.roadnumber then
		return transform_and_format(data[idx].signpost.roadnumber, transform_format_roadnumber_eu, get_prepositionFormatSTRs(data[idx].signpost.roadnumber.text), true)
	end
end

local function road_name(data, idx)
	if data[idx].road.name then
		return transform_and_format(data[idx].road.name, transform.replace_for_turns, get_prepositionFormatSTRs(data[idx].road.name.text))
	end
end

local function road_number(data, idx)
	if data[idx].road.number then
		return transform_and_format(data[idx].road.number, transform_format_roadnumber_eu, get_prepositionFormatSTRs(data[idx].road.number.text), true)
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, data, idx)
		t = transform_chain(t, signpost_exitnumber, data, idx)
		t = transform_chain(t, signpost_roadnumber, data, idx)
		t = transform_chain(t, signpost_destination, data, idx)
		t = transform_chain(t, signpost_settlement, data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, data, idx)
		t = transform_chain(t, road_name, data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, data, idx)
	t = transform_chain(t, road_name, data, idx)
	return table_concat(t, L", ")
end

function format_sentence(str)
	for key, value in ipairs(transform.sentence_transform) do
		str = wstring.gsub(str, value[1], value[2])
	end
	return str
end

function format_street_name(streetname)
	if wstring.sub(streetname, 1, 9) == L"for_turns" then
		local str = wstring.sub(streetname, 10)
		return not_settlement(str) .. transform_and_format(str, transform.replace_mapinfo)
	else
		return transform_and_format(streetname, transform.replace_mapinfo)
	end
end

function route_summary_format_road_name(data)
	return transform_format_roadnumber_eu(data.text)
end

function route_summary_format_street_name(data)
	return data.text
end

function route_summary_format_bridge_tunnel(data)
	return data.text
end

function route_summary_format_order(data)
	return data.text
end

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	local loc = MODEL.regional.is_it_voice_localizable(DescKey) 
	ASSERT(loc, "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	if data.roadnumber then 
		local road = L" Kelyje " .. transform_format_roadnumber_eu(data.roadnumber.text)
		if data.from and not data.to then
			str =  str .. road .. L", šalia " .. transform_and_format(data.from)
		elseif data.from and data.to then 
			str =  str .. road .. L", tarp "..transform_and_format(data.from) .. L" ir " .. transform_and_format(data.to)
		else
			str = str .. road
		end
	elseif data.roadname then
		local road = transform_and_format(data.roadname)
		road = L" Kelyje ".. get_preposition(data.roadname.text, transform.traffic_preposition_insert_tbl) .. road
		if data.from and not data.to then
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str .. road .. L", sankryžoje " .. from .. L" ir " .. to
			else 
				str = str .. road .. L", sankryžoje " .. data.from.text
			end
		elseif data.from and data.to then
			str = str .. road .. L", tarp "..transform_and_format(data.from) .. L" ir " .. transform_and_format(data.to)
		else
			str = str .. road
		end
	else
		if data.from and not data.to then
			str =  str .. L" šalia " .. transform_and_format(data.from)
		elseif data.from and data.to then 
			str =  str .. L" šalia " .. transform_and_format(data.from) .. L" ir " .. transform_and_format(data.to)
		else
		end
	end
	str = str .. L"."
	return str
end

function eta(time, waypoint, currenttime)
	local head = currenttime and L"Dabar: " or (waypoint and L"Į tarpinį punktą atvyksite: " or L"Į tikslą atvyksite: ")
	--local strseconds, strmins, strhour
	local hour = time.hour
	local mins = time.min
	--local seconds = time.sec
	local wi_hour_table = {L"pirmą va~landą ",L"antrą va~landą ",L"trečią va~landą ",L"ketvirtą va~landą ",L"penktą va~landą ",L"šeštą va~landą ",L"septintą va~landą ",L"aštuntą va~landą ",L"devintą va~landą ",L"dešimtą va~landą ",L"vienuoliktą va~landą ",L"dvyliktą va~landą ",L"tryliktą va~landą ",L"keturioliktą va~landą ",L"penkioliktą va~landą ",L"šešioliktą va~landą ",L"septynioliktą va~landą ",L"aštuonioliktą va~landą ",L"devynioliktą va~landą ",L"dvidešimtą va~landą ",L"20 pirmą va~landą ",L"20 antrą va~landą ",L"20 trečią va~landą "}
	local wi_hour_table_cur = {L"pirma valanda' ",L"antra valanda' ",L"trečia valanda' ",L"ketvirta valanda' ",L"penkta valanda' ",L"šešta valanda' ",L"septinta valanda' ",L"aštunta valanda' ",L"devinta valanda' ",L"dešimta valanda' ",L"vienuolikta valanda' ",L"dvylikta valanda' ",L"trylikta valanda' ",L"keturiolikta valanda' ",L"penkiolikta valanda' ",L"šešiolikta valanda' ",L"septyniolikta valanda' ",L"aštuoniolikta valanda' ",L"devyniolikta valanda' ",L"dvidešimta valanda' ",L"20 pirma valanda' ",L"20 antra valanda' ",L"20 trečia valanda' "}
	local wi_min_table = {L"viena minutė ",L"dvi minutės ",L"trys minutės ",L"keturios minutės ",L"penkios minutės ",L"šešios minutės ",L"septynios minutės ",L"aštuonios minutės ",L"devynios minutės ",L"10 minučių ",L"11 minučių ",L"12 minučių ",L"13 minučių ",L"14 minučių ",L"15 minučių ",L"16 minučių ",L"17 minučių ",L"18 minučių ",L"19 minučių ",L"20 minučių ",L"20 viena minutė ",L"20 dvi minutės ",L"20 trys minutės ",L"20 keturios minutės ",L"20 penkios minutės ",L"20 šešios minutės ",L"20 septynios minutės ",L"20 aštuonios minutės ",L"20 devynios minutės ",L"30 minučių ",L"30 viena minutė ",L"30 dvi minutės ",L"30 trys minutės ",L"30 keturios minutės ",L"30 penkios minutės ",L"30 šešios minutės ",L"30 septynios minutės ",L"30 aštuonios minutės ",L"30 devynios minutės ",L"40 minučių ",L"40 viena minutė ",L"40 dvi minutės ",L"40 trys minutės ",L"40 keturios minutės ",L"40 penkios minutės ",L"40 šešios minutės ",L"40 septynios minutės ",L"40 aštuonios minutės ",L"40 devynios minutės ",L"50 minučių ",L"50 viena minutė ",L"50 dvi minutės ",L"50 trys minutės ",L"50 keturios minutės ",L"50 penkios minutės ",L"50 šešios minutės ",L"50 septynios minutės ",L"50 aštuonios minutės",L"50 devynios minutės"}
	--local wi_sec_table = {L"viena sekundė ",L"dvi sekundės ",L"trys sekundės ",L"keturios sekundės ",L"penkios sekundės ",L"šešios sekundės ",L"septynios sekundės ",L"aštuonios sekundės ",L"devynios sekundės ",L"10 sekundžių ",L"11 sekundžių ",L"12 sekundžių ",L"13 sekundžių ",L"14 sekundžių ",L"15 sekundžių ",L"16 sekundžių ",L"17 sekundžių ",L"18 sekundžių ",L"19 sekundžių ",L"20 sekundžių ",L"20 viena sekundė ",L"20 dvi sekundės ",L"20 trys sekundės ",L"20 keturios sekundės ",L"20 penkios sekundės ",L"20 šešios sekundės ",L"20 septynios sekundės ",L"20 aštuonios sekundės ",L"20 devynios sekundės ",L"30 sekundžių ",L"30 viena sekundė ",L"30 dvi sekundės ",L"30 trys sekundės ",L"30 keturios sekundės ",L"30 penkios sekundės ",L"30 šešios sekundės ",L"30 septynios sekundės ",L"30 aštuonios sekundės ",L"30 devynios sekundės ",L"40 sekundžių ",L"40 viena sekundė ",L"40 dvi sekundės ",L"40 trys sekundės ",L"40 keturios sekundės ",L"40 penkios sekundės ",L"40 šešios sekundės ",L"40 septynios sekundės ",L"40 aštuonios sekundės ",L"40 devynios sekundės ",L"50 sekundžių ",L"50 viena sekundė ",L"50 dvi sekundės ",L"50 trys sekundės ",L"50 keturios sekundės ",L"50 penkios sekundės ",L"50 šešios sekundės ",L"50 septynios sekundės ",L"50 aštuonios sekundės",L"50 devynios sekundės"}
	if time.hour == 0 then
		strhour = L"nulis "
	else
		strhour = currenttime and wi_hour_table_cur[hour] or wi_hour_table[hour]
	end
	if time.min == 0 then
		strmins = L" nulis, nulis"
	else
		strmins = wi_min_table[time.min]
	end
	--if MODEL.regional.timeformat() == 0 or MODEL.regional.timeformat() == 1 then
		--if time.sec == 0 then
			--strseconds = L" nulis, nulis"
		--else
			--strseconds = wi_sec_table[time.sec]
		--end
		--return head .. strhour .. strmins .. strseconds
	--else
		return head .. strhour .. strmins
	--end
end

function timeto(timeto)
	local hournew, minsnew
	local hour = wstring.sub(timeto,1,-4)
	local mins = wstring.sub(timeto,-2,-1)
	local hournumber = tonumber(hour)
	local replace_hourone = {
		{L"0val",L" "},
		{L"1val",L"viena valanda' "},
		{L"2val",L"dvi va~landos "},
		{L"3val",L"trys va~landos "},
		{L"4val",L"keturios va~landos "},
		{L"5val",L"penkios va~landos "},
		{L"6val",L"šešios va~landos "},
		{L"7val",L"septynios va~landos "},
		{L"8val",L"aštuonios va~landos "},
		{L"9val",L"devynios va~landos "},}
	local replace_hoursec = {
		{L"10val",L"10 va~landų "},
		{L"11val",L"11 va~landų "},
		{L"12val",L"12 va~landų "},
		{L"13val",L"13 va~landų "},
		{L"14val",L"14 va~landų "},
		{L"15val",L"15 va~landų "},
		{L"16val",L"16 va~landų "},
		{L"17val",L"17 va~landų "},
		{L"18val",L"18 va~landų "},
		{L"19val",L"19 va~landų "},
		{L"20val",L"20 va~landų "},
		{L"21val",L"20 viena valanda' "},
		{L"22val",L"20 dvi va~landos "},
		{L"23val",L"20 trys va~landos "},
		{L"24val",L"20 keturios va~landos "},
		{L"25val",L"20 penkios va~landos "},
		{L"26val",L"20 šešios va~landos "},
		{L"27val",L"20 septynios va~landos "},
		{L"28val",L"20 aštuonios va~landos "},
		{L"29val",L"20 devynios va~landos "},
		{L"30val",L"30 va~landų "},
		{L"31val",L"30 viena valanda' "},
		{L"32val",L"30 dvi va~landos "},
		{L"33val",L"30 trys va~landos "},
		{L"34val",L"30 keturios va~landos "},
		{L"35val",L"30 penkios va~landos "},
		{L"36val",L"30 šešios va~landos "},
		{L"37val",L"30 septynios va~landos "},
		{L"38val",L"30 aštuonios va~landos "},
		{L"39val",L"30 devynios va~landos "},
		{L"40val",L"40 va~landų "},
		{L"41val",L"40 viena valanda' "},
		{L"42val",L"40 dvi va~landos "},
		{L"43val",L"40 trys va~landos "},
		{L"44val",L"40 keturios va~landos "},
		{L"45val",L"40 penkios va~landos "},
		{L"46val",L"40 šešios va~landos "},
		{L"47val",L"40 septynios va~landos "},
		{L"48val",L"40 aštuonios va~landos "},
		{L"49val",L"40 devynios va~landos "},
		{L"50val",L"50 va~landų "},
		{L"51val",L"50 viena valanda' "},
		{L"52val",L"50 dvi va~landos "},
		{L"53val",L"50 trys va~landos "},
		{L"54val",L"50 keturios va~landos "},}
	local replace_mins = {
		{L"00minut",L""},
		{L"01minut",L"viena minutė"},
		{L"02minut",L"dvi minutės"},
		{L"03minut",L"trys minutės"},
		{L"04minut",L"keturios minutės"},
		{L"05minut",L"penkios minutės"},
		{L"06minut",L"šešios minutės"},
		{L"07minut",L"septynios minutės"},
		{L"08minut",L"aštuonios minutės"},
		{L"09minut",L"devynios minutės"},
		{L"10minut",L"10 minučių"},
		{L"11minut",L"11 minučių"},
		{L"12minut",L"12 minučių"},
		{L"13minut",L"13 minučių"},
		{L"14minut",L"14 minučių"},
		{L"15minut",L"15 minučių"},
		{L"16minut",L"16 minučių"},
		{L"17minut",L"17 minučių"},
		{L"18minut",L"18 minučių"},
		{L"19minut",L"19 minučių"},
		{L"20minut",L"20 minučių"},
		{L"21minut",L"20 viena minutė"},
		{L"22minut",L"20 dvi minutės"},
		{L"23minut",L"20 trys minutės"},
		{L"24minut",L"20 keturios minutės"},
		{L"25minut",L"20 penkios minutės"},
		{L"26minut",L"20 šešios minutės"},
		{L"27minut",L"20 septynios minutės"},
		{L"28minut",L"20 aštuonios minutės"},
		{L"29minut",L"20 devynios minutės"},
		{L"30minut",L"30 minučių"},
		{L"31minut",L"30 viena minutė"},
		{L"32minut",L"30 dvi minutės"},
		{L"33minut",L"30 trys minutės"},
		{L"34minut",L"30 keturios minutės"},
		{L"35minut",L"30 penkios minutės"},
		{L"36minut",L"30 šešios minutės"},
		{L"37minut",L"30 septynios minutės"},
		{L"38minut",L"30 aštuonios minutės"},
		{L"39minut",L"30 devynios minutės"},
		{L"40minut",L"40 minučių"},
		{L"41minut",L"40 viena minutė"},
		{L"42minut",L"40 dvi minutės"},
		{L"43minut",L"40 trys minutės"},
		{L"44minut",L"40 keturios minutės"},
		{L"45minut",L"40 penkios minutės"},
		{L"46minut",L"40 šešios minutės"},
		{L"47minut",L"40 septynios minutės"},
		{L"48minut",L"40 aštuonios minutės"},
		{L"49minut",L"40 devynios minutės"},
		{L"50minut",L"50 minučių"},
		{L"51minut",L"50 viena minutė"},
		{L"52minut",L"50 dvi minutės"},
		{L"53minut",L"50 trys minutės"},
		{L"54minut",L"50 keturios minutės"},
		{L"55minut",L"50 penkios minutės"},
		{L"56minut",L"50 šešios minutės"},
		{L"57minut",L"50 septynios minutės"},
		{L"58minut",L"50 aštuonios minutės"},
		{L"59minut",L"50 devynios minutės"},}
	if hournumber <= 9 then
		hournew = transform_and_format(hour .. L"val",replace_hourone)
	else
		hournew = transform_and_format(hour .. L"val",replace_hoursec)
	end
		minsnew = transform_and_format(mins .. L"minut",replace_mins)
	return hournew .. minsnew
end