namespace window {
	public:
		class Window {
			private ctrl = controller{};
			private window;
			private closeHookId;

			constructor( params ) {
				if ( ??params.template ) {
					this.window = global.screen.createWindow( params.template.w, params.template.h, params.template.dpi, params.template.options ?? undef );
				}
				else {
					this.window = params.windowObj;
				}
				
				this.window.controller = this.ctrl;

				/* when closing this window*/
				this.closeHookId = global.screen.onWindowClosed.register( ( hook, window ) => { this.onClose( hook, window ) } );

				/* when closing main window*/
				screen.close_event.register( () => {
					if ( ??this.window ) {
						this.window.close();
					}
				} );
			}

			private onClose( hook, window ) {
				if ( window == this.window ) {
					hook.unregister( this.closeHookId );
					this.window = undef;
				}
			}

			public getWindowObject() {
				return this.window;
			}
		}
}