precision mediump float;

uniform mat4 projView;
uniform vec4 Ucolor;

attribute vec3 position;
attribute vec2 texCoor;

varying vec2 v_txCoor;
varying float luminosity;

float Luminosity( vec3 color )
{
	return 0.299 * color.r + 0.587 * color.g + 0.114 * color.b;
}

void main()
{
	gl_Position = projView * vec4(position, 1.);
	v_txCoor = texCoor;
	luminosity = Luminosity(Ucolor.rgb);
}
