//precision mediump float; // do not do this!

uniform mat4 projView;
uniform mat4 Uview;

attribute vec3 position;
attribute vec2 texCoor;
attribute vec3 normal;

varying vec2 v_txCoor;
varying vec3 v_EyeSpaceNormal;
varying vec3 v_EyeSpacePos;
varying vec3 v_ObjectSpaceNormal;

void main()
{
	gl_Position = projView * vec4(position, 1.);
	v_txCoor = texCoor;
	v_EyeSpacePos = (Uview * vec4(position, 1.0)).xyz;
	v_ObjectSpaceNormal = normal;
	
	// if there is a non-uniform scale then this will give wrong results!!!
	v_EyeSpaceNormal = (Uview * vec4(normal, 0.)).xyz;
}
