precision mediump float;// medium precision is OK because the coordinates are in screen-space

// Attributes
attribute vec4 position;	// xyzw: position 
attribute vec2 texCoor; 	// texture UV

varying vec2 v_txCoor;
varying vec4 v_color;

uniform vec4 U_V4_0,U_V4_1,U_V4_2;

void main() 
{
vec4 fog,pColor,fogColor;

	gl_Position = position;
	v_txCoor = texCoor;
	
	pColor=U_V4_0;
	fog=U_V4_1;
	fogColor=U_V4_2;
	
	float fog_ratio=(fog.x-position.w)*fog.y;
	fog_ratio=clamp(fog_ratio,0.0,1.0);
	v_color = fog_ratio * pColor + fogColor;
}

