// Uniforms
uniform mat4 projView;

// Attributes
attribute vec3 position;	// xyz: position
attribute vec3 position2; 	// xyz: other point
attribute vec4 color;		// xyz: color RGB, (a unused)
attribute vec3 custom1; 	// xy: direction, z: distortion
attribute vec2 texCoor;		// xy: texcoords

uniform vec4 U_V4_0; 		// width params
uniform vec3 U_V4_1; 		// mapcenter
uniform vec3 U_V4_2; 		// forward direction on ground
uniform vec4 U_V4_3; 		// x,y: 2/screen size z: horizontal distortion

#define Width 		U_V4_0.x
#define FadeBegin	U_V4_0.y
#define FadeEnd		U_V4_0.z
#define ScreenSize	U_V4_3.xy
#define Distortion	U_V4_3.z

varying vec2 v_txCoor;

// If this function is modified, note that this code also exists in C++,
// SERENITY::SHADER_IMP::TransformBeamPoint
void main() 
{
	//project start/endpoint
	vec4 vMVP = projView * vec4( position.xyz, 1.0 );
	vec4 otherMVP = projView * vec4( position2.xyz, 1.0 );

	// line direction
	vec2 lineDirProj = (vMVP.xy*otherMVP.w) - (otherMVP.xy*vMVP.w);
	lineDirProj = normalize(lineDirProj * ScreenSize.yx);

	if( sign(otherMVP.w) != sign(vMVP.w) )
		lineDirProj = -lineDirProj;

	// line width
	float z_dist=dot(position-U_V4_1,U_V4_2);
	vec2 s = custom1.xy * ( Width * (1.0 - smoothstep(0.0,FadeEnd,z_dist))) * vMVP.w;
	
	vec2 real_displacement = lineDirProj.xy * s.x * ScreenSize;				// local x * scale.x
	real_displacement += lineDirProj.yx*vec2(1.0,-1.0) * s.y * ScreenSize;	// local y * scale.y
	
	// horizontal distortion madness
	real_displacement *= 1.0+ (Distortion - 1.0) * abs(lineDirProj.x);
	
	vMVP.xy += real_displacement;

	gl_Position = vMVP;
	v_txCoor.xy = texCoor.xy;
}
