// Uniforms
uniform mat4 projView;

// Attributes
attribute vec3 position;	// xyz: position
attribute vec3 position2; 	// xyz: other point
attribute vec4 color;		// xyz: color RGB, (a unused)
attribute vec3 custom1; 	// xy: local, z: distortion
attribute vec2 texCoor;		// xy: texcoords

uniform vec4 U_V4_0; 		// width params
uniform vec4 U_V4_2; 		// 2/screen size


// other varyings. fragment shader accepts and expects these values
// works only with fragment shader
varying vec4 v_color;
varying vec2 v_txCoor;

void main() 
{
	//project start/endpoint
	vec4 vMVP = projView * vec4( position.xyz, 1.0 );
	vec4 otherMVP = projView * vec4( position2.xyz, 1.0 );

	// line direction
	vec2 lineDirProj = normalize( (vMVP.xy*otherMVP.w) - (otherMVP.xy*vMVP.w) );
	lineDirProj.x *= custom1.z;  // distortion correction

	if( sign(otherMVP.w) != sign(vMVP.w) )
		lineDirProj = -lineDirProj;

	// calculate width
	float t = (vMVP.w - U_V4_0.x) * U_V4_0.y;	// t = (w - neardistance) * recipfarnear;
	t = clamp(t,0.0,1.0);
	t = ( t * U_V4_0.z + U_V4_0.w ) * 0.5;	//t = t * farminusnearwidth + nearwidth; t=(t+1)/2
	t = t * vMVP.w;								// will be divided by w later

	vec2 s = custom1.xy * t;
	vMVP.xy += lineDirProj.xy * s.x * U_V4_2.xy;				// local x * scale.x
	vMVP.xy += lineDirProj.yx*vec2(1.0,-1.0) * s.y * U_V4_2.xy;	// local y * scale.y

	gl_Position = vMVP;
	v_color = color * 0.00390625;
	v_color.w = 1.0;
	v_txCoor.xy = texCoor.xy;
}
