//precision mediump float; // do not do this!

// Uniforms
uniform mat4 projView;
uniform float vertex_color_range;
uniform vec4 U_V4_3; 		// x: homogenous space->pixel ratio

// Attributes
attribute vec4 position;	// xyz: position w:texture U
attribute vec4 color;		// xyz: color RGB w: texture V
attribute vec3 normal;		// xyz: normal
attribute vec4 texCoor; 	// x:neardistance y:recipfarnear z:farminusnearwidth w:nearwidth

// consts
const float c_zerof = 0.0;
const float c_onef = 1.0;

// other varyings. fragment shader accepts and expects these values
// works only with fragment shader
varying vec4 v_color;
varying vec2 v_txCoor;

float w,t;
vec4 tmp_pos;

void main() 
{
	v_txCoor = vec2(color.w * vertex_color_range, position.w);
	tmp_pos = position; tmp_pos.w=1.0;
	// bad matrix setup!!!
	vec4 alma;
	alma.x = 	projView[0][3];
	alma.y = 	projView[1][3];
	alma.z = 	projView[2][3];
	alma.w = 	projView[3][3];
	w = dot( alma, tmp_pos ); // calculate w
//	w = dot( projView[3], tmp_pos ); // calculate w 
	t = (w - texCoor.x) * texCoor.y; // t = (w - neardistance) * recipfarnear;
	// clamp to 0..1
	t = clamp(t, 0.0, 1.0);
		
	t = ( t * texCoor.z + texCoor.w + 1.0) * 0.5 ; //t = t * farminusnearwidth + nearwidth; t=(t+1)/2
//	if (t<4.0)
//	{ 
//		t=4.0; // at least 2 pixel wide
//	}
	t = t * w; //multiply with w so when transformed back the width will be ok
	
	tmp_pos = tmp_pos + t * U_V4_3.x * vec4(normal.xyz,0)  ; // screen to pixel ratio
	tmp_pos.w = 1.0 ; // reset w to 1 // is it necessary?
	
	// calculate final 3d pos
	gl_Position = projView * tmp_pos;
	// pass through color
	v_color = vec4(color.xyz  * vertex_color_range, 1.0);
}

