
// (world) position code chunks
// TODO: shader include 
#ifdef HEIGHT_SCALE
uniform float uHeightScale;
#endif // HEIGHT_SCALE

#ifdef DEM_OFFSET
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr)    vec4( attr.xy, attr.z * uHeightScale + attr.w, 1. )
#		define WORLDPOSA_W(attr, w) vec4( attr.xy, attr.z * uHeightScale + w, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z + attr.w, 1. )
#		define WORLDPOSA_W(attr,w) vec4( attr.xy, attr.z + w, 1. )
#	endif // HEIGHT_SCALE
#else
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z * uHeightScale, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xyz, 1. )
#	endif // HEIGHT_SCALE
#endif // DEM_OFFSET

#ifdef DYNAMIC_LOD
	uniform vec4 uNeighborMask1;
	uniform vec4 uNeighborMask2;
	attribute vec3 aPositionLOD;
	//varying   vec3 vLOD;
	
	float lerp2( vec2 w, vec4 v )
	{
	    //  vz vw
		//  vx vy
		
		vec2 a = mix( v.xy, v.zw, w.y );
		return mix( a.x, a.y, w.x );
	}
	
	float GetLodWeight()
	{
		// a =  uNeighborMask1
		// b =  uNeighborMask2
		//  aw az ay
		//  bx    ax
		//  by bz bw
		
		float w = 0.;
		float x = aPositionLOD.x*2.;
		float y = aPositionLOD.y*2.;
		if( x > 1. )
		{
			if( y > 1. ) w = lerp2( vec2(x-1., y-1.), vec4( 0., uNeighborMask1.x, uNeighborMask1.z, uNeighborMask1.y ) );  //TR
			else         w = lerp2( vec2(x-1., y   ), vec4( uNeighborMask2.z, uNeighborMask2.w, 0., uNeighborMask1.x ) );  //BR
		}
		else
		{
			if( y > 1. ) w = lerp2( vec2(x, y-1.), vec4( uNeighborMask2.x, 0., uNeighborMask1.w, uNeighborMask1.z ) ); // TL
			else         w = lerp2( vec2(x, y   ), vec4( uNeighborMask2.y, uNeighborMask2.z, uNeighborMask2.x, 0. ) ); // BL
		}		
		return w;
	}
#endif // DYNAMIC_LOD
	

#ifdef DEM_OFFSET
	attribute vec4 aPositionH;	
#	ifdef DYNAMIC_LOD
#		define WORLDPOS	mix( WORLDPOSA(aPositionH), WORLDPOSA_W(aPositionH, aPositionLOD.z), GetLodWeight() )
#	else
#		define WORLDPOS	WORLDPOSA(aPositionH)
#	endif // DYNAMIC_LOD
#else	
	attribute vec3 aPosition;
#	define WORLDPOS	WORLDPOSA(aPosition)
#endif // DEM_OFFSET





attribute vec3 aNormal;

#ifdef HEIGHT_SCALE
uniform float uHeightScale;
#endif // HEIGHT_SCALE

#ifdef OFFSET_DEPTH
uniform float uDepthOffset;
#endif // OFFSET_DEPTH

#ifdef HD_WATER
#ifdef TEXCOORDUV
	attribute vec2 aTexCoordUV;
	uniform vec2 uUVScale;
#elif defined TEXCOORDHD
	attribute vec2 aTexCoordHD;
#else
	hiba, nem tamogatott uv	
#endif

varying vec2 vTexcoord1;
varying vec2 vTexcoord2;
varying vec3 vFromEye;

uniform vec4 uUVSpeed;

#endif // HD_WATER

uniform vec3 uColorMod;

varying vec3 vColor;

#ifdef SHADOW_MAPPING
# ifdef SHADOW_PCF
varying vec2 vShadowCoordinateH1;
varying vec2 vShadowCoordinateH2;
varying vec2 vShadowCoordinateH3;
varying vec2 vShadowCoordinateH4;
# else
varying vec2 vShadowCoordinateH;
# endif // SHADOW_PCF
varying float vShadowCoordinateHZ;
#endif

void main()
{
	vec4 worldPosition = WORLDPOS;
	vec4 clipPosition = GetProjView() * worldPosition;

#ifdef OFFSET_DEPTH
    clipPosition.z += uDepthOffset * clipPosition.w;
#endif // OFFSET_DEPTH

	gl_Position = clipPosition;

#ifdef HD_WATER
# ifdef TEXCOORDUV
    vTexcoord1 = aTexCoordUV.xy * uUVScale + uUVSpeed.xy;
    vTexcoord2 = ( aTexCoordUV.xy * uUVScale + uUVSpeed.zw ).yx;
# elif defined TEXCOORDHD
    vTexcoord1 = aTexCoordHD.xy + uUVSpeed.xy;
    vTexcoord2 = ( aTexCoordHD.xy + uUVSpeed.zw ).yx;
# endif // UVSCALE
    vFromEye = normalize( GetViewPosition() - worldPosition.xyz );
#endif // HD_WATER

    float diffuse = max( dot( aNormal, -GetLightDirection() ), 0.2 );
	vColor        = uColorMod * diffuse;

#ifdef SHADOW_MAPPING
    vec3 projShadow = ( GetShadowMatrix() * worldPosition ).xyz;
# ifdef SHADOW_PCF
	vShadowCoordinateH1 = projShadow.xy + vec2(-0.5, -0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH2 = projShadow.xy + vec2(+0.5, -0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH3 = projShadow.xy + vec2(-0.5, +0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH4 = projShadow.xy + vec2(+0.5, +0.5) * SHADOW_MAP_SIZEINV;
# else
	vShadowCoordinateH  = projShadow.xy;
# endif // SHADOW_PCF
    vShadowCoordinateHZ = min( projShadow.z, 0.9921568627450980392156862745098 ); // 253 / 255
#endif // SHADOW_MAPPING
}