
attribute vec3 aPosition;

#ifdef TEXTURING
	varying vec2 vTexCoord;
	#ifdef TEXCOORDHD
		attribute vec2 aTexCoordHD;
	#elif defined TEXCOORDUV
		attribute vec2 aTexCoordUV;
	#else
		attribute vec2 aTexCoord;
	#endif
#endif //TEXTURING

uniform mat4 uProjView;

void main()
{
	vec4 worldPosition = vec4( aPosition.xyz, 1. );
	vec4 clipPosition = uProjView * worldPosition;

	gl_Position = clipPosition;

#ifdef TEXTURING
	#ifdef TEXCOORDUV
		vTexCoord = aTexCoordUV.xy;
	#elif defined TEXCOORDHD
		vTexCoord = aTexCoordHD.xy;
	#else
		vTexCoord = aTexCoord / 1024.;
	#endif //TEXCOORD*
#endif // TEXTURING

}