
#ifdef ROAD_BEAM
	#ifdef ROAD_FLAT
		vec3 error_both_ROAD_BEAM_and_ROAD_FLAT_are_defined = vec2(1.,1.);
	#endif
#endif

#ifdef ROAD_FLAT
	#ifdef DYNAMIC_LOD
		vec3 error_ROAD_FLAT_does_not_support_DYNAMIC_LOD = vec2(1.,1.);
	#endif
#endif

//rename custom attributes to have some sensible meaning
#define aModelShiftDir aCustom2
#define aScreenShiftDir aCustom3
#define uFadePoint uCustom1
#define uFadeDirection uCustom2



// (world) position code chunks
// TODO: shader include 
#ifdef HEIGHT_SCALE
uniform float uHeightScale;
#endif // HEIGHT_SCALE

#ifdef DEM_OFFSET
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr)    vec4( attr.xy, attr.z * uHeightScale + attr.w, 1. )
#		define WORLDPOSA_W(attr, w) vec4( attr.xy, attr.z * uHeightScale + w, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z + attr.w, 1. )
#		define WORLDPOSA_W(attr,w) vec4( attr.xy, attr.z + w, 1. )
#	endif // HEIGHT_SCALE
#else
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z * uHeightScale, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xyz, 1. )
#	endif // HEIGHT_SCALE
#endif // DEM_OFFSET

#ifdef DYNAMIC_LOD
	uniform vec4 uNeighborMask1;
	uniform vec4 uNeighborMask2;
	attribute vec3 aPositionLOD;
	attribute vec3 aPositionLOD2;
	//varying   vec3 vLOD;
	
	float lerp2( vec2 w, vec4 v )
	{
	    //  vz vw
		//  vx vy
		
		vec2 a = mix( v.xy, v.zw, w.y );
		return mix( a.x, a.y, w.x );
	}
	
	float GetLodWeight( vec2 posLOD )
	{
		// a =  uNeighborMask1
		// b =  uNeighborMask2
		//  aw az ay
		//  bx    ax
		//  by bz bw
		
		float w = 0.;
		float x = posLOD.x*2.;
		float y = posLOD.y*2.;
		if( x > 1. )
		{
			if( y > 1. ) w = lerp2( vec2(x-1., y-1.), vec4( 0., uNeighborMask1.x, uNeighborMask1.z, uNeighborMask1.y ) );  //TR
			else         w = lerp2( vec2(x-1., y   ), vec4( uNeighborMask2.z, uNeighborMask2.w, 0., uNeighborMask1.x ) );  //BR
		}
		else
		{
			if( y > 1. ) w = lerp2( vec2(x, y-1.), vec4( uNeighborMask2.x, 0., uNeighborMask1.w, uNeighborMask1.z ) ); // TL
			else         w = lerp2( vec2(x, y   ), vec4( uNeighborMask2.y, uNeighborMask2.z, uNeighborMask2.x, 0. ) ); // BL
		}		
		return w;
	}
#endif // DYNAMIC_LOD
	

#ifdef DEM_OFFSET
	attribute vec4 aPositionH;
	attribute vec4 aPositionH2;
	
	#ifdef DYNAMIC_LOD
		#define WORLDPOS	mix( WORLDPOSA(aPositionH), WORLDPOSA_W(aPositionH, aPositionLOD.z), GetLodWeight( aPositionLOD.xy ) )
		#define WORLDPOS2	mix( WORLDPOSA(aPositionH2), WORLDPOSA_W(aPositionH2, aPositionLOD2.z), GetLodWeight( aPositionLOD2.xy ) )
	#else
		#define WORLDPOS	WORLDPOSA(aPositionH)
		#define WORLDPOS2	WORLDPOSA(aPositionH2)
	#endif	
#else	
	attribute vec3 aPosition;
	attribute vec3 aPosition2;
	#define WORLDPOS	WORLDPOSA(aPosition)
	#define WORLDPOS2	WORLDPOSA(aPosition2)
#endif // DEM_OFFSET


#ifdef ROAD_BEAM
	uniform vec3 uViewDirection;
	attribute vec2 aScreenShiftDir;
#endif // ROAD_BEAM

#ifdef ROAD_FLAT
	attribute vec2 aModelShiftDir;
#endif // ROAD_FLAT

#ifdef OFFSET_DEPTH
	uniform float uDepthOffset;
#endif // OFFSET_DEPTH

uniform float uRoadOffset;

uniform vec2  uRoadWidth;			// x: width, y: aspect

#ifdef ENABLE_DISTANCE_FADE
	uniform vec3  uFadePoint;
	uniform vec3  uFadeDirection;
	uniform vec2  uRoadFade;			// x: near, y: far	
	#ifdef ROAD_BEAM	
		varying float vFade;
	#endif // ROAD_BEAM
#endif // ENABLE_DISTANCE_FADE

#ifdef LINE_END_EXCLUSION
	#ifdef ROAD_BEAM	
		uniform vec2	uCarTarget;
		uniform float	uExclusionRadius;
		varying vec2	vCarTarget;
		varying float	vExclusionRadius;
	#endif // ROAD_BEAM
#endif // LINE_END_EXCLUSION

#ifdef DEPTH_PASS
	varying vec2 clipSpacePosition;
#else // DEPTH_PASS
	#ifdef TEXTURING
		#ifdef TEXCOORDL
			attribute vec3 aTexCoordL;
			varying vec2 vTexCoord;
		#elif defined TEXCOORDHD
			attribute vec2 aTexCoordHD;
		#elif defined TEXCOORDUV
			attribute vec2 aTexCoordUV;
		#else
			attribute vec2 aTexCoord;
		#endif // TEXTURED*
		varying vec2 vAlphaTexCoord;
	#endif //TEXTURING
#endif // DEPTH_PASS


// attribute vec3 aColor;
// varying vec3 vColor;


void main()
{
	//   C-----
	//   A     B
	//   ------

	//vec3 dbgColor = vec3(1.);

#ifdef ROAD_FLAT
	vec4 worldA1 = WORLDPOS;
	vec4 worldA2 = WORLDPOS2;
	vec4 worldA =  mix( worldA1,worldA2, uRoadOffset );
	vec4 clipA = GetProjView() * worldA;
	
//	#ifdef ENABLE_DISTANCE_FADE
//		float d = dot( worldA.rgb - uFadePoint, uFadeDirection );
//		float fade = 1. - smoothstep( uRoadFade.y, uRoadFade.x, d );
//	#else
//		float fade = 1.;
//	#endif // ENABLE_DISTANCE_FADE
	float fade = 1.;

	vec2 sh = aModelShiftDir;
	vec4 worldC = worldA + vec4( sh.xy, 0., 0. ) * uRoadWidth.x * fade;
	vec4 clipC = GetProjView() * worldC;
	#ifdef OFFSET_DEPTH
		clipC.z += uDepthOffset;
	#endif // OFFSET_DEPTH
#endif //ROAD_FLAT




#ifdef ROAD_BEAM
	vec4 worldA = WORLDPOS;
	vec4 clipA = GetProjView() * worldA;
	
	#ifdef ENABLE_DISTANCE_FADE
		float d = dot( worldA.rgb - uFadePoint, uFadeDirection );
		float fade = 1. - smoothstep( uRoadFade.x, uRoadFade.y, d );
		vFade = fade;		
	#else
		float fade = 1.;
	#endif // ENABLE_DISTANCE_FADE	
	
	//dbgColor = vec3(0.5, fade, d);
	
	#ifdef LINE_END_EXCLUSION
		vCarTarget = uCarTarget;
		vExclusionRadius = uExclusionRadius;
	#endif // LINE_END_EXCLUSION
	
	vec4 worldB = WORLDPOS2;
	vec4 clipB = GetProjView() * worldB;

	vec2 clipAB = (clipB.xy * clipA.w) - (clipA.xy * clipB.w);
	clipAB = normalize( clipAB );
	if( sign(worldA.w) != sign(worldB.w) )
		clipAB = -clipAB;

	vec2 s = aScreenShiftDir.xy * uRoadWidth.x * fade * 2.;
	s.y += uRoadOffset;
	#ifndef ROAD_PERSPECTIVE
		s *= clipA.w;
	#endif // ROAD_PERSPECTIVE


	vec4 clipC = clipA;
	clipC.xy += clipAB.xy * vec2( 1.0, 1. ) * s.x ;
	clipC.xy += clipAB.yx * vec2(-1.0, uRoadWidth.y ) * s.y;

	//basic idea: without altering the z value, the rect is facing toward the camera
	// this modification mimics that, the rect has an L shape
	// the upper part is parallel to the image plane, the lower part is parallel to the xy (terrain) plane
	// of course it is just a draft approximation
	//float q = sqrt(uViewDirection.z * uViewDirection.z - 1.);
	//float q = 1. - abs(uViewDirection.z);
	//float depthBias = clamp((clipA.y - clipC.y) * q, 0., 1.);

	#ifdef OFFSET_DEPTH
		clipC.z += uDepthOffset * clipC.w;
	#endif //OFFSET_DEPTH
	
//#ifdef DYNAMIC_LOD
//	vLOD = aColor; //vec3( GetLodWeight(aPositionLOD.xy), GetLodWeight(aPositionLOD2.xy), 1. );
//#endif // DYNAMIC_LOD	

	//vColor.rgb = dbgColor;
#endif // ROAD_BEAM



	vec4 clip = clipC;
	gl_Position = clip;

#ifdef DEPTH_PASS
	clipSpacePosition = clip.zw;
#else // DEPTH_PASS

#ifdef TEXTURING
	#ifdef TEXCOORDL
		vAlphaTexCoord = aTexCoordL.xy;
		vTexCoord = aTexCoordL.zy;
	#elif defined TEXCOORDUV
		vAlphaTexCoord = aTexCoordUV.xy;
	#elif defined TEXCOORDHD
		vAlphaTexCoord = aTexCoordHD.xy;
	#else
		vAlphaTexCoord = aTexCoord / 1024.;
	#endif //TEXCOORD*
#endif // TEXTURING

#endif // DEPTH_PASS
}
