
#ifdef DEM_OFFSET
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
#	define WORLDPOSA(attr) vec4( attr.xy, attr.z + attr.w, 1. )
#else
#	define WORLDPOSA(attr) vec4( attr.xyz, 1. )
#endif // DEM_OFFSET
	
#ifdef DEM_OFFSET
	attribute vec4 aPositionH;
#	define WORLDPOS	WORLDPOSA(aPositionH)
#else	
	attribute vec3 aPosition;
#	define WORLDPOS	WORLDPOSA(aPosition)
#endif // DEM_OFFSET

#ifdef OFFSET_DEPTH
uniform float uDepthOffset;
#endif // OFFSET_DEPTH

attribute vec2 aTexCoordHD;
varying   vec2 vTexCoord;

uniform vec4 uTextureTrsf;		// x,y: offset, z,w: scale in x,y dir

void main()
{
	vec4 worldPosition = WORLDPOS;
	vec4 clipPosition = GetProjView() * worldPosition;
#ifdef OFFSET_DEPTH
    clipPosition.z += uDepthOffset * clipPosition.w;
#endif // OFFSET_DEPTH
	gl_Position = clipPosition;
	vTexCoord = aTexCoordHD * uTextureTrsf.zw + uTextureTrsf.xy;
}
