
#ifndef WORLD_SPACE
uniform   mat4 uModel;
#endif // WORLD_SPACE



// (world) position code chunks
// TODO: shader include 
#ifdef HEIGHT_SCALE
uniform float uHeightScale;
#endif // HEIGHT_SCALE

#ifdef DEM_OFFSET
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z * uHeightScale + attr.w, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z + attr.w, 1. )
#	endif // HEIGHT_SCALE
#else
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z * uHeightScale, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xyz, 1. )
#	endif // HEIGHT_SCALE
#endif // DEM_OFFSET
	

#ifdef DEM_OFFSET
	attribute vec4 aPositionH;
#	define WORLDPOS	WORLDPOSA(aPositionH)
#else	
	attribute vec3 aPosition;
#	define WORLDPOS	WORLDPOSA(aPosition)
#endif // DEM_OFFSET



#ifdef TEXTURING
attribute vec2 aTexCoord;
varying   vec2 vTexCoord;
# ifdef UVSCALE
uniform vec2 uUVScale;
# endif // UVSCALE
#endif // TEXTURING

#ifdef VERTEX_COLOR
attribute vec3 aColor;
#endif // VERTEX_COLOR

#ifdef OFFSET_DEPTH
uniform float uDepthOffset;
#endif // OFFSET_DEPTH

#ifdef LIGHTING
uniform   vec3 uLightDiffuse;
attribute vec3 aNormal;
#endif // LIGHTING

#if defined( SPECULAR ) && defined( LIGHTING )
uniform vec4 uSpecular;
uniform vec3 uCameraPos;
varying float vSpecular;
#endif // SPECULAR && LIGHTING

#if defined( LIGHTING ) || defined( VERTEX_COLOR )
varying vec3 vColor;
#endif // LIGHTING || VERTEX_COLOR

#if defined REFLECTION && defined LIGHTING && defined TEXTURING
varying vec3 vReflection;
#endif // REFLECTION && LIGHTING && TEXTURING

#ifdef SHADOW_MAPPING
# ifdef SHADOW_PCF
varying vec2 vShadowCoordinateH1;
varying vec2 vShadowCoordinateH2;
varying vec2 vShadowCoordinateH3;
varying vec2 vShadowCoordinateH4;
# else
varying vec2 vShadowCoordinateH;
# endif // SHADOW_PCF
varying float vShadowCoordinateHZ;
# ifdef LIGHTING
varying float NdotLSign;
# endif // LIGHTING
#endif

#ifdef DEPTH_PASS
varying vec2 clipSpacePosition;
#endif

float Fresnel( vec3 toEye, vec3 normal )
{
	float fresnelBias  = -0.3;
	float fresnelScale =  1.4;
	float fresnelPower =  8.0;
	return fresnelBias + fresnelScale * pow( 1. - dot( toEye, normal ), fresnelPower );
}

void main()
{
	vec4 worldPos = WORLDPOS;
	vec4 clipPosition = GetProjView() * worldPos;

#ifdef OFFSET_DEPTH
    clipPosition.z += uDepthOffset;
#endif // OFFSET_DEPTH

	gl_Position = clipPosition;

#ifdef DEPTH_PASS
	clipSpacePosition = clipPosition.zw;
#endif // DEPTH_PASS

#ifdef TEXTURING
	vTexCoord = aTexCoord / 1024.;
# ifdef UVSCALE
	vTexCoord *= uUVScale;
# endif // UVSCALE
#endif // TEXTURING

	vec3 color = vec3( 1, 1, 1 );

#ifdef VERTEX_COLOR
	color = aColor;
#endif // VERTEX_COLOR

#ifdef SHADOW_MAPPING
    vec3 projShadow = ( GetShadowMatrix() * worldPos ).xyz;
# ifdef SHADOW_PCF
	vShadowCoordinateH1 = projShadow.xy + vec2(-0.5, -0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH2 = projShadow.xy + vec2(+0.5, -0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH3 = projShadow.xy + vec2(-0.5, +0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH4 = projShadow.xy + vec2(+0.5, +0.5) * SHADOW_MAP_SIZEINV;
# else
	vShadowCoordinateH  = projShadow.xy;
# endif // SHADOW_PCF
    vShadowCoordinateHZ = min( projShadow.z, 0.9921568627450980392156862745098 ); // 253 / 255
#endif // SHADOW_MAPPING

#ifdef LIGHTING
#	ifdef WORLD_SPACE
	vec3  nrmw = aNormal;
#	else
	mat3  otor = mat3( uModel );
	vec3  nrmw = normalize( otor * aNormal );
#	endif // WORLD_SPACE
	float dotd = dot( -GetLightDirection(), nrmw );
	float dotc = max( dotd, 0. );
	color.rgb *= vec3( dotc, dotc, dotc ) * uLightDiffuse;
#	ifdef SHADOW_MAPPING
	vShadowCoordinateHZ = vShadowCoordinateHZ * step( 0.0, dotd );
	NdotLSign = sign( max( dotc - 0.02, 0. ) );
#	endif // SHADOW_MAP
#endif // LIGHTING

#if ( defined( SPECULAR ) || defined( REFLECTION ) ) && defined( LIGHTING )
#	ifdef WORLD_SPACE
	vec3 refPoint = worldPos.xyz;
#	else
	vec3 refPoint = ( uModel * worldPos ).xyz;
#	endif // WORLD_SPACE
#endif // ( SPECULAR || REFLECTION ) && LIGHTING

#if defined( SPECULAR ) && defined( LIGHTING )
	vec3 toCamera = GetViewPosition() - refPoint;
	vec3 toCamRef = normalize( reflect( toCamera, nrmw ) );
	vec3 toLight  = GetLightDirection();
	float dotSpec = max( dot( toCamRef, toLight ), 0. );
	vSpecular = pow( dotSpec, uSpecular.w );
#endif // SPECULAR && LIGHTING

#if defined( LIGHTING ) || defined( VERTEX_COLOR )
	vColor = color;
#endif // LIGHTING || VERTEX_COLOR

#if defined REFLECTION && defined LIGHTING && defined TEXTURING
	vec3 toEye = normalize( GetViewPosition() - refPoint );
    vec3 reflectionVector = normalize( reflect( toEye, nrmw ) );
    vReflection.xy = reflectionVector.xz;
    vReflection.z  = Fresnel( toEye, nrmw );
#endif // REFLECTION && LIGHTING && TEXTURING
}