// owners: ftukor
// experts:

// (world) position code chunks
// TODO: shader include 

#ifdef DYNAMIC_LOD
	uniform vec4 uNeighborMask1;
	uniform vec4 uNeighborMask2;
	attribute vec3 aPositionLOD;
	//varying   vec3 vLOD;
	
	float lerp2( vec2 w, vec4 v )
	{
	    //  vz vw
		//  vx vy
		
		vec2 a = mix( v.xy, v.zw, w.y );
		return mix( a.x, a.y, w.x );
	}
	
	float GetLodWeight()
	{
		// a =  uNeighborMask1
		// b =  uNeighborMask2
		//  aw az ay
		//  bx    ax
		//  by bz bw
		
		float w = 0.;
		float x = aPositionLOD.x*2.;
		float y = aPositionLOD.y*2.;
		if( x > 1. )
		{
			if( y > 1. ) w = lerp2( vec2(x-1., y-1.), vec4( 0., uNeighborMask1.x, uNeighborMask1.z, uNeighborMask1.y ) );  //TR
			else         w = lerp2( vec2(x-1., y   ), vec4( uNeighborMask2.z, uNeighborMask2.w, 0., uNeighborMask1.x ) );  //BR
		}
		else
		{
			if( y > 1. ) w = lerp2( vec2(x, y-1.), vec4( uNeighborMask2.x, 0., uNeighborMask1.w, uNeighborMask1.z ) ); // TL
			else         w = lerp2( vec2(x, y   ), vec4( uNeighborMask2.y, uNeighborMask2.z, uNeighborMask2.x, 0. ) ); // BL
		}		
		return w;
	}
#endif // DYNAMIC_LOD

#ifdef DEM_OFFSET
	attribute vec4 aPositionH;	
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
	#define WORLDPOSA(attr) vec4( attr.xy, attr.z + attr.w, 1. )
	#define WORLDPOSA_W(attr,w) vec4( attr.xy, attr.z + w, 1. )
	
	#ifdef DYNAMIC_LOD
		#define WORLDPOS mix( WORLDPOSA(aPositionH), WORLDPOSA_W(aPositionH, aPositionLOD.z), GetLodWeight() )
	#else
		#define WORLDPOS WORLDPOSA(aPositionH)
	#endif // DYNAMIC_LOD
#else	
	attribute vec3 aPosition;
	#define WORLDPOSA(attr) vec4( attr.xyz, 1. )
	#define WORLDPOS WORLDPOSA(aPosition)
#endif // DEM_OFFSET

#ifdef OFFSET_DEPTH
	uniform float uDepthOffset;
#endif // OFFSET_DEPTH

#ifdef TEXTURING
	attribute vec2 aTexCoordHD;
	varying   vec2 vTexCoord;
#endif // TEXTURING

void main()
{
	vec4 worldPosition = WORLDPOS;

	vec4 clipPosition = GetProjView() * worldPosition;

#ifdef OFFSET_DEPTH
    clipPosition.z += uDepthOffset;
#endif // OFFSET_DEPTH

	gl_Position = clipPosition;

#ifdef TEXTURING
	vTexCoord = aTexCoordHD;
#endif // TEXTURING
}