// owners: lperneky
// experts: zgaal, bjako

//#define PERPIX_LIGHT

// (world) position code chunks
// TODO: shader include 
#ifdef HEIGHT_SCALE
uniform float uHeightScale;
#endif // HEIGHT_SCALE

#ifdef DEM_OFFSET
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr)    vec4( attr.xy, attr.z * uHeightScale + attr.w, 1. )
#		define WORLDPOSA_W(attr, w) vec4( attr.xy, attr.z * uHeightScale + w, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z + attr.w, 1. )
#		define WORLDPOSA_W(attr,w) vec4( attr.xy, attr.z + w, 1. )
#	endif // HEIGHT_SCALE
#else
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, attr.z * uHeightScale, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xyz, 1. )
#	endif // HEIGHT_SCALE
#endif // DEM_OFFSET

#ifdef DYNAMIC_LOD
	uniform vec4 uNeighborMask1;
	uniform vec4 uNeighborMask2;
	attribute vec3 aPositionLOD;
	//varying   vec3 vLOD;
	
	float lerp2( vec2 w, vec4 v )
	{
	    //  vz vw
		//  vx vy
		
		vec2 a = mix( v.xy, v.zw, w.y );
		return mix( a.x, a.y, w.x );
	}
	
	float GetLodWeight()
	{
		// a =  uNeighborMask1
		// b =  uNeighborMask2
		//  aw az ay
		//  bx    ax
		//  by bz bw
		
		float w = 0.;
		float x = aPositionLOD.x*2.;
		float y = aPositionLOD.y*2.;
		if( x > 1. )
		{
			if( y > 1. ) w = lerp2( vec2(x-1., y-1.), vec4( 0., uNeighborMask1.x, uNeighborMask1.z, uNeighborMask1.y ) );  //TR
			else         w = lerp2( vec2(x-1., y   ), vec4( uNeighborMask2.z, uNeighborMask2.w, 0., uNeighborMask1.x ) );  //BR
		}
		else
		{
			if( y > 1. ) w = lerp2( vec2(x, y-1.), vec4( uNeighborMask2.x, 0., uNeighborMask1.w, uNeighborMask1.z ) ); // TL
			else         w = lerp2( vec2(x, y   ), vec4( uNeighborMask2.y, uNeighborMask2.z, uNeighborMask2.x, 0. ) ); // BL
		}		
		return w;
	}
#endif // DYNAMIC_LOD
	

#ifdef DEM_OFFSET
	attribute vec4 aPositionH;	

#	ifdef DYNAMIC_LOD
#		define WORLDPOS	mix( WORLDPOSA(aPositionH), WORLDPOSA_W(aPositionH, aPositionLOD.z), GetLodWeight() )
#	else
#		define WORLDPOS	WORLDPOSA(aPositionH)
#	endif // DYNAMIC_LOD
#else	
	attribute vec3 aPosition;
#	define WORLDPOS	WORLDPOSA(aPosition)
#endif // DEM_OFFSET


#ifdef EARTH
	attribute vec2 aTexCoordEARTH;
	varying   vec2 vTexCoordEARTH;	
#	undef TEXTURING
#	undef REFLECTION	
#endif // EARTH


#if defined( TEXTURING ) && !defined( SKYBOX )
#	ifdef TEXCOORDHD
		attribute vec2 aTexCoordHD;
		varying   vec2 vTexCoord;
#	elif defined TEXCOORDUV
		attribute vec2 aTexCoordUV;
		varying   vec2 vTexCoord;
		uniform   vec2 uUVScale;
#	else
		attribute vec2 aTexCoord;
		varying   vec2 vTexCoord;
#	endif // TEXCOORD*
#endif // TEXTURING && !SKYBOX


#ifdef VERTEX_COLOR_ALPHA
# define color_t vec4
#else
# define color_t vec3
#endif // VERTEX_COLOR_ALPHA

#ifdef VERTEX_COLOR
attribute color_t aColor;
varying	  color_t vVertexColor;
#endif // VERTEX_COLOR

#ifdef COLOR_INDEX
    attribute vec2 aColorIndex;
    varying   vec2 vColorTexCoord;

    const vec2 cColorAtlasResolution = vec2(256.0, 64.0);  
#endif // COLOR_INDEX

#ifdef OFFSET_DEPTH
uniform float uDepthOffset;
#endif // OFFSET_DEPTH

#ifdef LIGHTING
uniform   vec3 uLightDiffuse;
attribute vec3 aNormal;
	#ifdef PERPIX_LIGHT
		varying vec3 vNormal;
		varying vec3 vLightDir;
	#endif // PERPIX_LIGHT
#endif // LIGHTING

#if defined( LIGHTING ) || defined( VERTEX_COLOR )
varying   color_t vColor;
#endif // LIGHTING || VERTEX_COLOR

#if defined REFLECTION && defined LIGHTING
varying vec2 vReflection;
#endif // REFLECTION && LIGHTING

#ifdef SHADOW_MAPPING
# ifdef SHADOW_PCF
varying vec4 vShadowCoordinateH12;
varying vec4 vShadowCoordinateH34;
# else
varying vec2 vShadowCoordinateH;
# endif // SHADOW_PCF
varying float vShadowCoordinateHZ;
# ifdef LIGHTING
varying float NdotLSign;
# endif // LIGHTING
#endif

#ifdef DEPTH_PASS
varying vec2 clipSpacePosition;
#endif

#ifdef SKYBOX
varying vec3 skyUV;
#endif // SKYBOX

void main()
{
#ifdef SKYBOX
	skyUV.x =  aPosition.x;
	skyUV.y =  aPosition.y;
	skyUV.z =  aPosition.z;
#endif // SKYBOX

	vec4 worldPosition = WORLDPOS;

	vec4 clipPosition = GetProjView() * worldPosition;

#ifdef OFFSET_DEPTH
    clipPosition.z += uDepthOffset;
#endif // OFFSET_DEPTH

	gl_Position = clipPosition;

#ifdef DEPTH_PASS
	clipSpacePosition = clipPosition.zw;
#endif // DEPTH_PASS


#ifdef EARTH
	vTexCoordEARTH = aTexCoordEARTH;
#endif // EARTH

#if defined( TEXTURING ) && !defined( SKYBOX )
# ifdef TEXCOORDHD
	vTexCoord = aTexCoordHD;
//# elif defined TEXCOORDL
//	vTexCoord = aTexCoordL;
# elif defined TEXCOORDUV
	vTexCoord = aTexCoordUV * uUVScale;	
# else 
	// TEXCOORD in short as fixp_6_10
	vTexCoord = aTexCoord / 1024.;
# endif // TEXCOORDHD

#endif // TEXTURING && !SKYBOX


#ifdef VERTEX_COLOR_ALPHA
	color_t color = color_t( 1, 1, 1, 1 );
#else
	color_t color = color_t( 1, 1, 1 );
#endif // VERTEX_COLOR_ALPHA

#ifdef VERTEX_COLOR
	color = aColor;
	vVertexColor = aColor;
#endif // VERTEX_COLOR

#ifdef SHADOW_MAPPING
    vec3 projShadow = ( GetShadowMatrix() * worldPosition ).xyz;
# ifdef SHADOW_PCF
	vShadowCoordinateH12.xy = projShadow.xy + vec2(-0.5, -0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH12.zw = projShadow.xy + vec2(+0.5, -0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH34.xy = projShadow.xy + vec2(-0.5, +0.5) * SHADOW_MAP_SIZEINV;
	vShadowCoordinateH34.zw = projShadow.xy + vec2(+0.5, +0.5) * SHADOW_MAP_SIZEINV;
# else
	vShadowCoordinateH  = projShadow.xy;
# endif // SHADOW_PCF
    vShadowCoordinateHZ = min( projShadow.z, 0.9921568627450980392156862745098 ); // 253 / 255
#endif // SHADOW_MAPPING

#ifdef LIGHTING
	vec3 ld = -GetLightDirection();
	vec3 normal = aNormal;
	normal.z *= GetShadingEnhancement();
	normal = normalize(normal);
	float dt  = dot( ld, normal );
//	float dtc  = max( dt, 0. ); // normal shading
	float dtc = (dt + 1.0) * 0.5; // shadows are much softer
	#ifdef PERPIX_LIGHT
		vNormal = normal;
		vLightDir = ld;
	#else
		color.rgb *= dtc;
	#endif // PERPIX_LIGHT	
	 color.rgb *= uLightDiffuse;
# ifdef SHADOW_MAPPING
	vShadowCoordinateHZ = vShadowCoordinateHZ * step( 0.0, dt );
	NdotLSign = sign( max( dtc - 0.02, 0. ) );
# endif // SHADOW_MAP
#endif // LIGHTING

#if defined( LIGHTING ) || defined( VERTEX_COLOR )
	vColor = color;
#endif // LIGHTING || VERTEX_COLOR

//#ifdef DYNAMIC_LOD
//	vLOD = vec3( GetLodWeight() );
//#endif // DYNAMIC_LOD

#if defined REFLECTION && defined LIGHTING
	vec3 fromEye = normalize( GetViewPosition() - worldPosition.xyz );
    vec3 reflectionVector = normalize( reflect( fromEye, aNormal ) );
    vReflection = reflectionVector.xy * 0.5;
#endif // REFLECTION && LIGHTING

#ifdef COLOR_INDEX
	vColorTexCoord = aColorIndex / cColorAtlasResolution; // convert byte --> float [0.0, 1.0)
//    vColorTexCoord *= (cColorAtlasResolution - vec2(1.0, 1.0)) / cColorAtlasResolution; // correct back to texel corner
    vColorTexCoord += vec2(0.5, 0.5) / cColorAtlasResolution; // correct to texel center
#endif // COLOR_INDEX
}