// owners: ftukor
// experts: zgaal, asimon3

// (world) position code chunks
// TODO: shader include 
#ifdef HEIGHT_SCALE
uniform float uHeightScale;
#endif // HEIGHT_SCALE

uniform float uBuildingHeightMin;

float height_scale(float original, float factor)
{
// if height ~0 -> point is on the ground. Do not move it.
// height>0 -> roof point. should not go below a limit because it will z-fight with terrain
	return original < 0.01 ? original : max(uBuildingHeightMin, original * factor);
}



#ifdef DEM_OFFSET
	//x,y,z : pos without dem; w: offset to place over dem
	// Note: on igo side z elevation without, w: elevation with dem. 
	// The vertex factory transforms it into z + offset
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, height_scale( attr.z , uHeightScale) + attr.w, 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xy, height_scale(attr.z, 1.) + attr.w, 1. )
#	endif // HEIGHT_SCALE
#else
#	if defined HEIGHT_SCALE
#		define WORLDPOSA(attr) vec4( attr.xy, height_scale(attr.z , uHeightScale), 1. )
#	else
#		define WORLDPOSA(attr) vec4( attr.xy, height_scale(attr.z , 1.), 1. )
#	endif // HEIGHT_SCALE
#endif // DEM_OFFSET
	

#ifdef DEM_OFFSET
	attribute vec4 aPositionH;
#	define WORLDPOS	WORLDPOSA(aPositionH)
#else	
	attribute vec3 aPosition;
#	define WORLDPOS	WORLDPOSA(aPosition)
#endif // DEM_OFFSET

#ifdef TEXTURING
#	ifdef COLOR_INDEX
		attribute vec2 aColorIndex;
		varying vec2 vTexCoord;
#	else
		attribute vec2 aTexCoord;
		varying   vec2 vTexCoord;
#	endif // COLOR_INDEX
#endif

#ifdef OFFSET_DEPTH
uniform float uDepthOffset;
#endif // OFFSET_DEPTH

#ifdef LIGHTING
uniform   vec3 uLightDiffuse;
attribute vec3 aNormal;
varying   vec3 vLightColor;
#endif // LIGHTING

#if defined REFLECTION && defined LIGHTING
varying vec2 vReflection;
#endif // REFLECTION && LIGHTING

#ifdef LIGHTING
	#ifdef SHADOW_MAPPING
		#ifdef SHADOW_PCF
			varying vec4 vShadowCoordinateH12;
			varying vec4 vShadowCoordinateH34;
		#else
			varying vec2 vShadowCoordinateH;
		#endif // SHADOW_PCF
		varying float vShadowCoordinateHZ;
	#endif
# endif // LIGHTING

#ifdef DEPTH_PASS
varying vec2 clipSpacePosition;
#endif

const vec2 cCityMapColorAtlasResolution = vec2(256.0, 2.0);

void main()
{
	vec4 worldPosition = WORLDPOS;
	vec4 clipPosition = GetProjView() * worldPosition;

#ifdef DEPTH_PASS	// shadow pass
	clipSpacePosition = clipPosition.zw;
#endif // DEPTH_PASS

#ifdef OFFSET_DEPTH
    clipPosition.z += uDepthOffset;
#endif // OFFSET_DEPTH

	gl_Position = clipPosition;

#ifdef TEXTURING
#	ifdef COLOR_INDEX // color index is a kind of texcoord
		vTexCoord = aColorIndex / vec2(255.0, 255.0); // convert 0 .. 255 --> 0.0 .. 1.0
		vTexCoord *= (cCityMapColorAtlasResolution - vec2(1.0, 1.0)) / cCityMapColorAtlasResolution; // correct back to texel corner
		vTexCoord += vec2(0.5, 0.5) / cCityMapColorAtlasResolution; // correct to texel center
#	else 
		// TEXCOORD in short as fixp_6_10
		vTexCoord = aTexCoord / 1024.;
#	endif // COLOR_INDEX
#endif

#ifdef LIGHTING
	vec3 color = vec3( 1, 1, 1 );
	float dot  = dot( -GetLightDirection(), aNormal );
//	float dotc  = max( dot, 0. );// normal shading
	float dotc = (dot + 1.0) * 0.5; // shadows are much softer
	color.rgb *= uLightDiffuse * dotc;
	vLightColor = color;
	#ifdef SHADOW_MAPPING
		vec3 projShadow = ( GetShadowMatrix() * worldPosition ).xyz;
		# ifdef SHADOW_PCF
			vShadowCoordinateH12.xy = projShadow.xy + vec2(-0.5, -0.5) * SHADOW_MAP_SIZEINV;
			vShadowCoordinateH12.zw = projShadow.xy + vec2(+0.5, -0.5) * SHADOW_MAP_SIZEINV;
			vShadowCoordinateH34.xy = projShadow.xy + vec2(-0.5, +0.5) * SHADOW_MAP_SIZEINV;
			vShadowCoordinateH34.zw = projShadow.xy + vec2(+0.5, +0.5) * SHADOW_MAP_SIZEINV;
		# else
			vShadowCoordinateH  = projShadow.xy;
		# endif // SHADOW_PCF
			vShadowCoordinateHZ = min( projShadow.z, 0.9921568627450980392156862745098 ); // 253 / 255
	
		vShadowCoordinateHZ = vShadowCoordinateHZ * step( 0.02, dot );
	#endif // SHADOW_MAP
#endif // LIGHTING

#if defined REFLECTION && defined LIGHTING
	vec3 fromEye = normalize( GetViewPosition() - worldPosition.xyz );
    vec3 reflectionVector = normalize( reflect( fromEye, aNormal ) );
    vReflection = reflectionVector.xy * 0.5;
#endif // REFLECTION && LIGHTING

}