precision mediump float;
varying vec2 v_txCoor;
uniform sampler2D texture;
uniform vec4 v_ssaoparams; // effect range (20), effect strength (3), image width, image height

float CalcSample( float c, float s )
{
	float weight = c - s;
	if ( abs( weight ) > 0.115 * ( 1. - c ) )
		return 0.;
	return weight;
}

void main()
{
	float c = texture2D( texture, v_txCoor ).x;
	float kernelSize = ( 1. - c ) * v_ssaoparams.x;
	
	// Sampling by a Poisson disk. The disk is written here this ugly as "This version of the compiler doesn't support array constructors".
	
	float occ = 0.;
	float sample;
	sample = texture2D( texture, v_txCoor + vec2(  0.1110859  * v_ssaoparams.z,   0.3802654  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.3694369  * v_ssaoparams.z,   0.8293799  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.4308059  * v_ssaoparams.z,   0.04681017 * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2( -0.1874037  * v_ssaoparams.z,   0.8884219  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2( -0.4335341  * v_ssaoparams.z,  -0.311551   * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2( -0.657006   * v_ssaoparams.z,   0.5890706  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.9298374  * v_ssaoparams.z,   0.05642248 * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.1208179  * v_ssaoparams.z,  -0.3072735  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.8025908  * v_ssaoparams.z,   0.5396532  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2( -0.3391338  * v_ssaoparams.z,   0.1609961  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2( -0.9145367  * v_ssaoparams.z,  -0.00705356 * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2( -0.7762721  * v_ssaoparams.z,  -0.6175131  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.480394   * v_ssaoparams.z,  -0.6733992  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.04880055 * v_ssaoparams.z,  -0.9635738  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );									   
	sample = texture2D( texture, v_txCoor + vec2(  0.8544056  * v_ssaoparams.z,  -0.4065076  * v_ssaoparams.w ) * kernelSize ).x;
	occ += CalcSample( c, sample );
	
	occ  = min( abs( occ ) * v_ssaoparams.y, 1. );
	
	gl_FragColor.x = 0.;
	gl_FragColor.y = occ;
	gl_FragColor.z = 0.;
	gl_FragColor.w = 1.;
}
