precision mediump float;

varying vec2 v_txCoor;
uniform sampler2D texture;
uniform vec4 Ucolor;

float Luminosity( vec3 color )
{
	return 0.299 * color.r + 0.587 * color.g + 0.114 * color.b;
}

void main()
{
	vec4 color = texture2D( texture, v_txCoor ) * Ucolor;
	gl_FragColor.r = gl_FragColor.g = gl_FragColor.b = Luminosity(color.rgb);
	gl_FragColor.a = color.a;
}