precision highp float;

varying vec2 v_txCoor;

uniform sampler2D texture;
uniform vec4 Ucolor;

float Luminosity( vec3 color )
{
	return 0.299 * color.r + 0.587 * color.g + 0.114 * color.b;
}

void main()
{
	vec4 color = texture2D( texture, v_txCoor ) * vec4(1.0, 1.0, 1.0, Ucolor.a);
	float lum = Luminosity(color.rgb);
	float luma_in = Luminosity(Ucolor.rgb);

	// colorize
	if (lum < luma_in)
	{
		color.r = min(color.r * lum + Ucolor.r / 4.0, 1.0);
		color.g = min(color.g * lum + Ucolor.g / 4.0, 1.0);
		color.b = min(color.b * lum + Ucolor.b / 4.0, 1.0);
	}
	else
	{
		color.rgb = Ucolor.rgb * lum;
	}

	gl_FragColor = color;
}