precision mediump float;
varying vec2 v_txCoor;
uniform sampler2D texture;

uniform vec4 U_V4_0;	// (topleft gcoor), (bottomright gcoor)
uniform vec4 U_V4_1;	// (texture width/height multiplier), 0, 0

vec2 calc(vec2 x, vec2 scale, vec2 minCoord, vec2 maxCoord)
{
	vec2 scaled=(x-minCoord)*scale;
	vec2 div=(maxCoord-minCoord);
	return vec2(scaled.x/div.x, scaled.y/div.y);
}

void main()
{
	vec2 trfCoor = calc(v_txCoor, U_V4_1.xy, U_V4_0.xy, U_V4_0.zw);
	gl_FragColor = texture2D(texture, trfCoor);
}
