//precision mediump float; // do not do this!

uniform mat4 projView;
uniform float vertex_color_range;
uniform vec3 Ueye; 		// cam pos
uniform vec4 U_V4_0; 		// width params
uniform vec3 U_V4_1; 		// mapcenter
uniform vec3 U_V4_2; 		// forward direction on ground

#define Width 		U_V4_0.x
#define FadeBegin	U_V4_0.y
#define FadeEnd		U_V4_0.z

attribute vec3 position;
attribute vec3 normal;
attribute vec2 texCoor;

varying vec2 v_txCoor;
varying float v_shadowFade;

#define fadeStartDist 2.4
#define fadeEndDist   3.2

void main() 
{
	v_shadowFade = 1.0 - ((length(Ueye - position.xyz) - fadeStartDist) / (fadeEndDist - fadeStartDist));
	
	float z_dist=dot(position-U_V4_1,U_V4_2);
	gl_Position = projView * vec4(position + normal * ( Width * (1.0 - smoothstep(FadeBegin,FadeEnd,z_dist))), 1.);
	v_txCoor = texCoor;
}
