precision mediump float;

varying vec2 v_txCoor;
varying float v_shadowFade;

uniform sampler2D texture;
uniform vec4 Ucolor;

void main()
{
	float alpha = texture2D( texture, v_txCoor ).a;
	if (alpha<0.75)
		discard;
	alpha = alpha * clamp(v_shadowFade, 0.0, 1.0);

	gl_FragColor = Ucolor;
	gl_FragColor.a = gl_FragColor.a * alpha;
}
