// Uniforms
uniform mat4 projView;

// Attributes
attribute vec3 position;	// xyz: position
attribute vec3 position2; 	// xyz: other point
attribute vec3 custom1; 	// xy: local, z: distortion
attribute vec3 texCoor;		// xy: texcoords z : overall length

uniform mediump vec4 U_V4_1;// width params


// other varyings. fragment shader accepts and expects these values
// works only with fragment shader
varying vec3 v_txCoor;

void main() 
{
	//project start/endpoint
	vec4 vMVP = projView * vec4( position.xyz, 1.0 );
	vec4 otherMVP = projView * vec4( position2.xyz, 1.0 );

	// calculate width
	float t = U_V4_1.y * 0.001236;

	// line direction
	vec2 lineDirProj = normalize( (vMVP.xy*otherMVP.w) - (otherMVP.xy*vMVP.w) );
	lineDirProj.x *= custom1.z;  // distortion correction

	if( sign(otherMVP.w) != sign(vMVP.w) )
		lineDirProj = -lineDirProj;

	vec2 s = custom1.xy * t;
	vMVP.xy += lineDirProj.xy * s.x;			// local x * scale.x
	vMVP.xy += lineDirProj.yx*vec2(1.0,-1.0) * s.y;		// local y * scale.y

	gl_Position = vMVP;

	v_txCoor = texCoor;
}
