uniform mat4 projView;
uniform vec4 Ucolor;
uniform vec3 Ueye;

attribute vec3 position;
attribute vec4 color;
uniform float vertex_color_range;
attribute vec3 normal;

varying vec2 v_tx;
varying vec3 v_color;

const vec3 Xunit = vec3(1.0, 0.0, 0.0);
const vec3 Yunit = vec3(0.0, 0.0, 1.0);

void main() 
{

	gl_Position = projView * vec4(position, 1.);

	vec3 dir = normalize(position - Ueye);
	vec3 rd = normalize( reflect(dir,normal) );

	//v_tx.y = dot(rd, Yunit);
	//rd.y = 0.0;
	//v_tx.x = dot(rd, Xunit);

	v_tx = rd.xz * 4.;
	v_color = color.rgb * vertex_color_range * Ucolor.rgb;
}
