﻿module("VOICE")

prepositions ={
	pattern_to_roadnumber_on_hwy = L"A *%d+$",
	formatStr_to_roadnumber_on_hwy = L"w kierunku autostrady numer %s",
	pattern_to_roadnumber_on_expw = L"S *%d+$",
	formatStr_to_roadnumber_on_expw = L"w drogę ekspresową numer %s",
	pattern_to_roadnumber_on_inthwy = L"E *%d+$",
	formatStr_to_roadnumber_on_inthwy = L"w drogę numer %s",
	formatStr_to_roadnumber_default = L"w drogę numer %s",
	formatStr_to_exit = L"zjazdem numer %s",
	formatStr_to_destination = L"kierunek %s",
	formatStr_to_destinationCountry = L"w kierunku %s",
	formatStr_to_settlement = L"kierunek %s",
	formatStr_to_settlementCountry = L". kierunek %s",
	formatStr_to_roadname = L"w drogę %s",
	formatStr_to_roadname_nom2gen = L"o nazwie %s",
}

transform =     {}

transform.sentence_transform = TRANSFORM.new({
	{2, L"(?i)\\. +(poźniej,?) +", L", \\1 "},
	{2, L"(%p)+ *(%p)+", L"%1 "},
	{2, L"%s+(%p+)", L"%1 "},
	{2, L" +", L" "},
})

transform.substitute_for_detour = TRANSFORM.new({

	{2,L"(?i)adna\\.?",L"adną"},
	{2,L"(?i)ajna\\.?",L"ajną"},
	{2,L"(?i)atna\\.?",L"atną"},
	{2,L"(?i)atnia\\.?",L"atnią"},
	{2,L"(?i)awna\\.?",L"awną"},
	{2,L"(?i)ałowa\\.?",L"ałową"},
	{2,L"(?i)bna\\.?",L"bną"},
	{2,L"(?i)borna\\.?",L"borną"},
	{2,L"(?i)bowa\\.?",L"bową"},
	{2,L"(?i)brna\\.?",L"brną"},
	{2,L"(?i)bska\\.?",L"bską"},
	{2,L"(?i)cerna\\.?",L"cerną"},
	{2,L"(?i)ciana\\.?",L"cianą"},
	{2,L"(?i)cista\\.?",L"cistą"},
	{2,L"(?i)cka\\.?",L"cką"},
	{2,L"(?i)cna\\.?",L"cną"},
	{2,L"(?i)cowa\\.?",L"cową"},
	{2,L"(?i)czana\\.?",L"czaną"},
	{2,L"(?i)czna\\.?",L"czną"},
	{2,L"(?i)darna\\.?",L"darną"},
	{2,L"(?i)derna\\.?",L"derną"},
	{2,L"(?i)dnia\\.?",L"dnią"},
	{2,L"(?i)doska\\.?",L"doską"},
	{2,L"(?i)dowa\\.?",L"bową"},
	{2,L"(?i)dzka\\.?",L"dzką"},
	{2,L"(?i)dłowa\\.?",L"dłową"},
	{2,L"(?i)enna\\.?",L"enną"},
	{2,L"(?i)eska\\.?",L"eską"},
	{2,L"(?i)esna\\.?",L"esną"},
	{2,L"(?i)etna\\.?",L"etną"},
	{2,L"(?i)ewcza\\.?",L"ewczą"},
	{2,L"(?i)ewna\\.?",L"ewną"},
	{2,L"(?i)eńcza\\.?",L"eńczą"},
	{2,L"(?i)farna\\.?",L"farną"},
	{2,L"(?i)fska\\.?",L"fską"},
	{2,L"(?i)garna\\.?",L"garną"},
	{2,L"(?i)goska\\.?",L"goską"},
	{2,L"(?i)gska\\.?",L"gską"},
	{2,L"(?i)głowa\\.?",L"głową"},
	{2,L"(?i)howna\\.?",L"howną"},
	{2,L"(?i)hska\\.?",L"hską"},
	{2,L"(?i)iarna\\.?",L"iarną"},
	{2,L"(?i)idna\\.?",L"idną"},
	{2,L"(?i)ijna\\.?",L"ijną"},
	{2,L"(?i)inna\\.?",L"inną"},
	{2,L"(?i)iorna\\.?",L"iorną"},
	{2,L"(?i)iowa\\.?",L"iową"},
	{2,L"(?i)iska\\.?",L"iską"},
	{2,L"(?i)itna\\.?",L"itną"},
	{2,L"(?i)jarna\\.?",L"jarną"},
	{2,L"(?i)jowa\\.?",L"jową"},
	{2,L"(?i)jska\\.?",L"jską"},
	{2,L"(?i)koska\\.?",L"koską"},
	{2,L"(?i)kowa\\.?",L"kową"},
	{2,L"(?i)lana\\.?",L"laną"},
	{2,L"(?i)larna\\.?",L"larną"},
	{2,L"(?i)lerna\\.?",L"lerną"},
	{2,L"(?i)lista\\.?",L"listą"},
	{2,L"(?i)liwa\\.?",L"liwą"},
	{2,L"(?i)lna\\.?",L"lną"},
	{2,L"(?i)lona\\.?",L"loną"},
	{2,L"(?i)loska\\.?",L"loską"},
	{2,L"(?i)lowa\\.?",L"lową"},
	{2,L"(?i)lska\\.?",L"lską"},
	{2,L"(?i)mowa\\.?",L"mową"},
	{2,L"(?i)mowna\\.?",L"mowną"},
	{2,L"(?i)mska\\.?",L"mską"},
	{2,L"(?i)murna\\.?",L"murną"},
	{2,L"(?i)niana\\.?",L"nianą"},
	{2,L"(?i)nicza\\.?",L"niczą"},
	{2,L"(?i)nista\\.?",L"nistą"},
	{2,L"(?i)noska\\.?",L"noską"},
	{2,L"(?i)nowa\\.?",L"nową"},
	{2,L"(?i)nska\\.?",L"nską"},
	{2,L"(?i)odna\\.?",L"odną"},
	{2,L"(?i)onna\\.?",L"onną"},
	{2,L"(?i)osna\\.?",L"osną"},
	{2,L"(?i)otna\\.?",L"onną"},
	{2,L"(?i)owana\\.?",L"owaną"},
	{2,L"(?i)owcza\\.?",L"owczą"},
	{2,L"(?i)ołowa\\.?",L"ołową"},
	{2,L"(?i)porna\\.?",L"porną"},
	{2,L"(?i)poska\\.?",L"poską"},
	{2,L"(?i)powa\\.?",L"pową"},
	{2,L"(?i)rarna\\.?",L"rarną"},
	{2,L"(?i)roska\\.?",L"roską"},
	{2,L"(?i)rowa\\.?",L"rową"},
	{2,L"(?i)rowna\\.?",L"rowną"},
	{2,L"(?i)rska\\.?",L"rską"},
	{2,L"(?i)rwana\\.?",L"rwaną"},
	{2,L"(?i)rwna\\.?",L"rwną"},
	{2,L"(?i)rzana\\.?",L"rzaną"},
	{2,L"(?i)rzna\\.?",L"rzną"},
	{2,L"(?i)rłowa\\.?",L"rłową"},
	{2,L"(?i)siana\\.?",L"sianą"},
	{2,L"(?i)soska\\.?",L"soską"},
	{2,L"(?i)sowa\\.?",L"sową"},
	{2,L"(?i)stna\\.?",L"stną"},
	{2,L"(?i)szana\\.?",L"szaną"},
	{2,L"(?i)szna\\.?",L"szną"},
	{2,L"(?i)tarna\\.?",L"tarną"},
	{2,L"(?i)torna\\.?",L"torną"},
	{2,L"(?i)towa\\.?",L"tową"},
	{2,L"(?i)towna\\.?",L"towną"},
	{2,L"(?i)udna\\.?",L"udną"},
	{2,L"(?i)ujna\\.?",L"ujną"},
	{2,L"(?i)uska\\.?",L"uską"},
	{2,L"(?i)utna\\.?",L"utną"},
	{2,L"(?i)ułowa\\.?",L"ułową"},
	{2,L"(?i)warna\\.?",L"warną"},
	{2,L"(?i)worna\\.?",L"worną"},
	{2,L"(?i)wowa\\.?",L"wową"},
	{2,L"(?i)wska\\.?",L"wską"},
	{2,L"(?i)yjna\\.?",L"yjną"},
	{2,L"(?i)ynna\\.?",L"ynną"},
	{2,L"(?i)yrna\\.?",L"yrną"},
	{2,L"(?i)yska\\.?",L"yską"},
	{2,L"(?i)ywna\\.?",L"ywną"},
	{2,L"(?i)zarna\\.?",L"zarną"},
	{2,L"(?i)zdna\\.?",L"zdną"},
	{2,L"(?i)zerna\\.?",L"zerną"},
	{2,L"(?i)ziana\\.?",L"zianą"},
	{2,L"(?i)zicza\\.?",L"ziczą"},
	{2,L"(?i)zista\\.?",L"zistą"},
	{2,L"(?i)zoska\\.?",L"zoską"},
	{2,L"(?i)zowa\\.?",L"zową"},
	{2,L"(?i)złowa\\.?",L"złową"},
	{2,L"(?i)ójna\\.?",L"ójną"},
	{2,L"(?i)órcza\\.?",L"órczą"},
	{2,L"(?i)órna\\.?",L"órną"},
	{2,L"(?i)ówna\\.?",L"ówną"},
	{2,L"(?i)ądna\\.?",L"ądną"},
	{2,L"(?i)ąska\\.?",L"ąską"},
	{2,L"(?i)ątna\\.?",L"ątną"},
	{2,L"(?i)ęsia\\.?",L"ęsią"},
	{2,L"(?i)ęska\\.?",L"ęską"},
	{2,L"(?i)ęsna\\.?",L"ęsną"},
	{2,L"(?i)ętna\\.?",L"ętną"},
	{2,L"(?i)łska\\.?",L"łską"},
	{2,L"(?i)ńska\\.?",L"ńską"},
	{2,L"(?i)śna\\.?",L"śną"},
	{2,L"(?i)źna\\.?",L"źną"},
	{2,L"(?i)żana\\.?",L"żaną"},
	{2,L"(?i)żarna\\.?",L"żarną"},
	{2,L"(?i)żna\\.?",L"żną"},
	{2,L"(?i)żowa\\.?",L"żową"},
})

transform.substitute_transform = TRANSFORM.new({
---nazwy ulic
	{1,L"1 Armii",L"Pierwszej armii"},
	{1,L"1 Dyw",L"Pierwszej Dywizji"},
	{1,L"1 Praskiego",L"Pierwszego Praskiego"},
	{1,L"1-go",L"Pierwszego"},
	{1,L"10 Lutego",L"Dziesiątego lutego"},
	{1,L"10 Sudeckiej",L"dziesiątej sudeckiej"},
	{1,L"10-Lecia",L"Dziesięciolecia"},
	{1,L"100-Lecia",L"Stulecia"},
	{1,L"11 Pułku Piechoty",L"Jedenastego Pułku Piechoty"},
	{1,L"11 Pułku Piechoty",L"Jedenastego Pułku Piechoty"},
	{1,L"12 Lutego",L"Dwunastego lutego"},
	{1,L"12 Marca",L"Dwunastego Marca"},
	{1,L"15 Grudnia",L"Piętnastego grudnia"},
	{1,L"15-Lecia",L"Piętnastolecia"},
	{1,L"17 Pułku",L"Siedemnastego pułku"},
	{1,L"1831 R",L"Tysiąc osiemset trzydziestego pierwszego roku"},
	{1,L"1863 R",L"Tysiąc osiemset sześćdziesiątego trzeciego roku"},
	{1,L"1905 R",L"Tysiąc dziewięćset piątego roku"},
	{1,L"1940",L"Tysiąc dziewięćset czterdzieści"},
	{1,L"1943 R",L"Tysiąc dziewięćset czterdziestego trzeciego roku"},
	{1,L"1970 R",L"tysiąc dziewięćset siedemdziesiątego roku"},
	{1,L"1976 R",L"tysiąc dzięwięćset siedemdziesiątego szóstego roku"},
	{1,L"1989 R",L"tysiąc dziewięćset osiemdziesiątego dziewiątego roku"},
	{1,L"2 Morskiego",L"Drugiego morskiego"},
	{1,L"2 sec.",L"dwie sekundy"},
	{1,L"2-go",L"Drugiego"},
	{1,L"20 Dywizji Piechoty",L"Dwudziestej dywizji piechoty"},
	{1,L"20-Lecia",L"Dwudziestolecia"},
	{1,L"200",L"dwieście"},
	{1,L"200-Lecia",L"Dwustulecia"},
	{1,L"21 Pułku",L"Dwudziestego pierwszego pułku"},
	{1,L"25-Lecia",L"Dwudziesto pięciolecia"},
	{1,L"26 Kwietnia",L"Dwudziestego szóstego kwietnia"},
	{1,L"26 Stycznia",L"Dwudziestego szóstego stycznia"},
	{1,L"28 Płk. Strzelców Kaniowskich",L"dwudziestego usmego półku strzelców Kaniowskich"},
	{1,L"3 Batalionu",L"Trzeciego Batalionu"},
	{1,L"3 Maja",L"Trzeciego Maja"},
	{1,L"3 Marca",L"Trzeciego Marca"},
	{1,L"3 Pułku Ułanów",L"Trzeciego Pułku Ułanów"},
	{1,L"3 Płk. Strzelców Podh.",L"Trzeciego Pułku Strzelców Podhalańskich"},
	{1,L"3-go",L"Trzeciego"},
	{1,L"3. Pułku Ułanów",L"Trzeciego Pułku Ułanów"},
	{1,L"30-Lecia",L"trzydziestolecia"},
	{1,L"308 Dywizjonu",L"Trzysta ósmego Dywizjonu"},
	{1,L"31 Stycznia",L"Trzydziestego pierwszego stycznia"},
	{1,L"35-Lecia",L"Trzydziesto pięciolecia"},
	{1,L"36 Pułku",L"Trzydziestego szustego Pułku"},
	{1,L"4-go",L"Czwartego"},
	{1,L"40-Lecia",L"Czterdziestolecia"},
	{1,L"5 Marca",L"Piątego marca"},
	{1,L"5-go",L"Piątego"},
	{1,L"5. Května",L"Piatego kwetn-a"},
	{1,L"59",L"Pięćdziesiąt dziewięć"},
	{1,L"6 Sierpnia",L"Szustego sierpnia"},
	{1,L"6-go",L"Szóstego"},
	{1,L"60-Lecia",L"Sześćdziesięciolecia"},
	{1,L"7-go",L"Siódmego"},
	{1,L"750-Lecia",L"Siedemset piędziesięciolecia"},
	{1,L"8-go",L"Ósmego"},
	{1,L"9 Maja",L"Dziewiątego Maja"},
	{1,L"9-go",L"Dziewiątego"},
	{1,L"A. Boboli",L"Andrzeja Boboli"},
	{1,L"A. I Z. Pronaszków",L"Andrzeja i Zbigniewa Pronaszków"},
	{1,L"Aleja Monte Cassino" ,L"Aleja Monte Kassino"},
	{1,L"B. Głowackiego",L"Bartosza Głowackiego"},
	{1,L"B. Skury-Skoczyńskiego",L"Bronisława Skury Skoczyńskiego"},
	{1,L"Balice I",L"Balice jeden"},
	{1,L"Becka",L"Beka"},
	{1,L"Beethovena",L"Betowena"},
	{1,L"Bratislava I" ,L"Bratysława"},
	{1,L"Bursztynowa",L"Bursztynowa A jeden"},
	{1,L"Bł. Franciszki",L"Błogosławionej Franciszki"},
	{1,L"Bł. Królowej",L"Błogosławionej Królowej"},
	{1,L"Cassino",L"Kassino"},
	{1,L"Charlesa",L"Szarla"},
	{1,L"Chvojenec",L"hwojenec"},
	{1,L"Conrada",L"Konrada"},
	{1,L"Curie",L"Kiri"},
	{1,L"Dickensa",L"Dikensa"},
	{1,L"Dubois",L"Dibua"},
	{1,L"Duboisa",L"Dibua"},
	{1,L"Dunajom" ,L"Dunajem"},
	{1,L"Dunajom" ,L"Dunajem"},
	{1,L"F. Lubeckiego-Druckiego",L"Franciszka Lubeckiego Druckiego"},
	{1,L"Fieldorfa",L"Fildorfa"},
	{1,L"Gaulle'a",L"Gola"},
	{1,L"Gaullea",L"Gola"},
	{1,L"Gen. A. E. Fieldorfa-Nila",L"Generała Augusta Emila Fieldorfa Nila"},
	{1,L"Gen. T. Rozwadowskiego",L"Generała Tadeusza Rozwadowskiego"},
	{1,L"Generała Jana H. Dąbrowskiego",L"Generała Jana Henryka Dąbrowskiego"},
	{1,L"Grottgera",L"Grotgera"},
	{1,L"H. Dąbrowskiego",L"Henryka Dąbrowskiego"},
	{1,L"H. I S. Sierakowskich",L"Sierakowskich"},
	{1,L"Hetm. Jana K. Chodkiewicza",L"Hetmana Jana Karola Chodkiewicza"},
	{1,L"I Armii",L"Pierwszej Armii"},
	{1,L"I Brygady Pancernej Wp",L"Pierwszej Brygady Pancernej Wojska Polskiego"},
	{1,L"I Dywizji",L"Pierwszej Dywizji"},
	{1,L"I Dywizji",L"pierwszej dywizji"},
	{1,L"I Hermana",L"Pierwszego Hermana"},
	{1,L"I Konopackiego",L"Pierwszego Konopackiego"},
	{1,L"I Korpusu Pancernego WP",L"Pierwszego Korpusu Pancernego Wojska Polskiego"},
	{1,L"I Mazowieckiego",L"Pierwszego Mazowieckiego"},
	{1,L"I Morskiego Pułku Strzelców",L"Pierwszego Morskiego Pułku Strzelców"},
	{1,L"I Poprzeczna",L"Pierwsza poprzeczna"},
	{1,L"I Prezydenta",L"Pierwszego Prezydenta"},
	{1,L"I Pułku",L"Pierwszego pułku"},
	{1,L"I Raciborskiego",L"pierwszego Raciborskiego"},
	{1,L"I Starego",L"Pierwszego Starego"},
	{1,L"I Świdnickego",L"Pierwszego Świdnickiego"},
	{1,L"I. Gałczyńskiego",L"Gałczyńskiego"},
	{1,L"II Armii",L"Drugiej Armii"},
	{1,L"II Poprzeczna",L"Druga poprzeczna"},
	{1,L"II RP",L"drugiej Rzeczpospolitej"},
	{1,L"II Rzeczpospolitej",L"drugiej Rzeczpospolitej"},
	{1,L"II Wojny",L"Drugiej wojny"},
	{1,L"III Poprzeczna",L"Trzecia poprzeczna"},
	{1,L"III Rzeszę",L"Trzecią Rzeszę"},
	{1,L"III Węglowy",L"Trzeci węglowy"},
	{1,L"IV Poprzeczna",L"Czwarta poprzeczna"},
	{1,L"IX Poprzeczna",L"Dziewiąta poprzeczna"},
	{1,L"IX Wieków",L"Dziewięciu wieków"},
	{1,L"J. Bilczewskiego", L"Józefa Bilczewskiego"},
	{1,L"Jaśkowa",L"Jaśkowa"},
	{1,L"Jaśkowa",L"Jaśkowa"},
	{1,L"Josepha",L"Dżozefa"},
	{1,L"K. Chodkiewicza",L"Karola Chodkiewicza"},
	{1,L"Katowicka II",L"Katowicka dwa"},
	{1,L"Kirch",L"Kiirś"},
	{1,L"Kirchplatz",L"Kiirś plac"},
	{1,L"Kleeberga",L"Kleberga"},
	{1,L"Koścół Par.",L"Koścół Parafialny"},
	{1,L"Kr. Pole",L"Kralowe Pole"},
	{1,L"Kremnické Bane",L"Kremnic-ke Bahne"},
	{1,L"Krzysztofa C. Mrongowiusza",L"Krzysztofa Celestyna Mrongowiusza"},
	{1,L"Krzysztofa K. Baczyńskiego",L"Krzysztofa Kamila Baczyńskiego"},
	{1,L"Ks. Anny" ,L"Księżnej Anny"},
	{1,L"Ks. Barnima" ,L"Księcia Barnima"},
	{1,L"Ks. Bolka Swidnickiego" ,L"Księcia Bolka Świdnickiego"},
	{1,L"Ks. Borysa" ,L"Księcia Borysa"},
	{1,L"Ks. Dąbrówki" ,L"Księżnej Dąbrówki"},
	{1,L"Ks. Eryka" ,L"Księcia Eryka"},
	{1,L"Ks. Henryka Brodatego" ,L"Księcia Henryka Brodatego"},
	{1,L"Ks. Henryka Pobożnego" ,L"Księcia Henryka Pobożnego"},
	{1,L"Ks. Jeremiego Wiśniowieckiego" ,L"Księcia Jeremiego Wiśniowieckiego"},
	{1,L"Ks. Jolanty" ,L"Księżnej Jolanty"},
	{1,L"Ks. Józefa Poniatowskiego" ,L"Księcia Józefa Poniatowskiego"},
	{1,L"Ks. Konstantego Radziwiłła" ,L"Księcia Konstantego Radziwiłła"},
	{1,L"Ks. Ludgardy" ,L"Księżnej Ludgardy"},
	{1,L"Ks. Mściwoja" ,L"Księcia Mściwoja"},
	{1,L"Ks. Przybysławy" ,L"Księżnej Przybysławy"},
	{1,L"Ks. Salomei" ,L"Księżnej Salomei"},
	{1,L"Ks. Warcisława" ,L"Księcia Warcisława"},
	{1,L"Ks. Witolda",L"Księcia Witolda"},
	{1,L"Ks. Zofii" ,L"Księżnej Zoffi"},
	{1,L"M. Borelowskiego Lewela",L"Marcina Borelowskiego Lewela"},
	{1,L"M. Boruty",L"Mieczysława Boruty"},
	{1,L"M. Kolbego",L"Maria Kolbego"},
	{1,L"M. Michałowicza",L"Mieczysława Michałowicza"},
	{1,L"Millenium",L"Milenium"},
	{1,L"Ml. Boleslav",L"Mlada Boleslaw"},
	{1,L"Mozarta",L"Mocarta"},
	{1,L"Nabrzeże Helskie II",L"Nabrzeże Helskie dwa"},
	{1,L"O Wolność",L"o wolność"},
	{1,L"Osiedle 1000-Lecia Pp",L"Osiedle tysiąc lecia Państwa Polskiego"},
	{1,L"Pasłęk",L"Pasł ęk"},
	{1,L"Peč",L"Pecz"},
	{1,L"Peč",L"Pecz"},
	{1,L"Place",L"plac"},
	{1,L"Poprzeczna I",L"Pierwsza poprzeczna"},
	{1,L"Poprzeczna II",L"Druga poprzeczna"},
	{1,L"Poprzeczna III",L"Trzecia poprzeczna"},
	{1,L"Poprzeczna IV",L"Czwarta poprzeczna"},
	{1,L"Poprzeczna IX",L"Dziewiąta poprzeczna"},
	{1,L"Poprzeczna V",L"Piąta poprzeczna"},
	{1,L"Poprzeczna VI",L"Szósta poprzeczna"},
	{1,L"Poprzeczna VII",L"Siódma poprzeczna"},
	{1,L"Poprzeczna VIII",L"Ósma poprzeczna"},
	{1,L"Poprzeczna X",L"Dziesiata poprzeczna"},
	{1,L"Poprzeczna XI",L"Jedenasta poprzeczna"},
	{1,L"Posag 7 Panien",L"Posag siedmiu Panien"},
	{1,L"Pozostaly",L"Pozostały"},
	{1,L"Prof",L"Profesora"},
	{1,L"Płk. Piech.",L"Pułku piechoty"},
	{1,L"Rampa",L""},
	{1,L"Rejonu AK",L"Rejonu Armi krajowej"},
	{1,L"Reymonta",L"Rejmonta"},
	{1,L"Rondo Graniczne 1920-1939",L"Rondo graniczne tysiąc dziewięćset dwadzieścia tysiąc dziewięćset trzydzieści dziewięć"},
	{1,L"Rondo Marsz. Sejmu M. Płażyńskiego",L"Rondo Marszałka Sejmu Macieja Płażyńskiego"},
	{1,L"Roosevelta",L"Ruswelta"},
	{1,L"Rue",L"Ulicę"},
	{1,L"Rynek II",L"Rynek drugi"},
	{1,L"Singera",L"Zingera"},
	{1,L"St. Grota" ,L"Stanisława Grota"},
	{1,L"Strada",L"Ulicę"},
	{1,L"T. Bora",L"Tadeusza Bora"},
	{1,L"Tajnej Org.",L"Tajnej Organizacji"},
	{1,L"Tischnera",L"Tisznera"},
	{1,L"Ulica 55 Poznań. Płk. Piechoty",L"Ulica pięćdziesiątego piątego półku piechoty"},
	{1,L"Ulica 9 Marca",L"Ulica dziewiątego marca"},
	{1,L"V Poprzeczna",L"Piąta poprzeczna"},
	{1,L"VI Poprzeczna",L"Szósta poprzeczna"},
	{1,L"VII Poprzeczna",L"Siódma poprzeczna"},
	{1,L"VIII Poprzeczna",L"Ósma poprzeczna"},
	{1,L"Vltavou",L"Wełtawą"},
	{1,L"Vltavou",L"Wełtawą"},
	{1,L"Voie",L"drogę"},
	{1,L"Vysočany",L"Wysoczany"},
	{1,L"Vysočany",L"Wysoczany"},
	{1,L"Walerego E Radzikowskiego",L"Walerego Radzikowskiego"},
	{1,L"Węzeł Nowe Marzy",L"Węzeł Nowe Mar-zy"},
	{1,L"Władysława S.",L"Władysława"},
	{1,L"X Poprzeczna",L"Dziesiata poprzeczna"},
	{1,L"X-Lecia",L"Dziesięcio lecia"},
	{1,L"XI Poprzeczna",L"Jedenasta poprzeczna"},
	{1,L"XII Poprzeczna",L"Dwunasta poprzeczna"},
	{1,L"XV Aleja",L"Piętnasta aleja"},
	{1,L"XV-Lecia",L"Piętnastolecia"},
	{1,L"XVI Aleja",L"Szesnasta aleja"},
	{1,L"XVII Aleja",L"Siedemnasta aleja"},
	{1,L"XVIII Aleja",L"Osiemnasta aleja"},
	{1,L"XX-Lecia",L"Dwudziestolecia"},
	{1,L"XXV Drużyny",L"Dwudziestej piatej drużyny"},
	{1,L"XXV-Lecia",L"Dwudziesto pięciolecia"},
	{1,L"XXX-Lecia",L"Trzydziestolecia"},
	{1,L"XXXV-Lecia",L"Trzydziesto pieciolecia"},
	{1,L"Zatorze I",L"Zatorze jeden"},
	{1,L"kościerska",L"kościerską"},
	{1,L"česká",L"czeska"},
	{1,L"česká",L"czeska"},
	{1,L"Św. Agnieszki",L"Świętej Agnieszki"},
	{1,L"Św. Anny",L"Świętej Anny"},
	{1,L"Św. Barbary",L"Świętej Barbary"},
	{1,L"Św. Bronisławy",L"Świętej Bronisławy"},
	{1,L"Św. Cecylii",L"Świętej Cecylii"},
	{1,L"Św. Elżbiety",L"Świętej Elzbiety"},
	{1,L"Św. Faustyny",L"Świętej Fałstyny"},
	{1,L"Św. Gertrudy",L"Świętej Gertrudy"},
	{1,L"Św. Jadwigi",L"Świętej Jadwigi"},
	{1,L"Św. Katarzyny",L"Świętej Katarzyny"},
	{1,L"Św. Kingi",L"Świętej Kingi"},
	{1,L"Św. Klary",L"Świętej Klary"},
	{1,L"Św. Kunegundy",L"Świętej Kunegundy"},
	{1,L"Św. Marcin",L"Święty Marcin"},
	{1,L"Św. Marii",L"Świętej Marii"},
	{1,L"Św. Rodziny",L"Świętej Rodziny"},
	{1,L"Św. Teresy",L"Świętej Teresy"},
	{1,L"Św. Trójcy",L"Świętej Trójcy"},
	{1,L"Św. Urszuli",L"Świętej Urszuli"},
	{2,L"6-Letniego",L"sześcio letniego"},
	{2,L"I Brygady",L"pierwszej brygady"},
	{2,L"I. Gałczyńskiego",L"Ildefonsa Gałczyńskiego"},
	{2,L"J. I W.",L"Jerzego i Władysławy"},
--skroty w nazwach
	{1,L"Abp",L"Arcybiskupa"},
	{1,L"Adm",L"Admirała"},
	{1,L"Ak" ,L"Armii Krajowej"},
	{1,L"Ak",L"A Ka"},
	{1,L"Akad",L"Akademickiej"},
	{1,L"Al",L"Aleja"},
	{1,L"Boh",L"Bohaterów"},
	{1,L"Bojow",L"Bojowników"},
	{1,L"Bojown",L"Bojowników"},
	{1,L"Bp",L"Biskupa"},
	{1,L"Bł",L"Błogosławionego"},
	{1,L"Demok",L"Demokrację"},
	{1,L"Dr",L"Doktora"},
	{1,L"Dyw",L"Dywizji"},
	{1,L"Gen",L"Generała"},
	{1,L"Gop",L"Górnośląskiego Okręgu Przemysłowego"},
	{1,L"Grenad",L"Grenadierów"},
	{1,L"Hetm",L"Hetmana"},
	{1,L"Hr",L"Hradec"},
	{1,L"II",L"drugiego"},
	{1,L"III",L"trzeciego"},
	{1,L"IV",L"czwartego"},
	{1,L"IX",L"dziewiątego"},
	{1,L"Im",L"Imienia"},
	{1,L"Inż",L"Inżyniera"},
	{1,L"Jiz",L"jizerou"},
	{1,L"Kard",L"Kardynała"},
	{1,L"Kmdr",L"Komandora"},
	{1,L"Kol",L"Kolonia"},
	{1,L"Kpr",L"Kaprala"},
	{1,L"Kpt",L"Kapitana"},
	{1,L"Ks",L"Księdza"},
	{1,L"Marsz",L"Marszałka"},
	{1,L"Mjr",L"Majora"},
	{1,L"NMP",L"Najświętszej Mari Panny"},
	{1,L"Nám",L"RYNEK"},
	{1,L"O",L"Ojca"},
	{1,L"Obr",L"Obrońców"},
	{1,L"Org",L"Organizacji"},
	{1,L"Os",L"Osiedle"},
	{1,L"Piech",L"Piechoty"},
	{1,L"Pl",L"Plac"},
	{1,L"Por",L"Porucznika"},
	{1,L"Poszkod",L"Poszkodowanych"},
	{1,L"Pow",L"Powstańców"},
	{1,L"Powst",L"Powstańczej"},
	{1,L"Ppor",L"Podporucznika"},
	{1,L"Ppłk",L"Podpułkownika"},
	{1,L"Prał",L"Prałata"},
	{1,L"Prof",L"Profesora"},
	{1,L"Płd",L"Południowy"},
	{1,L"Płk",L"Pułkownika"},
	{1,L"Płn",L"Północny"},
	{1,L"R",L"Roku"},
	{1,L"Rtm",L"Rotmistrza"},
	{1,L"Sródmieście Pd",L"śródmieście połódnie"},
	{1,L"Ul",L"ulica"},
	{1,L"V",L"piątego"},
	{1,L"VI",L"szóstego"},
	{1,L"VII",L"siódmego"},
	{1,L"VIII",L"ósmego"},
	{1,L"Vlt",L"Wełtawą"},
	{1,L"Warsz",L"Warszawy"},
	{1,L"Warszaw",L"Warszawskiego"},
	{1,L"Więźn",L"Więźniów"},
	{1,L"Wlk",L"Wielka"},
	{1,L"Wlkp",L"Wielkopolskich"},
	{1,L"Wp",L"Wojska polskiego"},
	{1,L"Wsch",L"Wschodni"},
	{1,L"Wyb",L"Wybrzeże"},
	{1,L"Wł",L"Władysława"},
	{1,L"X",L"dziesiątego"},
	{1,L"XI",L"jedenastego"},
	{1,L"XII",L"dwunastego"},
	{1,L"XVI",L"szesnastego"},
	{1,L"XX-lecia",L"Dwudziestolecia"},
	{1,L"XXIII",L"dwudziestego trzeciego"},
	{1,L"Zach",L"Zachodni"},
	{1,L"čsl." ,L"czesko slowensej"},
	{1,L"Św",L"Świętego"},
	{1,L"Żoł",L"Żołnierzy"},

	{2,L"(?i) I\\.?$",L"pierwszego"},
	{2,L"^(%u)(%u)[ -]*(%d+)",L"%1.%2. %3"},
	{2,L"\-",L" "},
	{2,L"(%d)(%a)",L"%1 %2"},
	{2,L"(%a)(%d)",L"%1 %2"},
	{2,L"//",L", "},
	{2,L"(?i) St\\.? +(\\d+)",L"s t \\1"},
	{2,L"(?i)^St\\.? ",L"Saint "},
	{2,L"(?i) St\\.?$",L"Strit "},
	{2,L"(?i)^Dr\\.? ",L"Doktora"},
	{2,L"(?i) Dr\\.?$",L"Drajw"},
})

transform.substitute_names = TRANSFORM.new({
	{2,L"(?i)adna\\.?$",L"adną"},
	{2,L"(?i)ajna\\.?$",L"ajną"},
	{2,L"(?i)atna\\.?$",L"atną"},
	{2,L"(?i)atnia\\.?$",L"atnią"},
	{2,L"(?i)awna\\.?$",L"awną"},
	{2,L"(?i)ałowa\\.?$",L"ałową"},
	{2,L"(?i)bna\\.?$",L"bną"},
	{2,L"(?i)borna\\.?$",L"borną"},
	{2,L"(?i)bowa\\.?$",L"bową"},
	{2,L"(?i)brna\\.?$",L"brną"},
	{2,L"(?i)bska\\.?$",L"bską"},
	{2,L"(?i)cerna\\.?$",L"cerną"},
	{2,L"(?i)ciana\\.?$",L"cianą"},
	{2,L"(?i)cista\\.?$",L"cistą"},
	{2,L"(?i)cka\\.?$",L"cką"},
	{2,L"(?i)cna\\.?$",L"cną"},
	{2,L"(?i)cowa\\.?$",L"cową"},
	{2,L"(?i)czana\\.?$",L"czaną"},
	{2,L"(?i)czna\\.?$",L"czną"},
	{2,L"(?i)darna\\.?$",L"darną"},
	{2,L"(?i)derna\\.?$",L"derną"},
	{2,L"(?i)dnia\\.?$",L"dnią"},
	{2,L"(?i)doska\\.?$",L"doską"},
	{2,L"(?i)dowa\\.?$",L"bową"},
	{2,L"(?i)dzka\\.?$",L"dzką"},
	{2,L"(?i)dłowa\\.?$",L"dłową"},
	{2,L"(?i)enna\\.?$",L"enną"}, --
	{2,L"(?i)eska\\.?$",L"eską"},
	{2,L"(?i)esna\\.?$",L"esną"},
	{2,L"(?i)etna\\.?$",L"etną"},
	{2,L"(?i)ewcza\\.?$",L"ewczą"},
	{2,L"(?i)ewna\\.?$",L"ewną"},
	{2,L"(?i)eńcza\\.?$",L"eńczą"},
	{2,L"(?i)farna\\.?$",L"farną"},
	{2,L"(?i)fska\\.?$",L"fską"},
	{2,L"(?i)garna\\.?$",L"garną"},
	{2,L"(?i)goska\\.?$",L"goską"},
	{2,L"(?i)gska\\.?$",L"gską"},
	{2,L"(?i)głowa\\.?$",L"głową"},
	{2,L"(?i)howna\\.?$",L"howną"},
	{2,L"(?i)hska\\.?$",L"hską"},
	{2,L"(?i)iarna\\.?$",L"iarną"},
	{2,L"(?i)iasta\\.?$",L"iastą"},
	{2,L"(?i)idna\\.?$",L"idną"},
	{2,L"(?i)ijna\\.?$",L"ijną"},
	{2,L"(?i)inna\\.?$",L"inną"},
	{2,L"(?i)iorna\\.?$",L"iorną"},
	{2,L"(?i)iowa\\.?$",L"iową"},
	{2,L"(?i)iska\\.?$",L"iską"},
	{2,L"(?i)itna\\.?$",L"itną"},
	{2,L"(?i)jarna\\.?$",L"jarną"},
	{2,L"(?i)jowa\\.?$",L"jową"},
	{2,L"(?i)jska\\.?$",L"jską"},
	{2,L"(?i)koska\\.?$",L"koską"},
	{2,L"(?i)kowa\\.?$",L"kową"},
	{2,L"(?i)lana\\.?$",L"laną"},
	{2,L"(?i)larna\\.?$",L"larną"},
	{2,L"(?i)lerna\\.?$",L"lerną"},
	{2,L"(?i)lista\\.?$",L"listą"},
	{2,L"(?i)liwa\\.?$",L"liwą"},
	{2,L"(?i)lna\\.?$",L"lną"},
	{2,L"(?i)lona\\.?$",L"loną"},
	{2,L"(?i)loska\\.?$",L"loską"},
	{2,L"(?i)lowa\\.?$",L"lową"},
	{2,L"(?i)lska\\.?$",L"lską"},
	{2,L"(?i)mowa\\.?$",L"mową"},
	{2,L"(?i)mowna\\.?$",L"mowną"},
	{2,L"(?i)mska\\.?$",L"mską"},
	{2,L"(?i)murna\\.?$",L"murną"},
	{2,L"(?i)niana\\.?$",L"nianą"},
	{2,L"(?i)nicza\\.?$",L"niczą"},
	{2,L"(?i)nista\\.?$",L"nistą"},
	{2,L"(?i)noska\\.?$",L"noską"},
	{2,L"(?i)nowa\\.?$",L"nową"},
	{2,L"(?i)nska\\.?$",L"nską"},
	{2,L"(?i)odna\\.?$",L"odną"},
	{2,L"(?i)onna\\.?$",L"onną"},
	{2,L"(?i)osna\\.?$",L"osną"},
	{2,L"(?i)otna\\.?$",L"onną"},
	{2,L"(?i)owana\\.?$",L"owaną"},
	{2,L"(?i)owcza\\.?$",L"owczą"},
	{2,L"(?i)ołowa\\.?$",L"ołową"},
	{2,L"(?i)porna\\.?$",L"porną"},
	{2,L"(?i)poska\\.?$",L"poską"},
	{2,L"(?i)powa\\.?$",L"pową"},
	{2,L"(?i)rarna\\.?$",L"rarną"},
	{2,L"(?i)roska\\.?$",L"roską"},
	{2,L"(?i)rowa\\.?$",L"rową"},
	{2,L"(?i)rowna\\.?$",L"rowną"},
	{2,L"(?i)rska\\.?$",L"rską"},
	{2,L"(?i)rwana\\.?$",L"rwaną"},
	{2,L"(?i)rwna\\.?$",L"rwną"},
	{2,L"(?i)rzana\\.?$",L"rzaną"},
	{2,L"(?i)rzna\\.?$",L"rzną"},
	{2,L"(?i)rłowa\\.?$",L"rłową"},
	{2,L"(?i)siana\\.?$",L"sianą"},
	{2,L"(?i)soska\\.?$",L"soską"},
	{2,L"(?i)sowa\\.?$",L"sową"},
	{2,L"(?i)stna\\.?$",L"stną"},
	{2,L"(?i)szana\\.?$",L"szaną"},
	{2,L"(?i)szna\\.?$",L"szną"},
	{2,L"(?i)tarna\\.?$",L"tarną"},
	{2,L"(?i)torna\\.?$",L"torną"},
	{2,L"(?i)towa\\.?$",L"tową"},
	{2,L"(?i)towna\\.?$",L"towną"},
	{2,L"(?i)udna\\.?$",L"udną"},
	{2,L"(?i)ujna\\.?$",L"ujną"},
	{2,L"(?i)uska\\.?$",L"uską"},
	{2,L"(?i)utna\\.?$",L"utną"},
	{2,L"(?i)ułowa\\.?$",L"ułową"},
	{2,L"(?i)warna\\.?$",L"warną"},
	{2,L"(?i)worna\\.?$",L"worną"},
	{2,L"(?i)wowa\\.?$",L"wową"},
	{2,L"(?i)wska\\.?$",L"wską"}, --
	{2,L"(?i)yjna\\.?$",L"yjną"},
	{2,L"(?i)ynna\\.?$",L"ynną"},
	{2,L"(?i)yrna\\.?$",L"yrną"},
	{2,L"(?i)yska\\.?$",L"yską"},
	{2,L"(?i)ywna\\.?$",L"ywną"},
	{2,L"(?i)zarna\\.?$",L"zarną"},
	{2,L"(?i)zdna\\.?$",L"zdną"},
	{2,L"(?i)zerna\\.?$",L"zerną"},
	{2,L"(?i)ziana\\.?$",L"zianą"},
	{2,L"(?i)zicza\\.?$",L"ziczą"},
	{2,L"(?i)zista\\.?$",L"zistą"},
	{2,L"(?i)zoska\\.?$",L"zoską"},
	{2,L"(?i)zowa\\.?$",L"zową"},
	{2,L"(?i)złowa\\.?$",L"złową"},
	{2,L"(?i)ójna\\.?$",L"ójną"},
	{2,L"(?i)órcza\\.?$",L"órczą"},
	{2,L"(?i)órna\\.?$",L"órną"},
	{2,L"(?i)ówna\\.?$",L"ówną"},
	{2,L"(?i)ądna\\.?$",L"ądną"},
	{2,L"(?i)ąska\\.?$",L"ąską"},
	{2,L"(?i)ątna\\.?$",L"ątną"},
	{2,L"(?i)ęsia\\.?$",L"ęsią"},
	{2,L"(?i)ęska\\.?$",L"ęską"},
	{2,L"(?i)ęsna\\.?$",L"ęsną"},
	{2,L"(?i)ętna\\.?$",L"ętną"},
	{2,L"(?i)łska\\.?$",L"łską"},
	{2,L"(?i)ńska\\.?$",L"ńską"},
	{2,L"(?i)śna\\.?$",L"śną"},
	{2,L"(?i)źna\\.?$",L"źną"},
	{2,L"(?i)żana\\.?$",L"żaną"},
	{2,L"(?i)żarna\\.?$",L"żarną"},
	{2,L"(?i)żna\\.?$",L"żną"},
	{2,L"(?i)żowa\\.?$",L"żową"},
})

transform.substitute_road_names = TRANSFORM.new({
	{1,L"7",L"siedem"},
	{1,L"Aleja",L"Aleję"},
	{1,L"Alejka",L"Alejkę"},
	{1,L"Autostrada",L"Autostradę"},
	{1,L"Babia",L"Babią"},
	{1,L"Banioska",L"Banioską"},
	{1,L"Bartna",L"Bartną"},
	{1,L"Bartoska",L"Bartoską"},
	{1,L"Biała",L"Białą"},
	{1,L"Bierna",L"Bierną"},
	{1,L"Biskupia",L"Biskupią"},
	{1,L"Bliźniacza",L"Bliźniaczą"},
	{1,L"Bobrza",L"Bobrzą"},
	{1,L"Bociania",L"Bocianią"},
	{1,L"Borsucza",L"Borsuczą"},
	{1,L"Brama",L"Bramę"},
	{1,L"Błędna",L"Błędną"},
	{1,L"Cała",L"Całą"},
	{1,L"Chata",L"Chatę"},
	{1,L"Chrobacza",L"Chrobaczą"},
	{1,L"Ciasna",L"Ciasną"},
	{1,L"Cicha",L"Cichą"},
	{1,L"Cietrzewia",L"Cietrzewią"},
	{1,L"Cudowna",L"Cudowną"},
	{1,L"Cyrulicza",L"Cyruliczą"},
	{1,L"Czajcza",L"Czajczą"},
	{1,L"Czwarta",L"Czwartą"},
	{1,L"Czysta",L"Czystą"},
	{1,L"Cłowa",L"Cłową"},
	{1,L"Dobra",L"Dobrą"},
	{1,L"Dolina",L"Dolina"},
	{1,L"Dostawcza",L"Dostawczą"},
	{1,L"Droga",L"Drogę"},
	{1,L"Druga",L"Drugą"},
	{1,L"Dwunasta",L"Dwunastą"},
	{1,L"Dzicza",L"Dziczą"},
	{1,L"Dziekania",L"Dziekanią"},
	{1,L"Dziesiąta",L"Dziesiatą"},
	{1,L"Dziewicza",L"Dziewiczą"},
	{1,L"Dziewiąta",L"Dziewiątą"},
	{1,L"Długa",L"Długą"},
	{1,L"Estakada",L"Estakadę"},
	{1,L"Flisacza",L"Flisaczą"},
	{1,L"Fortunna",L"Fortunną"},
	{1,L"Gawronia",L"Gawronią"},
	{1,L"Gospodarcza",L"Gospodarczą"},
	{1,L"Gołębia",L"Gołebią"},
	{1,L"Grobla",L"Groblę"},
	{1,L"Grzybia",L"Grzybią"},
	{1,L"Góra",L"Górę"},
	{1,L"Górka",L"Górkę"},
	{1,L"Głęboka",L"Głęboką"},
	{1,L"Hala",L"Halę"},
	{1,L"Hoża",L"Hożą"},
	{1,L"Huta",L"Hutę"},
	{1,L"Ideowa",L"Ideową"},
	{1,L"Iglasta",L"Iglastą"},
	{1,L"Iłowa",L"Iłową"},
	{1,L"Jachowa",L"Jachową"},
	{1,L"Jarzębia",L"Jarzębią"},
	{1,L"Jaskółcza",L"Jaskółczą"},
	{1,L"Jastrzębia",L"Jastrzębią"},
	{1,L"Jaszczurcza",L"Jaszczurczą"},
	{1,L"Jedenasta",L"Jedenastą"},
	{1,L"Jelenia",L"Jelenią"},
	{1,L"Kacza",L"Kaczą"},
	{1,L"Kakaowa",L"Kakaową"},
	{1,L"Karna",L"Karną"},
	{1,L"Kawcza",L"Kawczą"},
	{1,L"Kawia",L"Kawią"},
	{1,L"Kolonia",L"Kolonię"},
	{1,L"Korabia",L"Korabią"},
	{1,L"Kotwicza",L"Kotwiczą"},
	{1,L"Kotłowa",L"Kotłową"},
	{1,L"Kozia",L"Kozią"},
	{1,L"Krajoznawcza",L"Krajoznawczą"},
	{1,L"Krogulcza",L"Krogulczą"},
	{1,L"Krucza",L"Kruczą"},
	{1,L"Krulicza",L"Kruliczą"},
	{1,L"Krzywa",L"Krzywą"},
	{1,L"Krótka",L"Krótką"},
	{1,L"Kręta",L"Krętą"},
	{1,L"Kukułcza",L"Kukułczą"},
	{1,L"Kępa",L"Kępę"},
	{1,L"Letnia",L"Letnią"},
	{1,L"Liściasta",L"Liściastą"},
	{1,L"Lwia",L"Lwią"},
	{1,L"Matłoska",L"Matłoską"},
	{1,L"Mała",L"Małą"},
	{1,L"Mewia",L"Mewią"},
	{1,L"Mierna",L"Mierną"},
	{1,L"Miła",L"Miłą"},
	{1,L"Miłosierna",L"Miłosierną"},
	{1,L"Mocarna",L"Mocarną"},
	{1,L"Modra",L"Modrą"},
	{1,L"Mokra",L"Mokrą"},
	{1,L"Mrowia",L"Mrowią"},
	{1,L"Mrówcza",L"Mrówczą"},
	{1,L"Mysia",L"Mysią"},
	{1,L"Niecała",L"Niecałą"},
	{1,L"Niedługa",L"Niedługą"},
	{1,L"Niedźwiedzia",L"Niedźwiedzią"},
	{1,L"Niewielka",L"Niewielką"},
	{1,L"Obwodnica",L"Obwodnicę"},
	{1,L"Ochocza",L"Ochoczą"},
	{1,L"Ocznia",L"Ocznią"},
	{1,L"Olejna",L"Olejną"},
	{1,L"Opiekuńcza",L"Opiekuńczą"},
	{1,L"Orla",L"Orlą"},
	{1,L"Orna",L"Orną"},
	{1,L"Osada",L"Osadę"},
	{1,L"Osiemnasta",L"Osiemnastą"},
	{1,L"Pajęcza",L"Pajęczą"},
	{1,L"Pawia",L"Pawią"},
	{1,L"Perlicza",L"Perliczą"},
	{1,L"Pierwsza",L"Pierwszą"},
	{1,L"Piąta",L"Piątą"},
	{1,L"Piętnasta",L"Piętnastą"},
	{1,L"Pleciona",L"Plecioną"},
	{1,L"Podchojna",L"Podchojną"},
	{1,L"Podmierna",L"Podmierną"},
	{1,L"Pokorna",L"Pokorną"},
	{1,L"Polana",L"Polanę"},
	{1,L"Powstańcza",L"Powstańczą"},
	{1,L"Prawdziwa",L"Prawdziwą"},
	{1,L"Promenada",L"Promenadę"},
	{1,L"Prosta",L"Prostą"},
	{1,L"Prostopadła",L"Prostopadłą"},
	{1,L"Przecznia",L"Przecznią"},
	{1,L"Przecznica",L"Przecznicę"},
	{1,L"Przekorna",L"Przekorną"},
	{1,L"Przemysłowa",L"Przemysłową"},
	{1,L"Przewoska",L"Przewoską"},
	{1,L"Przezorna",L"Przezorną"},
	{1,L"Przyjezierna",L"Przyjezierną"},
	{1,L"Przęsłowa",L"Przęsłową"},
	{1,L"Puszcza",L"Puszczę"},
	{1,L"Robocza",L"Roboczą"},
	{1,L"Rojna",L"Rojną"},
	{1,L"Rumiana",L"Rumianą"},
	{1,L"Rybia",L"Rybią"},
	{1,L"Rysia",L"Rysią"},
	{1,L"Równia",L"Równię"},
	{1,L"Sarnia", L"Sarnią"},
	{1,L"Siedemnasta",L"Siedemnastą"},
	{1,L"Sikorcza",L"Sikorczą"},
	{1,L"Siwa",L"Siwą"},
	{1,L"Siódma",L"Siódmą"},
	{1,L"Skarpa",L"Skarpę"},
	{1,L"Skowronia",L"Skowronią"},
	{1,L"Skowrończa",L"Skowrończą"},
	{1,L"Smocza",L"Smoczą"},
	{1,L"Sowia",L"Sowią"},
	{1,L"Sołtysia",L"Sołtysią"},
	{1,L"Spokojna",L"Spokojną"},
	{1,L"Spożywczaa",L"Spożywczą"},
	{1,L"Spółdzielcza",L"Spółdzielczą"},
	{1,L"Srebrzysta",L"Srebrzystą"},
	{1,L"Srocza",L"Sroczą"},
	{1,L"Stacja",L"Stację"},
	{1,L"Sterna",L"Sterną"},
	{1,L"Strojna",L"Strojną"},
	{1,L"Stroma",L"Stromą"},
	{1,L"Sucha",L"Suchą"},
	{1,L"Szczupacza",L"Szczupaczą"},
	{1,L"Szermiercza",L"Szermierczą"},
	{1,L"Szeroka",L"Szeroką"},
	{1,L"Szesnasta",L"Szesnastą"},
	{1,L"Szosa",L"Szosę"},
	{1,L"Szpacza",L"Szpaczą"},
	{1,L"Szykowna",L"Szykowną"},
	{1,L"Szósta",L"Szóstą"},
	{1,L"Sójcza",L"Sójczą"},
	{1,L"Sędziwa",L"Sędziwą"},
	{1,L"Słomiana",L"Słomianą"},
	{1,L"Słowicza",L"Słowiczą"},
	{1,L"Tama",L"Tamę"},
	{1,L"Tarnawska",L"Tarnawską"},
	{1,L"Trasa",L"Trasę"},
	{1,L"Trawiasta",L"Trawiastą"},
	{1,L"Trzecia",L"Trzecią"},
	{1,L"Trójmiasta",L"Trój miejską"},
	{1,L"Tygrysia",L"Tygrysią"},
	{1,L"Ul",L"Ulicę"},
	{1,L"Ulica",L"Ulicę"},
	{1,L"Upojna",L"Upojną"},
	{1,L"Urocza",L"Uroczą"},
	{1,L"Warnawska",L"Warnawską"},
	{1,L"Wawelska",L"Wawelską"},
	{1,L"Wesoła",L"Wesołą"},
	{1,L"Wiatracza",L"Wiatraczą"},
	{1,L"Wieczorna",L"Wieczorną"},
	{1,L"Wielka",L"Wielką"},
	{1,L"Wielorybia",L"Wielorybią"},
	{1,L"Wierna",L"Wierną"},
	{1,L"Wieśniacza",L"Wieśniaczą"},
	{1,L"Wilcza",L"Wilczą"},
	{1,L"Wiosłowa",L"Wiosłową"},
	{1,L"Wisłocza",L"Wisłoczą"},
	{1,L"Wodocza",L"Wodoczą"},
	{1,L"Wodopojna",L"Wodopojną"},
	{1,L"Wola",L"Wolę"},
	{1,L"Wołoska",L"Wołoską"},
	{1,L"Wronia",L"Wronią"},
	{1,L"Wyboista",L"Wyboistą"},
	{1,L"Wydobywsza",L"Wydobywczą"},
	{1,L"Wysoka",L"Wysoką"},
	{1,L"Wąskie pasy",L"Zwęrzenie jezdni"},
	{1,L"Własna",L"Własną"},
	{1,L"Włoska",L"Włoską"},
	{1,L"Zadumana",L"Zadumaną"},
	{1,L"Zagórczańska",L"Zgórczańską"},
	{1,L"Zajezierna",L"Zajezierną"},
	{1,L"Zajęcza",L"Zajęczą"},
	{1,L"Zakolejna",L"Zakolejną"},
	{1,L"Zamknięta",L"Zamkniętą"},
	{1,L"Zapadła",L"Zapadłą"},
	{1,L"Zbiorcza",L"Zbiorczą"},
	{1,L"Zbrojna",L"Zbrojną"},
	{1,L"Ziębia",L"Ziebią"},
	{1,L"Znana",L"Znaną"},
	{1,L"Złota",L"Złotą"},
	{1,L"dwuch" ,L"dwa"},
	{1,L"punkt znajduje sie w odleglosci",L"punkt znajduje się w odległości"},
	{1,L"Ósma",L"Ósmą"},
	{1,L"Ćwikłowa",L"Ćwikłową"},
	{1,L"Łabędzia",L"Łabędzią"},
	{1,L"Łamana",L"Łamaną"},
	{1,L"Łowna",L"Łowną"},
	{1,L"Ścieżka",L"Scieżkę"},
	{1,L"Świstacza",L"Świstaczą"},
	{1,L"Żabia",L"Żabią"},
	{1,L"Żniwna",L"Żniwną"},
	{1,L"Żubrza",L"Żubrzą"},
	{1,L"Żurawia",L"Żurawią"},
	{1,L"Żytnia",L"Żytnią"},
	{1,L"Żywa",L"Żywą"},
	{1,L"Żyzna",L"Żyzną"},
	{1,L"Żółwia",L"Żółwią"},
})

transform.country_abbrev_table = TRANSFORM.new({
	{1,L"A. D.",L"An der"},
	{1,L"A. Inn",L"Ammm Inn"},
	{1,L"A.D.",L"An der"},
	{1,L"A.D.D.",L"an der donau"},
	{1,L"Al. Jerozolimskie",L"Aleje Jerozolimskie"},
	{1,L"Al. Prymasa Tysiąclecia",L"Aleja prymasa tysiąclecia"},
	{1,L"Anschlussstelle",L"Anszlussztele"},
	{1,L"Antwerpen",L"Antferpia"},
	{1,L"Auf D.",L"Auf der"},
	{1,L"Autobahndreieck",L"Autobandrajek"},
	{1,L"Autobahnkreuz",L"węzeł"},
	{1,L"B. Bystrica",L"Banska Bystri-ca"},
	{1,L"Ban. Bystrica",L"Banska Bystrzyca"},
	{1,L"Bautzen",L"Budziszyn"},
	{1,L"Bielsko-B.",L"Bielsko biała"},
	{1,L"Bologna",L"Bolonia"},
	{1,L"Bratislava",L"Bratysława"},
	{1,L"Brücke",L"Briyke"},
	{1,L"Brücken",L"Briyken"},
	{1,L"Brüssel",L"Bruksela"},
	{1,L"Budapest",L"Budapeszt"},
	{1,L"Bukovec",L"Bukowiec"},
	{1,L"Bystřice",L"Bystrzice"},
	{1,L"Bystřice",L"Bystrzyca"},
	{1,L"Bystřicí" ,L"Bystrzycą"},
	{1,L"Bystřicí",L"Bystrzycą"},
	{1,L"Central London",L"Londyn Centralny"},
	{1,L"Chocholná-Velčice",L"Chocholna"},
	{1,L"Cirochou",L"cirohoł"},
	{1,L"Cottbus",L"Chociebuż"},
	{1,L"D-Bilk",L"Diseldorf Bilk"},
	{1,L"D. Kubín",L"Dolny Kubin"},
	{1,L"Dačice",L"Daczice"},
	{1,L"Dlhá nad Oravou",L"Dylha nad Orawou"},
	{1,L"Dlouhý",L"długi"},
	{1,L"Doubravou",L"Dobrawą"},
	{1,L"Dreieck",L"Drajek"},
	{1,L"Dresden",L"Drezno"},
	{1,L"Dresden",L"Drezno"},
	{1,L"Dunajom" ,L"Dunajem"},
	{1,L"Flughafen",L"Flluug-hafen"},
	{1,L"Frankfurt (Oder)",L"Frankfurt nad Odrą"},
	{1,L"Frankfurt A.M.",L"Frankfurt nad Menem"},
	{1,L"Garmisch-P.", L"Garmisz Partenkirszien"},
	{1,L"Generala" ,L"Generała"},
	{1,L"Giessen",L"Gisen"},
	{1,L"Gorzów Wlkp.",L"Gorzów wielkopolski"},
	{1,L"Graz",L"Grac"},
	{1,L"Görlitz",L"Zgorzelec"},
	{1,L"Głogów Młp.",L"Głogów małopolski"},
	{1,L"Hannover",L"Hanower"},
	{1,L"Havl.",L"Hawliczków"},
	{1,L"Havířov",L"Hawirzow"},
	{1,L"Havížov",L"Hawirzow"},
	{1,L"Hennef",L"Henef"},
	{1,L"Hořická",L"Horzyska"},
	{1,L"I. Allgäu",L"in Algau"},
	{1,L"I. Bay",L"in Bai"},
	{1,L"I. Chiemgau",L"in Chimgau"},
	{1,L"I. D.",L"In der"},
	{1,L"I. Grabfeld",L"in grabfeld"},
	{1,L"I. Ofr.",L"in oberfranken"},
	{1,L"I. Rottal",L"in Rotal"},
	{1,L"I. Ufr.",L"in uunterfranken"},
	{1,L"I.D.",L"In der"},
	{1,L"J. Hradec",L"indrzichów Hradec"},
	{1,L"Jablunkov",L"Jabłonków"},
	{1,L"Jičín",L"iczin"},
	{1,L"Jílové",L"i-lowe"},
	{1,L"K. Vary",L"Karlowe Wary"},
	{1,L"Kašp. Hory" ,L"Kaszperskii Hory"},
	{1,L"Klíčany",L"Kli-czany"},
	{1,L"Košice", L"Koszyce"},
	{1,L"Krakow",L"kraków"},
	{1,L"Kremnica",L"Kremni-ca"},
	{1,L"Krzysztofa C. Mrongowiusza",L"Krzysztofa Celestyna Mrongowiusza"},
	{1,L"Krzysztofa K.Baczyńskiego",L"Krzysztofa Kamila Baczyńskiego"},
	{1,L"Králové",L"Kralowe"},
	{1,L"Kysucké Nové Mesto",L"Kysuc-ke Nowe Mesto"},
	{1,L"Kysucou",L"Kysuco-u"},
	{1,L"Köln",L"Kolonia"},
	{1,L"Königs",L"Kyniks"},
	{1,L"Kąty Wr.",L"Kąty wrocławskie"},
	{1,L"L. Rovne" ,L"Lednic-kerowne"},
	{1,L"Labem" ,L"Łabą"},
	{1,L"Leipzig",L"Lipsk"},
	{1,L"Leipzig",L"Lipsk"},
	{1,L"Lipník nad Bečvou",L"Lipnik nad Beczwoł"},
	{1,L"Lučenec",L"Luczenec"},
	{1,L"Madrid",L"Madryt"},
	{1,L"Marseille",L"Marsylia"},
	{1,L"Mińsk Maz.",L"Mińsk mazowiecki"},
	{1,L"Ml. Boleslav",L"Mlada Boleslaw"},
	{1,L"München",L"Monachium"},
	{1,L"N. Doubr." ,L"nad Dobrawą"},
	{1,L"N. N.",L"Nad Nysą"},
	{1,L"N. S.",L"Nad Sazawou"},
	{1,L"N. T.",L"Nad Toplou"},
	{1,L"N/v.",L"Nad wahom"},
	{1,L"Nisou",L"Nysą"},
	{1,L"Nižná",L"Nirzna"},
	{1,L"Náchod", L"Nach-od"},
	{1,L"Náměšt nad Oslavou", L"Namest"},
	{1,L"Oborniki Wlkp.",L"Oborniki wielkopolskie"},
	{1,L"Ofr.",L"oberfranken"},
	{1,L"Ohří",L"Og-rzi"},
	{1,L"Olomouc",L"OŁomuniec"},
	{1,L"Olomouc-Centrum",L"OŁomuniec Centrum"},
	{1,L"Opf.",L"oberfalz"},
	{1,L"Oslavou", L"Oss-lawoł"},
	{1,L"Ostrowiec Św.",L"Ostrowiec świętokrzyski"},
	{1,L"Oščadnica",L"Oszczadnica"},
	{1,L"Paris",L"Paryż"},
	{1,L"Passau",L"Pasa-u"},
	{1,L"Pasłęk",L"Pasł ęk"},
	{1,L"Pest",L"Peszt"},
	{1,L"Peč",L"Pecz"},
	{1,L"Piekary Śl.",L"Piekary śląskie"},
	{1,L"Piotrków Tryb.",L"Piotrków trybunalski"},
	{1,L"Plzeň",L"Pilzno"},
	{1,L"Policja",L"Posterunek Policji"},
	{1,L"Ponętów D.",L"Ponętów dolny"},
	{1,L"Popradom" ,L"Popradem"},
	{1,L"Potsdam",L"Poczdam"},
	{1,L"Powazki" ,L"Powązki"},
	{1,L"Prag",L"Praga"},
	{1,L"Praha", L"Praga"},
	{1,L"Prešov",L"Preszów"},
	{1,L"Pruszcz Gd.",L"Pruszcz gdański"},
	{1,L"Reiskirchen",L"Rajskirsien"},
	{1,L"Reiskirchener",L"Rajskirsiener"},
	{1,L"Rondo Graniczne 1920-1939" ,L"Rondo graniczne tysiąc dziewięćset dwadzieścia tysiąc dziewięćset trzydzieści dziewięć"},
	{1,L"Rondo Onz" ,L"Rondo O En Zet"},
	{1,L"Ruda Śl.",L"Ruda śląska"},
	{1,L"Sankt Augustin",L"Sankt Augustjin"},
	{1,L"Schönefeld",L"Szynefelt"},
	{1,L"Sieg",L"Zig"},
	{1,L"Siegburg",L"Zigburk"},
	{1,L"Siemianowice Śl.",L"Siemianowice śląskie"},
	{1,L"Slavonice",L"Slawonice"},
	{1,L"Spreeau",L"Szpriyau"},
	{1,L"Spreenhagen",L"Szpriynhagen"},
	{1,L"Srodmiescie",L"śrudmieście"},
	{1,L"Sródmieście Pd." ,L"śródmieście połódnie"},
	{1,L"Stargard Szcz.",L"Stargard szczeciński"},
	{1,L"Starogard Gd.",L"Starogard gdański"},
	{1,L"Strančice",L"Stranczice"},
	{1,L"Strasse des 17. Juni",L"Strasse des zipcyn juni"},
	{1,L"Stráž",L"Strarz"},
	{1,L"Strážske",L"Strarz-ske"},
	{1,L"Sucha B.",L"Sucha beskidzka"},
	{1,L"Svitavou",L"świtawą"},
	{1,L"Svitavy",L"świtawy"},
	{1,L"Svrčinovec",L"Sfryczinowec"},
	{1,L"Tomaszów Mazow.",L"Tomaszów Mazowiecki"},
	{1,L"Transportzone Meer A.C.D.",L"Transportzone Meer a.C.DE"},
	{1,L"Trenčín",L"Trenczin"},
	{1,L"Trhová",L"Tyrchowa"},
	{1,L"Trhové",L"Tyrchowe"},
	{1,L"Tunnel",L"Tunel"},
	{1,L"Tvrdošín",L"Tvrdo-szin"},
	{1,L"Třeštice",L"Tresz-ti-ce"},
	{1,L"Třinec",L"Trzyniec"},
	{1,L"Uh. Hradiště",L"Uhelske hradiszte"},
	{1,L"Ul. Wolska",L"ulica wolska"},
	{1,L"Universität",L"Uniwersytet"},
	{1,L"Usedom",L"Uznam"},
	{1,L"Venezia",L"Wenecja"},
	{1,L"Vlt",L"Wełtawą"},
	{1,L"Vltavou", L"Wełtawą"},
	{1,L"Vysočany",L"Wysoczany"},
	{1,L"Východ",L"wschód"},
	{1,L"Wien",L"Wiedeń"},
	{1,L"Wroclaw", L"Wrocław"},
	{1,L"Zentrum" ,L"Centrum"},
	{1,L"buseck",L"busek"},
	{1,L"centre",L"centrum"},
	{1,L"děčín",L"deczin"},
	{1,L"nižná" ,L"nirzna"},
	{1,L"nižný" ,L"nirzny"},
	{1,L"süd",L"zid"},
	{1,L"südring",L"zidring"},
	{1,L"velká bíteš", L"welka bitesz"},
	{1,L"západ",L"zachód"},
	{1,L"Č. Budějovice",L"Czeskie Budziejowice"},
	{1,L"Č. Těšín",L"Czeski Cieszyn"},
	{1,L"Čadca",L"Czadca"},
	{1,L"Český Těšín",L"Czeski Cieszyn"},
	{1,L"Čs.", L"czeskej"},
	{1,L"Čs.Armády", L"czeskej armady"},
	{1,L"č. těšín",L"czeski cieszyn"},
	{1,L"česká",L"czeska"},
	{1,L"český",L"czeski"},
	{1,L"Środa Wlkp.",L"Środa wielkopolska"},
	{1,L"Środa Śl.",L"Środa śląska"},
	{1,L"Śródmieście",L"śródmieście"},
	{1,L"žel",L"żelezna"},
	{1,L"žiar N.",L"rzi-ar nad"},
	{1,L"žiar N./Hronom",L"rzi-ar nad hronom"},
	{1,L"žiar N/Hronom",L"rzi-ar nad hronom"},
	{1,L"žihla",L"żichla"},
	{1,L"žilina",L"żylina"},
--skróty nazw--
	{1,L"CZ", L"Czechy"},
	{1,L"SK", L"Słowacja"},
	{1,L"D", L"Niemcy"},
	{1,L"BY", L"Białoruś"},
	{1,L"UA", L"Ukraina"},
	{1,L"RUS", L"Rosja"},
	{1,L"LT", L"Litwa"},
	{1,L"PL", L"Polska"},
	{1,L"Os", L"Osiedle"},
	{1,L"NL", L"Holandia"},
})

transform.country_inflection_table = TRANSFORM.new({
	{1,L"Czechy", L"Republiki Czeskiej"},
	{1,L"Słowacja", L"Słowacji"},
	{1,L"Niemcy", L"Niemiec"},
	{1,L"Rosja", L"Rosji"},
	{1,L"Ukraina", L"Ukrainy"},
	{1,L"Białoruś", L"Białorusi"},
	{1,L"Litwa", L"Litwy"},
	{1,L"Polska", L"Polski"},
})
