﻿module("VOICE")

----------------------------------------------------------------------------------------------------
---------------------------|  V O I C E   T R A N S F O R M   U T I L S  |--------------------------
----------------------------------------------------------------------------------------------------

-----------------------------------------------
-- ASSERT a konyvtari transform fuggvenyekre --
-----------------------------------------------
fill_functions.fill_waypointname = function (idx) return format_waypointname(info, idx) end
wprevroadtable = {L"-1", L"-1", L"-1"}
wsameroadname = false
wprevpointtable = {L"-1", L"-1"}
waypointname = L""
local use_dativ_for_sameroad = sc_GetSysEntry("tts", "dativ_for_sameroad", 1)
local function get_full_roadname(road)
	local roadname = road.name
	local roadnumber = road.number
	local roadtext = L""
	if roadname and roadnumber then roadtext = roadname.text .. L"|" .. roadnumber.text
	elseif roadnumber then roadtext = roadnumber.text
	elseif roadname then roadtext = roadname.text end
	return roadtext
end
local function check_same_maneuvers_done(data, idx, prevroadtable)
	local same = true
	local t = {L"-1", L"-1", L"-1"}
	local roadtext = get_full_roadname(data[idx].road)
	local t_unused_manouvers = {L"^roundabout", L"^goal", L"^uturn", L"^via"}
	if transform_pattern_match(towstring(data[idx].manouver),t_unused_manouvers) then same = false
	elseif prevroadtable[1] ~= roadtext then same = false
	elseif prevroadtable[2] ~= data[idx].manouver then same = false
	elseif prevroadtable[3] ~= roadtext then same = false end
	t[1] = roadtext == L"" and L"-1" or roadtext
	if #data > idx then
		t[2] = data[idx+1].manouver
		if data[idx+1].road then
			roadtext = get_full_roadname(data[idx+1].road)
			t[3] = roadtext == L"" and L"-1" or roadtext
		end
	end
	return same, t
end
local function check_same_maneuvers(mapinfo, events)
	if events.new_manouver then
		if mapinfo[1].road then wsameroadname, wprevroadtable = check_same_maneuvers_done(mapinfo, 1, wprevroadtable)
		else wsameroadname = false wprevroadtable = {L"-1", L"-1", L"-1"} end
		local match = wsameroadname and L"same" or L"other"
		local str = table_concat(wprevroadtable, L"|")
		voice_debug_log(L"TTS: sameroadname: " .. match .. L" road'"..str..L"'", 3)
	end
end
local function check_waypoint_maneuvers(mapinfo, events)
	local t_used_manouvers = {L"^goal", L"^via"}
	if transform_pattern_match(towstring(mapinfo[1].manouver),t_used_manouvers) then
		local via_type = wstring.find(towstring(mapinfo[1].manouver), L"^via")
		if events.new_manouver or via_type and waypointname == L"" then
			local str, str_index = L"", L""
			if via_type then
				local way_points = MODEL[sc_GetSysEntry("tts", "waypoints_list", "route.list.navigated.waypoints.list")]
				for i = 0, #way_points - 1 do
					if MODEL.navigation.distance_to_destination() > (way_points[#way_points - 1].total_length() - way_points[i].total_length()) then str = way_points[i].name() str_index = towstring(#way_points - i) break end
				end
				if wprevpointtable[1] == str or wprevpointtable[2] == str_index then str = L"" end
			else
				str, str_index = MODEL.navigation.destination_name_short(), L"0"
			end
			wprevpointtable[1] = str == L"" and L"-1" or str
			wprevpointtable[2] = str_index == L"" and L"-1" or str_index
			waypointname = str
			str = (events.new_manouver and L"new" or L"old")..L" maneuver"..L"|"..str_index..L"|"..waypointname
			voice_debug_log(L"TTS: waypointname check: '"..str..L"'", 3)
		end
	else
		wprevpointtable = {L"-1", L"-1"}
		waypointname = L""
	end
end
local guidance_orig = guidance
guidance = function(mapinfo, events)
	if use_dativ_for_sameroad then check_same_maneuvers(mapinfo, events) end
	if announce_waypointname then check_waypoint_maneuvers(mapinfo, events) end
	return guidance_orig(mapinfo, events)
end
function set_announce_waypoint()
	if MODEL.EXISTS.lua.tts.announce_waypointname() then announce_waypointname = MODEL.lua["tts.announce_waypointname"]()
	else announce_waypointname = sc_GetSysEntry("tts", "announce_waypointname", 0) end
end
function set_tts_settings()
	if MODEL.EXISTS.lua.tts.numbers_mode() then numbers_mode = MODEL.lua["tts.numbers_mode"]()
	else numbers_mode = sc_GetSysEntry("tts", "numbers_mode", 1) end
	set_distances_meters()
	set_distances_ttspro_meters()
	local unit_names = {"yards","meters","feet"}
	dist_table = distances[unit_names[MODEL.regional.units() + 1]]
	if MODEL.EXISTS.lua.tts.sentence_variations() then sentence_variations = MODEL.lua["tts.sentence_variations"]()
	else sentence_variations = sc_GetSysEntry("tts", "sentence_variations", 1) end
	set_pattern_variations()
	if MODEL.EXISTS.lua.tts.roadnumber_mode() then roadnumber_mode = MODEL.lua["tts.roadnumber_mode"]()
	else roadnumber_mode = sc_GetSysEntry("tts", "roadnumber_mode", 1) end
	if MODEL.EXISTS.lua.tts.traffic_events_description() then traffic_events_description = MODEL.lua["tts.traffic_events_description"]()
	else traffic_events_description = sc_GetSysEntry("tts", "traffic_events_description", 1) end
	if MODEL.EXISTS.lua.tts.traffic_events_distance() then traffic_events_distance = MODEL.lua["tts.traffic_events_distance"]()
	else traffic_events_distance = sc_GetSysEntry("tts", "traffic_events_distance", 0) end
	set_announce_waypoint()
end
set_tts_settings()

assert(type(transform_and_format) == "function")
assert(type(transform_pattern_match) == "function")
assert(type(transform_chain) == "function")
assert(type(transform_format_roadnumber_eu) == "function")

local preposition_tbl = {L"Через",L"в Напрямку На"}

local preposition_insert_tbl = {
	{L"в ",{L"Провулок",L"Проїзд",L"Тупик"}},
	{L"на ",{L""}},
}
local preposition_insert_tbl_direction = {
	{L"по ",{L""}},
}

local main_streetnames = {L"Бульвар",L"Вулиця",L"Майдан",L"Провулок",L"Площа",L"Проспект"}
local mother_country = "_ukr"
local settlement_preposition = L"в напрямку на"
local exit_preposition = L"на з'їзд"
local replace_roadnumber_prepare = {
	{L"^ ",L""},
	{wstring.char(160),L""},
	{L"[еЕ]",L"E"},
	{L"[мМ]",L"M"},
	{L"[nHН]",L"N"},
	{L"[рPР]",L"R"},
	{L"[tтТ]",L"T"},
	{L"[аА]",L"A"},
}
VOICE["replace_roadnumber" .. mother_country] = {
	{L"(.*)",L"%1/"},
	{L"^E +38([^0-9])",L"Траса Глухів Курськ%1"},
	{L"^E +40([^0-9])",L"Траса Львів Луганськ%1"},
	{L"^E +50([^0-9])",L"Траса Ужгород Донецьк%1"},
	{L"^E +58([^0-9])",L"Траса Одеса Мелітополь%1"},
	{L"^E +81([^0-9])",L"Траса Мукачеве Берегове%1"},
	{L"^E +85([^0-9])",L"Траса Ковель Чернівці%1"},
	{L"^E +87([^0-9])",L"Траса Одеса Рені%1"},
	{L"^E +95([^0-9])",L"Траса Чернігів Одеса%1"},
	{L"^E +97([^0-9])",L"Траса Херсон Джанкой%1"},
	{L"^E +101([^0-9])",L"Траса Київ Глухів%1"},
	{L"^E +105([^0-9])",L"Траса Харків Ялта%1"},
	{L"^E +372([^0-9])",L"Траса Львів Рава-Руська%1"},
	{L"^E +373([^0-9])",L"Траса Київ Ковель%1"},
	{L"^E +471([^0-9])",L"Траса Львів Мукачеве%1"},
	{L"^E +573([^0-9])",L"Траса Ужгород Чоп%1"},
	{L"^E +577([^0-9])",L"Траса Полтава Кропивницький Кишинів%1"},
	{L"^E +581([^0-9])",L"Траса Одеса Кишинів%1"},
	{L"^E +583([^0-9])",L"Траса Вінниця Житомир%1"},
	{L"^E +584([^0-9])",L"Траса Полтава Кропивницький%1"},
	{L"^M +0?1([^0-9])",L"Траса Київ Чернігів Нові Яриловичі%1"},
	{L"^M +0?2([^0-9])",L"Траса Кіпті Глухів Бачівськ%1"},
	{L"^M +0?3([^0-9])",L"Траса Київ Харків Довжанський%1"},
	{L"^M +0?4([^0-9])",L"Траса Знам'янка Луганськ Ізварине%1"},
	{L"^M +0?5([^0-9])",L"Траса Київ Одеса%1"},
	{L"^M +0?6([^0-9])",L"Траса Київ Чоп%1"},
	{L"^M +0?7([^0-9])",L"Траса Київ Ковель Ягодин%1"},
	{L"^M +0?8([^0-9])",L"Траса Ужгород КПП%1"},
	{L"^M +0?9([^0-9])",L"Траса Львів Рава-Руська%1"},
	{L"^M +10([^0-9])",L"Траса Львів Краківець%1"},
	{L"^M +11([^0-9])",L"Траса Львів Шегині%1"},
	{L"^M +12([^0-9])",L"Траса Стрий Кропивницький Знам'янка%1"},
	{L"^M +13([^0-9])",L"Траса Кропивницький Платонове%1"},
	{L"^M +14([^0-9])",L"Траса Одеса Мелітополь Новоазовськ%1"},
	{L"^M +15([^0-9])",L"Траса Одеса Рені%1"},
	{L"^M +16([^0-9])",L"Траса Одеса Кучурган%1"},
	{L"^M +17([^0-9])",L"Траса Херсон Феодосія Керч%1"},
	{L"^M +18([^0-9])",L"Траса Харків Ялта%1"},
	{L"^M +19([^0-9])",L"Траса Ковель Чернівці Тереблече%1"},
	{L"^M +20([^0-9])",L"Траса Харків Щербаківка%1"},
	{L"^M +21([^0-9])",L"Траса Житомир Могилів-Подільський%1"},
	{L"^M +22([^0-9])",L"Траса Полтава Олександрія%1"},
	{L"^M +23([^0-9])",L"Траса Берегове Виноградів Велика Копаня%1"},
	{L"^M +24([^0-9])",L"Траса Мукачеве Берегове КПП Лужанка%1"},
	{L"^M +25([^0-9])",L"Траса КПП Соломоново Яноші%1"},
	{L"^M +26([^0-9])",L"Траса КПП Вилок КПП Дякове%1"},
	{L"^M +27([^0-9])",L"Траса Одеса Чорноморськ%1"},
	{L"^M +28([^0-9])",L"Траса Одеса Южний%1"},
	{L"^M +29([^0-9])",L"Траса Харків Красноград Перещепине%1"},
	{L"^N +0?1([^0-9])",L"Траса Київ Знам'янка%1"},
	{L"^N +0?2([^0-9])",L"Траса Львів Тернопіль%1"},
	{L"^N +0?3([^0-9])",L"Траса Житомир Чернівці%1"},
	{L"^N +0?4([^0-9])",L"Траса Одеса Чорноморськ%1"},
	{L"^N +0?5([^0-9])",L"Траса Красноперекопськ Сімферополь%1"},
	{L"^N +0?6([^0-9])",L"Траса Сімферополь Севастополь%1"},
	{L"^N +0?7([^0-9])",L"Траса Київ Суми Юнаківка%1"},
	{L"^N +0?8([^0-9])",L"Траса Бориспіль Дніпро Запоріжжя%1"},
	{L"^N +0?9([^0-9])",L"Траса Мукачеве Івано-Франківськ Львів%1"},
	{L"^N +10([^0-9])",L"Траса Стрий Івано-Франківськ Чернівці%1"},
	{L"^N +11([^0-9])",L"Траса Дніпро Миколаїв%1"},
	{L"^N +12([^0-9])",L"Траса Суми Полтава%1"},
	{L"^N +13([^0-9])",L"Траса Львів Самбір Ужгород%1"},
	{L"^N +14([^0-9])",L"Траса Олександрівка Кропивницький Миколаїв%1"},
	{L"^N +15([^0-9])",L"Траса Запоріжжя Донецьк%1"},
	{L"^N +16([^0-9])",L"Траса Золотоноша Черкаси Умань%1"},
	{L"^N +17([^0-9])",L"Траса Львів Луцьк%1"},
	{L"^N +18([^0-9])",L"Траса Івано-Франківськ Тернопіль%1"},
	{L"^N +19([^0-9])",L"Траса Ялта Севастополь%1"},
	{L"^N +20([^0-9])",L"Траса Слов'янськ Маріуполь%1"},
	{L"^N +21([^0-9])",L"Траса Старобільськ Луганськ Донецьк%1"},
	{L"^N +22([^0-9])",L"Траса Устилуг Луцьк Рівне%1"},
	{L"^N +23([^0-9])",L"Траса Кропивницький Кривий Ріг Запоріжжя%1"},
	{L"^R +0?1([^0-9])",L"Дорога Київ Обухів%1"},
	{L"^R +0?2([^0-9])",L"Дорога Київ Іванків Овруч%1"},
	{L"^R +0?3([^0-9])",L"Об'їзд Києва%1"},
	{L"^R +0?4([^0-9])",L"Дорога Київ Фастів Звенигородка%1"},
	{L"^R +0?5([^0-9])",L"Дорога Городище Рівне Старокостянтинів%1"},
	{L"^R +0?6([^0-9])",L"Дорога Улъянівка Вознесенськ Миколаїв%1"},
	{L"^R +0?7([^0-9])",L"Дорога Чугуїв Старобільськ Мілове%1"},
	{L"^R +0?8([^0-9])",L"Дорога Немирів Ямпіль%1"},
	{L"^R +0?9([^0-9])",L"Дорога Миронівка Канів Софіївка%1"},
	{L"^R +10([^0-9])",L"Дорога Канів Кременчук%1"},
	{L"^R +11([^0-9])",L"Дорога Полтава Красноград%1"},
	{L"^R +12([^0-9])",L"Дорога Чернігів Грем'яч%1"},
	{L"^R +13([^0-9])",L"Дорога Чернігів Сеньківка%1"},
	{L"^R +14([^0-9])",L"Дорога Луцьк Любешів Дольськ%1"},
	{L"^R +15([^0-9])",L"Дорога Ковель Жовква%1"},
	{L"^R +16([^0-9])",L"спецоб'єкти Криму%1"},
	{L"^R +17([^0-9])",L"Дорога Біла Церква Тетіїв Липовець%1"},
	{L"^R +18([^0-9])",L"Дорога Житомир Володарка Ставище%1"},
	{L"^R +19([^0-9])",L"Дорога Фастів Обухів Канів%1"},
	{L"^R +20([^0-9])",L"Дорога Снятин Тязів%1"},
	{L"^R +21([^0-9])",L"Дорога Долина Хуст%1"},
	{L"^R +22([^0-9])",L"Дорога Красна Талівка Луганськ%1"},
	{L"^R +23([^0-9])",L"Дорога Сімферополь Феодосія%1"},
	{L"^R +24([^0-9])",L"Дорога Татарів Косів Кам'янець-Подільський%1"},
	{L"^R +25([^0-9])",L"Дорога Сімферополь Євпаторія%1"},
	{L"^R +26([^0-9])",L"Дорога Острог Кременець Радивилів%1"},
	{L"^R +27([^0-9])",L"Дорога Севастополь Інкерман%1"},
	{L"^R +28([^0-9])",L"Дорога Виступовичі Овруч Житомир%1"},
	{L"^R +29([^0-9])",L"Дорога Алушта Феодосія%1"},
	{L"^R +30([^0-9])",L"Під'їзд Ірпінь%1"},
	{L"^R +31([^0-9])",L"Дорога Бердичів Хмільник Літин%1"},
	{L"^R +32([^0-9])",L"Дорога Кременець Біла Церква Ржищів%1"},
	{L"^R +33([^0-9])",L"Дорога Вінниця Гайсин Велика Михайлівка%1"},
	{L"^R +34([^0-9])",L"Дорога Ялта Алушта%1"},
	{L"^R +35([^0-9])",L"Дорога Грушівка Судак%1"},
	{L"^R +36([^0-9])",L"Дорога Немирів Могилів-Подільський%1"},
	{L"^R +37([^0-9])",L"Дорога Енергодар Бердянськ%1"},
	{L"^R +38([^0-9])",L"Дорога Богородчани Гута%1"},
	{L"^R +39([^0-9])",L"Дорога Броди Тернопіль%1"},
	{L"^R +40([^0-9])",L"Дорога Рава-Руська Судова Вишня%1"},
	{L"^R +41([^0-9])",L"Обхід Тернопіль%1"},
	{L"^R +42([^0-9])",L"Дорога Лубни Миргород Опішня%1"},
	{L"^R +43([^0-9])",L"Дорога Тернопіль Ланівці%1"},
	{L"^R +44([^0-9])",L"Дорога Суми Путивль Глухів%1"},
	{L"^R +45([^0-9])",L"Дорога Суми Богодухів%1"},
	{L"^R +46([^0-9])",L"Дорога Харків Охтирка%1"},
	{L"^R +47([^0-9])",L"Дорога Херсон Генічеськ%1"},
	{L"^R +48([^0-9])",L"Дорога Кам'янець-Подільський Білогір'я%1"},
	{L"^R +49([^0-9])",L"Дорога Васьковичі Шепетівка%1"},
	{L"^R +50([^0-9])",L"Дорога Ярмолинці Сатанів%1"},
	{L"^R +51([^0-9])",L"Дорога Мерефа Лозова Павлоград%1"},
	{L"^R +52([^0-9])",L"Дорога Дніпро Решетилівка%1"},
	{L"^R +53([^0-9])",L"Дорога Малий Березний КПП%1"},
	{L"^R +54([^0-9])",L"Дорога Краснопілка Теплик Бершадь Дубинове%1"},
	{L"^R +55([^0-9])",L"Дорога Одеса Вознесенськ Новий Буг%1"},
	{L"^R +56([^0-9])",L"Дорога Чернігів Чорнобиль%1"},
	{L"^R +57([^0-9])",L"Дорога Цюрупинськ Скадовськ%1"},
	{L"^R +58([^0-9])",L"Дорога Севастополь порт Камишова бухта%1"},
	{L"^R +59([^0-9])",L"спецоб'єкти Севастополь%1"},
	{L"^R +60([^0-9])",L"Дорога Кролевець Пирятин%1"},
	{L"^R +61([^0-9])",L"Дорога Батурин Суми%1"},
	{L"^R +62([^0-9])",L"Дорога Криворівня Чернівці%1"},
	{L"^R +63([^0-9])",L"Дорога Чернівці КПП Руська%1"},
	{L"^R +64([^0-9])",L"Дорога Ківшувата Тарасівка%1"},
	{L"^R +65([^0-9])",L"Дорога КПП Миколаївка КПП Катеринівка%1"},
	{L"^R +66([^0-9])",L"Дорога КПП Демино-Олександрівка Луганськ%1"},
	{L"^R +67([^0-9])",L"Дорога Чернігів Пирятин%1"},
	{L"^R +68([^0-9])",L"Дорога Талалаївка Сокирниці%1"},
	{L"^R +69([^0-9])",L"Дорога Київ Вишгород Чернігів%1"},
	{L"^R +70([^0-9])",L"Дорога Одеса Білгород-Дністровський Монаші%1"},
	{L"^R +71([^0-9])",L"Дорога Одеса Ананьїв Рижавка%1"},
	{L"^R +72([^0-9])",L"Дорога КПП Старокозаче Білгород-Дністровський%1"},
	{L"^R +73([^0-9])",L"Дорога Н08 Нікополь%1"},
	{L"^R +74([^0-9])",L"Дорога П'ятихатки Кривий Ріг Широке%1"},
	{L"^R +75([^0-9])",L"Дорога КПП Тимкове Доманівка Олександрівка%1"},
	{L"^R +76([^0-9])",L"Дорога КПП Прикладники Зарічне Дубровиця%1"},
	{L"^R +77([^0-9])",L"Дорога Рівне Тучин Гоща%1"},
	{L"^R +78([^0-9])",L"Дорога Харків Балаклія Гороховатка%1"},
	{L"^R +79([^0-9])",L"Дорога Сахновщина Куп'янськ КПП Піски%1"},
	{L"^T +0101([^0-9])",L"Обхід Сімферополя на ділянці Мирне Дубки%1"},
	{L"^T +0102([^0-9])",L"Дорога Сєверне Войкове%1"},
	{L"^T +0104([^0-9])",L"Дорога Саки Орлівка%1"},
	{L"^T +0105([^0-9])",L"Дорога Танкове Оборонне%1"},
	{L"^T +0106([^0-9])",L"Дорога Сімферополь Миколаївка%1"},
	{L"^T +0107([^0-9])",L"Дорога Чорноморське Воїнка%1"},
	{L"^T +0108([^0-9])",L"Дорога Чорноморське Євпаторія%1"},
	{L"^T +0110([^0-9])",L"Дорога Красногвардійське Нижньогірський%1"},
	{L"^T +0111([^0-9])",L"Дорога Роздольне Євпаторія%1"},
	{L"^T +0112([^0-9])",L"Дорога Нижньогірський Білогірськ%1"},
	{L"^T +0113([^0-9])",L"Дорога Кіровське Первомайське%1"},
	{L"^T +0114([^0-9])",L"Дорога Леніне М17%1"},
	{L"^T +0116([^0-9])",L"Дорога Новопавлівка Научний%1"},
	{L"^T +0117([^0-9])",L"Дорога Бахчисарай Ялта%1"},
	{L"^T +0202([^0-9])",L"Дорога Могилів-Подільський Ямпіль Умань%1"},
	{L"^T +0203([^0-9])",L"Дорога Турбів Погребище Сквира%1"},
	{L"^T +0204([^0-9])",L"Дорога Південний обхід Вінниці%1"},
	{L"^T +0205([^0-9])",L"Дорога М12 Куна Кунка Р33%1"},
	{L"^T +0207([^0-9])",L"Дорога Джулинка Гайворон Ульяновка М5%1"},
	{L"^T +0211([^0-9])",L"Дорога Вербовець Новодністровськ Р63%1"},
	{L"^T +0212([^0-9])",L"Дорога Вінниця Шпиків Комаргород%1"},
	{L"^T +0214([^0-9])",L"Дорога М12 Біликівці%1"},
	{L"^T +0215([^0-9])",L"Дорога Ямпіль Велика Кісниця%1"},
	{L"^T +0216([^0-9])",L"Дорога Вінниця Гнівань Тиврів%1"},
	{L"^T +0217([^0-9])",L"Дорога Муровані Курилівці Горай%1"},
	{L"^T +0218([^0-9])",L"Дорога Лука-Барська Жмеринка Ямпіль%1"},
	{L"^T +0219([^0-9])",L"Дорога Стара Гута Калинівка Турбів%1"},
	{L"^T +0220([^0-9])",L"Дорога Вендичани Чернівці Томашпіль%1"},
	{L"^T +0221([^0-9])",L"Дорога Немирів Іллінці%1"},
	{L"^T +0222([^0-9])",L"Дорога Шпиків Тульчин Бершадь%1"},
	{L"^T +0225([^0-9])",L"Дорога КПП Болган Піщанка Чечельник%1"},
	{L"^T +0226([^0-9])",L"Дорога Гайсин Теплик%1"},
	{L"^T +0227([^0-9])",L"Дорога Білопілля Вівсяники%1"},
	{L"^T +0229([^0-9])",L"Дорога Бар Шаргород Чапаєве%1"},
	{L"^T +0230([^0-9])",L"Дорога Тиврів Шаргород%1"},
	{L"^T +0231([^0-9])",L"Під'їзд до аеропорту Вінниця 2%1"},
	{L"^T +0233([^0-9])",L"Дорога Вапнярка Крижопіль КПП Загнитків%1"},
	{L"^T +0236([^0-9])",L"Дорога Липовець Спичинці Погребище%1"},
	{L"^T +0240([^0-9])",L"Дорога Р8 переправа%1"},
	{L"^T +0301([^0-9])",L"Дорога Залісся Піща Козин%1"},
	{L"^T +0302([^0-9])",L"Дорога Піща Володимир-Волинський Козин М6%1"},
	{L"^T +0303([^0-9])",L"Дорога Луцьк Радомишль Дубно%1"},
	{L"^T +0304([^0-9])",L"Дорога Доманове Залухів Невір Ветли%1"},
	{L"^T +0305([^0-9])",L"Дорога Нововолинськ Павлівка Локачі%1"},
	{L"^T +0306([^0-9])",L"Дорога Т302 Шацьк Прип'ять Любохини%1"},
	{L"^T +0307([^0-9])",L"Дорога КПП Пулемець КПП Піща%1"},
	{L"^T +0308([^0-9])",L"Дорога Любомль Камінь-Каширський Любешів%1"},
	{L"^T +0309([^0-9])",L"Дорога Дубечне Турійськ Ківерці Піддубці%1"},
	{L"^T +0310([^0-9])",L"Дорога Стара Вижівка Буцин%1"},
	{L"^T +0311([^0-9])",L"Дорога Седлище Ковель Колодяжне Локачі%1"},
	{L"^T +0312([^0-9])",L"Дорога Журавичі Берестяне Цумань%1"},
	{L"^T +0401([^0-9])",L"Дорога Дніпро Васильківка Покровське Мелітополь%1"},
	{L"^T +0402([^0-9])",L"Дорога Ігрень Олександрівка%1"},
	{L"^T +0403([^0-9])",L"Дорога Мар'янське Берислав%1"},
	{L"^T +0404([^0-9])",L"Дорога Дніпро Кіровське%1"},
	{L"^T +0405([^0-9])",L"Дорога Дніпро Хутірське%1"},
	{L"^T +0406([^0-9])",L"Дорога Григорівка Межова Красноармійськ%1"},
	{L"^T +0408([^0-9])",L"Дорога Павлоград Новомиколаївка Токмак%1"},
	{L"^T +0410([^0-9])",L"Дорога Дніпро Магдалинівка Котовка%1"},
	{L"^T +0411([^0-9])",L"Дорога Широке Олександрівка Запоріжжя%1"},
	{L"^T +0412([^0-9])",L"Дорога Кам'янське Перещепине Жемчужне%1"},
	{L"^T +0413([^0-9])",L"Дорога Царичанка Магдалинівка Губиниха%1"},
	{L"^T +0414([^0-9])",L"Дорога Кам'янське Петриківка Магдалинівка%1"},
	{L"^T +0415([^0-9])",L"Дорога Верхньодніпровськ Вільногірськ%1"},
	{L"^T +0416([^0-9])",L"Дорога Павлоград Синельникове%1"},
	{L"^T +0417([^0-9])",L"Дорога Кам'янське Миколаївка Солоне%1"},
	{L"^T +0419([^0-9])",L"Дорога П'ятихатки Апостолове Зеленодольськ%1"},
	{L"^T +0420([^0-9])",L"Дорога Одарівка Томаківка Вищетарасівка%1"},
	{L"^T +0421([^0-9])",L"Дорога Дніпро Новомиколаївка%1"},
	{L"^T +0422([^0-9])",L"Дорога Павлоград Надеждівка Голубівка%1"},
	{L"^T +0423([^0-9])",L"Дорога Мишурин Ріг Вільногірськ%1"},
	{L"^T +0424([^0-9])",L"Дорога Веселе Олександропіль Петропавлівка%1"},
	{L"^T +0425([^0-9])",L"Дорога Підпільне Дерезувате Синельникове%1"},
	{L"^T +0426([^0-9])",L"Дорога М4 Козачий Гай%1"},
	{L"^T +0427([^0-9])",L"Дорога Дмитрівка Зелений Гай Гаврилівка%1"},
	{L"^T +0428([^0-9])",L"Дорога Слов'янка Межова Дачне%1"},
	{L"^T +0429([^0-9])",L"Дорога Станція Верхньодніпровськ Щорськ%1"},
	{L"^T +0430([^0-9])",L"Дорога Кам'янське Світлогірське%1"},
	{L"^T +0431([^0-9])",L"Дорога Першотравенськ Володимирівка Солоне%1"},
	{L"^T +0432([^0-9])",L"Дорога Щорськ Малософіївка Нікополь%1"},
	{L"^T +0433([^0-9])",L"Дорога Щорськ Болтишка Малософіївка%1"},
	{L"^T +0434([^0-9])",L"Дорога Ордо-Василівка Сергіївка Веселі Терни%1"},
	{L"^T +0435([^0-9])",L"Дорога Новоіванівка Марганець Вищетарасівка%1"},
	{L"^T +0436([^0-9])",L"Дорога Покровське Капулівка%1"},
	{L"^T +0437([^0-9])",L"Дорога Верхньодніпровськ Н8%1"},
	{L"^T +0439([^0-9])",L"Дорога Кринички М4%1"},
	{L"^T +0441([^0-9])",L"Дорога Дніпро Кобеляки Решетилівка%1"},
	{L"^T +0442([^0-9])",L"Під'їзд Інгулець%1"},
	{L"^T +0443([^0-9])",L"Дорога Сергіївка Н23%1"},
	{L"^T +0444([^0-9])",L"Дорога Новомиколаївка Ленінське Сурсько-Михайлівка%1"},
	{L"^T +0445([^0-9])",L"Дорога Синельникове Славгород Вільнянськ%1"},
	{L"^T +0446([^0-9])",L"Дорога Верхньодніпровськ Лихівка%1"},
	{L"^T +0447([^0-9])",L"Дорога Широке Шестірня Заградівка%1"},
	{L"^T +0504([^0-9])",L"Дорога Красноармійськ Артемівськ Михайлівка%1"},
	{L"^T +0505([^0-9])",L"Дорога Авдіївка Донецьк%1"},
	{L"^T +0507([^0-9])",L"Дорога Донецьк Амвросіївка КПП Успенка%1"},
	{L"^T +0508([^0-9])",L"Дорога Донецьк Новоазовськ Сєдове%1"},
	{L"^T +0509([^0-9])",L"Дорога Велика Новосілка Амвросіївка%1"},
	{L"^T +0510([^0-9])",L"Дорога Сніжне Маринівка%1"},
	{L"^T +0511([^0-9])",L"Дорога Єнакієве Харцизьк%1"},
	{L"^T +0512([^0-9])",L"Дорога Волноваха Тельманове%1"},
	{L"^T +0513([^0-9])",L"Дорога Красний Лиман Артемівськ Горлівка%1"},
	{L"^T +0514([^0-9])",L"Дорога Добропілля Красний Лиман%1"},
	{L"^T +0515([^0-9])",L"Дорога Олександрівка Красноармійськ Костянтинопіль%1"},
	{L"^T +0516([^0-9])",L"Дорога Костянтинівка Дзержинськ%1"},
	{L"^T +0517([^0-9])",L"Дорога Єнакієве Шахтарськ Амвросіївка%1"},
	{L"^T +0518([^0-9])",L"Дорога Богатир Велика Новосілка Володарське%1"},
	{L"^T +0519([^0-9])",L"Дорога Амвросіївка Тельманове Маріуполь%1"},
	{L"^T +0520([^0-9])",L"Дорога М4 Горлівка%1"},
	{L"^T +0521([^0-9])",L"Дорога М3 під'їзд Святогірськ%1"},
	{L"^T +0522([^0-9])",L"Дорога Н21 під'їзд Савур Могила%1"},
	{L"^T +0523([^0-9])",L"Дорога Н20 Кременівка Ялта%1"},
	{L"^T +0601([^0-9])",L"Дорога Баранівка Висока Піч%1"},
	{L"^T +0602([^0-9])",L"Дорога М6 Коростишів%1"},
	{L"^T +0603([^0-9])",L"Дорога М6 Червоноармійськ Володарськ-Волинський%1"},
	{L"^T +0604([^0-9])",L"Дорога Коростень Народичі%1"},
	{L"^T +0605([^0-9])",L"Дорога КПП Майдан Олевськ Ємільчине%1"},
	{L"^T +0606([^0-9])",L"Дорога Бердичів Погребище Іллінці%1"},
	{L"^T +0607([^0-9])",L"Дорога Овруч Народичі%1"},
	{L"^T +0608([^0-9])",L"Дорога Малин Кочерів%1"},
	{L"^T +0609([^0-9])",L"Дорога Р18 Андрушівка%1"},
	{L"^T +0610([^0-9])",L"Дорога Любар Луко-Барська Нова Ушиця%1"},
	{L"^T +0611([^0-9])",L"Дорога Ставище Брусилів Попільня%1"},
	{L"^T +0612([^0-9])",L"Дорога Новоград-Волинський Полонне Старокостянтинів%1"},
	{L"^T +0613([^0-9])",L"Дорога Коростень М7 через Кожухівку%1"},
	{L"^T +0614([^0-9])",L"Дорога Глибочиця Станишівка через Калинівку  Клітчин%1"},
	{L"^T +0615([^0-9])",L"Дорога М7 Лугини%1"},
	{L"^T +0618([^0-9])",L"Дорога Залужне Романів%1"},
	{L"^T +0619([^0-9])",L"Дорога Овруцьке напівкільце%1"},
	{L"^T +0710([^0-9])",L"Дорога Велика Добронь Мукачеве%1"},
	{L"^T +0712([^0-9])",L"Дорога Перечин Свалява%1"},
	{L"^T +0714([^0-9])",L"Дорога Шом Горонглаб КПП Дзвінкове%1"},
	{L"^T +0718([^0-9])",L"Дорога Нижні Ворота Воловець Міжгір'я%1"},
	{L"^T +0719([^0-9])",L"Дорога Іршава Виноградів%1"},
	{L"^T +0720([^0-9])",L"Дорога Міжгір'я Синевир%1"},
	{L"^T +0724([^0-9])",L"Дорога Синевир Синевирська Поляна%1"},
	{L"^T +0737([^0-9])",L"Дорога Хуст Вишково Буштино з під'їздом до санаторію Шаян%1"},
	{L"^T +0741([^0-9])",L"Дорога М6 Голубине%1"},
	{L"^T +0803([^0-9])",L"Дорога Запоріжжя Маріуполь%1"},
	{L"^T +0804([^0-9])",L"Дорога Кам'янка-Дніпровська Велика Лепетиха Каховка%1"},
	{L"^T +0805([^0-9])",L"Дорога Кам'янка-Дніпровська Велика Білозерка Веселе%1"},
	{L"^T +0810([^0-9])",L"Дорога Велика Білозерка Михайлівка%1"},
	{L"^T +0811([^0-9])",L"Дорога Веселе М18%1"},
	{L"^T +0812([^0-9])",L"Дорога М18 Лугове Оріхів%1"},
	{L"^T +0813([^0-9])",L"Дорога Токмак Чернігівка%1"},
	{L"^T +0814([^0-9])",L"Дорога T408 Омельник Гуляйполе%1"},
	{L"^T +0815([^0-9])",L"Дорога Оріхів Пологи%1"},
	{L"^T +0817([^0-9])",L"Дорога Р37 Веселе%1"},
	{L"^T +0818([^0-9])",L"Дорога Василівка Михайлівка%1"},
	{L"^T +0819([^0-9])",L"Дорога Куйбишеве М14%1"},
	{L"^T +0820([^0-9])",L"Дорога Якимівка Кирилівка%1"},
	{L"^T +0821([^0-9])",L"Дорога Р37 Приморськ%1"},
	{L"^T +0903([^0-9])",L"Дорога Галич Підгайці Сатанів%1"},
	{L"^T +0905([^0-9])",L"Дорога Делятин Раківчик%1"},
	{L"^T +0906([^0-9])",L"Дорога івано-Франківськ Надвірна%1"},
	{L"^T +0909([^0-9])",L"Дорога Снятин Косів Старі Кути%1"},
	{L"^T +0910([^0-9])",L"Дорога Бурштин Калуш%1"},
	{L"^T +1001([^0-9])",L"Дорога Ворзель Забуччя М6%1"},
	{L"^T +1002([^0-9])",L"Дорога Демидів Гостомель%1"},
	{L"^T +1004([^0-9])",L"Дорога Рудня Гоголів Бориспіль%1"},
	{L"^T +1006([^0-9])",L"Дорога Глеваха Підгірці%1"},
	{L"^T +1008([^0-9])",L"Дорога Київ Літочки Кіпті%1"},
	{L"^T +1009([^0-9])",L"Дорога Узин М5%1"},
	{L"^T +1010([^0-9])",L"Дорога Рокитне Узин%1"},
	{L"^T +1011([^0-9])",L"Дорога Гостомель Берестянка Мирча%1"},
	{L"^T +1012([^0-9])",L"Дорога Київ Боярка%1"},
	{L"^T +1013([^0-9])",L"Дорога Фастів Фурси Володарка%1"},
	{L"^T +1014([^0-9])",L"Дорога Тетіїв П'ятигори М5%1"},
	{L"^T +1016([^0-9])",L"Дорога Київ Ревне Рогозів%1"},
	{L"^T +1017([^0-9])",L"Дорога Миронівка Рокитне Плоске%1"},
	{L"^T +1018([^0-9])",L"Дорога Бориспіль Березань Яготин%1"},
	{L"^T +1019([^0-9])",L"Дорога Феневичі Бородянка Бишів%1"},
	{L"^T +1021([^0-9])",L"Дорога Телешівка Ольшаниця Ставище%1"},
	{L"^T +1022([^0-9])",L"Дорога Миронівка Богуслав Р4%1"},
	{L"^T +1023([^0-9])",L"Дорога Васильків Глеваха%1"},
	{L"^T +1024([^0-9])",L"Дорога Згурівка Березань М3%1"},
	{L"^T +1025([^0-9])",L"Дорога Баришівка М3 Переяслав-Хмельницький%1"},
	{L"^T +1027([^0-9])",L"Дорога Київське півкільце%1"},
	{L"^T +1032([^0-9])",L"Дорога Переяслав-Хмельницький М3%1"},
	{L"^T +1033([^0-9])",L"Дорога Узин Германівка Трипілля%1"},
	{L"^T +1034([^0-9])",L"Дорога М1 Крехаїв з під'їздом до Літки%1"},
	{L"^T +1035([^0-9])",L"Дорога станція Вільча КПП Вільча Олександрівка%1"},
	{L"^T +1037([^0-9])",L"Дорога Іванків Городище%1"},
	{L"^T +1038([^0-9])",L"Дорога Васильків Княжичі Гореничі%1"},
	{L"^T +1039([^0-9])",L"Дорога Гостомельське шосе проспект Маршала Рокосовського%1"},
	{L"^T +1201([^0-9])",L"Дорога Кіровоград Каніж Новомиргород%1"},
	{L"^T +1202([^0-9])",L"Дорога М12 заповідник Хутір Надія М13%1"},
	{L"^T +1203([^0-9])",L"Дорога Павлиш Онуфріївка Млинок%1"},
	{L"^T +1204([^0-9])",L"Дорога Долинська Новошевченкове Н23%1"},
	{L"^T +1205([^0-9])",L"Дорога Кіровоград Нова Прага Олександрія%1"},
	{L"^T +1206([^0-9])",L"Дорога Новоархангельськ Петроострів Новомиргород%1"},
	{L"^T +1208([^0-9])",L"Дорога Пушкове Вільшанка Добровеличківка%1"},
	{L"^T +1209([^0-9])",L"Дорога Новомиргород Олександрівка%1"},
	{L"^T +1210([^0-9])",L"Дорога Устинівка Петрове Жовті Води%1"},
	{L"^T +1211([^0-9])",L"Дорога Знам'янка Подорожнє%1"},
	{L"^T +1212([^0-9])",L"Дорога Новомиргород Велика Виска%1"},
	{L"^T +1214([^0-9])",L"Дорога Новоархангельськ Добровеличківка Миколаївка%1"},
	{L"^T +1215([^0-9])",L"Дорога Глинськ Олександрія Петрове%1"},
	{L"^T +1216([^0-9])",L"Дорога Компаніївка Устинівка%1"},
	{L"^T +1217([^0-9])",L"Дорога Олександрівка Бурякове Р10%1"},
	{L"^T +1218([^0-9])",L"Дорога Новгородка станція Шарівка Нова Прага%1"},
	{L"^T +1220([^0-9])",L"Дорога Знам'янка Подорожнє М04%1"},
	{L"^T +1221([^0-9])",L"Дорога Кіровоград Рівне%1"},
	{L"^T +1222([^0-9])",L"Дорога Новоукраїнка під'їзд до санаторію Гусарське Урочище%1"},
	{L"^T +1223([^0-9])",L"Дорога Івангород Розумівка Кримки%1"},
	{L"^T +1301([^0-9])",L"Дорога Луганськ Георгіївка з під'їздом до аеропорту Луганськ%1"},
	{L"^T +1302([^0-9])",L"Дорога КПП Танюшівка Старобільськ Артемівськ%1"},
	{L"^T +1303([^0-9])",L"Дорога Успенка Антрацит%1"},
	{L"^T +1305([^0-9])",L"Дорога Свердловськ Бірюкове М3%1"},
	{L"^T +1306([^0-9])",L"Дорога Сєвєродонецьк Новоайдар%1"},
	{L"^T +1307([^0-9])",L"Дорога Сватове Новопсков Мілове%1"},
	{L"^T +1308([^0-9])",L"Дорога Старобільськ Марківка%1"},
	{L"^T +1309([^0-9])",L"Дорога Щастя Широкий%1"},
	{L"^T +1310([^0-9])",L"Дорога Лутугине Краснодон%1"},
	{L"^T +1311([^0-9])",L"Дорога Свердловськ КПП Червонопартизанськ%1"},
	{L"^T +1312([^0-9])",L"Дорога Краснодон Антрацит%1"},
	{L"^T +1313([^0-9])",L"Дорога Троїцьке Білокуракине Старобільськ%1"},
	{L"^T +1314([^0-9])",L"Дорога КПП Просяне Біловодськ Широкий%1"},
	{L"^T +1315([^0-9])",L"Дорога Райгородка Слов'яносербськ Михайлівка%1"},
	{L"^T +1316([^0-9])",L"Під'їзд до Первомайська%1"},
	{L"^T +1317([^0-9])",L"Під'їзд до Кіровська%1"},
	{L"^T +1318([^0-9])",L"Дорога Біле Лутугине%1"},
	{L"^T +1319([^0-9])",L"Дорога Перевальськ Іванівка%1"},
	{L"^T +1320([^0-9])",L"Дорога Георгіївка Ровеньки М3%1"},
	{L"^T +1321([^0-9])",L"Дорога Білолуцьк КПП Новобіла%1"},
	{L"^T +1401([^0-9])",L"Дорога КПП Смільниця Старий Самбір%1"},
	{L"^T +1402([^0-9])",L"Дорога Східниця Пісочна%1"},
	{L"^T +1403([^0-9])",L"Дорога Грушів Немирів%1"},
	{L"^T +1404([^0-9])",L"Дорога Червоноград Рава-Руська%1"},
	{L"^T +1408([^0-9])",L"Дорога Угринів Хоробрів%1"},
	{L"^T +1410([^0-9])",L"Дорога Броди Червоноград%1"},
	{L"^T +1414([^0-9])",L"Північний обхід Львіва%1"},
	{L"^T +1415([^0-9])",L"Дорога Мостиська Самбір Борислав%1"},
	{L"^T +1416([^0-9])",L"Дорога Львів Пустомити Мединичі%1"},
	{L"^T +1417([^0-9])",L"Дорога Куровичі Рогатин%1"},
	{L"^T +1418([^0-9])",L"Дорога Нижанковичі Дрогобич Стрий%1"},
	{L"^T +1419([^0-9])",L"Дорога Миколаїв Жидачів Калуш%1"},
	{L"^T +1424([^0-9])",L"Дорога Сколе Славське%1"},
	{L"^T +1425([^0-9])",L"Дорога Миколаїв Жовква Кам'янка-Бузька%1"},
	{L"^T +1503([^0-9])",L"Обхід Нової Одеси%1"},
	{L"^T +1504([^0-9])",L"Дорога Первомайськ Новоукраїнка%1"},
	{L"^T +1505([^0-9])",L"Дорога Снігурівка Антонівка Р47%1"},
	{L"^T +1506([^0-9])",L"Дорога Миколаїв Доманівка Берізки%1"},
	{L"^T +1507([^0-9])",L"Дорога Миколаїв Парутине Очаків%1"},
	{L"^T +1508([^0-9])",L"Дорога Калинівка Снігурівка Березнегувате%1"},
	{L"^T +1509([^0-9])",L"Дорога Баштанка Березнегувате%1"},
	{L"^T +1510([^0-9])",L"Дорога Р6 Арбузинка Нова Одеса%1"},
	{L"^T +1511([^0-9])",L"Дорога Братське Вознесенськ%1"},
	{L"^T +1512([^0-9])",L"Дорога Казанка Березнегувате%1"},
	{L"^T +1513([^0-9])",L"Дорога Нечаяне Очаків%1"},
	{L"^T +1514([^0-9])",L"Під'їзд до смт Березанка%1"},
	{L"^T +1515([^0-9])",L"Дорога Федорівка Рибаківка база відпочинку Лугове%1"},
	{L"^T +1517([^0-9])",L"Під'їзд до Снігурівки%1"},
	{L"^T +1518([^0-9])",L"Дорога Велика Корениха Кам'янка%1"},
	{L"^T +1519([^0-9])",L"Дорога Очаків база відпочинку Чорноморка%1"},
	{L"^T +1520([^0-9])",L"Дорога Федорівка зони відпочинку Лугове Рибаківка%1"},
	{L"^T +1606([^0-9])",L"Дорога КПП Виноградівка Болград М15%1"},
	{L"^T +1607([^0-9])",L"Дорога Ізмаїл Кілія Вилкове%1"},
	{L"^T +1608([^0-9])",L"Дорога Болград Арциз Сарата%1"},
	{L"^T +1610([^0-9])",L"Дорога Приморське Татарбунари з підїздом до Сергіївка%1"},
	{L"^T +1611([^0-9])",L"Дорога КПП Олексіївка Кодима Балта%1"},
	{L"^T +1612([^0-9])",L"Дорога КПП Федосіївка Котовськ Ананьїв%1"},
	{L"^T +1613([^0-9])",L"Дорога Миколаївка Шабельники М5%1"},
	{L"^T +1614([^0-9])",L"Дорога КПП Йосипівка Ширяєве М5%1"},
	{L"^T +1615([^0-9])",L"Дорога КПП Великоплоске Новопетрівка Веселий Кут%1"},
	{L"^T +1616([^0-9])",L"Дорога КПП Гребеники Червонознам'янка Березівка%1"},
	{L"^T +1617([^0-9])",L"Дорога М5 Іванівка Петрівка Р55%1"},
	{L"^T +1618([^0-9])",L"Дорога Р33 Роздільна Єреміївка М5%1"},
	{L"^T +1619([^0-9])",L"Дорога Біляївка станція Вигода Роздільна%1"},
	{L"^T +1620([^0-9])",L"Дорога М15 Доброолександрівка Великодолинське М27%1"},
	{L"^T +1621([^0-9])",L"Дорога Саврань Любашівка М5%1"},
	{L"^T +1622([^0-9])",L"Дорога Кодима Слобідка Котовськ%1"},
	{L"^T +1623([^0-9])",L"Дорога Ананьїв Березівка Вікторівка%1"},
	{L"^T +1624([^0-9])",L"Дорога КПП Станіславка Чорна М13 Новосамарка%1"},
	{L"^T +1625([^0-9])",L"Дорога КПП Кучурган Біляївка Маяки Овідіополь%1"},
	{L"^T +1627([^0-9])",L"Дорога КПП Серпневе Тарутине Арциз Татарбунари%1"},
	{L"^T +1628([^0-9])",L"Дорога М15 Спаське Вилкове%1"},
	{L"^T +1629([^0-9])",L"Дорога КПП Табаки Виноградівка Нагірне Орлівка%1"},
	{L"^T +1630([^0-9])",L"Дорога Струмок Шевченкове Кілія%1"},
	{L"^T +1631([^0-9])",L"Дорога Болград М15%1"},
	{L"^T +1632([^0-9])",L"Дорога КПП Нові Трояни Червоноармійське Кам'янка М15%1"},
	{L"^T +1633([^0-9])",L"Дорога Ананьїв Байтали Білине%1"},
	{L"^T +1634([^0-9])",L"Дорога Велика Михайлівка Слов'яносербка кордон Молдови%1"},
	{L"^T +1635([^0-9])",L"Дорога Р55 Комінтернівське М5%1"},
	{L"^T +1636([^0-9])",L"Дорога Комінтернівське Дмитрівка Сичавка%1"},
	{L"^T +1637([^0-9])",L"Дорога Котовськ Долинське Мар'янівка%1"},
	{L"^T +1638([^0-9])",L"Дорога КПП Станіславка Мурована%1"},
	{L"^T +1639([^0-9])",L"Дорога Станція Чубівка М13 станція Мардарівка%1"},
	{L"^T +1640([^0-9])",L"Дорога Миколаївка Андрієво-Іванівка Настасіївка%1"},
	{L"^T +1641([^0-9])",L"Дорога Овідіополь Дальник Санжейка%1"},
	{L"^T +1642([^0-9])",L"Дорога М15 КПП Долинське%1"},
	{L"^T +1643([^0-9])",L"Дорога Кордон Молдови Фараонівка Сарата Дивізія%1"},
	{L"^T +1644([^0-9])",L"Дорога КПП Лісне КПП Малоярославець Перший%1"},
	{L"^T +1645([^0-9])",L"Дорога Виноградівка Новоіванівка М15%1"},
	{L"^T +1646([^0-9])",L"Дорога Фрунзівка станція Мардарівка Шимкове%1"},
	{L"^T +1647([^0-9])",L"Дорога Кароліно-Бугаз Грибівка Санжійка%1"},
	{L"^T +1701([^0-9])",L"Дорога Гребінка Кулажинці М3%1"},
	{L"^T +1702([^0-9])",L"Дорога Н12 Краснокутськ Богодухів%1"},
	{L"^T +1703([^0-9])",L"Дорога Н8 Недогарки Світловодськ%1"},
	{L"^T +1705([^0-9])",L"Дорога Лохвиця Охтирка КПП Велика Писарівка%1"},
	{L"^T +1706([^0-9])",L"Дорога Гадяч Опішня%1"},
	{L"^T +1707([^0-9])",L"Дорога Мала Рублівка Полтава%1"},
	{L"^T +1709([^0-9])",L"Дорога Оржиця Хорол%1"},
	{L"^T +1710([^0-9])",L"Дорога Пирятин Гребінка%1"},
	{L"^T +1711([^0-9])",L"Дорога Соснівка Кременчук Комсомольськ%1"},
	{L"^T +1712([^0-9])",L"Дорога М3 Машівка Карлівка%1"},
	{L"^T +1713([^0-9])",L"Об'їзна дорога Лохвиці%1"},
	{L"^T +1714([^0-9])",L"Дорога Чорнухи Лубни%1"},
	{L"^T +1715([^0-9])",L"Дорога Миргород Хорол%1"},
	{L"^T +1716([^0-9])",L"Дорога Хорол Кременчук%1"},
	{L"^T +1717([^0-9])",L"Дорога Мостовівщина Великі Кринки Глобине%1"},
	{L"^T +1718([^0-9])",L"Дорога Диканька Решетилівка%1"},
	{L"^T +1719([^0-9])",L"Дорога Миргород Байрак Поділ%1"},
	{L"^T +1720([^0-9])",L"Дорога Р42 Шишаки Поділ%1"},
	{L"^T +1721([^0-9])",L"Дорога Бугаївка Фрунзівка Козельщина%1"},
	{L"^T +1722([^0-9])",L"Дорога Гребінка Оржиця%1"},
	{L"^T +1723([^0-9])",L"Дорога Лохвиця Вирішальне Лубни%1"},
	{L"^T +1724([^0-9])",L"Дорога Вирішальне Залізняки Комишня%1"},
	{L"^T +1725([^0-9])",L"Дорога Гадяч Миргород%1"},
	{L"^T +1726([^0-9])",L"Дорога Рашівка Савинці Великі Сорочинці%1"},
	{L"^T +1727([^0-9])",L"Дорога Велика Багачка Великі Сорочинці Зіньків%1"},
	{L"^T +1728([^0-9])",L"Дорога Зіньків Т1705%1"},
	{L"^T +1729([^0-9])",L"Об'їзна дорога Котельва%1"},
	{L"^T +1730([^0-9])",L"Дорога Велика Рублівка Чутове%1"},
	{L"^T +1731([^0-9])",L"Дорога М3 Максимівка Карлівка%1"},
	{L"^T +1732([^0-9])",L"Дорога Руновщина Черкасівка М3%1"},
	{L"^T +1733([^0-9])",L"Дорога Шишаки Балясне%1"},
	{L"^T +1734([^0-9])",L"Дорога Решетилівка Нові Санжари Нехвороща%1"},
	{L"^T +1735([^0-9])",L"Дорога Кобеляки Нехвороща Машівка%1"},
	{L"^T +1736([^0-9])",L"Дорога Фрунзівка Дмитрівка Комсомольськ%1"},
	{L"^T +1737([^0-9])",L"Дорога Бочки Новий Байрак Петрівка%1"},
	{L"^T +1801([^0-9])",L"Дорога Рівне Здолбунів Дубно%1"},
	{L"^T +1802([^0-9])",L"Дорога Маюничі Копилля Торчин Шклинь%1"},
	{L"^T +1804([^0-9])",L"Дорога Корець Славута Антоніни%1"},
	{L"^T +1806([^0-9])",L"Дорога Рівне Берестечко Перемишляни%1"},
	{L"^T +1808([^0-9])",L"Дорога Зарічне Борове Полиці%1"},
	{L"^T +1809([^0-9])",L"Дорога Переброди Володимирець Суховоля%1"},
	{L"^T +1810([^0-9])",L"Дорога Дубровиця Любиковичі Сарни%1"},
	{L"^T +1811([^0-9])",L"Дорога Клесів Михалин Березне%1"},
	{L"^T +1812([^0-9])",L"Дорога Немовичі Великі Межирічі Федорівка%1"},
	{L"^T +1813([^0-9])",L"Дорога Демидівка Велика Городниця на Олику%1"},
	{L"^T +1814([^0-9])",L"Дорога Рокитне М7%1"},
	{L"^T +1815([^0-9])",L"Дорога Дубно Млинів Т1813%1"},
	{L"^T +1816([^0-9])",L"Східний під'їзд до Радивилова%1"},
	{L"^T +1817([^0-9])",L"Дорога Бережниця Степань Клевань%1"},
	{L"^T +1818([^0-9])",L"Дорога Будки-Кам'янські Рокитне Клесів%1"},
	{L"^T +1819([^0-9])",L"Дорога Соснове Маринин%1"},
	{L"^T +1820([^0-9])",L"Дорога Кунин Зелений Дуб%1"},
	{L"^T +1821([^0-9])",L"Дорога Верба Онишківці%1"},
	{L"^T +1822([^0-9])",L"Дорога Онишківці Стара Миколаївка%1"},
	{L"^T +1823([^0-9])",L"Дорога Удрицьк Жадень%1"},
	{L"^T +1824([^0-9])",L"Дорога Дерманка Корець М6%1"},
	{L"^T +1825([^0-9])",L"Дорога Дермань Перша Дермань Друга%1"},
	{L"^T +1826([^0-9])",L"Дорога Степань Р5%1"},
	{L"^T +1827([^0-9])",L"Дорога Костопіль Яполоть%1"},
	{L"^T +1828([^0-9])",L"Дорога Корчів'я Іваничі Берестовець%1"},
	{L"^T +1829([^0-9])",L"Дорога Вежиця Рокитне Борове%1"},
	{L"^T +1830([^0-9])",L"Дорога Рівне Тайкури Оженин%1"},
	{L"^T +1831([^0-9])",L"Дорога Бугрин Оженин Острог%1"},
	{L"^T +1832([^0-9])",L"Дорога Ходоси Кустин%1"},
	{L"^T +1833([^0-9])",L"Дорога Познань Т1829%1"},
	{L"^T +1901([^0-9])",L"Дорога Суми Миропілля Осоївка%1"},
	{L"^T +1904([^0-9])",L"Дорога Білопілля Липова Долина Гадяч%1"},
	{L"^T +1906([^0-9])",L"Дорога КПП Рижівка Білопілля Лантратівка%1"},
	{L"^T +1907([^0-9])",L"Дорога Шостка Кролевець%1"},
	{L"^T +1908([^0-9])",L"Дорога Шостка Зноб-Новгородське Середина-Буда%1"},
	{L"^T +1909([^0-9])",L"Дорога Суми Лебедин%1"},
	{L"^T +1910([^0-9])",L"Дорога Конотоп Буринь Чумакове%1"},
	{L"^T +1911([^0-9])",L"Дорога Мутин Путивль%1"},
	{L"^T +1912([^0-9])",L"Дорога Шостка Ямпіль%1"},
	{L"^T +1913([^0-9])",L"Дорога Ромни Тростянець Мезенівка%1"},
	{L"^T +1914([^0-9])",L"Дорога Хмелів Чернеча Слобода Буринь%1"},
	{L"^T +1915([^0-9])",L"Дорога КПП Середина-Буда Ямпіль Береза з під'їздом до Дружби%1"},
	{L"^T +1916([^0-9])",L"Дорога Ромни Бубни на Талалаївку%1"},
	{L"^T +1917([^0-9])",L"Дорога Зіньків Т1705%1"},
	{L"^T +1918([^0-9])",L"Дорога Краснопілля КПП Покровка%1"},
	{L"^T +1919([^0-9])",L"Дорога Буринь Воскресенка Терни%1"},
	{L"^T +1920([^0-9])",L"Дорога Путивль Нова Слобода з під'їздом до Софроніївського монастиря%1"},
	{L"^T +1921([^0-9])",L"Дорога Путивль Шалигине Заруцьке%1"},
	{L"^T +1922([^0-9])",L"Дорога Путивль Кардаші Спадщанський ліс%1"},
	{L"^T +1923([^0-9])",L"Дорога Тростянець Ницаха Солдатське%1"},
	{L"^T +1924([^0-9])",L"Дорога Середина-Буда Василівка з під'їздами до Хлібороб Винторівка%1"},
	{L"^T +1925([^0-9])",L"Дорога Конотоп Соснівка%1"},
	{L"^T +1926([^0-9])",L"Дорога Штепівка Жовтневе Тимченки Кушніри%1"},
	{L"^T +1927([^0-9])",L"Дорога Чернеччина Журавне%1"},
	{L"^T +1928([^0-9])",L"Дорога Н12 Лутище Куземин%1"},
	{L"^T +1929([^0-9])",L"Дорога Охтирка Бакирівка%1"},
	{L"^T +1930([^0-9])",L"Дорога Добрянське Сидорова Яруга%1"},
	{L"^T +1931([^0-9])",L"Дорога Велика Писарівка Олександрівка%1"},
	{L"^T +1932([^0-9])",L"Дорога Н12 Зарічне%1"},
	{L"^T +2001([^0-9])",L"Дорога Бучач Чортків Скала-Подільська%1"},
	{L"^T +2002([^0-9])",L"Дорога Тернопіль Скалат Жванець%1"},
	{L"^T +2004([^0-9])",L"Дорога Бережани Підгайці Монастирська%1"},
	{L"^T +2006([^0-9])",L"Дорога Городище Зарваниця Бучач%1"},
	{L"^T +2007([^0-9])",L"Дорога Бережани Нараїв Брюховичі%1"},
	{L"^T +2008([^0-9])",L"Дорога Шумськ Великі Дедеркали%1"},
	{L"^T +2009([^0-9])",L"Дорога Вишнівець Ланівці%1"},
	{L"^T +2010([^0-9])",L"Дорога Збараж Підволочиськ%1"},
	{L"^T +2011([^0-9])",L"Дорога Копичинці Гусятин%1"},
	{L"^T +2012([^0-9])",L"Дорога Ланівці Лисогірка Теофіполь%1"},
	{L"^T +2013([^0-9])",L"Дорога Почаїв Зборів%1"},
	{L"^T +2015([^0-9])",L"Дорога Борщів Заліщики%1"},
	{L"^T +2016([^0-9])",L"Дорога Бучач Товсте%1"},
	{L"^T +2017([^0-9])",L"Дорога Гримайлів Яблунів%1"},
	{L"^T +2018([^0-9])",L"Дорога Зборів Козова%1"},
	{L"^T +2019([^0-9])",L"Дорога Кам'янки Скалат%1"},
	{L"^T +2020([^0-9])",L"Дорога Мишковичі Дружба%1"},
	{L"^T +2101([^0-9])",L"Дорога М18 Мерефа Зміїв%1"},
	{L"^T +2103([^0-9])",L"Дорога Харків Золочів КПП Олександрівка%1"},
	{L"^T +2104([^0-9])",L"Дорога Харків Вовчанськ КПП Чугунівка%1"},
	{L"^T +2106([^0-9])",L"Дорога Старий Мерчик Мурафа Краснокутськ%1"},
	{L"^T +2108([^0-9])",L"Дорога Вовчанськ КПП Плетенівка%1"},
	{L"^T +2110([^0-9])",L"Дорога Шевченкове Балаклія Кегичівка%1"},
	{L"^T +2111([^0-9])",L"Дорога Чугуїв Печеніги Великий Бурлук%1"},
	{L"^T +2112([^0-9])",L"Дорога Пересічна Березівське з під'їздом до санаторію Березівські мінеральні води%1"},
	{L"^T +2113([^0-9])",L"Дорога Золочів Максимівка%1"},
	{L"^T +2114([^0-9])",L"Дорога Приколотне Великий Бурлук Дворічна%1"},
	{L"^T +2115([^0-9])",L"Дорога Гусарівка Грушуваха%1"},
	{L"^T +2116([^0-9])",L"Дорога Коломак Шелестове Колонтаїв%1"},
	{L"^T +2117([^0-9])",L"Дорога Дергачі Козача Лопань%1"},
	{L"^T +2118([^0-9])",L"Дорога Кегичівка Сахновщина%1"},
	{L"^T +2119([^0-9])",L"Дорога Наталине Зачепилівка Перещепине%1"},
	{L"^T +2120([^0-9])",L"Дорога Зачепилівка Кегичівка Старовірівка%1"},
	{L"^T +2121([^0-9])",L"Дорога Лозова Барвінкове Велика Комишуваха%1"},
	{L"^T +2122([^0-9])",L"Дорога Ізюм Барвінкове%1"},
	{L"^T +2201([^0-9])",L"Дорога Білозірка Херсон%1"},
	{L"^T +2202([^0-9])",L"Дорога Нова Каховка Армянськ%1"},
	{L"^T +2207([^0-9])",L"Дорога Високопілля Велика Олександрівка Берислав%1"},
	{L"^T +2208([^0-9])",L"Дорога Верхній Рогачик Нижні Сірогози%1"},
	{L"^T +2209([^0-9])",L"Дорога Велика Лепетиха Іванівка Генічеськ%1"},
	{L"^T +2210([^0-9])",L"Дорога Нова Каховка М17%1"},
	{L"^T +2213([^0-9])",L"Дорога М17 Скадовськ%1"},
	{L"^T +2214([^0-9])",L"Під'їзд до Каховки%1"},
	{L"^T +2215([^0-9])",L"Під'їзд до аеропорту Херсон%1"},
	{L"^T +2216([^0-9])",L"Дорога Гола Пристань Залізний Порт%1"},
	{L"^T +2301([^0-9])",L"Дорога Білогір'я Р26%1"},
	{L"^T +2302([^0-9])",L"Дорога Чернелівка Городок Смотрич%1"},
	{L"^T +2303([^0-9])",L"Дорога Дунаївці Грушка%1"},
	{L"^T +2305([^0-9])",L"Дорога Хмельницький Віньківці Дашківці%1"},
	{L"^T +2306([^0-9])",L"Дорога Шепетівка Старокостянтинів%1"},
	{L"^T +2308([^0-9])",L"Дорога Гуків Дунаївці Могилів-Подільський%1"},
	{L"^T +2309([^0-9])",L"Дорога Шепетівка Чуднів Бердичів%1"},
	{L"^T +2310([^0-9])",L"Дорога Голосків Деражня Лука-Барська%1"},
	{L"^T +2311([^0-9])",L"Дорога Хмельницький Волочиськ%1"},
	{L"^T +2312([^0-9])",L"Дорога Гусятин Городок%1"},
	{L"^T +2313([^0-9])",L"Дорога Кам'янка Шепетівка%1"},
	{L"^T +2314([^0-9])",L"Дорога Теофіполь Красилів Н3%1"},
	{L"^T +2315([^0-9])",L"Дорога Солобківці Нова Ушиця%1"},
	{L"^T +2316([^0-9])",L"Дорога Маниківці Деражня%1"},
	{L"^T +2317([^0-9])",L"Дорога Кам'янець-Подільський Стара Ушиця%1"},
	{L"^T +2318([^0-9])",L"Дорога Старий Остропіль Вовковинці%1"},
	{L"^T +2319([^0-9])",L"Дорога Стара Синява Меджибіж М12%1"},
	{L"^T +2320([^0-9])",L"Дорога М12 Волочиськ Підволочиськ%1"},
	{L"^T +2321([^0-9])",L"Дорога Ярмолинці Кам'янець-Подільський%1"},
	{L"^T +2324([^0-9])",L"Дорога Старокостянтинів Антоніни%1"},
	{L"^T +2325([^0-9])",L"Дорога Кам'янець-Подільський Устя%1"},
	{L"^T +2326([^0-9])",L"Дорога Старокостянтинів Шрубків%1"},
	{L"^T +2401([^0-9])",L"Дорога Городище Новоукраїнка Устинівка%1"},
	{L"^T +2402([^0-9])",L"Дорога Суботів Медведівка Кам'янка%1"},
	{L"^T +2403([^0-9])",L"Дорога Орадівка Жашків Корсунь-Шевченківський Мошни%1"},
	{L"^T +2404([^0-9])",L"Дорога Канів Прохорівка Домантове%1"},
	{L"^T +2405([^0-9])",L"Дорога Жашків Буки Озірна%1"},
	{L"^T +2406([^0-9])",L"Дорога Маньківка Іваньки Буки%1"},
	{L"^T +2407([^0-9])",L"Дорога Н1 Кам'янка%1"},
	{L"^T +2408([^0-9])",L"Дорога Шевченкове Городище Н16%1"},
	{L"^T +2409([^0-9])",L"Дорога М3 Драбів Золотоноша%1"},
	{L"^T +2410([^0-9])",L"Дорога Свічківка Гребінка%1"},
	{L"^T +2411([^0-9])",L"Дорога Звенигородка Тальне Маньківка%1"},
	{L"^T +2412([^0-9])",L"Дорога Софіївка Драбів%1"},
	{L"^T +2413([^0-9])",L"Дорога Катеринопіль Вікнине Шпола%1"},
	{L"^T +2414([^0-9])",L"Дорога Сміла Капітанівка Новомиргород%1"},
	{L"^T +2415([^0-9])",L"Дорога Тальне Нерубайка Ульяновка%1"},
	{L"^T +2416([^0-9])",L"Дорога Сушківка Вільшана-Слобідка Перегонівка%1"},
	{L"^T +2417([^0-9])",L"Дорога Чорнобай Хрестителеве Лубни%1"},
	{L"^T +2418([^0-9])",L"Дорога Н16 Сміла Н1%1"},
	{L"^T +2419([^0-9])",L"Дорога Звенигородка Ватутіне%1"},
	{L"^T +2501([^0-9])",L"Дорога М1 Олишівка Куликівка%1"},
	{L"^T +2503([^0-9])",L"Дорога Вільне Кролевець%1"},
	{L"^T +2506([^0-9])",L"Дорога Чернігів Любеч Славутич%1"},
	{L"^T +2507([^0-9])",L"Дорога М1 Добрянка%1"},
	{L"^T +2512([^0-9])",L"Дорога Ріпки Городня Корюківка Семенівка%1"},
	{L"^T +2513([^0-9])",L"Дорога Козелець Козари Носівка%1"},
	{L"^T +2514([^0-9])",L"Дорога Ніжин Бахмач Дмитрівка%1"},
	{L"^T +2515([^0-9])",L"Дорога Р68 Дмитрівка Харкове%1"},
	{L"^T +2516([^0-9])",L"Дорога Сосниця Короп М2%1"},
	{L"^T +2517([^0-9])",L"Дорога Короп Нехаївка Шабалинів%1"},
	{L"^T +2518([^0-9])",L"Дорога КПП Хрінівка Щорс Березна%1"},
	{L"^T +2519([^0-9])",L"Дорога Холми Авдіївка Оболоння%1"},
	{L"^T +2521([^0-9])",L"Дорога Сосниця Шаповалівка М2%1"},
	{L"^T +2523([^0-9])",L"Дорога Борзна Стрільники Бахмач%1"},
	{L"^T +2524([^0-9])",L"Дорога Борзна Ічня Прилуки%1"},
	{L"^T +2525([^0-9])",L"Дорога М2 Носівка%1"},
	{L"^T +2526([^0-9])",L"Дорога Ніжин Бобровиця Нова Басань%1"},
	{L"^T +2527([^0-9])",L"Дорога Бобровиця Новий Биків Ічня%1"},
	{L"^T +2528([^0-9])",L"Дорога Козелець Бобровиця%1"},
	{L"^T +2530([^0-9])",L"Дорога Прилуки Срібне Обухове%1"},
	{L"^T +2531([^0-9])",L"Дорога М2 Бахмач%1"},
	{L"^T +2532([^0-9])",L"Дорога Корюківка Матвіївка Сосниця%1"},
	{L"^T +2533([^0-9])",L"Дорога Семенівка Костобобрів Чайкине%1"},
	{L"^T +2534([^0-9])",L"Дорога Корюківка Синявка Блистова Мена%1"},
	{L"^T +2535([^0-9])",L"Дорога Козелець Карпилівка Сорокошичі%1"},
	{L"^T +2536([^0-9])",L"Дорога Корюківка Сахутівка Мена%1"},
	{L"^T +2537([^0-9])",L"Дорога Ріпки Любеч%1"},
	{L"^T +2538([^0-9])",L"Дорога Макіївка Журавка%1"},
	{L"^T +2539([^0-9])",L"Дорога Покошичі Мезин Курилівка%1"},
	{L"^T +2541([^0-9])",L"Дорога Новий Биків Згурівка Яготин%1"},
	{L"^T +2542([^0-9])",L"Дорога Мена Макошине%1"},
	{L"^T +2543([^0-9])",L"Дорога Мена Остреч%1"},
	{L"^T +2544([^0-9])",L"Дорога Березна Миколаївка%1"},
	{L"^T +2545([^0-9])",L"Дорога Ічня Буди%1"},
	{L"^T +2546([^0-9])",L"Дорога Варва Гнідинці%1"},
	{L"^T +2547([^0-9])",L"Дорога М1 Ладинка%1"},
	{L"^T +2548([^0-9])",L"Дорога Щорс Єліне%1"},
	{L"^T +2549([^0-9])",L"Дорога Козелець Данівка%1"},
	{L"^T +2550([^0-9])",L"Дорога Р12 Орлівка%1"},
	{L"^T +2551([^0-9])",L"Дорога М2 Заньки%1"},
	{L"^T +2552([^0-9])",L"Дорога Борзна Комарівка М2%1"},
	{L"^T +2553([^0-9])",L"Дорога Красилівка Надинівка%1"},
	{L"^T +2554([^0-9])",L"Дорога М1 Олешня%1"},
	{L"^T +2555([^0-9])",L"Дорога Р12 Улянівка%1"},
	{L"^T +2556([^0-9])",L"Дорога Н7 Густиня%1"},
	{L"^T +2558([^0-9])",L"Дорога Корюківка Гуринівка Бреч%1"},
	{L"^T +2559([^0-9])",L"Дорога М2 Лісове%1"},
	{L"^T +2560([^0-9])",L"Дорога Придеснянське Вишеньки%1"},
	{L"^T +2561([^0-9])",L"Дорога Ріпки Задеріївка Радуль%1"},
	{L"^T +2601([^0-9])",L"Дорога Чернівці КПП Руська з підїздом до КПП Шепіт%1"},
	{L"^T +2602([^0-9])",L"Дорога Чернівці Заставна М19%1"},
	{L"^T +2603([^0-9])",L"Дорога Чернівці Недобоївці Хотин%1"},
	{L"^T +2604([^0-9])",L"Дорога Чернівці Герца КПП Дяківці%1"},
	{L"^T +2605([^0-9])",L"Дорога М19 Глибока%1"},
	{L"^T +2606([^0-9])",L"Дорога Новоселиця Герца КПП Дяківці%1"},
	{L"^T +2607([^0-9])",L"Дорога Кіцмань Опришени з під'їздом до станції Вадул-Сірет%1"},
	{L"^T +2608([^0-9])",L"Дорога Сторожинець КПП Красноїльськ%1"},
	{L"^T +2609([^0-9])",L"Дорога Долішній Шепіт КПП Руська%1"},
	{L"^T +2610([^0-9])",L"Дорога Хотин КПП Мамалига на Кишинів%1"},
	{L"^T +2633([^0-9])",L"Дорога станція Васкауци Шишківці КПП Вашківці%1"},
	{L"^T +2701([^0-9])",L"Дорога Орлівка Бахчисарай%1"},
	{L"^T +2702([^0-9])",L"Дорога Севастополь порт Камишова бухта мис Фіолент%1"},
	{L"^T +2703([^0-9])",L"Дорога Гончарне Ялта%1"},
	{L"^T +2704([^0-9])",L"Дорога Севастополь порт Камишова бухта бухта Козача%1"},
	{L"^T +2705([^0-9])",L"Під'їзд до Ласпі%1"},
	{L"^T +2707([^0-9])",L"Дорога Любимівка Фруктове%1"},
	{L"^T +2708([^0-9])",L"Дорога Штурмове Хмельницьке%1"},
	{L"^T +2709([^0-9])",L"Дорога Під'їзд до Кача%1"},
	{L"^T +2710([^0-9])",L"Дорога Штурмове Сахарна Головка%1"},
	{L"^T +2711([^0-9])",L"Дорога Орлине Родникове Колхозне%1"},
	{L"^T +2712([^0-9])",L"Дорога Родникове Передове%1"},
	{L"^T +2714([^0-9])",L"Під'їзд до станції Любимівка%1"},
	{L"^T +2715([^0-9])",L"Під'їзд до станції Максимова дача%1"},
	{L"^T +2716([^0-9])",L"Дорога П'ятий кілометр Балаклавського шосе мис Фіолент%1"},
	{L"^T +2717([^0-9])",L"Під'їзд до станції Мекензієві гори%1"},
	{L"/",L""},
}
VOICE["replace_mapinfo_roadnumber_name" .. mother_country] = {
	{L"^ +(%S+) +$", function (s)
		local strroad
		local t_roads = {
		}
		for _,roads in ipairs(t_roads) do if roads[1] == s then strroad = roads[2] break end end
		if strroad == nil then return L" "..s..L" " end
		local strroadtype = wstring.find(strroad, L"^М") and L" Траса " or L" Дорога "
		return strroadtype..strroad..L" "..s..L" " end},
}
VOICE["replace_mapinfo" .. mother_country] = {
	{L"(.*)",L" %1 "},
	{L",",L" , "},
	{L"%([%S ]+%)",L" "},
	{L" [0-9]+%.[0-9]+ ",L" "},
	{L" ([0-9]+)",L"  %1"},
	{L" (%S)%.( ?)(%S)%. ", function (s1, s2, s3)
		if smart_lower_case_get_codegroup(wstring.byte(s1,1)) and smart_lower_case_get_codegroup(wstring.byte(s3,1)) then return L" " end
		return L" "..s1..L"."..s2..s3..L". " end},
	{L"Буль?в?%.",L"Бульвар "},
	{L"Вул%.",L"Вулиця "},
	{L"Дорога Без Назви",L" "},
	{L"Дорога Без Імені",L" "},
	{L"Дор%. Без Імені",L" "},
	{L"Залізн%.",L"Залізничний "},
	{L"Ім%.",L"Імені "},
	{L"Км%.",L"Кілометр "},
	{L"Мікр%.",L"Мікрорайон "},
	{L"Наб%.",L"Набережна "},
	{L"Пл%.",L"Площа "},
	{L"Пров%.",L"Провулок "},
	{L"Просп%.",L"Проспект "},
	{L"Поля Фільтрації",L"Поля_ Фільтрації"},
	{L"Хх%-",L"20-"},
	{L"Alle[%.y][%. ]",L"Алея "},
	{L"Ave[%. ]",L"Проспект "},
	{L"Blvd[%. ]",L"Бульвар "},
	{L"Hotel Ibis Kiev Shevchenko Bd",L"Готель Ібіс"},
	{L"Hotel Paradisson Sas",L"Готель Редісон Сас"},
	{L"Prov[%. ]",L"Провулок "},
	{L"Railway Station",L"Залізничний вокзал"},
	{L"Royal Grand Hotel",L"Роял Гранд Готель"},
	{L"Royal Hotel De Paris",L"Готель Роял Де Парі"},
	{L"Side%-Street[%. ]",L"Провулок "},
	{L"Str[%. ]",L"Вулиця "},
	{L"Vul[%. ]",L"Вулиця "},
	{L"|",L""},
}
local mapinfo_numbers = {
	{L"", L"двох", L"трьох", L"чотирьох", L"п'яти", L"шести", L"семи", L"восьми", L"дев'яти"},
	{L"оди", L"два", L"три", L"чотир", L"п'ят", L"шіст", L"сім", L"вісім", L"дев'ят"},
	{L"", L"двадцять", L"тридцять", L"сорок", L"п'ятдесят", L"шістдесят", L"сімдесят", L"вісімдесят", L"дев'яносто"},
	{L"сто", L"двісті", L"триста", L"чотириста", L"п'ятсот", L"шістсот", L"сімсот", L"вісімсот", L"дев'ятсот"},
	{L"тисяча", L"дві тисячі", L"три тисячі", L"чотири тисячі", L"п'ять тисяч", L"шість тисяч", L"сім тисяч", L"вісім тисяч", L"дев'ять тисяч"},
}
VOICE["replace_mapinfo_numbers" .. mother_country] = {
	{L" 26[%- ]?Т?и? Бакинських ",L" двадцяти шести Бакинських "},
	{L" ([0-9]+)%-Т?и Річчя ",L" %1 Річчя "},
	{L"(.*)", function (s)
		local matched = 0
		wstring.gsub(s, L"([0-9]+)", function() matched = matched + 1 end)
		return (matched >= 2 and L"||" or L"")..wstring.gsub(s, L"Імені ", L"|Імені ") end},
	{L"([0-9]+) +(%S+)", function (s1,s2)
		local t = {L"Року", L"Січня", L"Лютого", L"Березня", L"Квітня", L"Травня", L"Червня", L"Липня", L"Серпня", L"Вересня", L"Жовтня", L"Листопада", L"Грудня"}
		local suffix = L""
		for _,v in ipairs(t) do
			if s2==v then suffix = L"-о" break end
		end
		if s2==L"Кілометр" then suffix = L"-й" end
		if s2==L"Лінія" then suffix = L"-я" end
		return s1..suffix..L" "..s2 end},
	{L"([^0-9]+) ([0-9]+) ([^0-9]+)", function (s1,s2,s3)
		local suffix = L""
		if wstring.find(s1..s3,L"Проїзд") then suffix = L"-й" end
		if wstring.find(s3,L"Дивізії") then suffix = L"-ї" end
		return s1..L" "..s2..suffix..L" "..s3 end},

	{L" ([0-9])000[%- ]?Н?а ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"тисячна| " end},
	{L" ([0-9])000[%- ]?О?ї ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"тисячної " end},
	{L" ([0-9])000[%- ]?И?й ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"тисячний| " end},
	{L" ([0-9])000[%- ]?Н?е ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"тисячне| " end},
	{L" ([0-9])000[%- ]?Г?о ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"тисячного " end},
	{L" ([0-9])000[%- ]?Ліття ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"тисячоліття " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[ТШГВМ]?[ая] ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-а " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?О?ї ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" "..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-ї " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[ИІ]?й ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-й " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?[ТШГВМ]?[єе] ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" |"..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-е " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?Г?о ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" "..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-о " end},
	{L" ([0-9])([0-9])([0-9])([0-9])[%- ]?Річчя ", function (s1,s2,s3,s4) if s2==L"0" then s2=L"" if s3==L"0" then s3=L"" end end return L" "..mapinfo_numbers[5][tonumber(s1)]..L" "..s2..s3..s4..L"-Річчя " end},
	{L" ([0-9])00[%- ]?Т?а ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"сота| " end},
	{L" ([0-9])00[%- ]?О?ї ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"cотої " end},
	{L" ([0-9])00[%- ]?И?й ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"сотий| " end},
	{L" ([0-9])00[%- ]?Т?е ", function (s) return L" |"..mapinfo_numbers[1][tonumber(s)]..L"соте| " end},
	{L" ([0-9])00[%- ]?Г?о ", function (s) return L" "..mapinfo_numbers[1][tonumber(s)]..L"сотого " end},
	{L" ([0-9])00[%- ]?Річчя ", function (s)
		local t = {L"сто", L"двохсот", L"трьохсот", L"чотирьохсот", L"п'ятсот", L"шістсот", L"сімсот", L"вісімсот", L"дев'ятсот"}
		return L" "..t[tonumber(s)]..L"річчя " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[ТШГВМ]?[ая] ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-а " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?О?ї ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" "..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-ї " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[ИІ]?й ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-й " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?[ТШГВМ]?[єе] ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" |"..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-е " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?Г?о ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" "..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-о " end},
	{L" ([0-9])([0-9])([0-9])[%- ]?Річчя ", function (s1,s2,s3) if s2==L"0" then s2=L"" end return L" "..mapinfo_numbers[4][tonumber(s1)]..L" "..s2..s3..L"-Річчя " end},
	{L" ([0-9])0[%- ]?[ТВ]?а ", function (s)
		local t = {L"десята", L"двадцята", L"тридцята", L"сорокова", L"п'ятидесята", L"шестидесята", L"семидесята", L"восьмидесята", L"дев'яноста"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?О?ї ", function (s)
		local t = {L"десятої", L"двадцятої", L"тридцятої", L"сорокової", L"п'ятидесятої", L"шестидесятої", L"семидесятої", L"восьмидесятої", L"дев'яностої"}
		return L" "..t[tonumber(s)]..L" " end},
	{L" ([0-9])0[%- ]?И?й ", function (s)
		local t = {L"десятий", L"двадцятий", L"тридцятий", L"сороковий", L"п'ятидесятий", L"шестидесятий", L"семидесятий", L"восьмидесятий", L"дев'яностий"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?[ТВ]?е ", function (s)
		local t = {L"десяте", L"двадцяте", L"тридцяте", L"сорокове", L"п'ятидесяте", L"шестидесяте", L"семидесяте", L"восьмидесяте", L"дев'яносте"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])0[%- ]?Г?о ", function (s)
		local t = {L"десятого", L"двадцятого", L"тридцятого", L"сорокового", L"п'ятидесятого", L"шестидесятого", L"семидесятого", L"восьмидесятого", L"дев'яностого"}
		return L" "..t[tonumber(s)]..L" " end},
	{L" ([0-9])0[%- ]?Річчя ", function (s)
		local t = {L"десяти", L"двадцяти", L"тридцяти", L"сорока", L"п'ятдесяти", L"шістдесяти", L"сімдесяти", L"вісімдесяти", L"дев'яносто"}
		return L" "..t[tonumber(s)]..L"річчя " end},
	{L" 1([0-9])[%- ]?Т?а ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцята| " end},
	{L" 1([0-9])[%- ]?О?ї ", function (s) return L" "..mapinfo_numbers[2][tonumber(s)]..L"надцятої " end},
	{L" 1([0-9])[%- ]?И?й ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцятий| " end},
	{L" 1([0-9])[%- ]?Т?е ", function (s) return L" |"..mapinfo_numbers[2][tonumber(s)]..L"надцяте| " end},
	{L" 1([0-9])[%- ]?Г?о ", function (s) return L" "..mapinfo_numbers[2][tonumber(s)]..L"надцятого " end},
	{L" 1([0-9])[%- ]?Річчя ", function (s)
		local t = {L"одинадцяти", L"дванадцяти", L"тринадцяти", L"чотирнадцяти", L"п'ятнадцяти", L"шістнадцяти", L"сімнадцяти", L"вісімнадцяти", L"дев'ятнадцяти"}
		return L" "..t[tonumber(s)]..L"річчя " end},
	{L" ([0-9])([0-9])[%- ]?[ТШГВМ]?[ая] ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-а " end},
	{L" ([0-9])([0-9])[%- ]?О?ї ", function (s1,s2) return L" "..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-ї " end},
	{L" ([0-9])([0-9])[%- ]?[ИІ]?й ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-й " end},
	{L" ([0-9])([0-9])[%- ]?[ТШГВМ]?[єе] ", function (s1,s2) return L" |"..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-е " end},
	{L" ([0-9])([0-9])[%- ]?Г?о ", function (s1,s2) return L" "..mapinfo_numbers[3][tonumber(s1)]..L" "..s2..L"-о " end},
	{L" ([0-9])([0-9])[%- ]?Річчя ", function (s1,s2)
		local t = {L"", L"двадцяти", L"тридцяти", L"сорока", L"п'ятдесяти", L"шістдесяти", L"сімдесяти", L"вісімдесяти", L"дев'яносто"}
		return L" "..t[tonumber(s1)]..L" "..s2..L"-Річчя " end},
	{L" ([0-9])[%- ]?[ТШГМ]?[ая] ", function (s)
		local t = {L"перша", L"друга", L"третя", L"четверта", L"п'ята", L"шоста", L"сьома", L"восьма", L"дев'ята"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?О?ї ", function (s)
		local t = {L"першої", L"другої", L"третьої", L"четвертої", L"п'ятої", L"шостої", L"сьомої", L"восьмої", L"дев'ятої"}
		return L" "..t[tonumber(s)]..L" " end},
	{L" ([0-9])[%- ]?[ИІ]?й ", function (s)
		local t = {L"перший", L"другий", L"третій", L"четвертий", L"п'ятий", L"шостий", L"сьомий", L"восьмий", L"дев'ятий"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?[ТШГМ]?[єе] ", function (s)
		local t = {L"перше", L"друге", L"третє", L"четверте", L"п'яте", L"шосте", L"сьоме", L"восьме", L"дев'яте"}
		return L" |"..t[tonumber(s)]..L"| " end},
	{L" ([0-9])[%- ]?Г?о ", function (s)
		local t = {L"першого", L"другого_", L"третього", L"четвертого", L"п'ятого", L"шостого", L"сьомого", L"восьмого_", L"дев'ятого"}
		return L" "..t[tonumber(s)]..L" " end},
	{L" ([0-9])[%- ]?Річчя ", function (s)
		local t = {L"одно", L"двох", L"трьох", L"чотирьох", L"п'яти", L"шести", L"семи", L"восьми", L"дев'яти"}
		return L" "..t[tonumber(s)]..L"річчя " end},

	{L"^||(.*)",function (s) return wstring.gsub(s, L"|", L"") end},
	{L"|(.*)|", function (s) return L"|"..wstring.gsub(s, L"|",L"")..L"|" end},
}
VOICE["replace_mapinfo_end" .. mother_country] = {
	{L"(.*)|(.*)|(.*)",L" %2 %1 %3 "},
	{L" (%S)%.", function (s) if smart_lower_case_get_codegroup(wstring.byte(s,1)) then return L" " end return L" "..s..L". " end},
	{L"^([A-Z])([A-Z])[ ?]*([0-9]+)",L"%1.%2. %3"},
	{L"%-([0-9]+)",L" %1"},
	{L"([0-9])([a-zA-Z])",L"%1 %2"},
	{L"([a-zA-Z])([0-9])",L"%1 %2"},
	{L"([еЕ])([0-9])",L"Є %2"},
	{L"([нН])([0-9])",L"ен %2"},
	{L"([мМ])([0-9])",L"ем %2"},
	{L"([рР])([0-9])",L"ер %2"},
	{L"//",L", "},
	{L" +",L" "},
	{L"^ ",L""},
	{L" $",L""},
}
VOICE["replace_mapinfo_inner" .. mother_country] = {}
VOICE["replace_mapinfo_inner2" .. mother_country] = {}
VOICE["match_inner" .. mother_country] = {}
VOICE["replace_tmc_description" .. mother_country] = {
	{L"([,%.])",L" %1"},
}
local replace_for_turns = {
	{L"(.*)",L" %1 "},
}
local replace_for_turns_end = {
	{L" +",L" "},
	{L"^ ",L""},
	{L" $",L""},
}
local replace_for_turns_inner = {
	{L"^ +Грунтова Дорога +$",L" Грунтову Дорогу "},
	{L"^ +Кільцева Дорога +$",L" Кільцеву Дорогу "},
	{L"(.*) Дорога ",L" Дорогу %1 "},
	{L"(.*) Міст ",L" Міст %1 "},
	{L"(.*) Набережна ",L" Набережну %1 "},
	{L"(.*) Проїзд ",L" Проїзд %1 "},
	{L"(.*) Станція ",L" Станцію %1 "},
}
local replace_for_turns_inner2 = {
	{L"(.*) Алея ",L" Алею %1 "},
	{L"(.*) Бульвар ",L" Бульвар %1 "},
	{L"(.*) Виїзд ",L" Виїзд %1 "},
	{L"(.*) Вулиця ",L" Вулицю %1 "},
	{L"(.*) В'їзд ",L" В'їзд %1 "},
	{L"(.*) Майдан ",L" Майдан %1 "},
	{L"(.*) Мікрорайон ",L" Мікрорайон %1 "},
	{L"(.*) Переїзд ",L" Переїзд %1 "},
	{L"(.*) Провулок ",L" Провулок %1 "},
	{L"(.*) Площа ",L" Площу %1 "},
	{L"(.*) Проспект ",L" Проспект %1 "},
	{L"(.*) Спуск ",L" Спуск %1 "},
	{L"(.*) Траса ",L" Трасу %1 "},
	{L"(.*) Тупик ",L" Тупик %1 "},
}
VOICE["replace_cities_for_turns" .. mother_country] = {
	{L"^(%S+)а$", L"%1у"},
	{L"^(%S+)я$", L"%1ю"},
	{L"^Біла Церква$", L"Білу Церкву"},
	{L"^Гола Пристань$", L"Голу Пристань"},
	{L"^Мала Виска$", L"Малу Виску"},
	{L"^Нова Каховка$", L"Нову Каховку"},
	{L"^Нова Одеса$", L"Нову Одесу"},
	{L"^Стара Вижівка$", L"Стару Вижівку"},
	{L"^Судова Вишня$", L"Судову Вишню"},
	{L"^Запоріжжю$", L"Запоріжжя"},
	{L"^Зимогір'ю$", L"Зимогір'я"},
	{L"^Білопіллю$", L"Білопілля"},
	{L"^Добропіллю$", L"Добропілля"},
	{L"^Привіллю$", L"Привілля"},
	{L"^Щастю$", L"Щастя"},
}
local replace_for_directions_inner = {
	{L"^ +Грунтова Дорога +$",L" Грунтовій Дорозі "},
	{L"^ +Кільцева Дорога +$",L" Кільцевій Дорозі "},
	{L"(.*) Дорога ",L" Дорозі %1 "},
	{L"(.*) Міст ",L" Мосту %1 "},
	{L"(.*) Набережна ",L" Набережній %1 "},
	{L"(.*) Проїзд ",L" Проїзду %1 "},
	{L"(.*) Станція ",L" Станції %1 "},
	{L"(.*) Шосе ",L" Шосе %1 "},
}
local replace_for_directions_inner2 = {
	{L"(.*) Алея ",L" Алеї %1 "},
	{L"(.*) Бульвар ",L" Бульвару %1 "},
	{L"(.*) Виїзд ",L" Виїзду %1 "},
	{L"(.*) Вулиця ",L" Вулиці %1 "},
	{L"(.*) В'їзд ",L" В'їзду %1 "},
	{L"(.*) Майдан ",L" Майдану %1 "},
	{L"(.*) Мікрорайон ",L" Мікрорайону %1 "},
	{L"(.*) Переїзд ",L" Переїзду %1 "},
	{L"(.*) Провулок ",L" Провулку %1 "},
	{L"(.*) Площа ",L" Площі %1 "},
	{L"(.*) Проспект ",L" Проспекту %1 "},
	{L"(.*) Спуск ",L" Спуску %1 "},
	{L"(.*) Траса ",L" Трасі %1 "},
	{L"(.*) Тупик ",L" Тупику %1 "},
}
local replace_for_traffic_fromto_inner = {
	{L"^ +Грунтова Дорога +$",L" Грунтової Дороги "},
	{L"^ +Кільцева Дорога +$",L" Кільцевої Дороги "},
	{L"(.*) Дорога ",L" Дороги %1 "},
	{L"(.*) Міст ",L" Мосту %1 "},
	{L"(.*) Набережна ",L" Набережної %1 "},
	{L"(.*) Проїзд ",L" Проїзду %1 "},
	{L"(.*) Станція ",L" Станції %1 "},
	{L"(.*) Шосе ",L" Шосе %1 "},
}
local replace_for_traffic_fromto_inner2 = {
	{L"(.*) Алея ",L" Алеї %1 "},
	{L"(.*) Бульвар ",L" Бульвару %1 "},
	{L"(.*) Виїзд ",L" Виїзду %1 "},
	{L"(.*) Вулиця ",L" Вулиці %1 "},
	{L"(.*) В'їзд ",L" В'їзду %1 "},
	{L"(.*) Майдан ",L" Майдану %1 "},
	{L"(.*) Мікрорайон ",L" Мікрорайону %1 "},
	{L"(.*) Переїзд ",L" Переїзду %1 "},
	{L"(.*) Провулок ",L" Провулку %1 "},
	{L"(.*) Площа ",L" Площі %1 "},
	{L"(.*) Проспект ",L" Проспекту %1 "},
	{L"(.*) Спуск ",L" Спуску %1 "},
	{L"(.*) Траса ",L" Траси %1 "},
	{L"(.*) Тупик ",L" Тупика %1 "},
}
local replace_for_traffic_on_inner = {
	{L"^ +Грунтова Дорога +$",L" Грунтовій Дорозі "},
	{L"^ +Кільцева Дорога +$",L" Кільцевій Дорозі "},
	{L"(.*) Дорога ",L" Дорозі %1 "},
	{L"(.*) Міст ",L" Мосту %1 "},
	{L"(.*) Набережна ",L" Набережній %1 "},
	{L"(.*) Проїзд ",L" Проїзді %1 "},
	{L"(.*) Станція ",L" Станції %1 "},
	{L"(.*) Шосе ",L" Шосе %1 "},
}
local replace_for_traffic_on_inner2 = {
	{L"(.*) Алея ",L" Алеї %1 "},
	{L"(.*) Бульвар ",L" Бульварі %1 "},
	{L"(.*) Виїзд ",L" Виїзді %1 "},
	{L"(.*) Вулиця ",L" Вулиці %1 "},
	{L"(.*) В'їзд ",L" В'їзді %1 "},
	{L"(.*) Майдан ",L" Майдані %1 "},
	{L"(.*) Мікрорайон ",L" Мікрорайоні %1 "},
	{L"(.*) Переїзд ",L" Переїзді %1 "},
	{L"(.*) Провулок ",L" Провулку %1 "},
	{L"(.*) Площа ",L" Площі %1 "},
	{L"(.*) Проспект ",L" Проспекті %1 "},
	{L"(.*) Спуск ",L" Спуску %1 "},
	{L"(.*) Траса ",L" Трасі %1 "},
	{L"(.*) Тупик ",L" Тупику %1 "},
}
local replace_for_summary_inner = {
	{L"(.*) Дорога ",L" Дорога %1 "},
	{L"(.*) Міст ",L" Міст %1 "},
	{L"(.*) Набережна ",L" Набережна %1 "},
	{L"(.*) Проїзд ",L" Проїзд %1 "},
	{L"(.*) Станція ",L" Станція %1 "},
}
local replace_for_summary_inner2 = {
	{L"(.*) Алея ",L" Алея %1 "},
	{L"(.*) Бульвар ",L" Бульвар %1 "},
	{L"(.*) Виїзд ",L" Виїзд %1 "},
	{L"(.*) Вулиця ",L" Вулиця %1 "},
	{L"(.*) В'їзд ",L" В'їзд %1 "},
	{L"(.*) Майдан ",L" Майдан %1 "},
	{L"(.*) Мікрорайон ",L" Мікрорайон %1 "},
	{L"(.*) Переїзд ",L" Переїзд %1 "},
	{L"(.*) Провулок ",L" Провулок %1 "},
	{L"(.*) Площа ",L" Площа %1 "},
	{L"(.*) Проспект ",L" Проспект %1 "},
	{L"(.*) Спуск ",L" Спуск %1 "},
	{L"(.*) Траса ",L" Траса %1 "},
	{L"(.*) Тупик ",L" Тупик %1 "},
}
local replace_sentence={
	{L"/",L" , "},
	{L" +",L" "},
	{L" потім ",L" , потім "},
	{L" там ",L" , там "},
}
local function get_preposition(str, tbl)
	for k,value in ipairs(tbl) do
		for _,pattern in ipairs(tbl[k][2]) do
			if wstring.find(str,pattern) then
				return tbl[k][1]
			end
		end
	end
end

----------------------------------------------------------------------------------------------------
----------------------------------------|  G U I D A N C E  |---------------------------------------
----------------------------------------------------------------------------------------------------

local function not_settlement(str, direction)
	if transform_pattern_match(str,preposition_tbl) then return L"" end
        return get_preposition(str, direction and preposition_insert_tbl_direction or preposition_insert_tbl)
end
local function wlocalize_table(tname,tcountry)
	if tcountry == mother_country then return VOICE[tname .. mother_country] end
	local localized = ""
	for _,v in pairs(wlocalized.countries) do
		if v == tcountry then localized = v break end
	end
	local need_load = localized ~= ""
	if need_load then need_load = not wlocalized["loaded"..localized] end
	if need_load then pcall(dofile, L"%app%/config/config_transforms"..towstring(localized)..L".lua") end
	if type(VOICE[tname .. localized]) ~= "table" then localized = mother_country end
	return VOICE[tname .. localized]
end
local function check_unknown_country(country)
	if country == nil then
		MODEL.other.country_info.select_country_by_pos(MODEL.navigation.car.position())
		local countryindex = MODEL.other.country_info.list.index()
		if countryindex ~= nil then
			country = MODEL.other.country_info.list[countryindex].name()
		end
	end
	return string.lower(country)
end

local function format_mapinfo(str, country, roadnumber_name)
	country = check_unknown_country(country)
	str = smart_lower_case(str)
	if roadnumber_name then str = transform_and_format(str, wlocalize_table("replace_mapinfo_roadnumber_name",country)) end
	local replace_mapinfo_inner_need = transform_pattern_match(str..L" ",wlocalize_table("match_inner",country))
	str = transform_and_format(transform_and_format(transform_and_format(str, wlocalize_table("replace_mapinfo",country)), replace_mapinfo_inner_need and wlocalize_table("replace_mapinfo_inner",country)), wlocalize_table("replace_mapinfo_inner2",country))
	local replace_mapinfo_numbers_need = wstring.find(str,L"[0-9]")
	return transform_and_format(transform_and_format(str, replace_mapinfo_numbers_need and wlocalize_table("replace_mapinfo_numbers",country)), wlocalize_table("replace_mapinfo_end",country))
end

local function format_roadnumber(number, country)
	country = check_unknown_country(country)
	local str = transform_format_roadnumber_eu(transform_and_format(number, replace_roadnumber_prepare))
	local need2text = roadnumber_mode
	if VOICE["replace_roadnumber" .. mother_country] == wlocalize_table("replace_roadnumber",country) and need2text then need2text = country == mother_country end
	local str1 = transform_and_format(str, need2text and wlocalize_table("replace_roadnumber",country))
	if str1 == str then
		str1 = wstring.gsub(str1,L"E +",L"Е ")
		str1 = wstring.gsub(str1,L",",L" , ")
	elseif wstring.find(number,L"/") then
		str1 = wstring.gsub(str1,L"(.*),(.*)",L"%1")
	end
	return format_all_numbers2text(str1)
end

local function format_cases(str, case, mapinfo)
	local str_input = str
	str=transform_and_format(str, replace_for_turns)
	local t_inner = replace_for_turns_inner
	local t_inner2 = replace_for_turns_inner2
	if case == "for_directions" then
		t_inner = replace_for_directions_inner
		t_inner2 = replace_for_directions_inner2
	elseif case == "for_summary" then
		t_inner = replace_for_summary_inner
		t_inner2 = replace_for_summary_inner2
	elseif case == "for_traffic_on" then
		t_inner = replace_for_traffic_on_inner
		t_inner2 = replace_for_traffic_on_inner2
	elseif case == "for_traffic_fromto" then
		t_inner = replace_for_traffic_fromto_inner
		t_inner2 = replace_for_traffic_fromto_inner2
	end
	if not transform_pattern_match(str, main_streetnames) then str = transform_and_format(str, t_inner) end
	local matched = 0
	for _,v in ipairs(main_streetnames) do
		if wstring.find(str,v) then wstring.gsub(str, v, function() matched = matched + 1 end) end
	end
	if matched < 2 then str = transform_and_format(str, t_inner2) end
	str = transform_and_format(str, replace_for_turns_end)
	if wstring.find(str,L"[0-9]$") then str = format_all_numbers2text(str) end
	if mapinfo == nil or str == L"" or case == "for_summary" or case == "for_traffic_fromto" then
		return str
	else
		return not_settlement(str_input, case == "for_directions") .. str
	end
end

function format_tmc_description(str, country)
	country = check_unknown_country(country)
	local announce = sc_GetSysEntry("tts", "announce_speed_unit", true)
	local wtmc_units = {"km/h", "mph"}
	str = transform_and_format(str, wlocalize_table("replace_tmc_description",country))
	for _,v in pairs(wtmc_units) do
		local value = announce and (MODEL.regional.is_it_voice_localizable(m_i18n_voice(v)) and translate_voice(v) or translate(v)) or L""
		str = wstring.gsub(str, L"([0-9]+) -"..translate(v),L"%1 "..value)
	end
	return str
end

local function signpost_exit(data, idx)
	local exitnumber = data[idx].signpost.exitnumber
	local exitname = data[idx].signpost.exitname
	local strnumber, strname = L"", L""
	local preposition_name = true
	if exitnumber then
		strnumber = wstring.gsub(exitnumber.text,L"([0-9]+)",L"%1 ")
		strnumber = format_all_numbers2text(strnumber)
		preposition_name = nil
	end
	if exitname then
		strname=exitname.text
		voice_debug_log(L"TTS: signpost_exitname in: '"..strname..L"'", 3)
		strname = format_cases(format_mapinfo(strname, data[idx].signpost.country), "for_turns", preposition_name)
		voice_debug_log(L"TTS: signpost_exitname out: '"..strname..L"'", 3)
	end
	if exitnumber or exitname then
		return exit_preposition .. L" " .. strnumber .. (exitnumber and exitname and L"/" or L"") .. strname
	end
end

local function signpost_destination(data, idx)
	local dest
	if not ( data[idx].signpost and data[idx].road ) then return end
	if data[idx].signpost.destination and wstring.find( data[idx].signpost.destination.text, L"[A-z]" ) and data[idx].road then
	dest = data[idx].road.name --amk data[idx].signpost.destination
	else
	  dest = data[idx].signpost.destination
	end
	if dest then
		local str=dest.text
		voice_debug_log(L"TTS: signpost_destination in: '"..str..L"'", 3)
		str = format_cases(transform_and_format(format_mapinfo(str, data[idx].signpost.country), wlocalize_table("replace_cities_for_turns",check_unknown_country(data[idx].signpost.country))), "for_turns", true)
		voice_debug_log(L"TTS: signpost_destination out: '"..str..L"'", 3)
		return str
	end
end

local function signpost_settlement(data, idx) 			--  в "напрямку" де символи  '>>'
	local settlement = data[idx].signpost.settlement
	if not ( settlement and data[idx].road ) then return end
	if settlement and wstring.find( settlement.text, L"[A-z]" ) and data[idx].road then
		settlement = data[idx].road.name --amk
	end

	if settlement then
		local str=settlement.text
		voice_debug_log(L"TTS: signpost_settlement in: '"..str..L"'", 3)
		str = format_cases(transform_and_format(format_mapinfo(str, data[idx].signpost.country),wlocalize_table("replace_cities_for_turns",check_unknown_country(data[idx].signpost.country))), "for_turns")
		if not wstring.find(settlement.text,settlement_preposition) then
			str=settlement_preposition .. L" " .. str
		end
		voice_debug_log(L"TTS: signpost_settlement out: '"..str..L"'", 3)
		return str
	end
end

local function signpost_roadnumber(data, idx)    		--  назва траси M1 ... Mx
	local roadnumber = data[idx].signpost.roadnumber
	if roadnumber then
		local str=roadnumber.text
		voice_debug_log(L"TTS: signpost_roadnumber in: '"..str..L"'", 3)
		str = format_cases(format_roadnumber(str, data[idx].signpost.country), "for_turns", true)
		voice_debug_log(L"TTS: signpost_roadnumber out: '"..str..L"'", 3)
		return str
	end
end

local function road_number_name(data, idx)
	local number = data[idx].road.number
	local name = data[idx].road.name
	local country = data[idx].road.country
	local road_changed, strnumber, strname
	local t_for_turns = "for_turns"
	if number then road_changed = number.change
	elseif name then road_changed = name.change end
	if not use_dativ_for_sameroad then
	elseif road_changed ~= nil then t_for_turns = not road_changed and "for_directions" or "for_turns"
	elseif idx == 1 then t_for_turns = wsameroadname and "for_directions" or "for_turns"
	elseif idx == 2 then
		t_for_turns = check_same_maneuvers_done(data, idx, wprevroadtable) and "for_directions" or "for_turns"
		local match = t_for_turns == "for_directions" and L"same" or L"other"
		local str = get_full_roadname(data[idx].road)
		voice_debug_log(L"TTS: sameroadname then: " .. match .. L" road'"..str..L"'", 3)
	end
	if number and name then
		strnumber=number.text
		strname=name.text
		voice_debug_log(L"TTS: road_number in: '"..strnumber..L"'", 3)
		voice_debug_log(L"TTS: road_name in: '"..strname..L"'", 3)
		strnumber = format_cases(format_roadnumber(strnumber, country), t_for_turns, true)
		strname = format_cases(format_mapinfo(strname, country, true), t_for_turns)
		voice_debug_log(L"TTS: road_number out: '"..strnumber..L"'", 3)
		voice_debug_log(L"TTS: road_name out: '"..strname..L"'", 3)
		return strnumber .. L"/" .. strname
	elseif number then
		strnumber=number.text
		voice_debug_log(L"TTS: road_number in: '"..strnumber..L"'", 3)
		strnumber = format_cases(format_roadnumber(strnumber, country), t_for_turns, true)
		voice_debug_log(L"TTS: road_number out: '"..strnumber..L"'", 3)
		return strnumber
	elseif name then
		strname=name.text
		voice_debug_log(L"TTS: road_name in: '"..strname..L"'", 3)
		strname = format_cases(format_mapinfo(strname, country, true), t_for_turns, true)
		voice_debug_log(L"TTS: road_name out: '"..strname..L"'", 3)
		return strname
	end
end

function format_destname(data, idx)
	local t = {}
	if data[idx].signpost then
		t = transform_chain(t, signpost_exit, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber,data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain(t, road_number_name, 	data, idx)
	end
	return table_concat(t, L"/")
end

function format_streetname(data, idx)
	local t = {}
	if data[idx].road then t = transform_chain(t, road_number_name, data, idx) end
	return table_concat(t, L"/")
end

function format_sentence(str)
	for key, value in ipairs(replace_sentence) do
		str = wstring.gsub(str,value[1],value[2])
	end
	return str
end

local function format_replace_shield(str)
	for i=4190, 4200 do
		str = wstring.gsub(str, wstring.char(i),L"|")
	end
	str = wstring.gsub(str, wstring.char(4244),L"|")
	str = wstring.gsub(str, wstring.char(4255),L"|")
	str = wstring.gsub(str, L"|(.*)|",L"")
	return wstring.gsub(str, L"|",L"")
end

function format_street_name(streetname)
	voice_debug_log(L"TTS: streetname from skin in: '"..streetname..L"'", 3)
	streetname = format_replace_shield(streetname)
	if wstring.sub(streetname, 1, 9) == L"for_turns" then
		local no_settlement = true
		local sett_preposition = L""
		streetname = wstring.sub(streetname, 10)
		if wstring.find(streetname, wstring.char(187)) then
			no_settlement = nil
			sett_preposition = settlement_preposition .. L" "
			streetname = wstring.gsub(streetname, wstring.char(187),L"")
		end
		streetname = wstring.gsub(streetname, L",", L"/")
		local t = {}
		if wstring.find(streetname, L"/") then
			wstring.gsub(streetname, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, s) end end)
			if #t then streetname = t[1] end
		end
		streetname = format_mapinfo(streetname)
		local matched = 0
		for _,v in ipairs(main_streetnames) do
			streetname = wstring.gsub(streetname, v,  function()
				matched = matched + 1
				if matched > 1 then return L"/"..v
				else return v end
			end)
		end
		t = {}
		if wstring.find(streetname, L"/") then
			wstring.gsub(streetname, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, s) end end)
			if #t then streetname = t[1] end
		end
		streetname = sett_preposition .. format_cases(streetname, "for_turns", no_settlement)
	else
		streetname = format_cases(format_mapinfo(streetname), "for_summary")
	end
	voice_debug_log(L"TTS: streetname from skin out: '"..streetname..L"'", 3)
	return streetname
end

function format_waypointname(data, idx)
        local str = L""
	if announce_waypointname and waypointname ~= L"" and idx == 1 then
		str = format_replace_shield(waypointname)
		voice_debug_log(L"TTS: waypointname in: '"..str..L"'", 3)
		str = wstring.gsub(str, L"([0-9]+)(%S)[ +]?$", function (s1,s2)
			if smart_lower_case_get_codegroup(wstring.byte(s2,1)) > 2 then return s1..wstring.char(2200)..s2 end
			return s1..s2 end)
	        local m_sign = wstring.char(215)
		local t = {}
		if wstring.find(str, m_sign) then
			wstring.gsub(str, L"([^"..m_sign..L"]+)"..m_sign..L"?", function(s) if wstring.gsub(s,L" ",L"")~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
			for k,v in ipairs(t) do t[k] = format_cases(format_mapinfo(v), "for_traffic_fromto") end
		end
		if #t > 1 then str = L" перехрестя " .. table_concat(t, L" і ")
		else str = format_cases(format_mapinfo(str), "for_summary") end
		str = wstring.gsub(str, wstring.char(2200), L" ")
		voice_debug_log(L"TTS: waypointname out: '"..str..L"'", 3)
	end
	return str
end

local transform_roadnumber_explode_eu_origvoice = transform_roadnumber_explode_eu
transform_roadnumber_explode_eu = function(str)
	local t = transform_roadnumber_explode_eu_origvoice(str)
	for k in ipairs(t) do
		if t[k+1] and wstring.gsub(t[k], L" ", L"") == wstring.gsub(t[k+1], L" ", L"") then
			table.remove(t, k+1)
		end
	end
	return t
end

----------------------------------------------------------------------------------------------------
-----------------------------------|  R O U T E   S U M M A R Y  |----------------------------------
----------------------------------------------------------------------------------------------------

function route_summary_format_road_name(data)
        local str = data.text
	voice_debug_log(L"TTS: summary roadnumber in: '"..str..L"'", 3)
	str = format_roadnumber(str,"")
	voice_debug_log(L"TTS: summary roadnumber out: '"..str..L"'", 3)
	return str
end

function route_summary_format_street_name(data)
        local str = data.text
	voice_debug_log(L"TTS: summary streetname in: '"..str..L"'", 3)
	str = format_cases(format_mapinfo(str), "for_summary")
	voice_debug_log(L"TTS: summary streetname out: '"..str..L"'", 3)
	return str
end

function route_summary_format_bridge_tunnel(data)
        local str = data.text
	voice_debug_log(L"TTS: summary bridge_tunnel in: '"..str..L"'", 3)
	str = format_cases(format_mapinfo(str), "for_summary")
	voice_debug_log(L"TTS: summary bridge_tunnel out: '"..str..L"'", 3)
	return str
end

function route_summary_format_order(data)
        local str = data.text
	voice_debug_log(L"TTS: summary order in: '"..str..L"'", 3)
	str = format_cases(format_mapinfo(str), "for_summary")
	voice_debug_log(L"TTS: summary order out: '"..str..L"'", 3)
	return str
end

----------------------------------------------------------------------------------------------------
local function format_string2unicode(str)
	if not sc_GetSysEntry("tts", "voice_log_to_unicode_chars", 0) then return str end
	local out, uni_code, repl_str
	out = L""
	for i = 1, #str do
		uni_code = wstring.byte(str, i)
		if uni_code >= 1025 and uni_code <= 1111 then repl_str = L"|"..wstring.sub(towstring(uni_code),2,4)
		else repl_str = wstring.sub(str,i,i) end
		out = out .. repl_str
	end
	return out
end
local voice_debug_log_origvoice = voice_debug_log
voice_debug_log = function(message, level)
	message = format_string2unicode(towstring(message))
	voice_debug_log_origvoice(message, level)
end
function smart_lower_case_get_codegroup(s)
	return s>=65 and s<=90 and 1 or (s>=97 and s<=122 and 2 or (s>=1040 and s<=1071 and 3 or (s>=1072 and s<=1103 and 4 or (s>=1025 and s<=1031 and 5 or (s>=1105 and s<=1111 and 6 or 0)))))
end
function smart_lower_case_inner1(s1, s3)
	local s2 = smart_lower_case_get_codegroup(wstring.byte(s1,1)) and (smart_lower_case_get_codegroup(wstring.byte(s3,1)) or wstring.byte(s3,1) == 32) and L"'" or L"`"
	return s1..s2..s3
end
function smart_lower_case_inner2(s1, s3)
	local s2 = smart_lower_case_get_codegroup(wstring.byte(s1,1)) and (smart_lower_case_get_codegroup(wstring.byte(s3,1)) or wstring.byte(s3,1) == 32) and L"'" or L"`"
	return s1..s2..s3
end
function smart_lower_case_inner3(s1,s2,s3)
	local upper_shift = {0,-32,0,-32,0,-80}
	local lower_shift = {32,0,32,0,80,0}
	local shift, group1, group2, group3 = 0, smart_lower_case_get_codegroup(s1), smart_lower_case_get_codegroup(s2), smart_lower_case_get_codegroup(s3)
	if group2 then
		if not group1 and not group3 or group1 then shift = lower_shift[group2] end
		if not group1 and group3 then shift = upper_shift[group2] end
	end
	return wstring.char(s2+shift)
end
function smart_lower_case(str)
	str = wstring.gsub(str, wstring.char(4244),L" ")
	str = wstring.gsub(str, wstring.char(4255),L" ")
	str = L" " .. format_sentence(str) .. L" "
	str = wstring.gsub(str, L" [`'](%S+)[`'] ", L" %1 ")
	str = wstring.gsub(str, L"(%S)`(.*)", smart_lower_case_inner1)
	str = wstring.gsub(str, L"(%S)'(.*)",  smart_lower_case_inner2)
	local out = L" "
	for i = 2, #str-1 do
		out = out .. smart_lower_case_inner3(wstring.byte(str,i-1),wstring.byte(str,i),wstring.byte(str,i+1))
	end
	return out .. L" "
end
----------------------------------------------------------------------------------------------------
-----------------------------------------|  T R A F F I C  |----------------------------------------
----------------------------------------------------------------------------------------------------

-- 1. Zar az M0 uton, Martonvasar kozeleben. = in die Strasse Numer A1, in der Nahe von Martonvasar./ in der Nahe von der HaupStrasse Numer 33.
-- 2. Zar az M0 uton, Martonvasar es Velence kozt. = in die Strasse Numer A1, zwischen Martonvasar und Velence.
-- 3. Zar a Budai uton, a Budai ut Fiskalis ut keresztezodesben = in der/dem (lsd tabla) Budai ut, in der Kreuzung Budai ut und Fiskalis ut.
-- 4. Zar a Budai uton, Fiskalis ut es 8. ut kozott. = in der/dem Budai ut, zwischen Fiskalis ut und 8. ut.

function traffic_event_supported()
	return true
end
local function traffic_fromto_format_func(str)
	return wstring.gsub(str,L"^ ?(%S) ?[0-9]+$",
		function (s)
			if smart_lower_case_get_codegroup(wstring.byte(s,1)) then return L"" else return s end
		end) == L"" and format_roadnumber or format_mapinfo
end
local function transform_traffic_fromto(fromto, str, roadname)
	local t = {}
	wstring.gsub(str, L"([^,]+),?", function(s) if s~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
	for k in ipairs(t) do
		if roadname~=L"" and t[k+1] and (wstring.find(roadname, t[k+1]) or roadname==t[k+1]) then table.remove(t, k+1) end
	end
	if roadname~=L"" and (wstring.find(roadname, t[1]) or roadname==t[1]) then table.remove(t, 1) end
	if #t then
		str = t[1]
		if wstring.find(str, L"/") then
			t = {}
			wstring.gsub(str, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
			local str_format_function, str_is_number = nil, false
			for k,v in ipairs(t) do
				str_format_function = traffic_fromto_format_func(v)
				if str_format_function == format_roadnumber then str_is_number = true end
				t[k] = format_cases(str_format_function(v), "for_traffic_fromto")
			end
			if str_is_number then
				for k in ipairs(t) do
					if t[k+1] and wstring.gsub(t[k], L" ", L"") == wstring.gsub(t[k+1], L" ", L"") then table.remove(t, k+1) end
				end
			end
			return fromto .. (#t > 1 and L" перехрестя " or L" ") .. table_concat(t, L" і ")
		else
			return fromto .. L" " .. format_cases(traffic_fromto_format_func(str)(str), "for_traffic_fromto")
		end
	end
	return L""
end
local function traffic_event_distance_get(dist)
	local unit_names = {"yards","meters","feet"}
	dist_table = distances[unit_names[MODEL.regional.units() + 1]]
	local _, _, f_dist = distance_formatter(dist)
	local dist_idx = search_distance_index(f_dist)
	local code_string
	if f_dist == dist_table[dist_idx] then code_string = dist_table[dist_idx + 1]
	else code_string = dist_table[search_distance_index(dist) + 1] end
	return decode_string(code_string, 1)
end
function traffic_event(DescKey, data)
	ASSERT(MODEL.regional.is_it_voice_localizable(DescKey), "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	local traffic_on, traffic_roadnumber, traffic_roadname, traffic_from, traffic_to, voice_from, voice_to = L"", L"", L"", L"", L"", L"", L""
	if data.roadnumber then
		traffic_roadnumber = data.roadnumber.text
		voice_debug_log(L"TTS: traffic on roadnumber in: '"..traffic_roadnumber..L"'", 3)
		traffic_on = format_cases(format_roadnumber(traffic_roadnumber), "for_traffic_on",true)
		voice_debug_log(L"TTS: traffic on roadnumber out: '"..traffic_on..L"'", 3)
	end
	if data.roadname then
		local roadnumber_nonexist = true
		if traffic_on ~= L"" then traffic_on = traffic_on .. L"/" roadnumber_nonexist = nil end
		traffic_roadname = data.roadname.text
		voice_debug_log(L"TTS: traffic on roadname in: '"..traffic_roadname..L"'", 3)
		if wstring.find(traffic_roadname, L"/") then
			local t = {}
			wstring.gsub(traffic_roadname, L"([^/]+)/?", function(s) if s~=L"" then table.insert(t, transform_and_format(s, replace_for_turns_end)) end end)
			if #t then traffic_on = traffic_on .. format_cases(format_mapinfo(t[1]), "for_traffic_on", roadnumber_nonexist) end
			if #t>1 then traffic_on =  traffic_on .. L" в районі " .. format_cases(format_mapinfo(t[2]), "for_traffic_fromto") end
		else
			traffic_on = traffic_on .. format_cases(format_mapinfo(traffic_roadname), "for_traffic_on", roadnumber_nonexist)
		end
		voice_debug_log(L"TTS: traffic on roadname out: '"..traffic_on..L"'", 3)
	end
	if data.roadname then traffic_roadname = data.roadname.text end
	if traffic_on ~= L"" then traffic_on = L" " .. traffic_on end
	if data.from then
		voice_from = data.from.text
		voice_debug_log(L"TTS: traffic from in: '"..voice_from..L"'", 3)
		traffic_from = transform_traffic_fromto((data.to and L" , від" or L" , біля"), voice_from, traffic_roadname)
		voice_debug_log(L"TTS: traffic from out: '"..traffic_from..L"'", 3)
	end
	if data.to then
		voice_to = data.to.text
		voice_debug_log(L"TTS: traffic to in: '"..voice_to..L"'", 3)
		traffic_to = transform_traffic_fromto(L" , до", voice_to, traffic_roadname)
		voice_debug_log(L"TTS: traffic to out: '"..traffic_to..L"'", 3)
	end
	local traffic_description, traffic_distance = translate_voice(DescKey), L""
	local traffic_description_on = traffic_events_description and MODEL.regional.current_language.lcid() == MODEL.regional.current_voice.lcid()
	if traffic_description_on then traffic_description_on = transform_pattern_match(towstring(DescKey), {L"ahead", L"blocked"}) end
	if (traffic_description_on or traffic_events_distance) and (data.roadnumber or data.roadname or data.from or data.to) then
		local current
		for i = 0, #MODEL.traffic.events.significant_events - 1 do
			current = MODEL.traffic.events.significant_events[i]
			local roadnumber_str = current.roadnumber_enc()
			if roadnumber_str ~= L"" and roadnumber_str ~= nil then roadnumber_str = wstring.gsub(L" "..roadnumber_str..L" ", L"(.*)([a-zA-Z]+)[%- ]?([0-9]+)(.*)",L"%2%3")
			else roadnumber_str = L"" end
			if traffic_roadnumber == roadnumber_str and traffic_roadname == current.road_name() and voice_to == current.location_to() and voice_from == current.location_from() then
				if current.description() ~= L"" and traffic_description_on then traffic_description = format_tmc_description(current.description()) voice_debug_log(L"TTS: traffic description out: '"..traffic_description..L"'", 3) end
				if current.distance() and traffic_events_distance then traffic_distance = translated_voice_format(m_i18n_voice("After %s"), traffic_event_distance_get(current.distance())) ..  L" " end
				break
			end
			if i>30 then break end
		end
	end
	return format_sentence(traffic_distance .. traffic_description .. traffic_on .. traffic_from .. traffic_to)
end

----------------------------------------------------------------------------------------------------
---------------------------------------------|  E T A  |--------------------------------------------
----------------------------------------------------------------------------------------------------
function format_all_numbers2text(str,spell)
	return wstring.gsub(str, L"([0-9]+)", function(s)
		local inner = L""
		if #s > 3 or wstring.find(s, L"^0") or spell then
			for i = 1, #s do inner = inner .. format_numbers2text(tonumber(wstring.sub(s, i, i))) end
		else inner = format_numbers2text(tonumber(s)) end
		return inner .. L" "
	end)
end
function format_numbers2text(number)
	local index = {{39,9,43,49,33,53,37,4,13},
		{14,8,42,38,32,52,36,3,12},
		{25,5,40,47,30,50,34,1,10,14,26,7,41,48,31,51,35,2,11}}
	local str = towstring(number)
	if #str > 3 then return L" " .. str end
	if str == L"0" then return L" нуль" end
	local t = {}
	local out = L""
	for i = 1, #str do
		table.insert(t, tonumber(wstring.sub(str, i, i)))
	end
	for i = 1, (3 - #str)  do
		table.insert(t, 1, 0)
	end
	if (10 * t[2] + t[3]) < 20 then
		t[3] = 10 * t[2] + t[3]
		t[2] = 0
	end
	for i = 1, #t do
		if t[i] then
			out = out .. L" " .. distances.patterns[index[i][t[i]]]
		end
	end
	return out
end
function eta(time,waypoint)
	local head = waypoint and L"Прибуття в проміжний пункт" or L"Прибуття в пункт призначення"
	local hours, mins, tod = L"", L"", L""
	local hour = time.hour
	local min = time.min
	if hour == 0 then hour = 12 tod = L" - ночі" end
	if hour == 1 then hours = L" о першій"
	else hours = L" в" .. format_numbers2text(hour) end
	if min == 0 then mins = L""
	elseif min < 10 then mins = L" нуль" .. format_numbers2text(min)
	else mins = format_numbers2text(min) end
	if min == 0 and tod == L"" then mins = L" нуль нуль" end
	return head..hours..mins..tod
end

--~ 	VW
local time_patternts = {L" одна", L" дві"}
function format_timeto(timeto)
	local hour, min
	if type(timeto) == "wstring" then
		local hour_ = wstring.sub(timeto,1,-4)
		local min_  = wstring.sub(timeto,-2,-1)
		hour = tonumber(hour_)
		min = tonumber(min_)
	else
		local _, _, hour_, min_ = wstring.find(Format_Timespan(timeto, ETimespanFormat.HrMinRounded), L"(%d+):(%d+)")
		hour, min = tonumber(hour_), tonumber(min_)
	end
	--local _, _, hour, min = wstring.find(Format_Timespan(timeto, ETimespanFormat.HrMinRounded), L"(%d+):(%d+)")
	--hour, min = tonumber(hour), tonumber(min)

	local function time_to_phrase(number, hm)
		local sentence = L""
		if number ~= 0 then
			local number_10 = number % 10
			if number_10 == 1 and number ~= 11 then
				sentence = hm == "h" and L" година " or L" хвилина "
			elseif number_10 > 4 or number_10 == 0 or (number > 10 and number < 20) then
				sentence = hm == "h" and L" годин " or L" хвилин "
			else
				sentence = hm == "h" and L" години " or L" хвилини "
			end

			sentence = (((number_10 == 1 or number_10 == 2) and number ~= 11 and number ~= 12) and
				((number - number_10) and format_numbers2text(number - number_10) or L"") .. time_patternts[number_10] or
				format_numbers2text(number)) .. sentence
		end
		return sentence
	end
	local time_text = time_to_phrase(hour, "h") .. time_to_phrase(min, "m")
	if time_text == L"" then
		time_text = L"менш ніж одна хвилина"
	end
	return time_text
end

wlocalized = {}
wlocalized.countries = {}
for _,v in pairs(wlocalized.countries) do
	wlocalized["loaded"..v] = false
end
if type(complete_POI_CAT_PRIO) == "function" then
	VOICE["complete_POI_CAT_PRIO"]()
	if not (fill_functions._PROC and condfun._PROC) then
		init_functions()
	end
end
