﻿module("VOICE")

ASSERT(type(voice_debug_log) == "function", "Missing voice_debug_log function.")
ASSERT(type(voice_debug_log_table) == "function", "Missing voice_debug_log_table function.")

ASSERT(type(wjoin) == "function", "Missing wjoin function.")
ASSERT(type(wsplit) == "function", "Missing wsplit function.")
ASSERT(type(getFirstNChar) == "function", "Missing getFirstNChar function.")
ASSERT(type(getLastNChar) == "function", "Missing getLastNChar function.")

ASSERT(type(transform_and_format) == "function", "Missing transform_and_format function.")
ASSERT(type(transform_chain) == "function", "Missing transform_chain function.")
ASSERT(type(table_concat) == "function", "Missing table_concat function.")
ASSERT(type(transform_pattern_match) == "function", "Missing transform_pattern_match function.")
ASSERT(type(transform_format_roadnumber_eu) == "function", "Missing transform_format_roadnumber_eu function.")

local function find_preposition(data, tbl)
	str = wstring.lower(data)
	for k, value in ipairs(tbl) do
		for _, pattern in ipairs(tbl[k][2]) do
			if wstring.find(str, pattern) then
				return tbl[k][1] 
			end
		end
	end
	return transform.transform_destname.simple
end

local function get_prepositionFormatSTRs(data)
	local str = wstring.lower(data)
	local _, found_preposition = transform_pattern_match(str, transform.prepositionFormatSTRs)
	if found_preposition then
		return transform.transform_destname.simple
	else
		return find_preposition(str, transform.preposition_accusatives)
	end
end

local function signpost_exitnumber(data, idx)
	return transform_and_format(data[idx].signpost.exitnumber, transform.replace_exitnumber, transform.transform_destname.exitnumber)
end

local function signpost_exitname(data, idx)
	if data[idx].signpost.exitname then 
		return transform_and_format(data[idx].signpost.exitname, transform.replace_mapinfo, get_prepositionFormatSTRs(data[idx].signpost.exitname.text))
	end
end

local function signpost_destination(data, idx)
	if data[idx].signpost.destination then
		return transform_and_format(data[idx].signpost.destination, transform.replace_mapinfo, get_prepositionFormatSTRs(data[idx].signpost.destination.text))
	end
end

local function signpost_settlement(data, idx)
	if data[idx].signpost.settlement then
		local format_str
		if wstring.find(data[idx].signpost.settlement.text, transform.transform_destname.settlement_pattern) then
			format_str = transform.transform_destname.simple
		else
			format_str = transform.transform_destname.settlement
		end
		return transform_and_format(data[idx].signpost.settlement, transform.replace_mapinfo, format_str)
	end
end

local function signpost_roadnumber(data, idx)
	if data[idx].signpost.roadnumber then
		return transform_and_format(data[idx].signpost.roadnumber, transform.replace_roadnumber, transform.transform_destname.roadnumber)
	end
end

local function road_name(data, idx)
	if data[idx].road.name then
		return transform_and_format(data[idx].road.name, transform.replace_for_turns, get_prepositionFormatSTRs(data[idx].road.name.text))
	end
end

local function road_number(data, idx)
	if data[idx].road.number then
		return transform_and_format(data[idx].road.number, transform.replace_roadnumber, transform.transform_destname.roadnumber)
	end
end

function format_destname(data, idx)
	local t = {}
	if data[idx].signpost then
		t = transform_chain(t, signpost_exitname,		data, idx)
		t = transform_chain(t, signpost_exitnumber,		data, idx)
		t = transform_chain(t, signpost_roadnumber,		data, idx)
		t = transform_chain(t, signpost_destination,	data, idx)
		t = transform_chain(t, signpost_settlement,		data, idx)
	elseif data[idx].road then
		t = transform_chain(t, road_number,	data, idx)
		t = transform_chain(t, road_name,	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t = {}
	if data[idx].road then
		t = transform_chain(t, road_number,	data, idx)
		t = transform_chain(t, road_name,	data, idx)
	end
	return table_concat(t, L", ")
end

function format_sentence(str)
	for key, value in ipairs(transform.sentence_transform) do
		str = wstring.gsub(str, value[1], value[2])
	end
	return str
end

function format_street_name(streetname)
	if wstring.sub(streetname, 1, 9) == L"for_turns" then
		local str = wstring.sub(streetname, 10)
		return not_settlement(str) .. transform_and_format(str, replace_mapinfo)
	else
		return transform_and_format(streetname, replace_mapinfo)
	end
end

function route_summary_format_road_name(data)
	return transform_and_format(data, transform_format_roadnumber_eu, nil, true)
end

function route_summary_format_street_name(data)
	return transform_and_format(data)
end

function route_summary_format_bridge_tunnel(data)
	return transform_and_format(data)
end

function route_summary_format_order(data)
	return transform_and_format(data)
end

function traffic_event_supported()
	return true
end

function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	local loc = MODEL.regional.is_it_voice_localizable(DescKey)
	ASSERT(loc, "Missing TrafficEvent dictionary.voice key:" .. DescKey)
	voice_debug_log(L"Desc: " .. str)
	local road = L""
	if data.roadnumber and data.roadnumber.text and data.country and data.country.text==L"_GER" then
		ASSERT(data.roadnumber.text:len())
		if data.roadnumber.text:len() and data.roadnumber.text:sub(1, 1)~=L"A" and data.roadnumber.text:sub(1, 1)~=L"B" then
			data.roadnumber=nil
		end
	end
	if data.roadnumber then
		road = transform_and_format(data.roadnumber, transform_format_roadnumber_eu, transform.traffic_prepositionFormatSTRs.roadnumber, true)
	elseif data.roadname then
		road = transform_and_format(data.roadname, nil, find_preposition(data.roadname.text, transform.traffic_preposition_insert_tbl))
	end
	str = str .. road
	if data.from and not data.to then
		local from = data.from.text
		local to = L""
		if not data.to then
			local _, _, f, t = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if f then
				from = f
				to = t
			end
		end
		if from and to == L"" then
			str = transform_and_format(from, nil, str .. transform.traffic_prepositionFormatSTRs.to)
		else
			str = transform_and_format(from, nil, str .. transform.traffic_prepositionFormatSTRs.from) .. transform.traffic_prepositionFormatSTRs.andstr .. transform_and_format(to)
		end	
	elseif data.from and data.to then 
		str = transform_and_format(data.from, nil, str .. transform.traffic_prepositionFormatSTRs.from) .. transform.traffic_prepositionFormatSTRs.andstr .. transform_and_format(data.to)
	end
	str = str .. L"."
	voice_debug_log(L"Sentence to say: " .. str)
	return str
end



function format_all_numbers2text(str,spell)
	return wstring.gsub(str, L"([0-9]+)", function(s)
		local inner = L""
		if #s > 3 or wstring.find(s, L"^0") or spell then
			for i = 1, #s do inner = inner .. format_numbers2text(tonumber(wstring.sub(s, i, i))) end
		else inner = format_numbers2text(tonumber(s)) end
		return inner .. L" "
	end)
end  

function format_numbers2text(number)
	local index = {{39,9,43,49,33,53,37,4,13},
		{14,8,42,38,32,52,36,3,12},
		{25,5,40,47,30,50,34,1,10,14,26,7,41,48,31,51,35,2,11}}
	local str = towstring(number)
	if #str > 3 then return L" " .. str end
	if str == L"0" then return L"  " end
	local t = {}
	local out = L""
	for i = 1, #str do
		table.insert(t, tonumber(wstring.sub(str, i, i)))
	end
	for i = 1, (3 - #str)  do
		table.insert(t, 1, 0)
	end
	if (10 * t[2] + t[3]) < 20 then
		t[3] = 10 * t[2] + t[3]
		t[2] = 0
	end
	for i = 1, #t do
		if t[i] then
			out = out .. L" " .. distances.patterns[index[i][t[i]]]
		end
	end
	return out
end


function eta(time,waypoint,currenttime)
	local head = currenttime and L"Sada je " or (waypoint and L"Dolazak na međuodredište u " or L"Dolazak na odredište u  ")
	local strmins,strhour
	local hour = time.hour
	local mins = time.min
	local wi_hour_table = {L"jedan sat ",L"dva sata ",L"tri sata ",L"četiri sata ",L"pet sati ",L"šest sati ",L"sedam sati ",L"osam sati ",L"devet sati ",L"deset sati ",L"jedanaest sati ",L"dvanaest sati ",L"trinaest sati ",L"četrnaest sati ",L"petnaest sati ",L"šesnaest sati ",L"sedamnaest sati ",L"osamnaest sati ",L"devetnaest sati ",L"dvadeset sati ",L"dvadest jedan sat ",L"dvadeset dva sata ",L"dvadeset tri sata "}
	local wi_hour_table_cur = {L"jedan sat ",L"dva sata ",L"tri sata ",L"četiri sata ",L"pet sati ",L"šest sati ",L"sedam sati ",L"osam sati ",L"devet sati ",L"deset sati ",L"jedanaest sati ",L"dvanaest sati ",L"trinaest sati ",L"četrnaest sati ",L"petnaest sati ",L"šesnaest sati ",L"sedamnaest sati ",L"osamnaest sati ",L"devetnaest sati ",L"dvadeset sati ",L"dvadeset jedan sat ",L"dvadeset dva sata ",L"dvadeset tri sata "}
	local wi_min_table = {L"jedan minut",L"dva minuta",L"tri minuta",L"četiri minuta",L"pet minuta",L"šest minuta",L"sedam minuta",L"osam minuta",L"devet minuta",L"deset minuta",L"jedanaest minuta",L"dvanaest minuta",L"trinaest minuta",L"četrnaest minuta",L"petnaest minuta",L"šesnaest minuta",L"sedamnaest minuta",L"osamnaest minuta",L"devetnaest minuta",L"dvadeset minuta",L"dvadeset jedan minut",L"dvadeset dva minuta",L"dvadeset tri minuta",L"dvadeset četiri minuta",L"dvadeset pet minuta",L"dvadeset šest minuta",L"dvadeset sedam minuta",L"dvadeset osam minuta",L"dvadeset devet minuta",L"trideset minuta",L"trideset jedan minut",L"trideset dva minuta",L"trideset tri minuta",L"trideset četiri minuta",L"trideset pet minuta",L"trideset šest minuta",L"trideset sedam minuta",L"trideset osam minuta",L"trideset devet minuta",L"četrdeset minuta",L"četrdeset jedan minut",L"četrdeset dva minuta",L"četrdeset tri minuta",L"četrdeset četiri minuta",L"četrdeset pet minuta",L"četrdeset šest minuta",L"četrdeset sedam minuta",L"četrdeset osam minuta",L"četrdeset devet minuta",L"pedeset minuta",L"pedeset jedan minut",L"pedeset dva minuta",L"pedeset tri minuta",L"pedeset četiri minuta",L"pedeset pet minuta",L"pedeset šest minuta",L"pedeset sedam minuta",L"pedeset osam minuta",L"pedeset devet minuta"}
	if time.hour == 0 then
		strhour = L" ponoć, "
	else
		strhour = currenttime and wi_hour_table_cur[hour] or wi_hour_table[hour]
	end
	if time.min == 0 then
		strmins = L"  "
	else
		strmins = wi_min_table[time.min]
	end
	return head .. strhour .. strmins
end

--- Pongo
function timeto(timeto)
	local hournew, minsnew
	local hour = wstring.sub(timeto,1,-4)
	local mins = wstring.sub(timeto,-2,-1)
	local hournumber = tonumber(hour)
	local replace_hourone = {
		{L"0val",L" "},
		{L"1val",L"jedan sat "},
		{L"2val",L"dva sata "},
		{L"3val",L"tri sata "},
		{L"4val",L"četiri sata "},
		{L"5val",L"pet sati "},
		{L"6val",L"šest sati "},
		{L"7val",L"sedam sati "},
		{L"8val",L"osam sati "},
		{L"9val",L"devet sati "},}
	local replace_hoursec = {
		{L"10val",L"deset sati "},
		{L"11val",L"jedanaest sati "},
		{L"12val",L"dvanaest sati "},
		{L"13val",L"trinaest sati "},
		{L"14val",L"četrnaest sati "},
		{L"15val",L"petnaest sati "},
		{L"16val",L"šesnaest sati "},
		{L"17val",L"sedamnaest sati "},
		{L"18val",L"osamnaest sati "},
		{L"19val",L"devetnaest sati "},
		{L"20val",L"dvadeset sati "},
		{L"21val",L"dvadeset jedan sat "},
		{L"22val",L"dvadeset dva sata "},
		{L"23val",L"dvadeset tri sata "},
		{L"24val",L"dvadeset četiri sata "},
		{L"25val",L"dvadeset pet sati "},
		{L"26val",L"dvadeset šest sati "},
		{L"27val",L"dvadeset sedam sati "},
		{L"28val",L"dvadeset osam sati "},
		{L"29val",L"dvadeset devet sati "},
		{L"30val",L"trideset sati "},
		{L"31val",L"trideset jedan sat "},
		{L"32val",L"trideset dva sata "},
		{L"33val",L"trideset tri sata "},
		{L"34val",L"trideset četiri sata "},
		{L"35val",L"trideset pet sati "},
		{L"36val",L"trideset šest sati "},
		{L"37val",L"trideset sedam sati "},
		{L"38val",L"trideset osam sati "},
		{L"39val",L"trideset devet sati "},
		{L"40val",L"četrdeset sati "},
		{L"41val",L"četrdeset jedan sat "},
		{L"42val",L"četrdeset dva sata "},
		{L"43val",L"četrdeset tri sata "},
		{L"44val",L"četrdeset četiri sata "},
		{L"45val",L"četrdeset pet sati "},
		{L"46val",L"četrdeset šest sati "},
		{L"47val",L"četrdeset sedam sati "},
		{L"48val",L"četrdeset osam sati "},
		{L"49val",L"četrdeset devet sati "},
		{L"50val",L"pedeset sati "},
		{L"51val",L"pedeset jedan sat "},
		{L"52val",L"pedeset dva sata "},
		{L"53val",L"pedeset tri sata "},
		{L"54val",L"pedeset četiri sata "},}
	local replace_mins = {
		{L"00minut",L""},
		{L"01minut",L"jedan minut"},
		{L"02minut",L"dva minuta"},
		{L"03minut",L"tri minuta"},
		{L"04minut",L"četiri minuta"},
		{L"05minut",L"pet minuta"},
		{L"06minut",L"šest minuta"},
		{L"07minut",L"sedam minuta"},
		{L"08minut",L"osam minuta"},
		{L"09minut",L"devet minuta"},
		{L"10minut",L"deset minuta"},
		{L"11minut",L"jedanaest minuta"},
		{L"12minut",L"dvanaest minuta"},
		{L"13minut",L"trinaest minuta"},
		{L"14minut",L"četrnaest minuta"},
		{L"15minut",L"petnaest minuta"},
		{L"16minut",L"šesnaest minuta"},
		{L"17minut",L"sedamnaest minuta"},
		{L"18minut",L"osamnaest minuta"},
		{L"19minut",L"devetnaest minuta"},
		{L"20minut",L"dvadeset minuta"},
		{L"21minut",L"dvadeset jedan minut"},
		{L"22minut",L"dvadeset dva minuta"},
		{L"23minut",L"dvadeset tri minuta"},
		{L"24minut",L"dvadeset četiri minuta"},
		{L"25minut",L"dvadeset pet minuta"},
		{L"26minut",L"dvadeset šest minuta"},
		{L"27minut",L"dvadeset sedam minuta"},
		{L"28minut",L"dvadeset osam minuta"},
		{L"29minut",L"dvadeset devet minuta"},
		{L"30minut",L"trideset minuta"},
		{L"31minut",L"trideset jedan minut"},
		{L"32minut",L"trideset dva minuta"},
		{L"33minut",L"trideset tri minuta"},
		{L"34minut",L"trideset četiri minuta"},
		{L"35minut",L"trideset pet minuta"},
		{L"36minut",L"trideset šest minuta"},
		{L"37minut",L"trideset sedam minuta"},
		{L"38minut",L"trideset osam minuta"},
		{L"39minut",L"trideset devet minuta"},
		{L"40minut",L"četrdeset minuta"},
		{L"41minut",L"četrdeset jedan minut"},
		{L"42minut",L"četrdeset dva minuta"},
		{L"43minut",L"četrdeset tri minuta"},
		{L"44minut",L"četrdeset četiri minuta"},
		{L"45minut",L"četrdeset pet minuta"},
		{L"46minut",L"četrdeset šest minuta"},
		{L"47minut",L"četrdeset sedam minuta"},
		{L"48minut",L"četrdeset osam minuta"},
		{L"49minut",L"četrdeset devet minuta"},
		{L"50minut",L"pedeset minuta"},
		{L"51minut",L"pedeset jedan minut"},
		{L"52minut",L"pedeset dva minuta"},
		{L"53minut",L"pedeset tri minuta"},
		{L"54minut",L"pedeset četiri minuta"},
		{L"55minut",L"pedeset pet minuta"},
		{L"56minut",L"pedeset šest minuta"},
		{L"57minut",L"pedeset sedam minuta"},
		{L"58minut",L"pedeset osam minuta"},
		{L"59minut",L"pedeset devet minuta"},}
	if hournumber <= 9 then
		hournew = transform_and_format(hour .. L"val",replace_hourone)
	else
		hournew = transform_and_format(hour .. L"val",replace_hoursec)
	end
		minsnew = transform_and_format(mins .. L"minut",replace_mins)
	return hournew .. minsnew .. L" "
end

--- Vicewandel
local time_patternts = {L" jedan", L" dva"}
function format_timeto(timeto)
	local hour, min
	if type(timeto) == "wstring" then
		local hour_ = wstring.sub(timeto,1,-4)
		local min_  = wstring.sub(timeto,-2,-1)
		hour = tonumber(hour_)
		min = tonumber(min_)
	else
		local _, _, hour_, min_ = wstring.find(Format_Timespan(timeto, ETimespanFormat.HrMinRounded), L"(%d+):(%d+)")
		hour, min = tonumber(hour_), tonumber(min_)
	end
	--local _, _, hour, min = wstring.find(Format_Timespan(timeto, ETimespanFormat.HrMinRounded), L"(%d+):(%d+)")
	--hour, min = tonumber(hour), tonumber(min)

	local function time_to_phrase(number, hm)
		local sentence = L""
		if number ~= 0 then
			local number_10 = number % 10
			if number_10 == 1 and number ~= 11 then
				sentence = hm == "h" and L" sat " or L" minut "
			elseif number_10 > 4 or number_10 == 0 or (number > 10 and number < 20) then
				sentence = hm == "h" and L" sati " or L" minuta "
			else
				sentence = hm == "h" and L" sata " or L" minuta "
			end

			sentence = (((number_10 == 1 or number_10 == 2) and number ~= 11 and number ~= 12) and
				((number - number_10) and format_numbers2text(number - number_10) or L"") .. time_patternts[number_10] or
				format_numbers2text(number)) .. sentence
		end
		return sentence
	end

	local time_text = time_to_phrase(hour, "h") .. time_to_phrase(min, "m")
	if time_text == L"" then
		time_text = L"manje od minuta"
	end
	return time_text
end


over_speed_limit = function()
	local key = m_i18n_voice("The speed limit is %s!")
	if MODEL.regional.is_it_voice_localizable(key) then
		local speedunits = {"mph","km/h","mph"}
		local correct = SysConfig:get("tts", "correct_speed_unit", true) and MODEL.regional.is_it_voice_localizable(m_i18n_voice("km/h")) and MODEL.regional.is_it_voice_localizable(m_i18n_voice("mph"))
		local announce = SysConfig:get("tts", "announce_speed_unit", true)
		local limitphrasepart = (correct or not announce) and 2 or 0
		local limitphraseunit = correct and announce and (L" " .. translate_voice(speedunits[MODEL.regional.units() + 1])) or L""
		local limitphrase = MODEL.other.format_speed(MODEL.warning.driveralert.speed_limit(), MODEL.regional.units(), 1, limitphrasepart)
		if correct and announce then
			limitphrase = format_all_numbers2text(limitphrase)
		end
		return translated_voice_format(key, limitphrase .. limitphraseunit)
	end
end


