﻿module("VOICE")

function set_tts_settings()
	if MODEL.EXISTS.lua.tts.numbers_mode() then numbers_mode = MODEL.lua["tts.numbers_mode"]()
	else numbers_mode = SysConfig:get("tts", "numbers_mode", 0) end
	set_distances_meters()
	local unit_names = {"yards","meters","feet"}
	dist_table = distances[unit_names[MODEL.regional.units() + 1]]
	if MODEL.EXISTS.lua.tts.sentence_variations() then sentence_variations = MODEL.lua["tts.sentence_variations"]()
	else sentence_variations = SysConfig:get("tts", "sentence_variations", 0) end
	set_pattern_variations()
	if MODEL.EXISTS.lua.tts.traffic_events_distance() then traffic_events_distance = MODEL.lua["tts.traffic_events_distance"]()
	else traffic_events_distance = SysConfig:get("tts", "traffic_events_distance", 0) end
end
set_tts_settings()

---VOICE TRANSFORM UTILS---
assert(type(transform_and_format) == "function", "Missing transform_and_format function.")
assert(type(transform.substitute_transform) == "table", "Missing transform.substitute_transform table.")
assert(type(transform_chain) == "function"--[[, "Missing transform_chain function."--]])
assert(type(transform_format_roadnumber_eu) == "function"--[[, "Missing transform_format_roadnumber_eu function."--]])
assert(type(transform_pattern_match) == "function"--[[, "Missing transform_pattern_match function."--]])
--[[
assert(type(table_concat) == "function", "Missing table_concat function.")
assert(type(transform.sentence_transform) == "table", "Missing transform.sentence_transform table.")
--]]

---Tabela wyjatków---
local pk_preposition_tbl = {L"^Most ",L"^Autostrada",L"^Bulwar",L"^Plac",L"^Osiedle",L"^Skwer",L"^Węzeł",L"^Wybrzeże",L"^Rondo"}

local pk_out_preposition_tbl = {
	L"Śrudmieście",
	L"Ariadna",
	L"Babinicza",
	L"Bartolona",
	L"Becka",
	L"Bieńczaka",
	L"Bilana",
	L"Bociana",
	L"Bohaterów Ossowa",
	L"Borowiczan",
	L"Bronicza",
	L"Browar$",
	L"Browarem",
	L"Browarki",
	--L"Browarna",--
	--L"Browarniana",--
	L"Browarniane",
	L"Browarniany",
	L"Browarnej",
	L"Browarnik",
	L"Browarny",
	--L"Browarowa",--
	L"Browarowy",
	--L"Browarska",--
	L"Bułhakowa",
	L"Cetnarskich",
	L"Cetnarskiego",
	L"Chodakowa",
	L"Chomicza",
	L"Cypiska",
	L"Czarnkowa",
	--L"Darowana",--
	L" Dnia",--
	L"Dobrzykowa",
	L"Do Grodziska",
	L"Do Rudna",
	L"Dolna Wilda",
	L"Dworzyska",
	L"Dymitrowa",
	L"Dyplomowanego",
	L" Eska",--
	L"Esplanada",
	L"Fastnachta",
	L"Filona",
	L"Fiodorowa",
	L"Galona",
	L"Chorzowa",
	L"Gielniowa",
	L"Glowatzkiego",
	L" Głowa",
	L"Gorbatowa",
	L"Górczaka",
	L"Górników Turowa",
	L"Grodna",
	L"Grudnia",
	L"Grzecznarowskiego",
	--L"Horodniańska",--
	L" Innowa",--
	L"Iwanowa",
	L"Kapelana",
	L"Karłowatej",
	L"Kasztelana",
	L"Klonami",
	L"Kolona",
	L"Konicza",
	--L"Kornowacka",--
	L"Koszowatkę",
	L"Kowaczka",
	--L" Kowa",--
	L"Krotowa",
	L"Kryniczanka",
	--L"Krywiczańska",--
	L"Kusztelana",
	--L"Kornowacka",--
	L"Krakowa",
	L"Kryska",
	L"Ksawerowa",
	L"Leliwa",
	L"Lermontowa",
	L"Lipowczana",
	L" Liska",--
	L"Liskowa",--
	L"Lubaczowa",
	L"Ludwiczaka",
	L"Ludziska",
	L"Łobzowa",
	L" Mąkowa",--
	L"Macmillana",
	L"Magellana",
	L"Małynicza",
	--L"Malowana",--
	L"Malowane",
	L"Malowany",
	L"Miasta",
	L"Milana",
	L"Millana",
	--L"Murowana",--
	L"Murowaniec",
	L" Nadnarwia",--
	L"Niewodniczańskiego",
	L"Nowaczyka",
	L"Nowackiego",
	L"Nowackiej",
	L"Nowaczyńskiego",
	L"Nowaka",
	L"Nowakowskiego",
	L"Nowalijek",
	L"Nowary",
	L"Nowaszki",
	--L" Nowa",--
	L"Nowa Ruda",
	--L"Nowoprojektowana",--
	L" Nowowa",--
	L"Obrońców Lwowa",--
	L"Obrońców Mogilna",
	L"Obrońców Różana",
	L"Odsieczy Wiednia",
	L" Olecka",--
	L"Olejniczaka",
	L"Opoczna",
	L"Ostaszkowa",
	L"Ostrowa",
	L"Owczarka",--
	--L"Pagórkowata",--
	L"Piasta",
	--L"Piętnasta",--
	L"Piętnastki",
	L"Piętnastolecia",
	L"Piwowara",
	L"Piwowarów",
	--L"Piwowarska",--
	L"Piwowary",
	L"Podnarew",
	L"Pogranicza",
	L" Powa",--
	--L"Projektowana",--
	L"Prosnaka",
	L" Prowa",--
	L"Radzanowa",
	L"Rajkowa",
	L"Ratnawy",
	L"Represjonowanych",
	L"Rzeźniczaka",
	L"Schonborna",
	--L"Serowarska",--
	L"Skrowaczewskiego",
	L"Snowalniana",--
	L"Snowaniec",
	L"Sosna",
	L"Sosnami",
	--L"Starowałowa",--
	--L"Starowapiennikowa",--
	--L"Starowarcka",--
	--L"Starowarszawska",--
	L"Studniarskiego",
	L"Szanajcy",
	--L"Szenkowana",--
	L"Sznajdra",
	L"Szpetnara",
	L"Szymankowa",
	L" Śliwa",--
	L"Średniak",
	L"Średniawskiego",
	L"Świętajna",
	L"Tarnawskiego",
	L"Tarnowa",
	L"Tarzana",
	L"Tomaszowa",
	--L"Towarna",--
	L"Towarnickiego",
	--L"Towarowa",--
	L"Towarowy",
	--L"Towarzyska",--
	L"Towarzystwa",
	L"Trznadla",
	L"Tygryska",
	L"Warzna",
	L"Węzeł Kliniczna",
	L" Wietna",--
	L"Wiszowatego",
	L"Witeltona",
	L"Wojska",
	L"Woodrowa",
	L"Woronicza",
	L"Wrzoska",
	L"Wyszanowa",
	--L"Zabrowarna",--
	--L"Zaczarowana",--
	L"Zaczarowane",
	L"Zaczarowanej",
	L"Zagórcza",--
	L"Zambrowa",
	L"Zamczyska",
	L"Zgrupowania",
	L"Zmechanizowanej",
	L"Zołotowa",
	L" Kolna",
	L" Krosna",
	L"Żukowa",
}

local preposition_insert_tbl = {
    {L"na ",{L"^most ",L"^autostrada",L"^bulwar",L"^plac",L"^osiedle",L"^obwodnica",L"^promenada", L"^skwer",L"^wybrzeże",L"^rondo",L"^%a?%d+%a?$"}},
    {L"przez ",{L"^tunel",L"tunnel$"}},
    {L"w ",{L"^ulica",L"^aleja",L"^droga",L"^szosa",L"^trasa",L"^węzeł"}},
       {L"w ulicę",{L""}},
} 

local traffic_preposition_insert_tbl = {
	{L"w ",{L"^aleja",L"^tunel"}},
	{L"w ",{L"^autostrada",L"^bulwar",L"^droga",L"^szosa",L"^trasa",L"^most ",L"^plac",L"^osiedle",L"^obwodnica",L"^promenada",L"^skwer",L"^ulica",L"^węzeł",L"^wybrzeże",L"^rondo",L""}},
	
}

local replace_tmc_od = {
	{L"Aleja",L"Alei"},
	{L"Autostrada",L"Autostrady"},
	{L"Bulwar",L"Bulwaru"},
	{L"Droga",L"Drogi"},
	{L"Most",L"Mostu"},
	{L"Osiedle",L"Osiedla"},
	{L"Obwodnica",L"Obwodnicy"},
	{L"Plac",L"Placu"},
	{L"Promenada",L"Promenady"},
	{L"Rondo",L"Ronda"},
	{L"Skwer",L"Skweru"},
	{L"Szosa",L"Szosy"},
	{L"Trasa",L"Trasy"},
	{L"Tunel",L"Tunelu"},
	{L"Ulica",L"Ulicy"},
	{L"Węzeł",L"Węzła"},
	{L"Wybrzeże",L"Wybrzeża"},
	{L"City border",L"Granica miasta"},
	{L"Northern intersection",L"Północne skrzyżowanie"},
	{L"Southern intersection",L"Południowe skrzyżowanie"},
	{L"Westhern intersection",L"Zachodnie skrzyżowanie"},
	{L"Osthern intersection",L"Wschodnie skrzyżowanie"},
	{L"German",L"Niemiec"},
	{L"Polish",L"Polski"},
}

local replace_tmc_na = {
	{L"Aleja",L"Alei"},
	{L"Autostrada",L"Autostradzie"},
	{L"Bulwar",L"Bulwarze"},
	{L"Droga",L"Drodze"},
	{L"Most",L"Moście"},
	{L"Osiedle",L"Osiedlu"},
	{L"Obwodnica",L"Obwodnicy"},
	{L"Plac",L"Placu"},
	{L"Promenada",L"Promenadzie"},
	{L"Rondo",L"Rondzie"},
	{L"Skwer",L"Skwerze"},
	{L"Szosa",L"Szosie"},
	{L"Trasa",L"Trasie"},
	{L"Tunel",L"Tunelu"},
	{L"Ulica",L"Ulicy"},
	{L"Węzeł",L"Węźle"},
	{L"Wybrzeże",L"Wybrzeżu"},
	{L"City Border",L"Granica miasta"},
	{L"Northern intersection",L"Północne skrzyżowanie"},
	{L"Southern intersection",L"Południowe skrzyżowanie"},
	{L"Westhern intersection",L"Zachodnie skrzyżowanie"},
	{L"Osthern intersection",L"Wschodnie skrzyżowanie"},
	{L"German",L"Niemiec"},
	{L"Polish",L"Polski"},
}

local function get_preposition(str, tbl)
	str = wstring.lower(str)
	for k,value in ipairs(tbl) do
		for _,pattern in ipairs(tbl[k][2]) do
			if wstring.find(str,pattern) then
				return tbl[k][1]
			end
		end
	end
end

---GUIDANCE---
function format_sentence(str)
	if transform.sentence_transform then
		str = transform.sentence_transform:transform(str)
	end
	return str
end

function get_road_number_prepos(road_numbers)
local prepos
	if wstring.find(road_numbers, prepositions.pattern_to_roadnumber_on_hwy) ~= nil then
		prepos = prepositions.formatStr_to_roadnumber_on_hwy
	elseif wstring.find(road_numbers, prepositions.pattern_to_roadnumber_on_expw) ~= nil then
		prepos = prepositions.formatStr_to_roadnumber_on_expw
	elseif wstring.find(road_numbers, prepositions.pattern_to_roadnumber_on_inthwy) ~= nil then
		prepos = prepositions.formatStr_to_roadnumber_on_inthwy
	else
		prepos = prepositions.formatStr_to_roadnumber_default
	end
	return prepos
end
local function signpost_exitnumber(data, idx)
	return transform_and_format(data[idx].signpost.exitnumber, nil, prepositions.formatStr_to_exit)
	end
	local function signpost_exitname(data, idx)
	return transform_and_format(data[idx].signpost.exitname, nil, prepositions.formatStr_to_exit)
end
local function signpost_destination(data, idx)
	if data[idx].signpost.destination then
		local format_str
		local country_abbrev = transform.country_abbrev_table:transform(data[idx].signpost.destination.text)		
		if country_abbrev == data[idx].signpost.destination.text then
			format_str = prepositions.formatStr_to_destination		
		else
			data[idx].signpost.destination.text = transform.country_inflection_table:transform(country_abbrev)			
			format_str = prepositions.formatStr_to_destinationCountry
		end
		return transform_and_format(data[idx].signpost.destination, nil, format_str)
	end
end

local function signpost_settlement(data, idx)
	if data[idx].signpost.settlement then
		local format_str		
		local country_abbrev = transform.country_abbrev_table:transform(data[idx].signpost.settlement.text)		
		if country_abbrev == data[idx].signpost.settlement.text then
			format_str = prepositions.formatStr_to_settlement		
		else
			data[idx].signpost.settlement.text = transform.country_inflection_table:transform(country_abbrev)			
			format_str = prepositions.formatStr_to_settlementCountry
		end
		return transform_and_format(data[idx].signpost.settlement, nil, format_str)
	end
end

local function signpost_roadnumber(data, idx)
	if data[idx].signpost.roadnumber then
		local format_str = get_road_number_prepos(data[idx].signpost.roadnumber.text)
		return transform_and_format(data[idx].signpost.roadnumber, transform_format_roadnumber_eu, format_str, true)
	end
end

local function road_name(data, idx)
	local name = data[idx].road.name
	if name then
		local str
		local str1 = transform.substitute_transform:transform(name.text)
		local str2 = transform.substitute_road_names:transform(str1)
		if transform_pattern_match(name.text,pk_preposition_tbl) then
			str = get_preposition(name.text, preposition_insert_tbl) .. str2
		elseif transform_pattern_match(name.text,pk_out_preposition_tbl) then
			str = get_preposition(name.text, preposition_insert_tbl) .. str2
		else
			str = get_preposition(name.text, preposition_insert_tbl) .. transform.substitute_names:transform(str2)
		end
		return str
	end
end

local function road_number(data, idx)
	 if data[idx].road.number then
	 	local format_str = get_road_number_prepos(data[idx].road.number.text)
	 	return transform_and_format(data[idx].road.number, transform_format_roadnumber_eu, format_str, true)
	end
end

function format_destname(data, idx)
	local t
	if data[idx].signpost then
		t = transform_chain({}, signpost_exitname, 	    data, idx)
		t = transform_chain(t,  signpost_exitnumber, 	data, idx)
		t = transform_chain(t,  signpost_roadnumber, 	data, idx)
		t = transform_chain(t,  signpost_destination,	data, idx)
		t = transform_chain(t,  signpost_settlement, 	data, idx)
	elseif data[idx].road then
		t = transform_chain({}, road_number, 	data, idx)
		t = transform_chain(t,  road_name, 	data, idx)
	end
	return table_concat(t, L", ")
end

function format_streetname(data, idx)
	local t
	t = transform_chain({}, road_number, 	data, idx)
	t = transform_chain(t,  road_name, 	data, idx)
	return table_concat(t, L", ")
end

---Detour---
local function format_replace_shield(str)
	for i=4190, 4200 do
		str = wstring.gsub(str, wstring.char(i),L"|")
	end
	str = wstring.gsub(str, wstring.char(4244),L"|")
	str = wstring.gsub(str, wstring.char(4255),L"|")
	str = wstring.gsub(str, L"|(.*)|",L"")
	return wstring.gsub(str, L"||",L"")
end

function format_street_name(streetname)
	streetname = format_replace_shield(streetname)
	if wstring.sub(streetname, 1, 9) == L"for_turns" then
		local str
		local propos = L" przez "
		local str1 = wstring.sub (streetname, 10)
		local str2 = transform.substitute_transform:transform(str1)
		local str3 = transform.substitute_road_names:transform(str2)
		local str4
		if transform_pattern_match(wstring.sub (streetname, 10),pk_preposition_tbl) then
			str = propos .. str3
		elseif transform_pattern_match(wstring.sub (streetname, 10),pk_out_preposition_tbl) then
			str = propos .. str3
		else
			str4 = transform.substitute_for_detour:transform(str3)
			str = propos .. transform.substitute_names:transform(str4)
		end
		return str
	else
		str = transform.substitute_transform:transform(streetname)
		str = transform.country_abbrev_table:transform(str)
		return str
	end
end

---ROUTE SUMMARY---
function route_summary_format_road_name(data)
        local propos = L" droga numer "
	local str = transform_and_format(data, transform_format_roadnumber_eu)
	return propos .. str 	
end
function route_summary_format_street_name(data)
	local str = transform.substitute_transform:transform(data.text)
	return str
end
function route_summary_format_bridge_tunnel(data)
	return transform.substitute_transform:transform(data.text)
end
function route_summary_format_order(data)
	transform.substitute_transform:transform(data.text)
end
function get_route_summary_phrases_separator()
	return L", "
end


---TRAFFIC---
function traffic_event_supported()
	return true
end
	local function traffic_event_distance_get(dist)
	local unit_names = {"yards","meters","feet"}
	dist_table = distances[unit_names[MODEL.regional.units() + 1]]
	local _, _, f_dist = distance_formatter(dist)
	local dist_idx = search_distance_index(f_dist)
	local code_string
	if f_dist == dist_table[dist_idx] then code_string = dist_table[dist_idx + 1]
	else code_string = dist_table[search_distance_index(dist) + 1] end
	return decode_string(code_string, 1)
end
function traffic_event(DescKey, data)
	local str = translate_voice(DescKey)
	local loc = MODEL.regional.is_it_voice_localizable(DescKey) 
	ASSERT(loc, "Missing TrafficEvent dictionary.voice key:" .. DescKey)
		if data.roadname then data.roadname.text = format_sentence(data.roadname.text) end
		if data.from then data.from.text =  format_sentence(data.from.text) end
		if data.to then data.to.text =  format_sentence(data.to.text) end
--- Roadnumber prioritas---
	if data.roadnumber then 
		local road = L" na drodze numer.//" .. transform_format_roadnumber_eu(data.roadnumber.text, L" %s")
		if data.from and not data.to then
			str =  str..road..L", w pobliżu.//" .. transform_and_format(data.from, replace_tmc_od)
		elseif data.from and data.to then 
			str =  str..road..L", na odcinku od.//" .. transform_and_format(data.from, replace_tmc_od) .. L" do.//" ..transform_and_format(data.to, replace_tmc_od)
		else
			str = str .. road
		end
--- Roadname---
	elseif data.roadname then
		local road = transform_and_format(data.roadname, replace_tmc_na, L" %s")
		road = L" " .. get_preposition(data.roadname.text, traffic_preposition_insert_tbl) .. road
		if data.from and not data.to then
			local _,_, from, to = wstring.find(data.from.text, L"^([^,]+),(.+)$")
			if from and to then 
				str = str..road..L", na skrzyżowaniu.//".. from..L" i.//" .. to
			else 
				str = str .. road .. L", na skrzyżowaniu.//" .. data.from.text
			end
		elseif data.from and data.to then
			str = str..road..L", na odcinku od.//"..transform_and_format(data.from, replace_tmc_od) .. L" do.//" .. transform_and_format(data.to, replace_tmc_od)
		else
			str = str..road
		end
	else
		if data.from and not data.to then
			str =  str .. L", w pobliżu.//" .. transform_and_format(data.from, replace_tmc_od)
		elseif data.from and data.to then 
			str =  str .. L" pomiędzy.//" .. transform_and_format(data.from, replace_tmc_od) .. L" i.//" .. transform_and_format(data.to, replace_tmc_od)
		else
	end
end

str = str .. L"."
	voice_debug_log(L"TTS: Out_TMC: '"..str..L"'", 3)
	local traffic_distance = L""
	if traffic_events_distance and (data.roadnumber or data.roadname or data.from or data.to) then
		local current
		for i = 0, #MODEL.traffic.events.significant_events - 1 do
			current = MODEL.traffic.events.significant_events[i]
			if data.roadname.text == current.road_name() and data.to.text == current.location_to() and data.from.text == current.location_from() then
				if current.distance() and traffic_events_distance then traffic_distance = translated_voice_format(m_i18n_voice("After %s"), traffic_event_distance_get(current.distance())) ..  L" " end
				break
			end
			if i>30 then break end
		end
	end
	----
	return traffic_distance .. str
end

----------------------------------------------------------------------------------------------------
---------------------------------------------|  E T A  |--------------------------------------------
----------------------------------------------------------------------------------------------------

function eta(time,waypoint,currenttime)	
	local hour = time.hour
	if hour == 0 then
		hour = 24
	end
	if hour > 12 then
		hour = hour - 0
	end	
	local min
	if time.min ~= 0 then
		min = L":" .. towstring(string.format("%02d", time.min))
	else
		min = L" "
	end 	
	local tod
	if time.hour < 3 then
		tod = L""
	elseif time.hour < 6 then
		tod = L""
	elseif time.hour < 12 then
		tod = L""
	elseif time.hour < 20 then
		tod = L""
	else
		tod = L""
	end	
    local etaStr = currenttime and L"Jest godzina " .. 
towstring(hour) .. min .. tod or waypoint and L"Do punktu trasy dojedziesz o godzinie " .. 
towstring(hour) .. min .. tod or L"Do celu podróży dojedziesz o godzinie " ..
towstring(hour) .. min .. tod
	voice_debug_log(L"ETA: " .. etaStr, 3)
	return etaStr
end

--dla skina pongo--
function timeto(timeto)
	local hournew, minsnew
	local hour = wstring.sub(timeto,1,-4)
	local mins = wstring.sub(timeto,-2,-1)
	local hournumber = tonumber(hour)
	local replace_hourone = {
		{L"0godzin",L" "},
		{L"1godzin",L" jedną godzinę "},
		{L"2godzin",L" dwie godziny "},
		{L"3godzin",L" trzy godziny "},
		{L"4godzin",L" cztery godziny "},
		{L"5godzin",L" pięć godzin "},
		{L"6godzin",L" sześć godzin "},
		{L"7godzin",L" siedem godzin "},
		{L"8godzin",L" osiem godzin "},
		{L"9godzin",L" dziewięć godzin "},
                }
	local replace_hoursec = {
		{L"22godzin",L" dwadzieścia-dwie godziny "},
		{L"23godzin",L" dwadzieścia-trzy godziny "},
		{L"24godzin",L" dwadzieścia-cztery godziny "},
		{L"32godzin",L" trzydzieści-dwie godziny "},
		{L"33godzin",L" trzydzieści-trzy godziny "},
		{L"34godzin",L" trzydzieści-cztery godziny "},
		{L"42godzin",L" czterdzieści-dwie godziny "},
		{L"43godzin",L" czterdzieści-trzy godziny "},
		{L"44godzin",L" czterdzieści-cztery godziny "},
		{L"52godzin",L" pięćdziesiąt-dwie godziny "},
		{L"53godzin",L" pięćdziesiąt-trzy godziny "},
		{L"54godzin",L" pięćdziesiąt-cztery godziny "},
                }
	local replace_mins = {
		{L"00minut",L"jedną minutę "},
		{L"01minut",L"jedną minutę "},
		{L"02minut",L"dwie minuty "},
		{L"03minut",L"trzy minuty "},
		{L"04minut",L"cztery minuty "},
		{L"05minut",L"pięć minut "},
		{L"06minut",L"sześć minut "},
		{L"07minut",L"siedem minut "},
		{L"08minut",L"osiem minut "},
		{L"09minut",L"dziewięć minut "},
		{L"10minut",L"dziesięć minut"},
		{L"11minut",L"jedenaście minut "},
		{L"12minut",L"dwanaście minut "},
		{L"13minut",L"trzynaście minut "},
		{L"14minut",L"czternaście minut "},
		{L"15minut",L"piętnaście minut "},
		{L"16minut",L"szesnaście minut "},
		{L"17minut",L"siedemnaście minut "},
		{L"18minut",L"osiemnaście minut "},
		{L"19minut",L"dziewiętnaście minut "},
		{L"20minut",L"dwadzieścia-minut "},
		{L"21minut",L"dwadzieścia-jeden minut "},
		{L"22minut",L"dwadzieścia-dwie minuty "},
		{L"23minut",L"dwadzieścia-trzy minuty "},
		{L"24minut",L"dwadzieścia-cztery minuty "},
		{L"25minut",L"dwadzieścia-pięć minut "},
		{L"26minut",L"dwadzieścia-sześć minut "},
		{L"27minut",L"dwadzieścia-siedem minut "},
		{L"28minut",L"dwadzieścia-osiem minut "},
		{L"29minut",L"dwadzieścia-dziewięć minut "},
		{L"30minut",L"trzydzieści-minut "},
		{L"31minut",L"trzydzieści-jeden minut "},
		{L"32minut",L"trzydzieści-dwie minuty "},
		{L"33minut",L"trzydzieści-trzy minuty "},
		{L"34minut",L"trzydzieści-cztery minuty "},
		{L"35minut",L"trzydzieści-pięć minut "},
		{L"36minut",L"trzydzieści-sześć minut "},
		{L"37minut",L"trzydzieści-siedem minut "},
		{L"38minut",L"trzydzieści-osiem minut "},
		{L"39minut",L"trzydzieści-dziewięć minut "},
		{L"40minut",L"czterdzieści-minut "},
		{L"41minut",L"Czterdzieści-jeden minut "},
		{L"42minut",L"czterdzieści-dwie minuty "},
		{L"43minut",L"czterdzieści-trzy minuty "},
		{L"44minut",L"czterdzieści-cztery minuty "},
		{L"45minut",L"czterdzieści-pięć minut "},
		{L"46minut",L"czterdzieści-sześć minut "},
		{L"47minut",L"czterdzieści-siedem minut "},
		{L"48minut",L"czterdzieści-osiem minut "},
		{L"49minut",L"czterdzieści-dziewięć minut "},
		{L"50minut",L"pięćdziesiąt-minut "},
		{L"51minut",L"pięćdziesiąt-jeden minut "},
		{L"52minut",L"pięćdziesiąt-dwie minuty "},
		{L"53minut",L"pięćdziesiąt-trzy minuty "},
		{L"54minut",L"pięćdziesiąt-cztery minuty "},
		{L"55minut",L"pięćdziesiąt-pięć minut "},
		{L"56minut",L"pięćdziesiąt-sześć minut "},
		{L"57minut",L"pięćdziesiąt-siedem minut "},
		{L"58minut",L"pięćdziesiąt-osiem minut "},
		{L"59minut",L"pięćdziesiąt-dziewięć minut "},
		}
	if hournumber <= 9 then
		hournew = transform_and_format(hour .. L"godzin",replace_hourone)
	else
		hournew = transform_and_format(hour .. L" godzin ",replace_hoursec)
	end
		minsnew = transform_and_format(mins .. L"minut",replace_mins)
	return hournew .. minsnew .. L" "
end

--dla skina arimi--
function format_timeto(timeto)
	local hournew, minsnew
	local hour = wstring.sub(timeto,1,-4)
	local mins = wstring.sub(timeto,-2,-1)
	local hournumber = tonumber(hour)
	local replace_hourone = {
		{L"0godzin",L" "},
		{L"1godzin",L" jedną godzinę "},
		{L"2godzin",L" dwie godziny "},
		{L"3godzin",L" trzy godziny "},
		{L"4godzin",L" cztery godziny "},
		{L"5godzin",L" pięć godzin "},
		{L"6godzin",L" sześć godzin "},
		{L"7godzin",L" siedem godzin "},
		{L"8godzin",L" osiem godzin "},
		{L"9godzin",L" dziewięć godzin "},
                }
	local replace_hoursec = {
		{L"22godzin",L" dwadzieścia dwie godziny "},
		{L"23godzin",L" dwadzieścia trzy godziny "},
		{L"24godzin",L" dwadzieścia cztery godziny "},
		{L"32godzin",L" trzydzieści dwie godziny "},
		{L"33godzin",L" trzydzieści trzy godziny "},
		{L"34godzin",L" trzydzieści cztery godziny "},
		{L"42godzin",L" czterdzieści dwie godziny "},
		{L"43godzin",L" czterdzieści trzy godziny "},
		{L"44godzin",L" czterdzieści cztery godziny "},
		{L"52godzin",L" pięćdziesiąt dwie godziny "},
		{L"53godzin",L" pięćdziesiąt trzy godziny "},
		{L"54godzin",L" pięćdziesiąt cztery godziny "},
                }
	local replace_mins = {
		{L"00minut",L" jedną minutę "},
		{L"01minut",L" jedną minutę "},
		{L"02minut",L" dwie minuty "},
		{L"03minut",L" trzy minuty "},
		{L"04minut",L" cztery minuty "},
		{L"22minut",L" dwadzieścia dwie minuty "},
		{L"23minut",L" dwadzieścia trzy minuty "},
		{L"24minut",L" dwadzieścia cztery minuty "},
		{L"32minut",L" trzydzieści dwie minuty "},
		{L"33minut",L" trzydzieści trzy minuty "},
		{L"34minut",L" trzydzieści cztery minuty "},
		{L"42minut",L" czterdzieści dwie minuty "},
		{L"43minut",L" czterdzieści trzy minuty "},
		{L"44minut",L" czterdzieści cztery minuty "},
		{L"52minut",L" pięćdziesiąt dwie minuty "},
		{L"53minut",L" pięćdziesiąt trzy minuty "},
		{L"54minut",L" pięćdziesiąt cztery minuty "},
                }
	if hournumber <= 9 then
		hournew = transform_and_format(hour .. L"godzin",replace_hourone)
	else
		hournew = transform_and_format(hour .. L" godzin ",replace_hoursec)
	end
		minsnew = transform_and_format(mins .. L"minut",replace_mins)
	return hournew .. minsnew .. L" "
end